/*
 * Decompiled with CFR 0.152.
 */
package org.amic.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.amic.desktop.ContainedPanel;
import org.amic.desktop.DefaultContainedPanel;
import org.amic.desktop.Desktop;
import org.amic.desktop.DesktopFrame;
import org.amic.desktop.ScrollDesktopManager;

public class DesktopPane
extends JDesktopPane
implements ChangeListener {
    public final int INC_X = 20;
    public final int INC_Y = 20;
    public final int WIDTH_PC = 80;
    public final int HEIGHT_PC = 60;
    private Desktop desktop;
    private JSplitPane splitter;
    private int position;
    private int currentX = 0;
    private int currentY = 0;
    private Rectangle lastBounds;
    private Point lastPoint = new Point(0, 0);
    private boolean reckoning = false;
    public JScrollBar verSb;
    public JScrollBar horSb;

    private DesktopPane() {
    }

    public DesktopPane(Desktop desktop, JSplitPane splitter, int position) {
        this.desktop = desktop;
        this.splitter = splitter;
        this.position = position;
        splitter.setOneTouchExpandable(false);
        this.setVisible(true);
    }

    public DesktopFrame addFrame(ContainedPanel panel, boolean maximized) {
        panel.setDesktop(this.desktop);
        DesktopFrame frame = this.addFrame(panel.getTitle(), JDesktopPane.DEFAULT_LAYER);
        panel.setFrame(frame);
        frame.setFrameIcon(panel.getIcon());
        frame.putClientProperty("c.panel", panel);
        frame.getContentPane().add((DefaultContainedPanel)panel);
        if (maximized) {
            try {
                frame.setMaximum(true);
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
        }
        panel.willShow();
        return frame;
    }

    public boolean closeAllFrames() {
        JInternalFrame[] frames = this.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i] instanceof DesktopFrame) {
                if (((DesktopFrame)frames[i]).getContainedPanel().canClose()) {
                    frames[i].dispose();
                } else {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private DesktopFrame addFrame(String titol, Integer layer) {
        int x = this.currentX;
        int y = this.currentY;
        int w = (int)((double)this.getWidth() * 0.8);
        int h = (int)((double)this.getHeight() * 0.6);
        DesktopFrame frame = new DesktopFrame(this.desktop, titol);
        frame.setClosable(true);
        if (layer == JDesktopPane.DEFAULT_LAYER) {
            frame.setMaximizable(true);
            frame.setIconifiable(true);
            frame.setResizable(true);
            frame.setDefaultCloseOperation(2);
            if (x + w > this.getWidth() || y + h > this.getHeight()) {
                x = 0;
                y = 0;
            }
            frame.setBounds(x, y, w, h);
            this.currentX = x + 20;
            this.currentY = y + 20;
        }
        this.add((Component)frame, layer);
        frame.show();
        return frame;
    }

    public static DesktopPane placeDesktopPane(Desktop desktop, JSplitPane splitter, int position) {
        DesktopPane desktopPane = new DesktopPane(desktop, splitter, position);
        if (position == 1) {
            desktopPane.setDesktopManager(new ScrollDesktopManager());
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            desktopPane.verSb = new JScrollBar(1);
            desktopPane.horSb = new JScrollBar(0);
            desktopPane.verSb.setVisible(false);
            desktopPane.horSb.setVisible(false);
            desktopPane.verSb.getModel().addChangeListener(desktopPane);
            desktopPane.horSb.getModel().addChangeListener(desktopPane);
            panel.add((Component)desktopPane.verSb, "East");
            panel.add((Component)desktopPane.horSb, "South");
            panel.add((Component)desktopPane, "Center");
            splitter.setRightComponent(panel);
        } else if (position == 0) {
            splitter.setLeftComponent(desktopPane);
        }
        return desktopPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSize() {
        if (this.reckoning) {
            return;
        }
        this.reckoning = true;
        try {
            this.lastBounds = this.getTotalBounds();
            if (this.lastBounds.x < 0 || this.lastBounds.width > this.getWidth()) {
                this.horSb.getModel().setMinimum(this.lastBounds.x);
                this.horSb.getModel().setMaximum(this.lastBounds.width + this.lastBounds.x);
                this.horSb.getModel().setExtent(this.getWidth());
                if (!this.horSb.isVisible()) {
                    this.horSb.setVisible(true);
                }
            } else if (this.horSb.isVisible()) {
                this.horSb.setVisible(false);
            }
            if (this.lastBounds.y < 0 || this.lastBounds.height > this.getHeight()) {
                this.verSb.getModel().setMinimum(this.lastBounds.y);
                this.verSb.getModel().setMaximum(this.lastBounds.height + this.lastBounds.y);
                this.verSb.getModel().setExtent(this.getHeight());
                if (!this.verSb.isVisible()) {
                    this.verSb.setVisible(true);
                }
            } else if (this.verSb.isVisible()) {
                this.verSb.setVisible(false);
            }
            this.lastPoint.x = 0;
            this.lastPoint.y = 0;
            Object var2_1 = null;
            this.reckoning = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.reckoning = false;
            throw throwable;
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (this.reckoning) {
            return;
        }
        if (e.getSource() == this.horSb.getModel()) {
            int currX = this.horSb.getModel().getValue();
            JInternalFrame[] ji = this.getAllFrames();
            int i = 0;
            while (i < ji.length) {
                ji[i].setLocation(ji[i].getX() + (this.lastPoint.x - currX), ji[i].getY());
                ++i;
            }
            this.lastPoint.x = currX;
            if (!this.horSb.getModel().getValueIsAdjusting()) {
                this.checkSize();
            }
        } else if (e.getSource() == this.verSb.getModel()) {
            int currY = this.verSb.getModel().getValue();
            JInternalFrame[] ji = this.getAllFrames();
            int i = 0;
            while (i < ji.length) {
                ji[i].setLocation(ji[i].getX(), ji[i].getY() + (this.lastPoint.y - currY));
                ++i;
            }
            this.lastPoint.y = currY;
            if (!this.verSb.getModel().getValueIsAdjusting()) {
                this.checkSize();
            }
        }
    }

    private Rectangle getTotalBounds() {
        Rectangle rect = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        JInternalFrame[] ji = this.getAllFrames();
        int i = 0;
        while (i < ji.length) {
            rect.add(ji[i].getBounds());
            ++i;
        }
        return rect;
    }
}

