/*
 * Decompiled with CFR 0.152.
 */
package org.amic.desktop.wizard;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.amic.desktop.wizard.IWizardPanel;
import org.amic.desktop.wizard.WizardList;
import org.amic.util.icons.Icons;

public class WizardActionsPanel
extends JPanel {
    private WizardList list;

    public WizardActionsPanel(WizardList list) {
        this.list = list;
        this.setPreferredSize(new Dimension(180, 300));
        this.setBackground(Color.WHITE);
        this.updateActions();
    }

    public void updateActions() {
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int y = 35;
        int state = 0;
        int x = 8;
        Graphics2D g2 = (Graphics2D)g;
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, Color.WHITE, g.getClipBounds().height, 0.0f, new Color(204, 204, 255));
        g2.setPaint(gradient);
        g2.fill(g.getClipBounds());
        g.setColor(new Color(0, 0, 100));
        g.drawLine(x, y + 6, g.getClipBounds().width - x, y + 6);
        g.setFont(new Font("Dialog", 1, 11));
        y += 26;
        boolean inactives = false;
        int i = 0;
        while (i < this.list.size()) {
            IWizardPanel wp = this.list.getPanel(i);
            if (state == 0 && wp == this.list.currentPanel()) {
                state = 1;
            }
            if (state == 1) {
                g.setColor(Color.BLACK);
            } else if (state == 0) {
                g.setColor(Color.GRAY);
            } else if (state == 2) {
                g.setColor(Color.LIGHT_GRAY);
            }
            if (wp.isActive()) {
                inactives = false;
                g.drawString(wp.getTitle(), x + 5, y);
                if (state == 1) {
                    state = 2;
                }
                y += 16;
            } else if (!inactives) {
                inactives = true;
                g.drawString("...", x + 5, y);
                if (state == 1) {
                    state = 2;
                }
                y += 16;
            }
            ++i;
        }
        Image image = ((ImageIcon)Icons.getIcon(this.getClass(), "/org/amic/images/wizard.gif")).getImage();
        g.drawImage(image, g.getClipBounds().width - image.getWidth(null), g.getClipBounds().height - image.getHeight(null), null);
        image = ((ImageIcon)Icons.getIcon(this.getClass(), "/org/amic/images/wizsteps.gif")).getImage();
        g.drawImage(image, 5, 5, null);
    }
}

