/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.date;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.amic.util.string.FindReplace;

public class CheckDate {
    static final String UNIVERSAL_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private Calendar param;
    private Calendar initial = Calendar.getInstance();

    public CheckDate() {
        this((Date)null);
    }

    public CheckDate(Date date) {
        if (date != null) {
            this.initial.setTime(date);
        }
    }

    public CheckDate(String date) {
        this.setDate(date);
    }

    public CheckDate(int year, int month, int day, int hour, int minute, int second) {
        this.setDate(year, month, day, hour, minute, second);
    }

    public Date getDate() {
        return this.initial.getTime();
    }

    public Calendar getCalendar() {
        return this.initial;
    }

    public String formatDate(String pattern) {
        return new SimpleDateFormat(pattern).format(this.initial.getTime());
    }

    public String getUniversalDate() {
        return new SimpleDateFormat(UNIVERSAL_PATTERN).format(this.initial.getTime());
    }

    public String toString() {
        return this.initial.toString();
    }

    public int getDay() {
        return this.initial.get(5);
    }

    public int getMaxDayInMonth() {
        return this.initial.getActualMaximum(5);
    }

    public int getDayOfWeek() {
        return this.initial.get(7);
    }

    public int getDayOfYear() {
        return this.initial.get(6);
    }

    public int getWeek() {
        return this.initial.get(3);
    }

    public int getMonth() {
        return this.initial.get(2) + 1;
    }

    public int getYear() {
        return this.initial.get(1);
    }

    public int getHour() {
        return this.initial.get(11);
    }

    public int getMinute() {
        return this.initial.get(12);
    }

    public CheckDate setUniversalDate(String date) {
        try {
            this.initial.setTime(new SimpleDateFormat(UNIVERSAL_PATTERN).parse(date));
        }
        catch (Exception ex) {}
        return this;
    }

    public CheckDate setDate(Date date) {
        this.initial.setTime(date);
        return this;
    }

    public CheckDate setDate(String date) {
        int year = -1;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        FindReplace f = new FindReplace(date);
        if (f.match("([0-9]{1,2})(/|-)([0-9]{1,2})(/|-)([0-9]{2,4})")) {
            day = Integer.parseInt(f.getString(1));
            month = Integer.parseInt(f.getString(3));
            year = Integer.parseInt(f.getString(5));
        }
        if (f.match("([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})")) {
            hour = Integer.parseInt(f.getString(1));
            minute = Integer.parseInt(f.getString(2));
            second = Integer.parseInt(f.getString(3));
        } else if (f.match("([0-9]{1,2}):([0-9]{1,2})")) {
            hour = Integer.parseInt(f.getString(1));
            minute = Integer.parseInt(f.getString(2));
            second = 0;
        }
        return this.setDate(year, month, day, hour, minute, second);
    }

    public CheckDate setDate(int year, int month, int day, int hour, int minute, int second) {
        this.initial.set(14, 0);
        if (year > -1) {
            this.setYear(year);
        }
        if (month > 0) {
            this.setMonth(month);
        }
        if (day > 0) {
            this.setDay(day);
        }
        if (hour > -1) {
            this.setHour(hour);
        }
        if (minute > -1) {
            this.setMinute(minute);
        }
        if (second > -1) {
            this.setSecond(second);
        }
        return this;
    }

    public CheckDate setDay(int value) {
        if (value > this.getMaxDayInMonth()) {
            value = this.getMaxDayInMonth();
        }
        this.initial.set(5, value);
        return this;
    }

    public CheckDate setDayOfWeek(int value) {
        while (this.initial.get(7) != value) {
            this.initial.add(5, 1);
        }
        return this;
    }

    public CheckDate setDayOfYear(int value) {
        while (this.initial.get(6) != value) {
            this.initial.add(5, 1);
        }
        return this;
    }

    public CheckDate setWeek(int value) {
        while (this.initial.get(3) != value) {
            this.initial.add(5, 1);
        }
        return this;
    }

    public CheckDate setMonth(int value) {
        this.initial.set(2, value - 1);
        return this;
    }

    public CheckDate setYear(int value) {
        if (value < 100) {
            int century = (int)Math.floor((double)Calendar.getInstance().get(1) / 100.0) * 100;
            value = value < 51 ? (value += century) : (value += century - 100);
        }
        this.initial.set(1, value);
        return this;
    }

    public CheckDate setHour(int value) {
        this.initial.set(11, value);
        return this;
    }

    public CheckDate setMinute(int value) {
        this.initial.set(12, value);
        return this;
    }

    public CheckDate setSecond(int value) {
        this.initial.set(13, value);
        this.initial.set(14, 0);
        return this;
    }

    public CheckDate addDays(int value) {
        this.initial.add(5, value);
        return this;
    }

    public CheckDate addWeeks(int value) {
        this.initial.add(5, value * 7);
        return this;
    }

    public CheckDate addMonths(int value) {
        this.initial.add(2, value);
        return this;
    }

    public CheckDate addYears(int value) {
        this.initial.add(1, value);
        return this;
    }

    public CheckDate addHours(int value) {
        this.initial.add(10, value);
        return this;
    }

    public CheckDate addMinutes(int value) {
        this.initial.add(12, value);
        return this;
    }

    public boolean sameDay(Date date) {
        this.setCalendar(date);
        return this.getDayOfYear() == this.param.get(6) && this.getYear() == this.param.get(1);
    }

    public boolean sameWeek(Date date) {
        this.setCalendar(date);
        return this.getWeek() == this.param.get(3) && this.getYear() == this.param.get(1);
    }

    public CheckDate setDayMonthYear(Date date) {
        if (date == null) {
            this.setHourMinute(0, 0);
            return this;
        }
        this.setCalendar(this.initial.getTime());
        this.initial.setTime(date);
        this.setHour(this.param.get(11));
        this.setMinute(this.param.get(12));
        this.setSecond(this.param.get(13));
        return this;
    }

    public CheckDate setHourMinute(Date date) {
        if (date == null) {
            this.setHourMinute(0, 0);
            return this;
        }
        this.setCalendar(date);
        this.setHourMinute(this.param.get(11), this.param.get(12));
        return this;
    }

    public CheckDate setHourMinute(int hour, int minute) {
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(0);
        return this;
    }

    public int compareDayMonthYear(Date date) {
        this.setCalendar(date);
        return this.compareDayMonthYear(this.param.get(5), this.param.get(2) + 1, this.param.get(1));
    }

    public int compareDayMonthYear(int day, int month, int year) {
        if (this.getYear() < year || this.getYear() == year && this.getMonth() < month || this.getYear() == year && this.getMonth() == month && this.getDay() < day) {
            return -1;
        }
        if (this.getYear() == year && this.getMonth() == month && this.getDay() == day) {
            return 0;
        }
        return 1;
    }

    public int compareDayMonth(int day, int month) {
        if (this.getMonth() < month || this.getMonth() == month && this.getDay() < day) {
            return -1;
        }
        if (this.getMonth() == month && this.getDay() == day) {
            return 0;
        }
        return 1;
    }

    public int compareDayMonth(Date date) {
        this.setCalendar(date);
        return this.compareDayMonth(this.param.get(5), this.param.get(2) + 1);
    }

    public int compareHourMinute(int hour, int minute) {
        if (this.getHour() < hour || this.getHour() == hour && this.getMinute() < minute) {
            return -1;
        }
        if (this.getHour() == hour && this.getMinute() == minute) {
            return 0;
        }
        return 1;
    }

    public int compareHourMinute(Date date) {
        this.setCalendar(date);
        return this.compareHourMinute(this.param.get(11), this.param.get(12));
    }

    private void setCalendar(Date date) {
        this.param = Calendar.getInstance();
        this.param.setTime(date);
    }
}

