/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.xml;

import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import next.swing.AbstractTreeTableModel;
import next.swing.JTreeTable;
import org.amic.util.db.Converter;
import org.amic.util.table.FormatterEditor;
import org.amic.util.table.FormatterRenderer;
import org.amic.util.xml.RecordPacked;
import org.amic.util.xml.TablePacked;

public class ModelDBTreeTable
extends AbstractTreeTableModel {
    private TablePacked table;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$next$swing$TreeTableModel;

    private ModelDBTreeTable(Object root, TablePacked table) {
        super(root);
        this.table = table;
    }

    public static ModelDBTreeTable getModel(TablePacked table) {
        int rows = table.getRowCount();
        int cols = table.getFieldCount();
        int currentLevel = 0;
        int indexLevel = 0;
        int readLevel = 0;
        DefaultMutableTreeNode[] level = new DefaultMutableTreeNode[20];
        level[0] = new DefaultMutableTreeNode(table.getIdentifier());
        indexLevel = table.getIndex("RLevel");
        int row = 0;
        while (row < rows) {
            RecordPacked record = table.getRecord(row);
            readLevel = indexLevel == -1 ? 999 : record.getInt(indexLevel);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(record.getString(0));
            node.setUserObject(record);
            if (readLevel == 999) {
                level[currentLevel].add(node);
            } else {
                level[readLevel] = node;
                level[readLevel - 1].add(node);
                currentLevel = readLevel;
            }
            ++row;
        }
        return new ModelDBTreeTable(level[0], table);
    }

    public static void setPreferences(JTreeTable treeTable, TablePacked table) {
        TableColumnModel tcm = treeTable.getColumnModel();
        treeTable.setDefaultEditor(class$java$util$Date == null ? (class$java$util$Date = ModelDBTreeTable.class$("java.util.Date")) : class$java$util$Date, new FormatterEditor("dd/MM/yy HH:mm", class$java$util$Date == null ? (class$java$util$Date = ModelDBTreeTable.class$("java.util.Date")) : class$java$util$Date));
        treeTable.setDefaultEditor(class$java$lang$Double == null ? (class$java$lang$Double = ModelDBTreeTable.class$("java.lang.Double")) : class$java$lang$Double, new FormatterEditor("#,###.##", class$java$lang$Double == null ? (class$java$lang$Double = ModelDBTreeTable.class$("java.lang.Double")) : class$java$lang$Double));
        treeTable.setDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = ModelDBTreeTable.class$("java.lang.String")) : class$java$lang$String, new FormatterEditor("", class$java$lang$String == null ? (class$java$lang$String = ModelDBTreeTable.class$("java.lang.String")) : class$java$lang$String));
        int i = 0;
        while (i < table.getVisibleFieldCount() - 1) {
            tcm.getColumn(i).setPreferredWidth(table.getFieldDisplaySize(i) * 10);
            if (table.getFieldValids(i).length > 0) {
                JComboBox<Object> cb = new JComboBox<Object>(table.getFieldValids(i));
                tcm.getColumn(i).setCellEditor(new DefaultCellEditor(cb));
            } else if (table.getFieldFormat(i) != null) {
                tcm.getColumn(i).setCellRenderer(new FormatterRenderer((String)table.getFieldFormat(i), table.getFieldType(i)));
                tcm.getColumn(i).setCellEditor(new FormatterEditor((String)table.getFieldFormat(i), new Converter().setType(table.getFieldType(i)).getValueClass()));
            }
            ++i;
        }
    }

    public int getChildCount(Object node) {
        return ((DefaultMutableTreeNode)node).getChildCount();
    }

    public Object getChild(Object node, int i) {
        return ((DefaultMutableTreeNode)node).getChildAt(i);
    }

    public int getColumnCount() {
        return this.table.getVisibleFieldCount();
    }

    public String getColumnName(int column) {
        return this.table.getFieldLabel(column);
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return class$next$swing$TreeTableModel == null ? (class$next$swing$TreeTableModel = ModelDBTreeTable.class$("next.swing.TreeTableModel")) : class$next$swing$TreeTableModel;
        }
        return new Converter().setType(this.table.getFieldType(column)).getValueClass();
    }

    public Object getValueAt(Object node, int column) {
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
        if (currentNode.getUserObject() instanceof RecordPacked) {
            RecordPacked rp = (RecordPacked)currentNode.getUserObject();
            return rp.getValue(column);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

