/*
 * Decompiled with CFR 0.152.
 */
package org.amic.xml;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import org.amic.util.string.ClassFormatter;
import org.amic.xml.NewXmlNode;
import org.amic.xml.XmlReader;
import org.amic.xml.XmlTreeTableRenderer;

public class XmlTableModel
extends AbstractTableModel {
    private XmlReader root;
    private Vector columns = null;
    private Map objs = new HashMap();
    private NewXmlNode newNode = null;
    public final int ALIGN_LEFT = 2;
    public final int ALIGN_RIGHT = 4;
    public final int ALIGN_CENTER = 0;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$org$amic$util$date$Date;
    static /* synthetic */ Class class$org$amic$xml$XmlReader;

    public XmlTableModel(XmlReader reader) {
        this.root = reader;
    }

    public void setNewXmlNode(NewXmlNode nxn) {
        this.newNode = nxn;
    }

    public XmlReader getRowNode(int row) {
        return this.root.getNodes()[row];
    }

    public void applyDefaults(JTable tt) {
        TableColumnModel tcm = tt.getColumnModel();
        int i = 0;
        while (i < tcm.getColumnCount()) {
            Column col = (Column)this.columns.elementAt(i);
            if (col.jClass != (class$java$lang$Boolean == null ? XmlTableModel.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                tcm.getColumn(i).setCellRenderer(new XmlTreeTableRenderer(col.format, col.align, col.jClass));
                if (col.editor != null) {
                    tcm.getColumn(i).setCellEditor(col.editor);
                }
            }
            tcm.getColumn(i).setPreferredWidth(col.width * 10);
            ++i;
        }
    }

    public void addStringColumn(String attribute, String label, int width, boolean readOnly, TableCellEditor editor) {
        this.addColumn(new Column(attribute, null, label, 2, width, class$java$lang$String == null ? (class$java$lang$String = XmlTableModel.class$("java.lang.String")) : class$java$lang$String, null, readOnly, editor, null));
    }

    public void addNumberColumn(String attribute, String label, int width, String format, boolean readOnly, TableCellEditor editor) {
        this.addColumn(new Column(attribute, null, label, 4, width, class$java$lang$Double == null ? (class$java$lang$Double = XmlTableModel.class$("java.lang.Double")) : class$java$lang$Double, format, readOnly, editor, null));
    }

    public void addDateColumn(String attribute, String label, int width, String format, boolean readOnly, TableCellEditor editor) {
        this.addColumn(new Column(attribute, null, label, 2, width, class$org$amic$util$date$Date == null ? (class$org$amic$util$date$Date = XmlTableModel.class$("org.amic.util.date.Date")) : class$org$amic$util$date$Date, format, readOnly, editor, null));
    }

    public void addBooleanColumn(String attribute, String label, int width, boolean readOnly) {
        this.addColumn(new Column(attribute, null, label, 2, width, class$java$lang$Boolean == null ? (class$java$lang$Boolean = XmlTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, null, readOnly, null, null));
    }

    public void addXmlReaderColumn(String attribute, String key, String label, int width, boolean readOnly, TableCellEditor editor, Object values) {
        this.addColumn(new Column(attribute, key, label, 2, width, class$org$amic$xml$XmlReader == null ? (class$org$amic$xml$XmlReader = XmlTableModel.class$("org.amic.xml.XmlReader")) : class$org$amic$xml$XmlReader, null, readOnly, editor, values));
        this.objs.put(attribute, new Vector());
    }

    public void addColumn(Column column) {
        if (this.columns == null) {
            this.columns = new Vector();
        }
        this.columns.add(column);
    }

    public String getColumnName(int column) {
        return ((Column)this.columns.elementAt((int)column)).label;
    }

    public boolean isCellEditable(int row, int column) {
        return !((Column)this.columns.elementAt((int)column)).readOnly;
    }

    public Class getColumnClass(int column) {
        return ((Column)this.columns.elementAt((int)column)).jClass;
    }

    public int getColumnCount() {
        if (this.columns == null) {
            return 0;
        }
        return this.columns.size();
    }

    public int getRowCount() {
        return this.root.getNodeCount();
    }

    public Object getValueAt(int row, int column) {
        XmlReader a = this.root.getNodes()[row];
        Column col = (Column)this.columns.elementAt(column);
        if (col.attribute.equals("tag-name")) {
            return a.getName();
        }
        if (col.attribute.equals("tag-value")) {
            return a.getValue();
        }
        if (ClassFormatter.representsClass(col.jClass, class$org$amic$xml$XmlReader == null ? (class$org$amic$xml$XmlReader = XmlTableModel.class$("org.amic.xml.XmlReader")) : class$org$amic$xml$XmlReader)) {
            Vector v = (Vector)this.objs.get(col.attribute);
            if (v == null || v.size() == 0 || v.size() <= row) {
                if (col.obj != null && a.getAttribute(col.attribute) != null) {
                    XmlReader[] xr = (XmlReader[])col.obj;
                    int i = 0;
                    while (i < xr.length) {
                        if (xr[i].getStrAttribute(col.key).equals(a.getAttribute(col.attribute))) {
                            this.setValueAt(xr[i], row, column);
                            return xr[i];
                        }
                        ++i;
                    }
                }
                return null;
            }
            return v.elementAt(row);
        }
        try {
            return ClassFormatter.parseNative(a.getAttribute(col.attribute), col.jClass);
        }
        catch (Exception ex) {
            return a.getAttribute(col.attribute);
        }
    }

    public void setValueAt(Object aValue, int row, int column) {
        XmlReader a = this.root.getNodes()[row];
        if (a == null) {
            return;
        }
        Column col = (Column)this.columns.elementAt(column);
        if (!col.attribute.equals("tag-name")) {
            if (col.attribute.equals("tag-value")) {
                if (aValue instanceof Date) {
                    a.getWriter().setText(ClassFormatter.format(aValue, col.format));
                } else {
                    a.getWriter().setText(aValue.toString());
                }
            } else if (aValue instanceof XmlReader) {
                Vector v = (Vector)this.objs.get(col.attribute);
                if (v.size() <= row) {
                    v.setSize(row + 1);
                }
                v.setElementAt(aValue, row);
                a.getWriter().setAttribute(col.attribute, ((XmlReader)aValue).getAttribute(col.key));
            } else if (aValue instanceof Date) {
                a.getWriter().setAttribute(col.attribute, ClassFormatter.format(aValue, col.format));
            } else {
                a.getWriter().setAttribute(col.attribute, aValue.toString());
            }
        }
        this.fireRowHasChanged(row);
    }

    public void fireRowHasChanged(int row, boolean updated) {
        this.fireRowHasChanged(row);
    }

    public void fireRowHasChanged(int row) {
        this.fireTableChanged(new TableModelEvent(this, row));
    }

    public void fireTableHasChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void deleteRow(int row) {
        if (row < 0 || row >= this.root.getNodeCount()) {
            return;
        }
        this.root.getNodes()[row].getWriter().removeNode();
        this.fireTableHasChanged();
    }

    public void insertRow(int row) {
        if (row < 0 || row >= this.root.getNodeCount()) {
            this.appendRow();
            return;
        }
        XmlReader xr = this.newNode.newNode(this.root, row);
        if (xr == null) {
            return;
        }
        this.root.getNodes()[row].getWriter().insertNode(xr.getWriter(), true);
        this.fireTableHasChanged();
    }

    public void appendRow() {
        XmlReader xr = this.newNode.newNode(this.root, this.root.getNodeCount());
        if (xr == null) {
            return;
        }
        this.root.getWriter().addNode(xr.getWriter(), true);
        this.fireTableHasChanged();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Column {
        int align;
        int width;
        Class jClass;
        String attribute;
        String key;
        String label;
        String format;
        boolean readOnly;
        TableCellEditor editor;
        Object obj;

        Column(String attribute, String key, String label, int align, int width, Class jClass, String format, boolean readOnly, TableCellEditor editor, Object obj) {
            this.attribute = attribute;
            this.key = key;
            this.label = label;
            this.align = align;
            this.width = width;
            this.jClass = jClass;
            this.format = format;
            this.readOnly = readOnly;
            this.editor = editor;
            this.obj = obj;
        }
    }
}

