/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.metadata.MetadataManager;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseRuntimeException;
import org.gvsig.tools.persistence.PersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHelper {
    private static final Logger LOG = LoggerFactory.getLogger(FileHelper.class);

    private FileHelper() {
    }

    public static DynStruct registerParametersDefinition(String name, Class theClass, String filename) {
        ClassLoader loader = theClass.getClassLoader();
        URL resource = theClass.getResource(filename);
        return FileHelper.registerParametersDefinition(name, theClass, loader, resource);
    }

    public static DynStruct registerParametersDefinition(String name, Class theClass, ClassLoader loader, URL resource) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' can't be null.");
        }
        if (theClass == null) {
            throw new IllegalArgumentException("Argument 'theClass' can't be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Argument 'resource' can't be null.");
        }
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(name);
        if (definition == null) {
            InputStream stream = null;
            try {
                stream = resource.openStream();
                definition = manager.addDefinition(theClass, name, stream, loader, null, null);
            }
            catch (IOException ex) {
                throw new DefinitionNotFoundException(theClass, resource.toString(), ex);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        return definition;
    }

    public static DynStruct registerMetadataDefinition(String name, Class theClass, String filename) throws MetadataException {
        ClassLoader loader = theClass.getClassLoader();
        URL resource = theClass.getResource(filename);
        return FileHelper.registerMetadataDefinition(name, theClass, loader, resource);
    }

    public static DynStruct registerMetadataDefinition(String name, Class theClass, ClassLoader loader, URL resource) throws MetadataException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' can't be null.");
        }
        if (theClass == null) {
            throw new IllegalArgumentException("Argument 'theClass' can't be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Argument 'resource' can't be null.");
        }
        MetadataManager manager = MetadataLocator.getMetadataManager();
        DynStruct definition = manager.getDefinition(name);
        if (definition == null) {
            InputStream stream = null;
            try {
                stream = resource.openStream();
                definition = manager.addDefinition(name, stream, theClass.getClassLoader());
            }
            catch (IOException ex) {
                throw new DefinitionNotFoundException(theClass, resource.toString(), ex);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        return definition;
    }

    public static DynObject newParameters(String name) {
        return ToolsLocator.getDynObjectManager().createDynObject(ToolsLocator.getPersistenceManager().getDefinition(name));
    }

    public static DynObject newMetadataContainer(String name) {
        try {
            MetadataManager manager = MetadataLocator.getMetadataManager();
            DynStruct definition = manager.getDefinition(name);
            return ToolsLocator.getDynObjectManager().createDynObject(definition);
        }
        catch (NullPointerException e) {
            throw new CantCreateMetadataException(name, e);
        }
    }

    private static class CantCreateMetadataException
    extends RuntimeException {
        private static final long serialVersionUID = -8373306339537106075L;

        CantCreateMetadataException(String name, Throwable cause) {
            super("Can't retrieve metadata definition for '" + name + "'.", cause);
        }
    }

    private static class DefinitionNotFoundException
    extends BaseRuntimeException {
        private static final long serialVersionUID = 7598155353307119897L;

        public DefinitionNotFoundException(Class theClass, String filename) {
            this(theClass, filename, null);
        }

        public DefinitionNotFoundException(Class theClass, String filename, Throwable ex) {
            super("Can't open parameters definition '%(filename)' from class %(classname).", "_ResourceForParametersDefinitionNotFoundException", 7598155353307119897L);
            this.initCause(ex);
            this.setValue("filename", filename);
            this.setValue("classname", theClass.getClass().getName());
        }
    }
}

