/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.simplereader.virtualrows;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.gvsig.fmap.dal.store.simplereader.virtualrows.RandomAccessFileIndex;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.library.impl.DefaultLibrariesInitializer;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.task.TaskStatusManager;

public class RandomAccessFileReader
extends Reader {
    public static final Predicate<String> FILTER_NONE = t -> false;
    protected static final int INDEX_HEADER_FILESIZE = 0;
    protected static final int INDEX_HEADER_INDEXCREATIONCOST = 1;
    protected static final int MAX_BUFFER_FOR_LINE = 51200;
    protected RandomAccessFile raf;
    protected Reader reader;
    protected long currentPosition;
    protected final Charset charset;
    protected long lastModified;

    public RandomAccessFileReader(File f, String charsetName) throws IOException {
        this(new RandomAccessFile(f, "r"), Charset.forName(charsetName));
        this.lastModified = f.lastModified();
    }

    public RandomAccessFileReader(File f, Charset charset) throws IOException {
        this(new RandomAccessFile(f, "r"), charset);
        this.lastModified = f.lastModified();
    }

    public RandomAccessFileReader(RandomAccessFile raf, String charsetName) throws IOException {
        this(raf, Charset.forName(charsetName));
        this.lastModified = -1L;
    }

    public RandomAccessFileReader(RandomAccessFile raf, Charset charset) throws IOException {
        this.charset = charset;
        this.raf = raf;
        this.reader = null;
        this.currentPosition = 0L;
        this.lastModified = -1L;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int n;
        if (this.reader == null) {
            this.createReader();
        }
        if ((n = this.reader.read(cbuf, off, len)) > 0) {
            CharBuffer charBuffer = CharBuffer.wrap(cbuf, off, len);
            ByteBuffer byteBuffer = this.charset.encode(charBuffer);
            this.currentPosition += (long)byteBuffer.limit();
        }
        return n;
    }

    protected void createReader() {
        this.reader = Channels.newReader((ReadableByteChannel)this.raf.getChannel(), this.charset.name());
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((Reader)this.reader);
        IOUtils.closeQuietly((Closeable)this.raf);
    }

    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    public long getCurrentPosition() {
        return this.currentPosition;
    }

    public void rewind() throws IOException {
        this.raf.seek(0L);
        this.reader = null;
        this.currentPosition = 0L;
    }

    public void seek(long position) throws IOException {
        this.raf.seek(position);
        this.reader = null;
        this.currentPosition = position;
    }

    public String readLine() throws IOException {
        StringBuilder buffer = new StringBuilder();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.raf.getFilePointer();
                    if (this.raf.read() == 10) continue block4;
                    this.raf.seek(cur);
                    continue block4;
                }
            }
            buffer.append((char)c);
        }
        if (c == -1 && buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    public long countLines(Predicate<String> filter, SimpleTaskStatus status) throws IOException {
        return this.countLines(filter, new MutableInt(), status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countLines(Predicate<String> filter, MutableInt maxLineLen, SimpleTaskStatus status) throws IOException {
        if (this.raf.length() == 0L) {
            return 0L;
        }
        long savedpos = this.getCurrentPosition();
        long count = -1L;
        if (status != null) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            status.message(i18n.getTranslation("_Calculating_number_of_lines"));
            status.setIndeterminate();
        }
        maxLineLen.setValue(0);
        BufferedReader breader = new BufferedReader(this, 51200);
        try {
            String line;
            count = 0L;
            while ((line = breader.readLine()) != null) {
                if (status != null) {
                    if (status.isCancellationRequested()) {
                        long l = -1L;
                        return l;
                    }
                    if (count % 1000L == 0L) {
                        status.setCurValue(count);
                    }
                }
                if (filter.test(line)) continue;
                ++count;
                int l = line.getBytes(this.getCharset()).length;
                if (l <= maxLineLen.getValue()) continue;
                maxLineLen.setValue(l);
            }
            if (status != null) {
                status.setCurValue(count);
                status.message("");
                status.setIndeterminate();
            }
        }
        finally {
            this.seek(savedpos);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isRecomendedTheRecreationOfTheLinesIndex(File index) {
        RandomAccessFileIndex line_idx = null;
        try {
            if (this.lastModified > 0L && this.lastModified > index.lastModified()) {
                boolean bl = true;
                IOUtils.closeQuietly((Closeable)line_idx);
                return bl;
            }
            line_idx = new RandomAccessFileIndex();
            line_idx.open(index);
            if (this.raf.length() != line_idx.getHeader(0)) {
                boolean bl = true;
                IOUtils.closeQuietly((Closeable)line_idx);
                return bl;
            }
            long creationCost = line_idx.getHeader(0);
            if (creationCost < 2000L) {
                boolean bl = true;
                IOUtils.closeQuietly((Closeable)line_idx);
                return bl;
            }
            if (line_idx.get(-1) == 0L) {
                boolean bl = true;
                IOUtils.closeQuietly((Closeable)line_idx);
                return bl;
            }
            boolean bl = false;
            IOUtils.closeQuietly((Closeable)line_idx);
            return bl;
        }
        catch (IOException ex) {
            boolean bl = true;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(line_idx);
        }
    }

    public RandomAccessFileIndex createOrOpenIndexOfLines(File index, Predicate<String> filter, SimpleTaskStatus status) throws IOException {
        return this.createOrOpenIndexOfLines(index, false, filter, status);
    }

    public RandomAccessFileIndex createOrOpenIndexOfLines(File index, boolean safe, Predicate<String> filter, SimpleTaskStatus status) throws IOException {
        return this.createOrOpenIndexOfLines(index, safe, filter, status, null);
    }

    public RandomAccessFileIndex createOrOpenIndexOfLines(File index, boolean safe, Predicate<String> filter, SimpleTaskStatus status, Function<BufferedReader, Integer> numberOfLines) throws IOException {
        if (this.isRecomendedTheRecreationOfTheLinesIndex(index)) {
            return this.createIndexOfLines(index, safe, filter, status, numberOfLines);
        }
        return new RandomAccessFileIndex(index);
    }

    public RandomAccessFileIndex createIndexOfLines(File index, Predicate<String> filter, SimpleTaskStatus status) throws IOException {
        return this.createIndexOfLines(index, false, filter, status);
    }

    public RandomAccessFileIndex createIndexOfLines(File index, boolean safe, Predicate<String> filter, SimpleTaskStatus status) throws IOException {
        return this.createIndexOfLines(index, safe, filter, status, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessFileIndex createIndexOfLines(File index, boolean safe, Predicate<String> filter, SimpleTaskStatus status, Function<BufferedReader, Integer> numberOfLines) throws IOException {
        MutableInt maxLineLen = new MutableInt();
        long countLines = this.countLines(filter, maxLineLen, status);
        if (countLines < 1L) {
            return null;
        }
        int maxBufferForLine = maxLineLen.getValue() + 1024;
        RandomAccessFileIndex line_idx = new RandomAccessFileIndex();
        line_idx.create(index, countLines);
        long savedpos = this.getCurrentPosition();
        try {
            if (status != null) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                status.push();
                status.message(i18n.getTranslation("_Creating_the_index_of_the_lines"));
                status.setRangeOfValues(0L, line_idx.size64());
                status.setCurValue(0L);
            }
            long t1 = System.currentTimeMillis();
            String line = null;
            int lineno = 0;
            long position = 0L;
            if (safe) {
                int x = (int)(countLines / 100L);
                while ((long)lineno < countLines && (line = this.readLine()) != null) {
                    if (filter.test(line)) continue;
                    line_idx.set(lineno++, position);
                    if (status != null) {
                        if (status.isCancellationRequested()) {
                            status.cancel();
                            RandomAccessFileIndex randomAccessFileIndex = null;
                            return randomAccessFileIndex;
                        }
                        if (lineno % x == 0) {
                            status.setCurValue((long)lineno);
                        }
                    }
                    position = this.getCurrentPosition();
                }
                status.setCurValue((long)lineno);
            } else {
                StringBuilder builder = new StringBuilder();
                MyBufferedReader breader = new MyBufferedReader(this, maxBufferForLine);
                while ((long)lineno < countLines) {
                    Integer nextLine;
                    this.seek(position);
                    breader.clean();
                    if (numberOfLines == null) {
                        line = breader.readLine();
                    } else {
                        String l;
                        breader.mark(maxBufferForLine);
                        nextLine = numberOfLines.apply(breader);
                        breader.reset();
                        builder.setLength(0);
                        for (int i = 0; i < nextLine && (l = breader.readLine()) != null; ++i) {
                            builder.append(l);
                        }
                        line = (String)StringUtils.defaultIfBlank((CharSequence)builder.toString(), null);
                    }
                    if (line == null) break;
                    if (filter.test(line)) continue;
                    line_idx.set(lineno++, position);
                    if (status != null) {
                        if (status.isCancellationRequested()) {
                            status.cancel();
                            nextLine = null;
                            return nextLine;
                        }
                        status.incrementCurrentValue();
                    }
                    CharBuffer charBuffer = null;
                    charBuffer = breader.isSkipLf() ? CharBuffer.wrap(line + "\r\n") : CharBuffer.wrap(line + "\n");
                    ByteBuffer byteBuffer = this.charset.encode(charBuffer);
                    position += (long)byteBuffer.limit();
                }
            }
            long t2 = System.currentTimeMillis();
            line_idx.setNumElements(lineno);
            line_idx.setHeader(0, this.raf.length());
            line_idx.setHeader(1, t2 - t1);
            if (status != null) {
                status.message("");
                status.pop();
            }
            RandomAccessFileIndex randomAccessFileIndex = line_idx;
            return randomAccessFileIndex;
        }
        finally {
            this.seek(savedpos);
        }
    }

    public long getLastLinesIndexCreationCost(RandomAccessFileIndex index) {
        return index.getHeader(1);
    }

    public static void main(String[] args) throws Exception {
        String line;
        MyBufferedReader breader;
        long lineoffset;
        int linenumber;
        new DefaultLibrariesInitializer().fullInitialize();
        String fname = "/home/jjdelcerro/Descargas/test/origen_coordenadas.csv";
        File data_file = new File(fname);
        File idx_file = new File(FilenameUtils.removeExtension((String)data_file.getAbsolutePath()) + ".idx");
        TaskStatusManager taskStatusManager = ToolsLocator.getTaskStatusManager();
        taskStatusManager.addObserver((observable, notification) -> {
            TaskStatus status = taskStatusManager.getRunningTaskStatusMostRecent();
        });
        SimpleTaskStatus status = taskStatusManager.createDefaultSimpleTaskStatus(data_file.getName());
        status.add();
        RandomAccessFileReader reader = new RandomAccessFileReader(data_file, "UTF-8");
        System.out.println("Index '" + idx_file.getName() + "', is creation recomended: " + reader.isRecomendedTheRecreationOfTheLinesIndex(idx_file));
        RandomAccessFileIndex lines_idx = reader.createOrOpenIndexOfLines(idx_file, FILTER_NONE, status);
        for (linenumber = 0; linenumber < lines_idx.size(); ++linenumber) {
            lineoffset = lines_idx.get(linenumber);
            reader.seek(lineoffset);
            breader = new MyBufferedReader(reader, 51200);
            line = breader.readLine();
            if (linenumber < 100) {
                System.out.println(String.format("%6d/%d: %s", lineoffset, linenumber, line));
                continue;
            }
            if (linenumber != 100) continue;
            System.out.println("More records...");
        }
        System.out.println("------------------------------------");
        for (linenumber = lines_idx.size() - 1; linenumber >= 0; --linenumber) {
            lineoffset = lines_idx.get(linenumber);
            reader.seek(lineoffset);
            breader = new MyBufferedReader(reader, 51200);
            line = breader.readLine();
            if (linenumber < 100) {
                System.out.println(String.format("%6d/%d: %s", lineoffset, linenumber, line));
                continue;
            }
            if (linenumber != 100) continue;
            System.out.println("More records...");
        }
    }

    public static class MyBufferedReader
    extends BufferedReader {
        private Reader in;
        private char[] cb;
        private int nChars;
        private int nextChar;
        private static final int INVALIDATED = -2;
        private static final int UNMARKED = -1;
        private int markedChar = -1;
        private int readAheadLimit = 0;
        private boolean skipLF = false;
        private boolean markedSkipLF = false;
        private static int defaultCharBufferSize = 8192;
        private static int defaultExpectedLineLength = 80;

        public MyBufferedReader(Reader in, int sz) {
            super(in);
            if (sz <= 0) {
                throw new IllegalArgumentException("Buffer size <= 0");
            }
            this.in = in;
            this.cb = new char[sz];
            this.nChars = 0;
            this.nextChar = 0;
        }

        public MyBufferedReader(Reader in) {
            this(in, defaultCharBufferSize);
        }

        private void ensureOpen() throws IOException {
            if (this.in == null) {
                throw new IOException("Stream closed");
            }
        }

        private void fill() throws IOException {
            int n;
            int dst;
            if (this.markedChar <= -1) {
                dst = 0;
            } else {
                int delta = this.nextChar - this.markedChar;
                if (delta >= this.readAheadLimit) {
                    this.markedChar = -2;
                    this.readAheadLimit = 0;
                    dst = 0;
                } else {
                    if (this.readAheadLimit <= this.cb.length) {
                        System.arraycopy(this.cb, this.markedChar, this.cb, 0, delta);
                        this.markedChar = 0;
                        dst = delta;
                    } else {
                        char[] ncb = new char[this.readAheadLimit];
                        System.arraycopy(this.cb, this.markedChar, ncb, 0, delta);
                        this.cb = ncb;
                        this.markedChar = 0;
                        dst = delta;
                    }
                    this.nextChar = this.nChars = delta;
                }
            }
            while ((n = this.in.read(this.cb, dst, this.cb.length - dst)) == 0) {
            }
            if (n > 0) {
                this.nChars = dst + n;
                this.nextChar = dst;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                while (true) {
                    if (this.nextChar >= this.nChars) {
                        this.fill();
                        if (this.nextChar >= this.nChars) {
                            return -1;
                        }
                    }
                    if (!this.skipLF) break;
                    this.skipLF = false;
                    if (this.cb[this.nextChar] != '\n') break;
                    ++this.nextChar;
                }
                return this.cb[this.nextChar++];
            }
        }

        private int read1(char[] cbuf, int off, int len) throws IOException {
            if (this.nextChar >= this.nChars) {
                if (len >= this.cb.length && this.markedChar <= -1 && !this.skipLF) {
                    return this.in.read(cbuf, off, len);
                }
                this.fill();
            }
            if (this.nextChar >= this.nChars) {
                return -1;
            }
            if (this.skipLF) {
                this.skipLF = false;
                if (this.cb[this.nextChar] == '\n') {
                    ++this.nextChar;
                    if (this.nextChar >= this.nChars) {
                        this.fill();
                    }
                    if (this.nextChar >= this.nChars) {
                        return -1;
                    }
                }
            }
            int n = Math.min(len, this.nChars - this.nextChar);
            System.arraycopy(this.cb, this.nextChar, cbuf, off, n);
            this.nextChar += n;
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                int n1;
                this.ensureOpen();
                if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return 0;
                }
                int n = this.read1(cbuf, off, len);
                if (n <= 0) {
                    return n;
                }
                while (n < len && this.in.ready() && (n1 = this.read1(cbuf, off + n, len - n)) > 0) {
                    n += n1;
                }
                return n;
            }
        }

        String readLine(boolean ignoreLF) throws IOException {
            StringBuilder s = null;
            Object object = this.lock;
            synchronized (object) {
                boolean omitLF;
                this.ensureOpen();
                boolean bl = omitLF = ignoreLF || this.skipLF;
                while (true) {
                    int i;
                    if (this.nextChar >= this.nChars) {
                        this.fill();
                    }
                    if (this.nextChar >= this.nChars) {
                        if (s != null && s.length() > 0) {
                            return s.toString();
                        }
                        return null;
                    }
                    boolean eol = false;
                    char c = '\u0000';
                    if (!omitLF || this.cb[this.nextChar] == '\n') {
                        // empty if block
                    }
                    this.skipLF = false;
                    omitLF = false;
                    for (i = ++this.nextChar; i < this.nChars; ++i) {
                        c = this.cb[i];
                        if (c != '\n' && c != '\r') continue;
                        eol = true;
                        break;
                    }
                    int startChar = this.nextChar;
                    this.nextChar = i;
                    if (eol) {
                        String str;
                        if (s == null) {
                            str = new String(this.cb, startChar, i - startChar);
                        } else {
                            s.append(this.cb, startChar, i - startChar);
                            str = s.toString();
                        }
                        ++this.nextChar;
                        if (c == '\r') {
                            this.skipLF = true;
                        }
                        return str;
                    }
                    if (s == null) {
                        s = new StringBuilder(defaultExpectedLineLength);
                    }
                    s.append(this.cb, startChar, i - startChar);
                }
            }
        }

        @Override
        public String readLine() throws IOException {
            return this.readLine(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException {
            if (n < 0L) {
                throw new IllegalArgumentException("skip value is negative");
            }
            Object object = this.lock;
            synchronized (object) {
                long r;
                long d;
                this.ensureOpen();
                for (r = n; r > 0L; r -= d) {
                    if (this.nextChar >= this.nChars) {
                        this.fill();
                    }
                    if (this.nextChar >= this.nChars) break;
                    if (this.skipLF) {
                        this.skipLF = false;
                        if (this.cb[this.nextChar] == '\n') {
                            ++this.nextChar;
                        }
                    }
                    if (r <= (d = (long)(this.nChars - this.nextChar))) {
                        this.nextChar = (int)((long)this.nextChar + r);
                        r = 0L;
                        break;
                    }
                    this.nextChar = this.nChars;
                }
                return n - r;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean ready() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (this.skipLF) {
                    if (this.nextChar >= this.nChars && this.in.ready()) {
                        this.fill();
                    }
                    if (this.nextChar < this.nChars) {
                        if (this.cb[this.nextChar] == '\n') {
                            ++this.nextChar;
                        }
                        this.skipLF = false;
                    }
                }
                return this.nextChar < this.nChars || this.in.ready();
            }
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mark(int readAheadLimit) throws IOException {
            if (readAheadLimit < 0) {
                throw new IllegalArgumentException("Read-ahead limit < 0");
            }
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.readAheadLimit = readAheadLimit;
                this.markedChar = this.nextChar;
                this.markedSkipLF = this.skipLF;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (this.markedChar < 0) {
                    throw new IOException(this.markedChar == -2 ? "Mark invalid" : "Stream not marked");
                }
                this.nextChar = this.markedChar;
                this.skipLF = this.markedSkipLF;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.in == null) {
                    return;
                }
                try {
                    this.in.close();
                }
                finally {
                    this.in = null;
                    this.cb = null;
                }
            }
        }

        @Override
        public Stream<String> lines() {
            Iterator<String> iter = new Iterator<String>(){
                String nextLine = null;

                @Override
                public boolean hasNext() {
                    if (this.nextLine != null) {
                        return true;
                    }
                    try {
                        this.nextLine = this.readLine();
                        return this.nextLine != null;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }

                @Override
                public String next() {
                    if (this.nextLine != null || this.hasNext()) {
                        String line = this.nextLine;
                        this.nextLine = null;
                        return line;
                    }
                    throw new NoSuchElementException();
                }
            };
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter, 272), false);
        }

        public boolean isSkipLf() {
            return this.skipLF;
        }

        public void clean() {
            this.nChars = 0;
            this.nextChar = 0;
            this.markedChar = -1;
            this.readAheadLimit = 0;
            this.skipLF = false;
            this.markedSkipLF = false;
        }
    }
}

