/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.reversedirection;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Spline;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class ReverseDirectionEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final EditingServiceParameter selectionParameter;
    private FeatureSelection selection;
    private final FeatureStore featureStore;

    public ReverseDirectionEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.selectionParameter = new DefaultEditingServiceParameter("selection", "selection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
    }

    public EditingServiceParameter next() {
        if (this.selection == null) {
            return this.selectionParameter;
        }
        return null;
    }

    public boolean mustRestartAtFinish() {
        return false;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        return null;
    }

    public void stop() throws StopServiceException {
        DisposeUtils.disposeQuietly((Disposable)this.selection);
        this.selection = null;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.selectionParameter);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        if (parameter == this.selectionParameter && value instanceof FeatureSelection) {
            FeatureSelection featureSelection = (FeatureSelection)value;
            if (featureSelection.getSelectedCount() > 0L) {
                try {
                    featureSelection.accept(obj -> {
                        Feature feature = (Feature)obj;
                        Geometry geometry = feature.getDefaultGeometry();
                        GeometryType geometryType = geometry.getGeometryType();
                        if (!geometryType.isTypeOf(2) && !geometryType.isTypeOf(8)) {
                            throw new InvalidEntryException(null);
                        }
                    });
                }
                catch (BaseException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
                ToolsLocator.getDisposableManager().bind((Disposable)((FeatureSelection)value));
                this.selection = featureSelection;
            } else {
                throw new InvalidEntryException(null);
            }
        }
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        if (this.selection != null) {
            EditingProviderServices editingProviderServices = this.getProviderServices();
            try {
                this.selection.accept(obj -> {
                    Feature feature = (Feature)obj;
                    EditableFeature eFeature = feature.getEditable();
                    Geometry geometry = eFeature.getDefaultGeometry();
                    eFeature.setDefaultGeometry(this.reverseDirection(geometry));
                    editingProviderServices.updateFeatureInFeatureStore((Feature)eFeature, this.featureStore);
                });
                DisposeUtils.dispose((Disposable)this.selection);
                this.featureStore.getFeatureSelection().deselectAll();
            }
            catch (BaseException e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
    }

    private Geometry reverseDirection(Geometry geometry) throws GeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        GeometryType geometryType = geometry.getGeometryType();
        if (geometryType.isTypeOf(8)) {
            MultiCurve reversedMultiCurve = geometryManager.createMultiCurve(geometryType.getSubType());
            MultiCurve multicurve = (MultiCurve)geometry;
            for (int i = 0; i < multicurve.getPrimitivesNumber(); ++i) {
                reversedMultiCurve.addCurve(this.reverseCurve(multicurve.getCurveAt(i)));
            }
            return reversedMultiCurve;
        }
        if (geometryType.isTypeOf(2)) {
            return this.reverseCurve((Curve)geometry);
        }
        throw new IllegalArgumentException(String.format("Can't reverse geometry with {} type", geometryType.getType()));
    }

    private Curve reverseCurve(Curve curve) throws GeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        Curve curveToReverse = null;
        Curve reverseCurve = null;
        if (curve instanceof Line || curve instanceof Spline) {
            reverseCurve = (Curve)curve.cloneGeometry();
            reverseCurve.flip();
        } else {
            curveToReverse = (Curve)curve.toLines().getPrimitiveAt(0);
            reverseCurve = (Curve)geometryManager.create(18, curve.getGeometryType().getSubType());
            for (int i = curveToReverse.getNumVertices() - 1; i >= 0; --i) {
                reverseCurve.addVertex(curveToReverse.getVertex(i));
            }
        }
        return reverseCurve;
    }

    public void start() throws StartServiceException, InvalidEntryException {
        FeatureSelection selected = null;
        if (this.featureStore != null) {
            try {
                selected = this.featureStore.getFeatureSelection();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            if (selected.getSelectedCount() > 0L) {
                try {
                    this.setValue(selected);
                }
                catch (InvalidEntryException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
        }
    }

    public String getName() {
        return "modify-reverse-direction";
    }

    public Object getValue(EditingServiceParameter parameter) {
        if (parameter == this.selectionParameter) {
            return this.selection;
        }
        return null;
    }
}

