/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.tool;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Timer;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingLibrary;
import org.gvsig.raster.georeferencing.swing.impl.tool.BaseViewTool;
import org.gvsig.raster.georeferencing.swing.view.GeoreferencingView;
import org.gvsig.raster.georeferencing.swing.view.ToolEvent;
import org.gvsig.raster.georeferencing.swing.view.ToolListener;
import org.gvsig.tools.task.Cancellable;

public class ZoomWheelTool
extends BaseViewTool
implements MouseWheelListener,
ActionListener {
    private Rectangle2D result = null;
    private double x = 0.0;
    private double y = 0.0;
    private double w = 0.0;
    private double h = 0.0;
    private Cancellable cancel = null;
    private Timer timer = new Timer(500, this);
    private ToolEvent toolEvent = null;
    private double scale = 1.0;

    public ZoomWheelTool(ToolListener listener, GeoreferencingView parentView) {
        super(parentView.getCanvas(), listener, parentView);
        this.canvas.addMouseWheelListener(this);
        this.type = GeoreferencingSwingLibrary.ZOOM_WHEEL_TOOL;
        this.cancel = new MyCancellable();
    }

    @Override
    public void draw(Graphics g) {
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
        if (active) {
            this.onTool(new ToolEvent((Object)this, this.getParentView(), null));
        } else {
            this.offTool(new ToolEvent((Object)this, this.getParentView(), null));
        }
    }

    private synchronized void setScale(double scale) {
        this.scale = scale;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() < 1) {
            this.setScale(this.scale + 0.1);
        } else {
            this.setScale(this.scale - 0.02);
        }
        double centerX = e.getX();
        double centerY = e.getY();
        this.w = (double)this.canvas.getWidth() / this.scale;
        this.h = (double)this.canvas.getHeight() / this.scale;
        this.x = (double)e.getX() - this.w / 2.0;
        this.y = (double)e.getY() - this.h / 2.0;
        Point2D.Double iniPoint = new Point2D.Double(this.w / 2.0, this.h / 2.0);
        Point2D.Double endPoint = new Point2D.Double((double)e.getX() / this.scale, (double)e.getY() / this.scale);
        double xx = ((Point2D)iniPoint).getX() - ((Point2D)endPoint).getX();
        double yy = ((Point2D)iniPoint).getY() - ((Point2D)endPoint).getY();
        Point2D.Double displacement = new Point2D.Double(xx, yy);
        Point2D pInit = this.canvas.viewCoordsToWorld(new Point2D.Double(this.x + ((Point2D)displacement).getX(), this.y + ((Point2D)displacement).getY()));
        Point2D pEnd = this.canvas.viewCoordsToWorld(new Point2D.Double(this.x + ((Point2D)displacement).getX() + this.w, this.y + ((Point2D)displacement).getY() + this.h));
        this.result = this.canvas.getMinxMaxyUL() ? new Rectangle2D.Double(pInit.getX(), pEnd.getY(), Math.abs(pInit.getX() - pEnd.getX()), Math.abs(pInit.getY() - pEnd.getY())) : new Rectangle2D.Double(pInit.getX(), pInit.getY(), Math.abs(pInit.getX() - pEnd.getX()), Math.abs(pInit.getY() - pEnd.getY()));
        double shiftX = centerX - centerX * this.scale;
        double shiftY = centerY - centerY * this.scale;
        this.canvas.setActiveMoveRedraw(false);
        this.canvas.setZoomAffineTransform(this.scale, this.scale, shiftX, shiftY);
        this.canvas.repaint();
        this.h = 0.0;
        this.w = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        if (this.toolEvent == null) {
            this.toolEvent = new ToolEvent((Object)this, this.getParentView(), this.cancel);
        }
        this.timer.restart();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.toolEvent.setResult((Object)this.result);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ToolListener)this.listeners.get(i)).endAction(this.toolEvent);
        }
        this.canvas.setActiveMoveRedraw(true);
        this.setScale(1.0);
        this.timer.stop();
    }

    public class MyCancellable
    implements Cancellable {
        private boolean cancel = false;

        public void setCanceled(boolean canceled) {
            this.cancel = canceled;
        }

        public boolean isCanceled() {
            return this.cancel;
        }
    }
}

