/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.view.synchronize;

import java.awt.Color;
import java.awt.geom.Point2D;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPoint;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingLibrary;
import org.gvsig.raster.georeferencing.swing.control.GeorefControlPanel;
import org.gvsig.raster.georeferencing.swing.exception.InvalidRequestException;
import org.gvsig.raster.georeferencing.swing.impl.GeoreferencingSwingImplLibrary;
import org.gvsig.raster.georeferencing.swing.impl.view.BaseViewPanel;
import org.gvsig.raster.georeferencing.swing.impl.view.ViewPanelImpl;
import org.gvsig.raster.georeferencing.swing.impl.view.synchronize.GCPSynchronizationImpl;
import org.gvsig.raster.georeferencing.swing.model.GCPList;
import org.gvsig.raster.georeferencing.swing.view.GeoreferencingView;
import org.gvsig.raster.georeferencing.swing.view.IViewRequestManager;
import org.gvsig.raster.georeferencing.swing.view.SynchronizedViews;
import org.gvsig.raster.georeferencing.swing.view.ToolListener;
import org.gvsig.raster.swing.pagedtable.PagedTable;

public class SynchronizationViewImpl
implements SynchronizedViews {
    private GeoreferencingView viewRaster = null;
    private GeoreferencingView viewMap = null;
    private GeoreferencingView zoomMap = null;
    private GeoreferencingView zoomRaster = null;
    private IViewRequestManager viewRasterRequestManager = null;
    private IViewRequestManager viewMapRequestManager = null;
    private IViewRequestManager zoomRasterRequestManager = null;
    private IViewRequestManager zoomMapRequestManager = null;
    private GCPList gpList = null;
    private GCPSynchronizationImpl gcpSync = null;
    private GeorefControlPanel controlPanel = null;

    public SynchronizationViewImpl(GCPList gpList, ToolListener listener) {
        this.gpList = gpList;
        this.gcpSync = new GCPSynchronizationImpl(gpList, listener);
    }

    public void setViews(GeoreferencingView vMap, GeoreferencingView vRaster, GeoreferencingView zMap, GeoreferencingView zRaster, PagedTable table) {
        this.viewRaster = vRaster;
        this.viewMap = vMap;
        this.zoomMap = zMap;
        this.zoomRaster = zRaster;
        this.gcpSync.setViews(vMap, vRaster, zMap, zRaster, table);
    }

    public void setRequestsManager(IViewRequestManager vMap, IViewRequestManager vRaster, IViewRequestManager zMap, IViewRequestManager zRaster) {
        this.viewRasterRequestManager = vRaster;
        this.viewMapRequestManager = vMap;
        this.zoomRasterRequestManager = zRaster;
        this.zoomMapRequestManager = zMap;
    }

    public void disableAllTools() {
        if (this.zoomMap != null) {
            ((BaseViewPanel)this.zoomMap).disableAllTools();
        }
        if (this.zoomRaster != null) {
            ((BaseViewPanel)this.zoomRaster).disableAllTools();
        }
        if (this.viewRaster != null) {
            ((BaseViewPanel)this.viewRaster).disableAllTools();
        }
        if (this.viewMap != null) {
            ((BaseViewPanel)this.viewMap).disableAllTools();
        }
        this.setActiveLayerPoints(false);
        this.controlPanel.getDragPointButton().setSelected(false);
        this.controlPanel.getMovePointButton().setSelected(false);
    }

    public void disableTool(int tool) {
        if (tool == GeoreferencingSwingLibrary.MOVE_POINT_TOOL) {
            tool = GeoreferencingSwingLibrary.SELECT_POINT_TOOL;
        }
        if (this.zoomMap != null) {
            ((BaseViewPanel)this.zoomMap).disableTool(tool);
        }
        if (this.zoomRaster != null) {
            ((BaseViewPanel)this.zoomRaster).disableTool(tool);
        }
        if (this.viewRaster != null) {
            ((BaseViewPanel)this.viewRaster).disableTool(tool);
        }
        if (this.viewMap != null) {
            ((BaseViewPanel)this.viewMap).disableTool(tool);
        }
        if (tool == GeoreferencingSwingLibrary.DRAG_POINT_TOOL) {
            this.controlPanel.getDragPointButton().setSelected(false);
            this.setActiveLayerPoints(false);
        }
        if (tool == GeoreferencingSwingLibrary.SELECT_POINT_TOOL) {
            this.controlPanel.getMovePointButton().setSelected(false);
        }
    }

    public void setGeoPointList(GCPList gpList) {
        this.gpList = gpList;
    }

    public void sleepActiveTools() {
        if (this.zoomMap != null) {
            ((BaseViewPanel)this.zoomMap).getControl().sleepTools();
        }
        if (this.zoomRaster != null) {
            ((BaseViewPanel)this.zoomRaster).getControl().sleepTools();
        }
        if (this.viewRaster != null) {
            ((BaseViewPanel)this.viewRaster).getControl().sleepTools();
        }
        if (this.viewMap != null) {
            ((BaseViewPanel)this.viewMap).getControl().sleepTools();
        }
    }

    public void awakeActiveTools() {
        if (this.zoomMap != null) {
            ((BaseViewPanel)this.zoomMap).getControl().awakeTools();
        }
        if (this.zoomRaster != null) {
            ((BaseViewPanel)this.zoomRaster).getControl().awakeTools();
        }
        if (this.viewRaster != null) {
            ((BaseViewPanel)this.viewRaster).getControl().awakeTools();
        }
        if (this.viewMap != null) {
            ((BaseViewPanel)this.viewMap).getControl().awakeTools();
        }
    }

    public void enableTool(int tool) {
        if (tool == GeoreferencingSwingLibrary.PAN_TOOL || tool == GeoreferencingSwingLibrary.ZOOM_RECTANGLE_TOOL) {
            if (this.viewRaster != null) {
                ((BaseViewPanel)this.viewRaster).enableToolPressingButton(tool);
            }
            if (this.viewMap != null) {
                ((BaseViewPanel)this.viewMap).enableToolPressingButton(tool);
            }
            return;
        }
        if (tool == GeoreferencingSwingLibrary.MOVE_POINT_TOOL) {
            tool = GeoreferencingSwingLibrary.SELECT_POINT_TOOL;
        }
        if (this.zoomMap != null) {
            ((BaseViewPanel)this.zoomMap).enableTool(tool);
        }
        if (this.zoomRaster != null) {
            ((BaseViewPanel)this.zoomRaster).enableTool(tool);
        }
        if (this.viewRaster != null) {
            ((BaseViewPanel)this.viewRaster).enableTool(tool);
        }
        if (this.viewMap != null) {
            ((BaseViewPanel)this.viewMap).enableTool(tool);
        }
        if (tool == GeoreferencingSwingLibrary.DRAG_POINT_TOOL) {
            this.controlPanel.getDragPointButton().setSelected(true);
            this.setActiveLayerPoints(true);
        }
        if (tool == GeoreferencingSwingLibrary.SELECT_POINT_TOOL) {
            this.controlPanel.getMovePointButton().setSelected(true);
        }
    }

    public void setGraphicsColor(Color c) {
        if (this.viewRaster != null && this.viewRaster instanceof ViewPanelImpl) {
            this.viewRaster.getCanvas().setTextColor(c);
            ((ViewPanelImpl)this.viewRaster).getZoomCursorGraphicLayer().setColor(c);
        }
        if (this.viewMap != null && this.viewRaster instanceof ViewPanelImpl) {
            this.viewMap.getCanvas().setTextColor(c);
            ((ViewPanelImpl)this.viewMap).getZoomCursorGraphicLayer().setColor(c);
        }
        if (this.zoomRaster != null) {
            this.zoomRaster.getCanvas().setTextColor(c);
        }
        if (this.zoomMap != null) {
            this.zoomMap.getCanvas().setTextColor(c);
        }
    }

    public void setBackgroundColor(Color c) {
        if (this.viewMapRequestManager != null) {
            this.viewMapRequestManager.setBackGroundColor(c);
        }
        if (this.viewRasterRequestManager != null) {
            this.viewRasterRequestManager.setBackGroundColor(c);
        }
        if (this.zoomMapRequestManager != null) {
            this.zoomMapRequestManager.setBackGroundColor(c);
        }
        if (this.zoomRasterRequestManager != null) {
            this.zoomRasterRequestManager.setBackGroundColor(c);
        }
        try {
            if (this.viewRaster != null) {
                this.viewRaster.getCanvas().setBackgroundColor(c);
                this.viewRaster.getCanvas().setForceRequest(true);
                ((BaseViewPanel)this.viewRaster).getControl().getExtensionRequest().request(this.viewRaster.getCanvas().getExtent(), null);
            }
            if (this.viewMap != null) {
                this.viewMap.getCanvas().setBackgroundColor(c);
                this.viewMap.getCanvas().setForceRequest(true);
                ((BaseViewPanel)this.viewMap).getControl().getExtensionRequest().request(this.viewMap.getCanvas().getExtent(), null);
            }
            if (this.zoomRaster != null) {
                this.zoomRaster.getCanvas().setBackgroundColor(c);
                this.zoomRaster.getCanvas().setForceRequest(true);
                ((BaseViewPanel)this.zoomRaster).getControl().getExtensionRequest().request(this.zoomRaster.getCanvas().getExtent(), null);
            }
            if (this.zoomMap != null) {
                this.zoomMap.getCanvas().setBackgroundColor(c);
                this.zoomMap.getCanvas().setForceRequest(true);
                ((BaseViewPanel)this.zoomMap).getControl().getExtensionRequest().request(this.zoomMap.getCanvas().getExtent(), null);
            }
        }
        catch (InvalidRequestException invalidRequestException) {
            // empty catch block
        }
    }

    public void centerToPoint(int n) {
        if (this.gpList.size() <= 0) {
            GeoreferencingSwingImplLibrary.messageBoxError("no_selected_point", null);
            return;
        }
        GeoPoint gp = this.gpList.getGeoPoint(n);
        double xMap = gp.getMapPoint().getX();
        double yMap = gp.getMapPoint().getY();
        double xRaster = gp.getPixelPoint().getX();
        double yRaster = gp.getPixelPoint().getY();
        if (this.viewRaster != null && this.viewRaster instanceof ViewPanelImpl) {
            ((ViewPanelImpl)this.viewRaster).setCenter(new Point2D.Double(xRaster, yRaster));
        }
        if (this.zoomRaster != null) {
            ((BaseViewPanel)this.zoomRaster).getControl().setCenter(new Point2D.Double(xRaster, yRaster));
        }
        if (this.viewMap != null && this.viewMap instanceof ViewPanelImpl) {
            ((ViewPanelImpl)this.viewMap).setCenter(new Point2D.Double(xMap, yMap));
        }
        if (this.zoomMap != null) {
            ((BaseViewPanel)this.zoomMap).getControl().setCenter(new Point2D.Double(xMap, yMap));
        }
    }

    public GeoreferencingView getViewMap() {
        return this.viewMap;
    }

    public GeoreferencingView getViewRaster() {
        return this.viewRaster;
    }

    public GeoreferencingView getZoomMap() {
        return this.zoomMap;
    }

    public GeoreferencingView getZoomRaster() {
        return this.zoomRaster;
    }

    public IViewRequestManager getViewMapRequestManager() {
        return this.viewMapRequestManager;
    }

    public IViewRequestManager getViewRasterRequestManager() {
        return this.viewRasterRequestManager;
    }

    public IViewRequestManager getZoomMapRequestManager() {
        return this.zoomMapRequestManager;
    }

    public IViewRequestManager getZoomRasterRequestManager() {
        return this.zoomRasterRequestManager;
    }

    public void setActiveLayerZoomCursor(boolean active) {
        this.gcpSync.setActiveLayerZoomCursor(active);
    }

    public void setActiveNumberPoint(boolean active) {
        this.gcpSync.setActiveNumberPoint(active);
    }

    public void setActiveLayerPoints(boolean active) {
        this.gcpSync.setActiveLayerPoints(active);
    }

    public void redrawPoints() {
        this.gcpSync.redrawPoints();
    }

    public void removePoint(int position) {
        this.gcpSync.removePoint(position);
    }

    public void removeAllPoints() {
        this.gcpSync.removeAllPoints();
    }

    public void synchronizeTablePointsNumerationWithGCPList() {
        this.gcpSync.synchronizeTablePointsNumerationWithGCPList();
    }

    public GeoPoint getPointByNumber(int number) {
        return this.gcpSync.getPointByNumber(number);
    }

    public int getPointPositionByNumber(int number) {
        return this.gcpSync.getPointPositionByNumber(number);
    }

    public void setVisiblePoint(boolean visible, int position) {
        this.gcpSync.setVisiblePoint(visible, position);
    }

    public void setCoordinates(int point, double xMap, double yMap, double xRaster, double yRaster) {
        this.gcpSync.setCoordinates(point, xMap, yMap, xRaster, yRaster);
    }

    public long addPoint(Point2D map, Point2D raster) {
        return this.gcpSync.addPoint(map, raster);
    }

    public void setControlPanel(GeorefControlPanel control) {
        this.controlPanel = control;
    }
}

