/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.dynclass;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.tools.library.impl.DefaultLibrariesInitializer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.impl.dynclass.DefaultModeler;
import org.gvsig.tools.swing.impl.dynclass.DynClassesPanel;
import org.gvsig.tools.swing.impl.dynclass.MenuBarHelper;
import org.gvsig.tools.swing.impl.windowmanager.DefaultDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJModeler
extends JPanel
implements org.gvsig.tools.swing.api.Component,
WindowManager_v2 {
    private static final long serialVersionUID = 6461465381374648630L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultJModeler.class);
    private JDesktopPane desktop;
    private JPanel status;
    private JLabel message;
    private MenuBarHelper menuBar;
    private final DefaultModeler modeler = new DefaultModeler();
    int frameCount = 0;
    static final int xOffset = 30;
    static final int yOffset = 30;

    public static void main(String[] args) {
        new DefaultLibrariesInitializer().fullInitialize();
        DefaultJModeler modeler = new DefaultJModeler();
        WindowManager windowManager = ToolsSwingLocator.getWindowManager();
        windowManager.showWindow(modeler.asJComponent(), "Modeler", WindowManager.MODE.WINDOW);
    }

    public DefaultJModeler() {
        this.initComponents();
    }

    public void addAction(String menuEntry, Action action) {
        this.menuBar.add(menuEntry, action);
    }

    public void addAction(String menuEntry) {
        this.menuBar.add(menuEntry, null);
    }

    private void initComponents() {
        this.menuBar = new MenuBarHelper();
        this.desktop = new JDesktopPane();
        this.addAction("File");
        this.addAction("File", new LoadModelAction());
        this.addAction("File", new ShowClassesAction());
        this.addAction("File/-");
        this.addAction("File", new ExitAction());
        this.status = new JPanel();
        this.status.setLayout(new BorderLayout());
        this.message = new JLabel();
        this.status.add((Component)this.message, "West");
        this.setLayout(new BorderLayout());
        this.add((Component)this.menuBar.asJComponent(), "North");
        this.add((Component)this.desktop, "Center");
        this.add((Component)this.status, "South");
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(800, 600);
    }

    public void showWindow(JComponent component, String tittle, WindowManager.MODE mode) {
        this.showWindow(component, tittle, mode, null, 0);
    }

    public void showWindow(JComponent component, String tittle, WindowManager.MODE mode, Image icon) {
        this.showWindow(component, tittle, mode, icon, 0);
    }

    public void showWindow(JComponent componet, String tittle, WindowManager.MODE mode, Map<String, Object> props) {
        Object icon_o;
        if (props == null || props.isEmpty()) {
            this.showWindow(componet, tittle, mode);
            return;
        }
        int flags = 0;
        Image icon = null;
        Object flags_o = props.get("flags");
        if (flags_o instanceof Number) {
            flags = ((Number)flags_o).intValue();
        }
        if ((icon_o = props.get("icon")) instanceof Image) {
            icon = (Image)icon_o;
        }
        this.showWindow(componet, tittle, mode, icon, flags);
    }

    public void showWindow(JComponent component, String tittle, WindowManager.MODE mode, Image icon, int flags) {
        final JInternalFrame frame = new JInternalFrame(tittle, true, true, true, true);
        ++this.frameCount;
        frame.setLocation(30 * this.frameCount, 30 * this.frameCount);
        frame.setVisible(true);
        frame.setContentPane(component);
        if (icon != null) {
            frame.setFrameIcon(new ImageIcon(icon));
        }
        Dimension d = component.getPreferredSize();
        frame.pack();
        frame.setSize(d);
        component.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                frame.toFront();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                frame.setVisible(false);
            }
        });
        this.desktop.add(frame);
    }

    public Dialog createDialog(JComponent component, String title, String header, int buttons) {
        ModelerDialog dialog = new ModelerDialog(component, title, header, buttons);
        return dialog;
    }

    public void showListOfClasses() {
        DynClassesPanel panel = new DynClassesPanel(this);
        panel.set(this.modeler.getClasses());
        this.showWindow(panel, "Entities", WindowManager.MODE.WINDOW);
    }

    private class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = -4619684474066026298L;

        public ExitAction() {
            this.putValue("Name", "Exit");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJModeler.this.setVisible(false);
        }
    }

    private class ShowClassesAction
    extends AbstractAction {
        private static final long serialVersionUID = -4619684474066026298L;

        public ShowClassesAction() {
            this.putValue("Name", "Show classes");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJModeler.this.showListOfClasses();
        }
    }

    private class LoadModelAction
    extends AbstractAction {
        private static final long serialVersionUID = -4619684474066026298L;

        public LoadModelAction() {
            this.putValue("Name", "Load model");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File[] f = ToolsSwingLocator.getThreadSafeDialogsManager().showOpenFileDialog("Select model", null);
            if (f == null || f.length == 0) {
                return;
            }
            DefaultJModeler.this.modeler.loadModel(f[0]);
            DefaultJModeler.this.showListOfClasses();
        }
    }

    private class ModelerDialog
    extends DefaultDialog {
        private static final long serialVersionUID = 9102998033789035805L;

        public ModelerDialog(JComponent contents, String title, String header, int buttons) {
            super(contents, title, header, buttons);
        }

        @Override
        protected WindowManager getWindowManager() {
            return DefaultJModeler.this;
        }
    }
}

