/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.rectangle;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.prov.rectangle.RectangleEditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class FilledRectangleEditingProvider
extends RectangleEditingProvider
implements EditingProvider {
    public FilledRectangleEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices, parameters);
    }

    @Override
    public Geometry finish() throws FinishServiceException {
        if (this.values != null) {
            Point firstPointValue = (Point)this.values.get(this.firstPoint);
            Point oppistePointValue = (Point)this.values.get(this.oppositePoint);
            if (firstPointValue != null && oppistePointValue != null) {
                EditingProviderServices editingProviderServices = this.getProviderServices();
                GeometryManager geometryManager = GeometryLocator.getGeometryManager();
                try {
                    int subtype = editingProviderServices.getSubType(this.featureStore);
                    Polygon rectangle = geometryManager.createPolygon(subtype);
                    rectangle.addVertex(firstPointValue);
                    Point secondPoint = editingProviderServices.createPoint(oppistePointValue.getX(), firstPointValue.getY(), subtype);
                    rectangle.addVertex(secondPoint);
                    rectangle.addVertex(oppistePointValue);
                    Point thirdPoint = editingProviderServices.createPoint(firstPointValue.getX(), oppistePointValue.getY(), subtype);
                    rectangle.addVertex(thirdPoint);
                    rectangle.addVertex(firstPointValue.cloneGeometry());
                    rectangle.ensureOrientation(false);
                    return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)rectangle);
                }
                catch (BaseException e) {
                    throw new FinishServiceException((Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return "insert-filled-rectangle";
    }
}

