/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.daltransform.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.daltransform.CreateWizardException;
import org.gvsig.daltransform.DataTransformManager;
import org.gvsig.daltransform.NotRegisteredTransformException;
import org.gvsig.daltransform.swing.DataTransformGui;
import org.gvsig.daltransform.swing.DataTransformWizard;
import org.gvsig.daltransform.swing.JDataTransformList;
import org.gvsig.daltransform.swing.JDialogDataTransformList;
import org.gvsig.daltransform.swing.impl.DefaultJDataTransformList;
import org.gvsig.daltransform.swing.impl.DefaultJDialogDataTransformList;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataTransformManager
implements DataTransformManager {
    private static final String TRANSFORM_GUI_EXTENSION_POINT = "TransformGuiExtensionPoint";
    private static final String TRANSFORM_WIZARD_EXTENSION_POINT = "TransformWizardExtensionPoint";
    private static final String TRANSFORM_WIZARD_NAME = "Wizard";
    private static final Logger logger = LoggerFactory.getLogger(DefaultDataTransformManager.class);
    private ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();

    @Override
    public void registerDataTransform(String name, Class<?> featureTransformPage) {
        if (!DataTransformGui.class.isAssignableFrom(featureTransformPage)) {
            throw new IllegalArgumentException(featureTransformPage.getName() + " must implement the DataTransformGui interface");
        }
        ExtensionPoint extensionPoint = this.extensionPoints.add(TRANSFORM_GUI_EXTENSION_POINT, "");
        extensionPoint.append(name, name, featureTransformPage);
    }

    @Override
    public List<DataTransformGui> getDataTransforms() {
        ArrayList<DataTransformGui> transformArray = new ArrayList<DataTransformGui>();
        ExtensionPoint ep = this.extensionPoints.add(TRANSFORM_GUI_EXTENSION_POINT);
        Iterator iterator = ep.iterator();
        while (iterator.hasNext()) {
            try {
                transformArray.add((DataTransformGui)((ExtensionPoint.Extension)iterator.next()).create());
            }
            catch (Exception e) {
                logger.error("Error creating a FeatureTranformationGui", (Throwable)e);
            }
        }
        return transformArray;
    }

    @Override
    public DataTransformWizard createWizard() throws CreateWizardException {
        ExtensionPoint ep = this.extensionPoints.add(TRANSFORM_WIZARD_EXTENSION_POINT);
        try {
            return (DataTransformWizard)ep.create(TRANSFORM_WIZARD_NAME);
        }
        catch (Exception e) {
            throw new CreateWizardException(e);
        }
    }

    @Override
    public void registerDataTransformWizard(Class<?> dataTransformWizard) {
        if (!DataTransformWizard.class.isAssignableFrom(dataTransformWizard)) {
            throw new IllegalArgumentException(dataTransformWizard.getName() + " must implement the DataTransformWizard interface");
        }
        ExtensionPoint extensionPoint = this.extensionPoints.add(TRANSFORM_WIZARD_EXTENSION_POINT, "");
        extensionPoint.append(TRANSFORM_WIZARD_NAME, "", dataTransformWizard);
    }

    @Override
    public DataTransformWizard createWizard(String transformName) throws CreateWizardException {
        ExtensionPoint ep = this.extensionPoints.add(TRANSFORM_GUI_EXTENSION_POINT);
        try {
            Object obj = ep.create(transformName);
            if (obj == null) {
                throw new NotRegisteredTransformException(transformName);
            }
            DataTransformGui dataTransformGui = (DataTransformGui)obj;
            DataTransformWizard wizard = this.createWizard();
            wizard.setDataTransformGui(dataTransformGui);
            return wizard;
        }
        catch (Exception e) {
            throw new CreateWizardException(e);
        }
    }

    @Override
    public JDataTransformList createJDataTransformList(FeatureStore featureStore) {
        return new DefaultJDataTransformList(featureStore);
    }

    @Override
    public JDialogDataTransformList createJDialogDataTransformList() {
        return new DefaultJDialogDataTransformList();
    }
}

