/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.gpe.handlers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.DefaultFeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProviderServices;
import org.gvsig.fmap.dal.store.gpe.GPEStoreProvider;
import org.gvsig.fmap.dal.store.gpe.model.GPEElement;
import org.gvsig.fmap.dal.store.gpe.model.GPEFeature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.gpe.lib.api.parser.IAttributesIterator;
import org.gvsig.gpe.lib.api.parser.ICoordinateIterator;
import org.gvsig.gpe.lib.api.parser.IGPEErrorHandler;
import org.gvsig.gpe.lib.impl.parser.GPEContentHandler;
import org.jfree.util.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FmapContentHandler
extends GPEContentHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FmapContentHandler.class);
    private HashMap featureSet = null;
    private EditableFeatureType featureType = null;
    private FeatureStoreProviderServices store = null;
    private GPEStoreProvider storeProvider = null;
    private GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private int featureId = 0;
    private Envelope envelope = null;
    private File file = null;
    private IProjection srs = null;
    private int geometryType = 0;
    private boolean useAxisOrderYX = false;

    public FmapContentHandler(IGPEErrorHandler errorHandler, FeatureStoreProviderServices store, GPEStoreProvider storeProvider, File file, IProjection srs, int geometryType) {
        this.setErrorHandler(errorHandler);
        this.store = store;
        this.storeProvider = storeProvider;
        this.file = file;
        this.srs = srs;
        this.geometryType = geometryType;
    }

    public FmapContentHandler(IGPEErrorHandler errorHandler, FeatureStoreProviderServices store, GPEStoreProvider storeProvider, File file, IProjection srs, int geometryType, boolean useAxisOrderYX) {
        this(errorHandler, store, storeProvider, file, srs, geometryType);
        this.useAxisOrderYX = useAxisOrderYX;
    }

    public int getFeaturesCount() {
        return this.featureSet.size();
    }

    public Feature getFeatureAt(int index) {
        return (Feature)this.featureSet.get(new Integer(index));
    }

    public EditableFeatureType getFeatureType() {
        return this.featureType;
    }

    public HashMap getFeatureSet() {
        return this.featureSet;
    }

    public Object startLayer(String id, String namespace, String name, String description, String srs, IAttributesIterator iterator, Object parentLayer, Object box) {
        if (this.featureSet == null) {
            this.featureSet = new HashMap();
        }
        if (this.envelope == null) {
            try {
                this.envelope = this.geomManager.createEnvelope(0);
            }
            catch (CreateEnvelopeException e) {
                Log.error((Object)"Error creating the envelope", (Exception)((Object)e));
            }
        }
        return this.featureSet;
    }

    public void endLayer(Object layer) {
        if (this.featureType == null) {
            this.createFeatureType(null);
        }
        this.storeProvider.setEnvelope(this.envelope);
    }

    public Object startPoint(String id, ICoordinateIterator coords, String srs) {
        return this.createPoint(coords);
    }

    private Point createPoint(ICoordinateIterator coords) {
        double[] buffer = new double[coords.getDimension()];
        try {
            coords.hasNext();
            coords.next(buffer);
            Point point = null;
            if (buffer.length == 2) {
                point = (Point)this.geomManager.create(1, 0);
                if (this.useAxisOrderYX) {
                    point.setX(buffer[1]);
                    point.setY(buffer[0]);
                } else {
                    point.setX(buffer[0]);
                    point.setY(buffer[1]);
                }
            } else if (buffer.length == 3) {
                point = (Point)this.geomManager.create(1, 1);
                if (this.useAxisOrderYX) {
                    point.setX(buffer[1]);
                    point.setY(buffer[0]);
                } else {
                    point.setX(buffer[0]);
                    point.setY(buffer[1]);
                }
                point.setCoordinateAt(2, buffer[2]);
            }
            return point;
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
        catch (CreateGeometryException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
        return null;
    }

    private Point createPoint(double[] buffer) {
        try {
            Point point = null;
            if (buffer.length == 2) {
                point = (Point)this.geomManager.create(1, 0);
                if (this.useAxisOrderYX) {
                    point.setX(buffer[1]);
                    point.setY(buffer[0]);
                } else {
                    point.setX(buffer[0]);
                    point.setY(buffer[1]);
                }
            } else if (buffer.length == 3) {
                point = (Point)this.geomManager.create(1, 1);
                if (this.useAxisOrderYX) {
                    point.setX(buffer[1]);
                    point.setY(buffer[0]);
                } else {
                    point.setX(buffer[0]);
                    point.setY(buffer[1]);
                }
                point.setCoordinateAt(2, buffer[2]);
            }
            return point;
        }
        catch (CreateGeometryException e) {
            this.getErrorHandler().addError((Throwable)e);
            return null;
        }
    }

    public Object startLineString(String id, ICoordinateIterator coords, String srs) {
        return this.createCurve(coords);
    }

    private Line createCurve(ICoordinateIterator coords) {
        try {
            Line curve = null;
            if (coords == null || coords.getDimension() == 2) {
                curve = (Line)this.geomManager.create(18, 0);
            } else if (coords.getDimension() == 3) {
                curve = (Line)this.geomManager.create(18, 1);
            }
            while (coords.hasNext()) {
                Point point = this.createPoint(coords);
                curve.addVertex(point);
            }
            return curve;
        }
        catch (CreateGeometryException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
        return null;
    }

    public Object startPolygon(String id, ICoordinateIterator coords, String srs) {
        return this.createPolygon(coords);
    }

    private Polygon createPolygon(ICoordinateIterator coords) {
        try {
            Polygon polygon = null;
            if (coords.getDimension() == 2) {
                polygon = (Polygon)this.geomManager.create(19, 0);
            } else if (coords.getDimension() == 3) {
                polygon = (Polygon)this.geomManager.create(19, 1);
            }
            while (coords.hasNext()) {
                Point point = this.createPoint(coords);
                polygon.addVertex(point);
            }
            if (!polygon.getVertex(0).equals(polygon.getVertex(polygon.getNumVertices() - 1))) {
                polygon.addVertex(polygon.getVertex(0));
            }
            return polygon;
        }
        catch (CreateGeometryException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
        return null;
    }

    public Object startInnerPolygon(String id, ICoordinateIterator coords, String srs) {
        return this.createPolygon(coords);
    }

    public void addGeometryToFeature(Object geometry, Object feature) {
        GPEFeature gpe_feat = (GPEFeature)feature;
        Geometry geom = gpe_feat.getGeometry();
        if (geom == null || geom.getGeometryType().getType() == 16) {
            gpe_feat.setGeometry((Geometry)geometry);
        }
    }

    public void addBboxToLayer(Object bbox, Object layer) {
    }

    public void addElementToFeature(Object element, Object feature) {
        GPEElement gpeElement = (GPEElement)element;
        ((GPEFeature)feature).addElement(gpeElement);
    }

    public void addFeatureToLayer(Object feature, Object layer) {
        GPEFeature gpefeature = (GPEFeature)feature;
        Envelope currentEnvelope = gpefeature.getEnvelope();
        if (this.featureType == null) {
            this.createFeatureType(gpefeature);
            try {
                this.envelope = this.geomManager.createEnvelope(0);
            }
            catch (CreateEnvelopeException e) {
                this.getErrorHandler().addError((Throwable)e);
            }
        }
        if (currentEnvelope != null) {
            this.envelope.add(currentEnvelope);
        }
        if (layer != null) {
            DefaultFeatureProvider data = new DefaultFeatureProvider(this.featureType.getNotEditableCopy(), this.storeProvider.createNewOID());
            LinkedHashMap elements = gpefeature.getelements();
            Iterator keys = elements.keySet().iterator();
            String gid = gpefeature.getId();
            data.setOID((Object)gid);
            while (keys.hasNext()) {
                String elementName = (String)keys.next();
                if (this.featureType.getIndex(elementName) == -1) continue;
                data.set(elementName, ((GPEElement)elements.get(elementName)).getValue());
            }
            data.setDefaultGeometry(gpefeature.getGeometry());
            data.set(this.featureType.getDefaultGeometryAttributeIndex(), (Object)gpefeature.getGeometry());
            ((HashMap)layer).put(gid, data);
        }
    }

    private void createFeatureType(GPEFeature gpefeature) {
        this.featureType = this.store.createFeatureType();
        EditableFeatureAttributeDescriptor attributeDescriptor = this.featureType.add("the_geom", 66).setGeometryType(this.geometryType);
        attributeDescriptor.setGeometrySubType(0);
        attributeDescriptor.setSRS(this.srs);
        this.featureType.setDefaultGeometryAttributeName("the_geom");
        EditableFeatureAttributeDescriptor ed = this.featureType.add("gid", 5);
        ed.setSize(10);
        this.featureType.setHasOID(true);
        if (gpefeature != null) {
            LinkedHashMap elements = gpefeature.getelements();
            for (String elementName : elements.keySet()) {
                if (elementName.equals("the_geom") || elementName.equals("gid")) continue;
                ed = this.featureType.add(elementName, 8);
                ed.setSize(80);
            }
        }
        FeatureType defaultType = this.featureType.getNotEditableCopy();
        ArrayList<FeatureType> types = new ArrayList<FeatureType>(1);
        types.add(defaultType);
        this.store.setFeatureTypes(types, defaultType);
    }

    public void addInnerPolygonToPolygon(Object innerPolygon, Object Polygon2) {
    }

    public void addNameToFeature(String name, Object feature) {
    }

    public void addParentElementToElement(Object parent, Object element) {
    }

    public void addSrsToLayer(String srs, Object Layer) {
    }

    public Object startBbox(String id, ICoordinateIterator coords, String srs) {
        Envelope envelope = null;
        try {
            if (coords.getDimension() == 2) {
                envelope = this.geomManager.createEnvelope(0);
            } else if (coords.getDimension() == 3) {
                envelope = this.geomManager.createEnvelope(1);
            }
            double[] buffer = new double[coords.getDimension()];
            if (coords.hasNext()) {
                coords.next(buffer);
                envelope.setLowerCorner(this.createPoint(buffer));
            }
            if (coords.hasNext()) {
                coords.next(buffer);
                envelope.setUpperCorner(this.createPoint(buffer));
            }
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
        catch (CreateEnvelopeException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
        return envelope;
    }

    public Object startElement(String namespace, String name, Object value, IAttributesIterator attributesIterator, Object parentElement) {
        return new GPEElement(name, value, (GPEElement)parentElement);
    }

    public Object startFeature(String id, String namespace, String name, IAttributesIterator attributes, Object layer) {
        String sId = id == null ? new String(new Long(this.featureId).toString()) : id;
        ++this.featureId;
        return new GPEFeature(sId, name, name);
    }

    public Object startLinearRing(String id, ICoordinateIterator coords, String srs) {
        return this.createPolygon(coords);
    }

    public Object startMultiPoint(String id, String srs, int dimension) {
        try {
            return this.geomManager.create(7, this.getGeometrySubtype(dimension));
        }
        catch (CreateGeometryException e) {
            this.getErrorHandler().addError((Throwable)e);
            return null;
        }
    }

    public Object startMultiPoint(String id, String srs) {
        try {
            return this.geomManager.create(7, 0);
        }
        catch (CreateGeometryException e) {
            this.getErrorHandler().addError((Throwable)e);
            return null;
        }
    }

    public void addPointToMultiPoint(Object point, Object multiPoint) {
        if (point instanceof Point) {
            Point gPoint = (Point)point;
            if (gPoint.getGeometryType().isSubTypeOf(1)) {
                try {
                    Point point2D = (Point)this.geomManager.create(1, 0);
                    point2D.setX(gPoint.getX());
                    point2D.setY(gPoint.getY());
                    ((MultiPoint)multiPoint).addPoint(point2D);
                }
                catch (CreateGeometryException e) {
                    this.getErrorHandler().addError((Throwable)e);
                }
            } else {
                ((MultiPoint)multiPoint).addPoint((Point)point);
            }
        }
    }

    public Object startMultiLineString(String id, String srs, int dimension) {
        try {
            return this.geomManager.create(21, this.getGeometrySubtype(dimension));
        }
        catch (CreateGeometryException e) {
            this.getErrorHandler().addError((Throwable)e);
            return null;
        }
    }

    public Object startMultiLineString(String id, String srs) {
        return this.startMultiLineString(id, srs, 0);
    }

    public void addLineStringToMultiLineString(Object lineString, Object multiLineString) {
        if (lineString instanceof Line) {
            Line gLine = (Line)lineString;
            if (gLine.getGeometryType().isSubTypeOf(1)) {
                try {
                    Line line2D = (Line)this.geomManager.create(18, 0);
                    for (int i = 0; i < gLine.getNumVertices(); ++i) {
                        Point point2D = (Point)this.geomManager.create(1, 0);
                        Point point3D = gLine.getVertex(i);
                        point2D.setX(point3D.getX());
                        point2D.setY(point3D.getY());
                        line2D.addVertex(point2D);
                    }
                    ((MultiLine)multiLineString).addPrimitive((Primitive)line2D);
                }
                catch (CreateGeometryException e) {
                    this.getErrorHandler().addError((Throwable)e);
                }
            } else {
                ((MultiLine)multiLineString).addPrimitive((Primitive)((Line)lineString));
            }
        }
    }

    public Object startMultiPolygon(String id, String srs, int dimension) {
        try {
            return this.geomManager.create(22, this.getGeometrySubtype(dimension));
        }
        catch (CreateGeometryException e) {
            this.getErrorHandler().addError((Throwable)e);
            return null;
        }
    }

    public Object startMultiPolygon(String id, String srs) {
        return this.startMultiPolygon(id, srs, 0);
    }

    public void addPolygonToMultiPolygon(Object polygon, Object multiPolygon) {
        if (polygon instanceof Polygon) {
            Polygon gPolygon = (Polygon)polygon;
            if (gPolygon.getGeometryType().isSubTypeOf(1)) {
                try {
                    Polygon polygon2D = (Polygon)this.geomManager.create(19, 0);
                    for (int p = 0; p < gPolygon.getNumVertices(); ++p) {
                        Point point2D = (Point)this.geomManager.create(1, 0);
                        Point point3D = gPolygon.getVertex(p);
                        point2D.setX(point3D.getX());
                        point2D.setY(point3D.getY());
                        polygon2D.addVertex(point2D);
                    }
                    for (int r = 0; r < gPolygon.getNumInteriorRings(); ++r) {
                        Ring ring2D = (Ring)this.geomManager.create(20, 0);
                        Ring ring3D = gPolygon.getInteriorRing(r);
                        for (int i = 0; i < ring2D.getNumVertices(); ++i) {
                            Point point2D = (Point)this.geomManager.create(1, 0);
                            Point point3D = ring3D.getVertex(i);
                            point2D.setX(point3D.getX());
                            point2D.setY(point3D.getY());
                            ring2D.addVertex(point2D);
                        }
                        polygon2D.addInteriorRing(ring2D);
                    }
                    ((MultiPolygon)multiPolygon).addPrimitive((Primitive)polygon2D);
                }
                catch (CreateGeometryException e) {
                    this.getErrorHandler().addError((Throwable)e);
                }
            } else {
                ((MultiPolygon)multiPolygon).addPrimitive((Primitive)((Polygon)polygon));
            }
        }
    }

    public void addCurveToMultiCurve(Object curve, Object multiCurve) {
        this.addLineStringToMultiLineString(curve, multiCurve);
    }

    public void addSegmentToCurve(Object segment, Object curve) {
        if (segment instanceof Point) {
            ((Curve)curve).addVertex((Point)segment);
        } else if (segment instanceof Curve) {
            Curve seg_cur = (Curve)segment;
            int n = seg_cur.getNumVertices();
            for (int i = 0; i < n; ++i) {
                ((Curve)curve).addVertex(seg_cur.getVertex(i));
            }
        } else {
            LOG.info("Discarded unexpected geometry class: " + (segment == null ? "NULL" : segment.getClass().getName()));
        }
    }

    public Object startCurve(String id, ICoordinateIterator coords, String srs) {
        return this.createCurve(coords);
    }

    public Object startCurve(String id, String srs) {
        return this.createCurve(null);
    }

    public Object startMultiCurve(String id, String srs, int dimension) {
        try {
            return this.geomManager.create(21, this.getGeometrySubtype(dimension));
        }
        catch (CreateGeometryException e) {
            this.getErrorHandler().addError((Throwable)e);
            return null;
        }
    }

    public Object startMultiCurve(String id, String srs) {
        return this.startMultiCurve(id, srs, 0);
    }

    public void addGeometryToMultiGeometry(Object geometry, Object multiGeometry) {
        if (((Geometry)multiGeometry).getGeometryType().isTypeOf(21)) {
            ((MultiLine)multiGeometry).addPrimitive((Primitive)((Line)geometry));
        }
        if (((Geometry)multiGeometry).getGeometryType().isTypeOf(7)) {
            ((MultiPoint)multiGeometry).addPrimitive((Primitive)((Point)geometry));
        }
        if (((Geometry)multiGeometry).getGeometryType().isTypeOf(22)) {
            ((MultiPolygon)multiGeometry).addPrimitive((Primitive)((Polygon)geometry));
        }
    }

    public Object startMultiGeometry(String id, String srs) {
        return null;
    }

    public Object createNewOID() {
        ++this.featureId;
        return String.valueOf(this.featureId);
    }

    public void setEnvelope(Envelope envelope) {
        this.envelope = envelope;
    }

    public void setFeatureType(EditableFeatureType featureType) {
        this.featureType = featureType;
    }

    private int getGeometrySubtype(int dimension) {
        switch (dimension) {
            case 3: {
                return 1;
            }
        }
        return 0;
    }
}

