/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.fonts.glyph.T3Glyphs;
import org.jpedal.fonts.glyph.T3Size;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class Type3
extends PdfFont {
    private GraphicsState currentGraphicsState = new GraphicsState();

    public Type3(PdfObjectReader pdfObjectReader) {
        this.glyphs = new T3Glyphs();
        this.init(pdfObjectReader);
    }

    public final void createFont(PdfObject pdfObject, String string, boolean bl, ObjectStore objectStore, Map map) throws Exception {
        LogWriter.writeMethod("{readType3Font}", 0);
        this.fontTypes = 1228944679;
        this.init(string, bl);
        PdfObject pdfObject2 = pdfObject.getDictionary(-1044665361);
        this.setBoundsAndMatrix(pdfObject);
        this.setName(pdfObject, string);
        this.setEncoding(pdfObject, pdfObject2);
        this.readWidths(pdfObject, false);
        this.readEmbeddedFont(pdfObject, objectStore, this.pageResources);
        if (bl) {
            this.setFont(this.getBaseFontName(), 1);
        }
    }

    private void readEmbeddedFont(PdfObject pdfObject, ObjectStore objectStore, PdfObject pdfObject2) {
        int n = -1;
        int n2 = -1;
        PdfObject pdfObject3 = pdfObject.getDictionary(2054190454);
        if (pdfObject3 != null) {
            PdfObject pdfObject4;
            PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(this.currentPdfFile, true, true);
            pdfStreamDecoder.setStore(objectStore);
            if (pdfObject2 != null) {
                this.currentPdfFile.checkResolved(pdfObject2);
                try {
                    pdfStreamDecoder.readResources(pdfObject2, true);
                }
                catch (PdfException pdfException) {
                    pdfException.printStackTrace();
                }
            }
            if ((pdfObject4 = pdfObject.getDictionary(2004251818)) != null) {
                try {
                    this.currentPdfFile.checkResolved(pdfObject4);
                    pdfStreamDecoder.readResources(pdfObject4, false);
                }
                catch (PdfException pdfException) {
                    pdfException.printStackTrace();
                }
            }
            PdfKeyPairsIterator pdfKeyPairsIterator = pdfObject3.getKeyPairsIterator();
            while (pdfKeyPairsIterator.hasMorePairs()) {
                String string = pdfKeyPairsIterator.getNextKeyAsString();
                PdfObject pdfObject5 = pdfKeyPairsIterator.getNextValueAsDictionary();
                n = -1;
                Object var14_15 = null;
                if (this.diffLookup != null) {
                    String string2 = StandardFonts.convertNumberToGlyph(string, this.containsHexNumbers);
                    var14_15 = this.diffLookup.get(string2);
                }
                if (pdfObject5 != null && this.renderPage) {
                    DynamicVectorRenderer dynamicVectorRenderer = new DynamicVectorRenderer(0, false, 20, objectStore);
                    dynamicVectorRenderer.setHiResImageForDisplayMode(true);
                    dynamicVectorRenderer.setType3Glyph(string);
                    try {
                        pdfStreamDecoder.init(false, true, 7, 0, new PdfPageData(), 0, dynamicVectorRenderer, this.currentPdfFile);
                        pdfStreamDecoder.setDefaultColors(this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getNonstrokeColor());
                        int n3 = 0;
                        int n4 = 0;
                        int n5 = 1;
                        double[] dArray = pdfObject.getDoubleArray(-2105119560);
                        if (dArray != null && dArray[0] == 1.0 && dArray[3] == 1.0) {
                            n5 = 10;
                        }
                        GraphicsState graphicsState = new GraphicsState(0, 0);
                        graphicsState.CTM = new float[][]{{n5, 0.0f, 0.0f}, {0.0f, n5, 0.0f}, {0.0f, 0.0f, 1.0f}};
                        T3Size t3Size = pdfStreamDecoder.decodePageContent(pdfObject5, 0, 0, graphicsState, null);
                        n3 = t3Size.x;
                        n4 = t3Size.y;
                        T3Glyph t3Glyph = new T3Glyph(dynamicVectorRenderer, n3, n4, pdfStreamDecoder.ignoreColors, string);
                        t3Glyph.setScaling(1.0f / (float)n5);
                        n2 = -1;
                        if (var14_15 != null) {
                            n = var14_15;
                            if (pdfKeyPairsIterator.isNextKeyANumber()) {
                                n2 = pdfKeyPairsIterator.getNextKeyAsNumber();
                            }
                        } else {
                            n = pdfKeyPairsIterator.getNextKeyAsNumber();
                        }
                        this.glyphs.setT3Glyph(n, n2, t3Glyph);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        LogWriter.writeLog("Exception " + exception + " is Type3 font code");
                    }
                }
                pdfKeyPairsIterator.nextPair();
            }
            this.isFontEmbedded = true;
        }
    }
}

