/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.grouping;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.SearchListener;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.StoryData;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_String;

public class PdfGroupingAlgorithms {
    private boolean includeHTMLtags = false;
    public int wordDetectionTechnique = 0;
    public static final int USER_DEFINED_LIST_ONLY = 0;
    public static final int SURROUND_BY_ANY_PUNCTUATION = 1;
    public static String SystemSeparator = System.getProperty("line.separator");
    private boolean[] isUsed;
    private String punctuation = ":_ ()!;.,\ufffd/-=+?\\\"'\ufffd\ufffd\ufffd\ufffd\ufffd[]{}";
    private float[] f_x1;
    private float[] f_x2;
    private float[] f_y1;
    private float[] f_y2;
    private boolean[] hadSpace;
    private String[] f_colorTag;
    private int[] writingMode;
    private int[] moveType;
    private int[] fontSize;
    private float[] spaceWidth;
    private StringBuffer[] content;
    private int[] textLength;
    private String hyphen_values = "";
    private PdfData pdf_data;
    PdfPageData pageData;
    private boolean isXHTML = true;
    private int nextSlot;
    private Vector_Int lineBreaks = new Vector_Int();
    private Vector_Object lines;
    private Vector_Int lineY2;
    private static final String MARKER = StoryData.marker;
    public static char MARKER2 = MARKER.charAt(0);
    private int max_rows = 0;
    private int master = 0;
    private boolean colorExtracted = false;
    private int[] line_order;
    private static final int increment = 100;
    private boolean IS_LEGACY = true;
    public static boolean oldTextExtraction = false;
    public static boolean useUnrotatedCoords;
    private float[] endPoints;
    private boolean includeTease;
    private String[] teasers;
    private StringBuffer tease;
    private float endX;
    private List multipleTermTeasers = new ArrayList();
    private boolean usingMultipleTerms = false;
    private String isWholeWordLastLine;
    private int isWholeWordCurrentIndex;
    private Point isWholeWordPosition;
    private boolean removeInvalidXMLValues = true;
    private boolean findAcrossLines = false;
    private boolean onlyCheckStart = false;
    private boolean foundAcrossLine = false;
    private String remainderOfSearch = "";
    private float[] partialFindCoords;
    private String partialFindTeaser;
    private int linkedSearchAreas = -101;

    public PdfGroupingAlgorithms(PdfData pdfData, PdfPageData pdfPageData) {
        this.pdf_data = pdfData;
        this.pageData = pdfPageData;
        this.colorExtracted = pdfData.isColorExtracted();
    }

    public static void setSeparator(String string) {
        SystemSeparator = string;
    }

    private final String getLineDownSeparator(int n, int n2, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        StringBuffer stringBuffer3;
        StringBuffer stringBuffer4;
        String string = " ";
        boolean bl = false;
        if (PdfDecoder.isXMLExtraction()) {
            stringBuffer4 = Strip.stripXML(stringBuffer);
            stringBuffer3 = Strip.stripXML(stringBuffer2);
        } else {
            stringBuffer4 = Strip.trim(stringBuffer);
            stringBuffer3 = Strip.trim(stringBuffer2);
        }
        int n3 = stringBuffer4.length();
        int n4 = stringBuffer3.length();
        if (n3 > 1 && n4 > 1) {
            char c = stringBuffer4.charAt(n3 - 1);
            char c2 = stringBuffer4.charAt(n3 - 2);
            char c3 = stringBuffer3.charAt(0);
            char c4 = stringBuffer3.charAt(1);
            if (this.hyphen_values.indexOf(c) != -1) {
                string = "";
                if (c2 == ':') {
                    string = "\n";
                }
                if (c == ' ') {
                    string = " ";
                }
            } else if ((c2 == '.' | c == '.') & (Character.isUpperCase(c3) | c3 == '&' | Character.isUpperCase(c4) | c4 == '&')) {
                string = PdfDecoder.isXMLExtraction() ? "<p></p>\n" : "\n";
            }
        }
        if (bl) {
            string = PdfDecoder.isXMLExtraction() ? string + "<p></p>\n" : string + '\n';
        }
        return string;
    }

    private final void cleanupShadowsAndDrownedObjects(boolean bl) {
        int[] nArray = this.getUnusedFragments();
        int n = nArray.length;
        String string = "";
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (this.isUsed[n2]) continue;
            float f2 = (this.f_x1[n2] + this.f_x2[n2]) / 2.0f;
            float f3 = (this.f_y1[n2] + this.f_y2[n2]) / 2.0f;
            for (int j = i + 1; j < n; ++j) {
                boolean bl2;
                int n3 = nArray[j];
                if (this.isUsed[n3] || this.isUsed[n2]) continue;
                float f4 = this.fontSize[n3] - this.fontSize[n2];
                if (f4 < 0.0f) {
                    f4 = -f4;
                }
                if ((f = this.f_x2[n3] - this.f_x1[n3] - (this.f_x2[n2] - this.f_x1[n2])) < 0.0f) {
                    f = -f;
                }
                if (f4 == 0.0f && f2 > this.f_x1[n3] && f2 < this.f_x2[n3] && f < 10.0f && f3 < this.f_y1[n3] && f3 > this.f_y2[n3]) {
                    this.isUsed[n3] = true;
                    continue;
                }
                boolean bl3 = this.f_x1[n3] > this.f_x1[n2] && this.f_x2[n3] < this.f_x2[n2] && this.f_y1[n3] < this.f_y1[n2] && this.f_y2[n3] > this.f_y2[n2];
                boolean bl4 = bl2 = this.f_x1[n2] > this.f_x1[n3] && this.f_x2[n2] < this.f_x2[n3] && this.f_y1[n2] < this.f_y1[n3] && this.f_y2[n2] > this.f_y2[n3];
                if (!bl3 && !bl2) continue;
                if (this.f_y2[n2] > this.f_y2[n3]) {
                    string = this.getLineDownSeparator(n3, n2, this.content[n2], this.content[n3]);
                    if (!bl || string.indexOf(32) == -1) {
                        this.merge(n2, n3, string, true);
                    }
                } else {
                    string = this.getLineDownSeparator(n3, n2, this.content[n3], this.content[n2]);
                    if (!bl || string.indexOf(32) == -1) {
                        this.merge(n3, n2, string, true);
                    }
                }
                f2 = (this.f_x1[n2] + this.f_x2[n2]) / 2.0f;
                f3 = (this.f_y1[n2] + this.f_y2[n2]) / 2.0f;
            }
        }
    }

    private final String isGapASpace(int n, int n2, float f, boolean bl, int n3) {
        String string = "";
        float f2 = this.spaceWidth[n] * (float)this.fontSize[n];
        float f3 = this.spaceWidth[n2] * (float)this.fontSize[n2];
        float f4 = f2 > f3 ? f3 : f2;
        int n4 = 0;
        if ((f4 = f / (f4 / 1000.0f)) > 0.6f && f4 < 1.0f) {
            f4 = 1.0f;
        }
        if ((n4 = (int)f4) > 0) {
            string = " ";
        }
        if (n4 > 1 && bl && n3 == 0 | oldTextExtraction) {
            string = " <SpaceCount space=\"" + n4 + "\" />";
        }
        return string;
    }

    private final void merge(int n, int n2, String string, boolean bl) {
        if (this.f_x1[n] > this.f_x1[n2]) {
            this.f_x1[n] = this.f_x1[n2];
        }
        if (this.f_y1[n] < this.f_y1[n2]) {
            this.f_y1[n] = this.f_y1[n2];
        }
        if (this.f_x2[n] < this.f_x2[n2]) {
            this.f_x2[n] = this.f_x2[n2];
        }
        if (this.f_y2[n] > this.f_y2[n2]) {
            this.f_y2[n] = this.f_y2[n2];
        }
        if (PdfDecoder.isXMLExtraction()) {
            String string2 = Fonts.fe;
            if (this.colorExtracted) {
                string2 = Fonts.fe + "</color>";
            }
            if (bl && this.content[n].toString().lastIndexOf(string2) != -1) {
                String string3 = this.content[n].toString();
                this.content[n] = new StringBuffer(string3.substring(0, string3.lastIndexOf(string2)));
                this.content[n].append(string);
                this.content[n].append(string3.substring(string3.lastIndexOf(string2)));
            } else {
                this.content[n].append(string);
            }
            if (this.textLength[n2] > 1 && this.content[n].toString().endsWith(" ")) {
                this.content[n].deleteCharAt(this.content[n].lastIndexOf(" "));
            }
            this.fontSize[n] = this.fontSize[n2];
            if (this.content[n2].indexOf("<color") != -1 && this.content[n].indexOf("<color") != -1 && this.content[n2].toString().startsWith(this.content[n].substring(this.content[n].lastIndexOf("<color"), this.content[n].indexOf(">", this.content[n].lastIndexOf("<color")))) && this.content[n].lastIndexOf("</color>") + 7 == this.content[n].lastIndexOf(">")) {
                this.content[n2].replace(this.content[n2].indexOf("<color"), this.content[n2].indexOf(">") + 1, "");
                this.content[n].replace(this.content[n].lastIndexOf("</color>"), this.content[n].lastIndexOf("</color>") + 8, "");
            }
            if (this.content[n2].indexOf("<font") != -1 && this.content[n].indexOf("<font") != -1 && this.content[n2].toString().startsWith(this.content[n].substring(this.content[n].lastIndexOf("<font"), this.content[n].indexOf(">", this.content[n].lastIndexOf("<font")))) && this.content[n].lastIndexOf("</font>") + 6 == this.content[n].lastIndexOf(">")) {
                this.content[n2].replace(this.content[n2].indexOf("<font"), this.content[n2].indexOf(">") + 1, "");
                this.content[n].replace(this.content[n].lastIndexOf("</font>"), this.content[n].lastIndexOf("</font>") + 7, "");
            }
            this.content[n] = this.content[n].append(this.content[n2]);
            this.textLength[n] = this.textLength[n] + this.textLength[n2];
            this.isUsed[n2] = true;
            this.content[n2] = null;
        } else {
            this.fontSize[n] = this.fontSize[n2];
            this.content[n] = this.content[n].append(string).append(this.content[n2]);
            this.textLength[n] = this.textLength[n] + this.textLength[n2];
            this.isUsed[n2] = true;
            this.content[n2] = null;
        }
    }

    private final void removeEncoding() {
        int[] nArray = this.getUnusedFragments();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (this.isUsed[n2]) continue;
            this.content[n2] = this.removeHiddenMarkers(n2);
        }
    }

    private final void copyToArrays() {
        this.colorExtracted = this.pdf_data.isColorExtracted();
        int n = this.pdf_data.getRawTextElementCount();
        this.isUsed = new boolean[n];
        this.fontSize = new int[n];
        this.writingMode = new int[n];
        this.spaceWidth = new float[n];
        this.content = new StringBuffer[n];
        this.textLength = new int[n];
        this.f_x1 = new float[n];
        this.f_colorTag = new String[n];
        this.f_x2 = new float[n];
        this.f_y1 = new float[n];
        this.f_y2 = new float[n];
        this.moveType = new int[n];
        for (int i = 0; i < n; ++i) {
            this.content[i] = new StringBuffer(this.pdf_data.contents[i]);
            this.fontSize[i] = this.pdf_data.f_end_font_size[i];
            this.writingMode[i] = this.pdf_data.f_writingMode[i];
            this.f_x1[i] = this.pdf_data.f_x1[i];
            this.f_colorTag[i] = this.pdf_data.colorTag[i];
            this.f_x2[i] = this.pdf_data.f_x2[i];
            this.f_y1[i] = this.pdf_data.f_y1[i];
            this.f_y2[i] = this.pdf_data.f_y2[i];
            this.moveType[i] = this.pdf_data.move_command[i];
            this.spaceWidth[i] = this.pdf_data.space_width[i];
            this.textLength[i] = this.pdf_data.text_length[i];
        }
    }

    private int[] getUnusedFragments() {
        int n = this.isUsed.length;
        int n2 = 0;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (this.isUsed[i]) continue;
            nArray[n2] = i;
            ++n2;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    private StringBuffer removeHiddenMarkers(int n) {
        if (this.content[n].indexOf(MARKER) == -1) {
            return this.content[n];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.content[n].toString(), MARKER, true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals(MARKER)) {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringBuffer = stringBuffer.append(stringTokenizer.nextToken());
                continue;
            }
            stringBuffer = stringBuffer.append(string);
        }
        return stringBuffer;
    }

    private ScanLinePair scanLineForValue(StringBuffer[] stringBufferArray, StringBuffer stringBuffer, String string, int n, boolean bl, boolean bl2, float f, float f2) {
        StringBuffer stringBuffer2 = null;
        int n2 = 0;
        int n3 = stringBuffer.length();
        char[] cArray = stringBuffer.toString().toCharArray();
        boolean bl3 = false;
        if (this.includeTease) {
            this.tease = new StringBuffer();
            stringBuffer2 = new StringBuffer();
        }
        float f3 = -1.0f;
        float f4 = -1.0f;
        float f5 = 0.0f;
        StringBuffer stringBuffer3 = new StringBuffer();
        if (!bl) {
            string = string.toLowerCase();
        }
        while (n2 < n3) {
            int n4;
            while (n2 < n3 && cArray[n2] != MARKER2) {
                ++n2;
            }
            if (cArray[n2] != MARKER2) continue;
            int n5 = ++n2;
            while (n2 < n3 && cArray[n2] != MARKER2) {
                ++n2;
            }
            f5 = Float.parseFloat(stringBuffer.substring(n5, n2));
            n5 = ++n2;
            while (n2 < n3 && cArray[n2] != MARKER2) {
                ++n2;
            }
            String string2 = stringBuffer.substring(n5, n2);
            n5 = ++n2;
            while (n2 < n3 && cArray[n2] != MARKER2) {
                ++n2;
            }
            String string3 = stringBuffer.substring(n5, n2);
            if (f5 < (float)n) continue;
            boolean bl4 = false;
            if (PdfDecoder.isXMLExtraction() && (n4 = string3.indexOf(60)) != -1) {
                if (string3.indexOf("<link:") != -1) {
                    bl4 = true;
                }
                string3 = string3.substring(0, n4);
            }
            if (this.includeTease) {
                n4 = stringBuffer2.lastIndexOf(" ");
                if (n4 != -1 && string3.indexOf(32) != -1) {
                    stringBuffer2 = new StringBuffer(stringBuffer2.substring(n4 + 1, stringBuffer2.length()));
                }
                stringBuffer2.append(string3);
                if (bl4) {
                    stringBuffer2.append(' ');
                }
            }
            stringBuffer3.append(string3);
            String string4 = stringBuffer3.toString();
            if (!bl) {
                string4 = string4.toLowerCase();
            }
            if (this.onlyCheckStart && string4.length() <= 1 && string.indexOf(string4) != 0) {
                this.onlyCheckStart = false;
                break;
            }
            if (f3 == -1.0f || string4.length() == 0) {
                f3 = f5;
            }
            int n6 = string4.length();
            if (this.findAcrossLines) {
                if (n2 == n3 && string4.length() > 1 && string.indexOf(string4.substring(0, string4.length() - 1)) == 0 && !string.equals(string4)) {
                    this.foundAcrossLine = true;
                    this.remainderOfSearch = stringBuffer3.toString().endsWith("-") ? string.substring(stringBuffer3.toString().length() - 1) : string.substring(stringBuffer3.toString().length());
                } else {
                    this.foundAcrossLine = false;
                    this.remainderOfSearch = "";
                }
            } else if (n6 > 0 && string4.endsWith("-") && string.length() > 0 && string.indexOf(string4) == -1) {
                string4 = string4.substring(0, n6 - 1);
                stringBuffer3.deleteCharAt(n6 - 1);
            }
            if (string4.indexOf(string) != -1 || this.foundAcrossLine) {
                f4 = f3;
                this.endX = f5 + Float.parseFloat(string2);
                if (bl2) {
                    bl3 = this.foundAcrossLine ? this.isWholeWord(new StringBuffer(stringBuffer.toString().toLowerCase()), n2, n3, stringBuffer3.toString().toLowerCase(), (int)f, (int)f2) : this.isWholeWord(new StringBuffer(stringBuffer.toString().toLowerCase()), n2, n3, string.toLowerCase(), (int)f, (int)f2);
                }
                if (this.includeTease) {
                    this.tease.append(Strip.stripXML(stringBuffer2));
                    if (this.onlyCheckStart) {
                        this.tease.append("</b>");
                    }
                    if (stringBuffer2.toString().endsWith(" ")) {
                        this.tease.append(' ');
                    }
                    if (stringBuffer != null) {
                        this.createTease(stringBufferArray, stringBuffer, n2, n3);
                    }
                }
            } else if (!string.startsWith(string4)) {
                stringBuffer3 = new StringBuffer();
                f3 = -1.0f;
                if (string3.equals(" ")) {
                    stringBuffer2 = new StringBuffer();
                }
            }
            if (!(f4 >= 0.0f)) continue;
            break;
        }
        return new ScanLinePair(f4, bl3);
    }

    public void setIncludeHTML(boolean bl) {
        this.includeHTMLtags = bl;
    }

    private boolean isWholeWord(StringBuffer stringBuffer, int n, int n2, String string, int n3, int n4) {
        String string2 = Strip.stripXML(PdfGroupingAlgorithms.removeHiddenMarkers(stringBuffer.toString())).toString();
        int n5 = 0;
        while (n5 != -1) {
            if (string2.equals(this.isWholeWordLastLine) && this.isWholeWordPosition != null && this.isWholeWordPosition.y == n4) {
                n5 = string2.indexOf(string, this.isWholeWordCurrentIndex + 1);
            } else {
                this.isWholeWordCurrentIndex = 0;
                n5 = string.endsWith(" ") ? string2.indexOf(string.substring(0, string.length() - 1)) : string2.indexOf(string);
            }
            if (n5 == -1) {
                return false;
            }
            this.isWholeWordLastLine = string2;
            this.isWholeWordPosition = new Point(n3, n4);
            this.isWholeWordCurrentIndex = n5;
            switch (this.wordDetectionTechnique) {
                case 0: {
                    char c;
                    if (n5 > 0 && this.punctuation.indexOf(c = string2.charAt(n5 - 1)) == -1 || n5 + string.length() < string2.length() && this.punctuation.indexOf(c = string2.charAt(n5 + string.length())) == -1) break;
                    return true;
                }
                case 1: {
                    char c;
                    if (n5 > 0 && (Character.isLetterOrDigit(c = string2.charAt(n5 - 1)) || this.punctuation.indexOf(c) == -1) || n5 + string.length() < string2.length() && (Character.isLetterOrDigit(c = string2.charAt(n5 + string.length())) || this.punctuation.indexOf(c) == -1)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private void createTease(StringBuffer[] stringBufferArray, StringBuffer stringBuffer, int n, int n2) {
        int n3 = 0;
        int n4 = 3;
        StringBuffer stringBuffer2 = stringBuffer;
        String string = "";
        while (n < n2 && n4 > 0) {
            int n5;
            while (n < n2 && stringBuffer2.charAt(n) != MARKER2) {
                ++n;
            }
            boolean bl = false;
            if (stringBuffer2.charAt(n) == MARKER2 | n == 0) {
                ++n;
                for (n5 = 0; n5 < 3; ++n5) {
                    n3 = n;
                    while (n < n2 && stringBuffer2.charAt(n) != MARKER2) {
                        ++n;
                    }
                    ++n;
                }
                string = stringBuffer2.substring(n3, --n);
                if (PdfDecoder.isXMLExtraction()) {
                    n5 = string.indexOf("<link:");
                    if (n5 != -1) {
                        int n6 = string.indexOf(62, n5);
                        int n7 = Integer.parseInt(string.substring(n5 + 6, n6));
                        n = 0;
                        if (n7 >= stringBufferArray.length) {
                            return;
                        }
                        stringBuffer2 = stringBufferArray[n7];
                        if (stringBuffer2 == null) {
                            return;
                        }
                        n2 = stringBuffer2.length();
                        bl = true;
                    }
                    if ((n5 = string.indexOf(60)) != -1) {
                        string = string.substring(0, n5);
                    }
                }
            }
            if (string.equals(" ")) {
                --n4;
            }
            this.tease.append(Strip.stripXML(string));
            if (string.endsWith(" ")) {
                this.tease.append(' ');
            }
            if (!bl || (n5 = (int)string.charAt(string.length() - 1)) == 45 || n5 == 32) continue;
            this.tease.append(' ');
        }
    }

    public static String removeHiddenMarkers(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(MARKER) == -1) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, MARKER, true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(MARKER)) {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringBuffer = stringBuffer.append(stringTokenizer.nextToken());
                continue;
            }
            stringBuffer = stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private void findVerticalLines(float f, float f2, float f3, float f4, int n) throws PdfException {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n2 = 0;
        int n3 = this.pdf_data.getRawTextElementCount();
        String string = "";
        for (int i = 0; i < n3; ++i) {
            float f5;
            float f6;
            float f7;
            float f8;
            float f9 = 0.0f;
            float f10 = 0.0f;
            string = this.pdf_data.contents[i];
            if (oldTextExtraction | n == 0) {
                f8 = this.f_x1[i];
                f7 = this.f_x2[i];
                f6 = this.f_y1[i];
                f5 = this.f_y2[i];
            } else if (n == 1) {
                f7 = this.f_x1[i];
                f8 = this.f_x2[i];
                f6 = this.f_y1[i];
                f5 = this.f_y2[i];
            } else if (n == 3) {
                f8 = this.f_y1[i];
                f7 = this.f_y2[i];
                f6 = this.f_x2[i];
                f5 = this.f_x1[i];
            } else if (n == 2) {
                f8 = this.f_y2[i];
                f7 = this.f_y1[i];
                f5 = this.f_x1[i];
                f6 = this.f_x2[i];
            } else {
                throw new PdfException("Illegal value " + n + "for currentWritingMode");
            }
            if (!((double)f8 > (double)f - 0.5) || !((double)f7 < (double)f3 + 0.5) || !((double)f5 > (double)f2 - 0.5) || !((double)f6 < (double)f4 + 0.5)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, MARKER, true);
            String string2 = "";
            String string3 = "";
            Object var21_27 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (!string2.equals(MARKER)) continue;
                string2 = stringTokenizer.nextToken();
                if (string2.length() > 0) {
                    f10 = f9;
                    f9 = Float.parseFloat(string2);
                    try {
                        if (string3.length() == 0 || string3.indexOf(32) != -1) {
                            int n4;
                            Integer n5 = new Integer((int)f9);
                            var21_27 = hashMap.get(n5);
                            if (var21_27 == null) {
                                hashMap.put(n5, new Integer(1));
                            } else {
                                n4 = var21_27;
                                if (++n4 > n2) {
                                    n2 = n4;
                                }
                                hashMap.put(n5, new Integer(n4));
                            }
                            n4 = (int)(f10 + (f9 - f10) / 2.0f);
                            if (f10 != 0.0f) {
                                n5 = new Integer(n4);
                                var21_27 = hashMap.get(n5);
                                if (var21_27 == null) {
                                    hashMap.put(n5, new Integer(1));
                                } else {
                                    int n6 = var21_27;
                                    if (++n6 > n2) {
                                        n2 = n6;
                                    }
                                    hashMap.put(n5, new Integer(n6));
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + " stripping x values");
                    }
                }
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                string3 = string2 = stringTokenizer.nextToken();
            }
        }
        Iterator iterator = hashMap.keySet().iterator();
        int n7 = n2 / 2;
        while (iterator.hasNext()) {
            Integer n8 = (Integer)iterator.next();
            int n9 = (Integer)hashMap.get(n8);
            if (n9 <= n7) continue;
            this.lineBreaks.addElement(n8);
        }
    }

    private void copyToArrays(float f, float f2, float f3, float f4, boolean bl, boolean bl2, boolean bl3, String string, boolean bl4) throws PdfException {
        int n = this.pdf_data.getRawTextElementCount() + 100;
        this.f_x1 = new float[n];
        this.f_colorTag = new String[n];
        this.hadSpace = new boolean[n];
        this.f_x2 = new float[n];
        this.f_y1 = new float[n];
        this.f_y2 = new float[n];
        this.spaceWidth = new float[n];
        this.content = new StringBuffer[n];
        this.fontSize = new int[n];
        this.textLength = new int[n];
        this.writingMode = new int[n];
        this.isUsed = new boolean[n];
        this.moveType = new int[n];
        boolean bl5 = false;
        n -= 100;
        float f5 = -1.0f;
        float f6 = 0.0f;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            float f7;
            float f8;
            float f9;
            float f10;
            f6 = this.pdf_data.f_character_spacing[i];
            string2 = this.pdf_data.contents[i];
            float f11 = this.pdf_data.f_x1[i];
            string4 = this.pdf_data.colorTag[i];
            float f12 = this.pdf_data.f_x2[i];
            float f13 = this.pdf_data.f_y1[i];
            float f14 = this.pdf_data.f_y2[i];
            int n2 = this.pdf_data.text_length[i];
            int n3 = this.pdf_data.f_writingMode[i];
            int n4 = this.pdf_data.move_command[i];
            boolean bl6 = false;
            if (oldTextExtraction | n3 == 0 | n3 == 1 && f14 > f2 && f13 < f4 && f11 < f3 && f12 > f) {
                bl6 = true;
            } else if (!oldTextExtraction && n3 == 3 | n3 == 2 && f11 > f && f12 < f3 && f13 > f2 && f14 < f4) {
                bl6 = true;
            }
            if (!bl6) continue;
            if (!bl5 && bl3) {
                this.findVerticalLines(f, f2, f3, f4, n3);
                bl5 = true;
            }
            if (oldTextExtraction | n3 == 0 | n3 == 1) {
                f10 = f11;
                f9 = f11;
                f8 = f;
                f7 = f3;
            } else {
                f10 = f14;
                f9 = f14;
                f8 = f2;
                f7 = f4;
            }
            f5 = -1.0f;
            char[] cArray = string2.toCharArray();
            int n5 = cArray.length;
            int n6 = 0;
            String string5 = "";
            String string6 = "";
            String string7 = "";
            boolean bl7 = false;
            if (string2.indexOf(MARKER) == -1) {
                stringBuffer = new StringBuffer(string2);
            }
            boolean bl8 = true;
            while (n6 < n5) {
                int n7;
                int n8;
                int n9;
                int n10;
                do {
                    if (cArray[n6] != MARKER2) {
                        n10 = n6;
                        while (n6 < n5 && cArray[n6] != MARKER2) {
                            ++n6;
                        }
                        string5 = string2.substring(n10, n6);
                    } else {
                        while (n6 < n5 && cArray[n6] != MARKER2) {
                            ++n6;
                        }
                        n10 = ++n6;
                        while (n6 < n5 && cArray[n6] != MARKER2) {
                            ++n6;
                        }
                        string7 = string2.substring(n10, n6);
                        n10 = ++n6;
                        while (n6 < n5 && cArray[n6] != MARKER2) {
                            ++n6;
                        }
                        string3 = string2.substring(n10, n6);
                        n10 = ++n6;
                        while (n6 < n5 && cArray[n6] != MARKER2) {
                            ++n6;
                        }
                        string6 = string5 = string2.substring(n10, n6);
                        if (string7.length() > 0) {
                            f9 = f10;
                            f10 = Float.parseFloat(string7);
                        }
                        if (PdfDecoder.isXMLExtraction() && f9 < f8 && f10 > f8 && !string5.startsWith(Fonts.fb)) {
                            string5 = Fonts.getActiveFontTag(string2, "") + string5;
                        }
                    }
                    if (f10 > f8 & f10 < f7) break;
                    string5 = "";
                    string6 = "";
                } while (n6 < n5);
                if (bl8) {
                    bl8 = false;
                    if (PdfDecoder.isXMLExtraction() && bl && !string5.startsWith(Fonts.fb) && !string5.startsWith("<color ")) {
                        stringBuffer.append(Fonts.getActiveFontTag(stringBuffer.toString(), string2));
                    }
                }
                if (bl7) {
                    bl7 = false;
                    if (oldTextExtraction | n3 == 0) {
                        f11 = f10;
                    } else if (n3 == 1) {
                        f12 = f10;
                    } else if (n3 == 3) {
                        f14 = f10;
                    } else if (n3 == 2) {
                        f13 = f10;
                    }
                }
                n10 = 0;
                if (bl3 && f6 > 0.0f && stringBuffer.toString().endsWith(" ")) {
                    n9 = this.lineBreaks.size();
                    for (n8 = 0; n8 < n9; ++n8) {
                        n7 = this.lineBreaks.elementAt(n8);
                        if (!(f9 < (float)n7 & f10 > (float)n7)) continue;
                        n8 = n9;
                        n10 = 1;
                    }
                }
                n9 = PdfGroupingAlgorithms.checkForPunctuation(string6, string);
                if (n10 != 0) {
                    float f15 = f11;
                    float f16 = f12;
                    float f17 = f13;
                    float f18 = f14;
                    if (oldTextExtraction | n3 == 0) {
                        f16 = f9 + Float.parseFloat(string3);
                    } else if (n3 == 1) {
                        f15 = f9 + Float.parseFloat(string3);
                    } else if (n3 == 3) {
                        f17 = f9 + Float.parseFloat(string3);
                    } else if (n3 == 2) {
                        f18 = f9 + Float.parseFloat(string3);
                    }
                    this.addFragment(n4, i, stringBuffer, f15, f16, f17, f18, n2, bl, string4, bl4);
                    stringBuffer = new StringBuffer(Fonts.getActiveFontTag(stringBuffer.toString(), string2));
                    stringBuffer.append(string5);
                    if (oldTextExtraction | n3 == 0) {
                        f11 = f10;
                        continue;
                    }
                    if (n3 == 1) {
                        f12 = f10;
                        continue;
                    }
                    if (n3 == 3) {
                        f14 = f10;
                        continue;
                    }
                    if (n3 != 2) continue;
                    f13 = f10;
                    continue;
                }
                if (n9 | (bl2 && (string6.indexOf(32) != -1 || string5.endsWith(" "))) | string6.indexOf("   ") != -1) {
                    if (n9 == 0) {
                        stringBuffer.append(string5.trim());
                    }
                    if (oldTextExtraction | n3 == 0) {
                        this.addFragment(n4, i, stringBuffer, f11, f10, f13, f14, n2, bl, string4, bl4);
                    } else if (n3 == 1) {
                        this.addFragment(n4, i, stringBuffer, f10, f12, f13, f14, n2, bl, string4, bl4);
                    } else if (n3 == 3) {
                        this.addFragment(n4, i, stringBuffer, f11, f12, f10, f14, n2, bl, string4, bl4);
                    } else if (n3 == 2) {
                        this.addFragment(n4, i, stringBuffer, f11, f12, f13, f10, n2, bl, string4, bl4);
                    }
                    if (string3.length() > 0) {
                        if (bl4) {
                            n7 = string6.length();
                            for (n8 = 0; n8 < n7 && string6.charAt(n8) == ' '; ++n8) {
                            }
                        }
                        f10 = n8 > 0 ? (f10 += (float)n8 * Float.parseFloat(string3)) : (f10 += Float.parseFloat(string3));
                    }
                    if (bl2 & this.nextSlot > 0) {
                        this.hadSpace[this.nextSlot - 1] = true;
                    }
                    stringBuffer = new StringBuffer(Fonts.getActiveFontTag(stringBuffer.toString(), string2));
                    if (oldTextExtraction | n3 == 0) {
                        f11 = f10;
                        continue;
                    }
                    if (n3 == 1) {
                        f12 = f10;
                        continue;
                    }
                    if (n3 == 3) {
                        f14 = f10;
                        continue;
                    }
                    if (n3 != 2) continue;
                    f13 = f10;
                    continue;
                }
                if (f5 != -1.0f & f10 > f5) {
                    if (oldTextExtraction | n3 == 0) {
                        this.addFragment(n4, i, stringBuffer, f11, f5, f13, f14, n2, bl, string4, bl4);
                    } else if (n3 == 1) {
                        this.addFragment(n4, i, stringBuffer, f5, f12, f13, f14, n2, bl, string4, bl4);
                    } else if (n3 == 3) {
                        this.addFragment(n4, i, stringBuffer, f11, f12, f5, f14, n2, bl, string4, bl4);
                    } else if (n3 == 2) {
                        this.addFragment(n4, i, stringBuffer, f11, f12, f13, f5, n2, bl, string4, bl4);
                    }
                    stringBuffer = new StringBuffer(Fonts.getActiveFontTag(stringBuffer.toString(), string2));
                    stringBuffer.append(string5);
                    if (oldTextExtraction | n3 == 0) {
                        f11 = f5;
                    } else if (n3 == 1) {
                        f12 = f5;
                    } else if (n3 == 3) {
                        f14 = f5;
                    } else if (n3 == 2) {
                        f13 = f5;
                    }
                    f5 = -1.0f;
                    continue;
                }
                if (PdfDecoder.isXMLExtraction() && string5.endsWith(' ' + Fonts.fe)) {
                    string5 = Fonts.fe;
                    string6 = "";
                    if (oldTextExtraction | n3 == 0) {
                        f12 = f9;
                    } else if (n3 == 1) {
                        f11 = f9;
                    } else if (n3 == 3) {
                        f13 = f9;
                    } else if (n3 == 2) {
                        f14 = f9;
                    }
                }
                stringBuffer.append(string5);
            }
            if (bl && PdfDecoder.isXMLExtraction() && !stringBuffer.toString().endsWith(Fonts.fe) && !stringBuffer.toString().endsWith("</color>")) {
                stringBuffer.append(Fonts.fe);
            }
            if (oldTextExtraction | n3 == 0 | n3 == 1) {
                if (f11 < f12) {
                    this.addFragment(n4, i, stringBuffer, f11, f12, f13, f14, n2, bl, string4, bl4);
                }
            } else if (oldTextExtraction | n3 == 3 | n3 == 2 && f13 > f14) {
                this.addFragment(n4, i, stringBuffer, f11, f12, f13, f14, n2, bl, string4, bl4);
            }
            stringBuffer = new StringBuffer();
        }
        this.isUsed = new boolean[this.nextSlot];
    }

    private static boolean checkForPunctuation(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        boolean bl = false;
        int n = string.length();
        int n2 = n - 1;
        if (n > 0) {
            char c = string.charAt(n2);
            boolean bl2 = c == '>';
            while ((bl2 | c == ' ') & n2 > 0) {
                if (c == '<') {
                    bl2 = false;
                }
                if ((c = string.charAt(--n2)) != '>') continue;
                bl2 = true;
            }
            if (c == ';') {
                bl = true;
                --n2;
                while (n2 > -1) {
                    c = string.charAt(n2);
                    if (c == '&' || c == '#') {
                        bl = false;
                        n2 = 0;
                    }
                    if (n2 != 0 && c != ' ' && Character.isLetterOrDigit(c)) {
                        --n2;
                        continue;
                    }
                    break;
                }
            } else if (string2.indexOf(c) != -1) {
                bl = true;
            }
        }
        return bl;
    }

    private void addFragment(int n, int n2, StringBuffer stringBuffer, float f, float f2, float f3, float f4, int n3, boolean bl, String string, boolean bl2) {
        StringBuffer stringBuffer2 = stringBuffer;
        String string2 = stringBuffer2.toString();
        if (bl2) {
            if (string2.indexOf("&#") != -1) {
                stringBuffer2 = Strip.stripAmpHash(stringBuffer2);
            }
            if (PdfDecoder.isXMLExtraction() && (string2.indexOf("&lt;") != -1 || string2.indexOf("&gt;") != -1)) {
                stringBuffer2 = Strip.stripXMLArrows(stringBuffer2);
            } else if (!(PdfDecoder.isXMLExtraction() || string2.indexOf(60) == -1 && string2.indexOf(62) == -1)) {
                stringBuffer2 = Strip.stripArrows(stringBuffer2);
            }
        }
        if (PdfGroupingAlgorithms.getFirstChar(stringBuffer2) != -1) {
            if (!bl) {
                stringBuffer2 = Strip.stripXML(stringBuffer2);
            } else if (PdfDecoder.isXMLExtraction()) {
                if (this.pdf_data.isColorExtracted() && !stringBuffer2.toString().endsWith("</color>")) {
                    if (!stringBuffer2.toString().endsWith(Fonts.fe)) {
                        stringBuffer2 = stringBuffer2.append(Fonts.fe);
                    }
                    stringBuffer2 = stringBuffer2.append("</color>");
                } else if (!this.pdf_data.isColorExtracted() && !stringBuffer2.toString().endsWith(Fonts.fe)) {
                    stringBuffer2 = stringBuffer2.append(Fonts.fe);
                }
            }
            int n4 = this.f_x1.length;
            if (this.nextSlot < n4) {
                this.f_x1[this.nextSlot] = f;
                this.f_colorTag[this.nextSlot] = string;
                this.f_x2[this.nextSlot] = f2;
                this.f_y1[this.nextSlot] = f3;
                this.f_y2[this.nextSlot] = f4;
                this.moveType[this.nextSlot] = n;
                this.fontSize[this.nextSlot] = this.pdf_data.f_end_font_size[n2];
                this.writingMode[this.nextSlot] = this.pdf_data.f_writingMode[n2];
                this.textLength[this.nextSlot] = n3;
                this.spaceWidth[this.nextSlot] = this.pdf_data.space_width[n2];
                this.content[this.nextSlot] = stringBuffer2;
                ++this.nextSlot;
            } else {
                float[] fArray = new float[n4 += 100];
                String[] stringArray = new String[n4];
                float[] fArray2 = new float[n4];
                float[] fArray3 = new float[n4];
                float[] fArray4 = new float[n4];
                float[] fArray5 = new float[n4];
                StringBuffer[] stringBufferArray = new StringBuffer[n4];
                int[] nArray = new int[n4];
                int[] nArray2 = new int[n4];
                int[] nArray3 = new int[n4];
                int[] nArray4 = new int[n4];
                boolean[] blArray = new boolean[n4];
                boolean[] blArray2 = new boolean[n4];
                for (int i = 0; i < n4 - 100; ++i) {
                    fArray[i] = this.f_x1[i];
                    stringArray[i] = this.f_colorTag[i];
                    fArray2[i] = this.f_x2[i];
                    fArray3[i] = this.f_y1[i];
                    fArray4[i] = this.f_y2[i];
                    blArray2[i] = this.hadSpace[i];
                    fArray5[i] = this.spaceWidth[i];
                    stringBufferArray[i] = this.content[i];
                    nArray[i] = this.fontSize[i];
                    nArray3[i] = this.writingMode[i];
                    nArray2[i] = this.textLength[i];
                    blArray[i] = this.isUsed[i];
                    nArray4[i] = this.moveType[i];
                }
                this.f_x1 = fArray;
                this.f_colorTag = stringArray;
                this.hadSpace = blArray2;
                this.f_x2 = fArray2;
                this.f_y1 = fArray3;
                this.f_y2 = fArray4;
                this.isUsed = blArray;
                this.fontSize = nArray;
                this.writingMode = nArray3;
                this.textLength = nArray2;
                this.spaceWidth = fArray5;
                this.content = stringBufferArray;
                this.moveType = nArray4;
                this.f_x1[this.nextSlot] = f;
                this.f_colorTag[this.nextSlot] = string;
                this.f_x2[this.nextSlot] = f2;
                this.f_y1[this.nextSlot] = f3;
                this.f_y2[this.nextSlot] = f4;
                this.fontSize[this.nextSlot] = this.pdf_data.f_end_font_size[n2];
                this.writingMode[this.nextSlot] = this.pdf_data.f_writingMode[n2];
                nArray2[this.nextSlot] = n3;
                this.content[this.nextSlot] = stringBuffer2;
                this.spaceWidth[this.nextSlot] = this.pdf_data.space_width[n2];
                this.moveType[this.nextSlot] = n;
                ++this.nextSlot;
            }
        }
    }

    private void mergeTableRows(int n) {
        String string = "\n";
        string = "</tr>\n<tr>";
        if (!this.isXHTML) {
            string = "\n";
        }
        this.master = ((Vector_Int)this.lines.elementAt(this.line_order[0])).elementAt(0);
        for (int i = 1; i < this.max_rows; ++i) {
            int n2 = ((Vector_Int)this.lines.elementAt(this.line_order[i])).elementAt(0);
            if (this.content[this.master] == null) {
                this.master = n2;
                continue;
            }
            if (this.content[n2] == null) continue;
            this.merge(this.master, n2, string, false);
        }
        if (this.isXHTML) {
            if (n == 0) {
                this.content[this.master].insert(0, "<TABLE>\n<tr>");
                this.content[this.master].append("</tr>\n</TABLE>\n");
            } else {
                StringBuffer stringBuffer = new StringBuffer("<TABLE border='");
                stringBuffer.append(String.valueOf(n));
                stringBuffer.append("'>\n<tr>");
                stringBuffer.append(this.content[this.master]);
                this.content[this.master] = stringBuffer;
                this.content[this.master].append("</tr>\n</TABLE>\n");
            }
        }
    }

    private final int[] getsortedUnusedFragments(boolean bl, boolean bl2) {
        int n = this.isUsed.length;
        int n2 = 0;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (this.isUsed[i]) continue;
            nArray[n2] = i;
            ++n2;
        }
        int[] nArray2 = new int[n2];
        int[] nArray3 = null;
        int[] nArray4 = new int[n2];
        int[] nArray5 = new int[n2];
        int[] nArray6 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            nArray2[i] = n3 = nArray[i];
            nArray4[i] = (int)this.f_x1[n3];
            nArray5[i] = (int)this.f_y1[n3];
            nArray6[i] = (int)this.f_y2[n3];
        }
        nArray3 = !bl ? (bl2 ? Sorts.quicksort(nArray5, nArray4, nArray2) : Sorts.quicksort(nArray6, nArray4, nArray2)) : Sorts.quicksort(nArray4, nArray5, nArray2);
        return nArray3;
    }

    private void createTableRows(boolean bl, boolean bl2, int n) throws PdfException {
        float f;
        boolean bl3;
        int n2;
        int n3;
        float[] fArray = null;
        float[] fArray2 = null;
        if (oldTextExtraction | n == 0) {
            fArray = this.f_x1;
            fArray2 = this.f_x2;
        } else if (n == 1) {
            fArray2 = this.f_x1;
            fArray = this.f_x2;
        } else if (n == 3) {
            fArray = this.f_y2;
            fArray2 = this.f_y1;
        } else if (n == 2) {
            fArray = this.f_y1;
            fArray2 = this.f_y2;
            n3 = 0;
            for (n2 = 0; n2 < fArray.length; ++n2) {
                if (!((float)n3 < fArray[n2])) continue;
                n3 = (int)fArray[n2];
            }
            ++n3;
            for (n2 = 0; n2 < fArray2.length; ++n2) {
                fArray[n2] = (float)n3 - fArray[n2];
                fArray2[n2] = (float)n3 - fArray2[n2];
            }
        } else {
            throw new PdfException("Illegal value " + n + "for currentWritingMode");
        }
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        int[] nArray = new int[this.max_rows];
        Vector_Int[] vector_IntArray = new Vector_Int[this.max_rows];
        Vector_String vector_String = new Vector_String();
        Vector_Float vector_Float = new Vector_Float();
        Vector_Float vector_Float2 = new Vector_Float();
        String string = "";
        String string2 = "&nbsp;";
        if (!this.isXHTML) {
            string = "\",\"";
            string2 = "";
        }
        int[] nArray2 = new int[this.max_rows];
        for (n2 = 0; n2 < this.max_rows; ++n2) {
            nArray2[n2] = ((Vector_Int)this.lines.elementAt(n2)).size() - 1;
            n5 += nArray2[n2];
            nArray[n2] = 0;
            vector_IntArray[n2] = new Vector_Int(20);
        }
        do {
            float f2 = 9999.0f;
            float f3 = 9999.0f;
            float f4 = 9999.0f;
            f = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 9999.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            ++n4;
            bl3 = true;
            float f10 = 0.0f;
            float f11 = 0.0f;
            float f12 = 0.0f;
            float f13 = 0.0f;
            String string3 = "center";
            if (n6 >= n5) continue;
            for (n2 = 0; n2 < this.max_rows; ++n2) {
                if (nArray2[n2] <= nArray[n2]) continue;
                n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2]);
                f = fArray[n3];
                f5 = fArray2[n3];
                if (f < f2) {
                    f2 = f;
                }
                if (!(f5 < f3)) continue;
                f3 = f5;
            }
            vector_Float2.addElement(f2);
            f4 = f3;
            for (n2 = 0; n2 < this.max_rows; ++n2) {
                n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2]);
                f6 = fArray[n3];
                if (f6 >= f2 & f6 < f3 & (f8 = fArray2[n3]) > f4) {
                    f4 = f8;
                }
                if (nArray[n2] >= nArray2[n2] || !((f = fArray[n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2] + 1)]) > f3 & f < f7)) continue;
                f7 = f;
            }
            if (f7 == 9999.0f) {
                f7 = f4;
            }
            for (n2 = 0; n2 < this.max_rows; ++n2) {
                n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2]);
                f6 = fArray[n3];
                if (!(f6 >= f2 & f6 < f3 & (f8 = fArray2[n3]) <= f7)) continue;
                f10 += f6;
                f11 += f8;
                f9 += 1.0f;
            }
            if (n2 == 0) {
                f12 = f2;
            }
            f13 = f7 == -1.0f ? 0.0f : (float)((int)((f7 - f4) / 2.0f));
            int n7 = (int)(f4 - f2 + f13 + f12);
            f12 = f13;
            vector_Float.addElement(n7);
            float f14 = f10 / f9 - f2;
            float f15 = f4 - f11 / f9;
            if (f14 < 1.0f) {
                string3 = "left";
            } else if (f15 < 1.0f) {
                string3 = "right";
            }
            vector_String.addElement(string3);
            for (n2 = 0; n2 < this.max_rows; ++n2) {
                this.master = ((Vector_Int)this.lines.elementAt(n2)).elementAt(0);
                if (nArray2[n2] > nArray[n2]) {
                    n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2]);
                    f6 = fArray[n3];
                    f8 = fArray2[n3];
                    bl3 = false;
                } else {
                    n3 = -1;
                    f6 = -1.0f;
                    f8 = -1.0f;
                }
                if (n3 == -1 & n6 <= n5) {
                    vector_IntArray[n2].addElement(-1);
                    continue;
                }
                if (f6 >= f2 & f6 < f4) {
                    vector_IntArray[n2].addElement(n3);
                    int n8 = n2;
                    nArray[n8] = nArray[n8] + 1;
                    ++n6;
                    continue;
                }
                if (!(f6 > f4)) continue;
                vector_IntArray[n2].addElement(-1);
            }
        } while (!bl3);
        for (int i = 0; i < this.max_rows; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            int n9 = vector_IntArray[i].size() - 1;
            this.master = ((Vector_Int)this.lines.elementAt(i)).elementAt(0);
            for (n2 = 0; n2 < n9; ++n2) {
                n3 = vector_IntArray[i].elementAt(n2);
                if (this.isXHTML) {
                    f = vector_Float.elementAt(n2);
                    String string4 = vector_String.elementAt(n2);
                    int n10 = -1;
                    int n11 = 1;
                    int n12 = n2 + 1;
                    if (n3 != -1) {
                        while (!((n10 = vector_IntArray[i].elementAt(n2 + 1)) != -1 | n9 == n2 + 1) && !(nArray2[i] > 1 & vector_Float2.elementAt(n2 + 1) > fArray2[n3])) {
                            --n9;
                            vector_IntArray[i].removeElementAt(n2 + 1);
                            ++n11;
                            f += vector_Float.elementAt(n12);
                            ++n12;
                        }
                    }
                    stringBuffer.append("<td");
                    if (bl) {
                        stringBuffer.append(" align='");
                        stringBuffer.append(string4);
                        stringBuffer.append('\'');
                        if (n11 > 1) {
                            stringBuffer.append(" colspan='").append(n11).append('\'');
                        }
                    }
                    if (bl2) {
                        stringBuffer.append(" width='").append((int)f).append('\'');
                    }
                    stringBuffer.append(" nowrap>");
                    if (n3 == -1) {
                        stringBuffer.append(string2);
                    } else {
                        stringBuffer.append(this.content[n3]);
                    }
                    stringBuffer.append("</td>");
                } else if (n3 == -1) {
                    stringBuffer.append("\"\",");
                } else {
                    stringBuffer.append('\"');
                    stringBuffer.append(this.content[n3]);
                    stringBuffer.append("\",");
                }
                if (n3 == -1 || this.master == n3) continue;
                this.merge(this.master, n3, string, false);
            }
            this.content[this.master] = stringBuffer;
        }
    }

    private Vector_Object createLinesInTable(int n, int[] nArray, boolean bl, int n2) throws PdfException {
        float[] fArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        float[] fArray4 = null;
        if (!oldTextExtraction && n2 == 1) {
            nArray = PdfGroupingAlgorithms.reverse(nArray);
        }
        if (oldTextExtraction | n2 == 0) {
            fArray = this.f_x1;
            fArray2 = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n2 == 1) {
            fArray2 = this.f_x1;
            fArray = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n2 == 3) {
            fArray = this.f_y1;
            fArray2 = this.f_y2;
            fArray3 = this.f_x2;
            fArray4 = this.f_x1;
        } else if (n2 == 2) {
            fArray = this.f_y2;
            fArray2 = this.f_y1;
            fArray4 = this.f_x1;
            fArray3 = this.f_x2;
            nArray = this.getsortedUnusedFragments(false, true);
            nArray = PdfGroupingAlgorithms.reverse(nArray);
        } else {
            throw new PdfException("Illegal value " + n2 + "for currentWritingMode");
        }
        Vector_Int vector_Int = new Vector_Int(20);
        String string = "";
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[i];
            int n5 = -1;
            int n6 = n4;
            float f = -1.0f;
            if (this.isUsed[n4] || !(this.writingMode[n4] == n2 | oldTextExtraction)) continue;
            vector_Int = new Vector_Int(20);
            vector_Int.addElement(n4);
            this.lineY2.addElement((int)fArray4[n4]);
            while (true) {
                for (int j = 0; j < n; ++j) {
                    float f2;
                    int n7 = nArray[j];
                    if (this.isUsed[n7] || n7 == n4 || !(this.writingMode[n4] == n2 | oldTextExtraction) || !((fArray[n7] > fArray[n4] && n2 != 2 | oldTextExtraction) | (fArray[n7] < fArray[n4] && !oldTextExtraction && n2 == 2))) continue;
                    float f3 = fArray[n7] - fArray2[n4];
                    if (!oldTextExtraction && n2 == 1 | n2 == 2) {
                        f3 = -f3;
                    }
                    if (f3 < 0.0f & f3 > -2.0f) {
                        f3 = 0.0f;
                    }
                    if (!((f2 = (fArray3[n7] + fArray4[n7]) / 2.0f) < fArray3[n4]) || !(f2 > fArray4[n4]) || !(f < 0.0f | f3 < f)) continue;
                    f = f3;
                    n5 = n7;
                }
                if (n5 == -1) break;
                float f4 = fArray[n5] - fArray2[n6];
                float f5 = fArray[n5] - fArray2[n4];
                float f6 = 1.5f * ((fArray2[n5] - fArray[n5]) / (float)this.textLength[n5]);
                float f7 = 1.5f * ((fArray2[n6] - fArray[n6]) / (float)this.textLength[n6]);
                if (!oldTextExtraction && n2 == 1 | n2 == 2) {
                    f5 = -f5;
                    f4 = -f4;
                    f6 = -f6;
                    f7 = -f7;
                }
                if (f4 < f6 & f4 < f7) {
                    string = this.isGapASpace(n5, n6, f5, bl, n2);
                    this.merge(n6, n5, string, true);
                } else {
                    vector_Int.addElement(n5);
                    n6 = n5;
                }
                this.isUsed[n5] = true;
                n5 = -1;
                f = 1000000.0f;
                ++n3;
            }
            this.lines.addElement(vector_Int);
            vector_Int = new Vector_Int(20);
            ++this.max_rows;
        }
        return this.lines;
    }

    public final Map extractTextAsTable(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n6) throws PdfException {
        int[] nArray = PdfGroupingAlgorithms.validateCoordinates(n, n2, n3, n4);
        n = nArray[0];
        n2 = nArray[1];
        n3 = nArray[2];
        n4 = nArray[3];
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        LogWriter.writeLog("extracting Text As Table");
        this.isXHTML = !bl;
        this.lines = new Vector_Object(20);
        this.lineY2 = new Vector_Int(20);
        this.max_rows = 0;
        this.copyToArrays(n, n4, n3, n2, bl2, false, true, null, false);
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] nArray2 = this.getsortedUnusedFragments(true, false);
        int n7 = nArray2.length;
        if (n7 == 0) {
            return hashtable;
        }
        int n8 = this.getWritingMode(nArray2, n7);
        String string = "Table Merging algorithm being applied " + n7 + " items";
        LogWriter.writeLog(string);
        if (n7 > 1) {
            this.createLinesInTable(n7, nArray2, this.isXHTML, n8);
            int n9 = 1;
            if (oldTextExtraction | n8 == 0 | n8 == 2) {
                n9 = -1;
            }
            this.line_order = new int[this.max_rows];
            int[] nArray3 = new int[this.max_rows];
            for (int i = 0; i < this.max_rows; ++i) {
                nArray3[i] = n9 * this.lineY2.elementAt(i);
                this.line_order[i] = i;
            }
            this.line_order = Sorts.quicksort(nArray3, this.line_order);
            this.createTableRows(bl4, bl3, n8);
            this.mergeTableRows(n6);
        }
        this.content[this.master] = this.cleanup(this.content[this.master]);
        String string2 = this.content[this.master].toString();
        if (string2 != null) {
            if (!bl) {
                string2 = Fonts.cleanupTokens(string2);
            }
            hashtable.put("content", string2);
            hashtable.put("x1", String.valueOf(n));
            hashtable.put("x2", String.valueOf(n3));
            hashtable.put("y1", String.valueOf(n2));
            hashtable.put("y2", String.valueOf(n4));
        }
        return hashtable;
    }

    private static int[] validateCoordinates(int n, int n2, int n3, int n4) throws PdfException {
        if (n > n3 | n2 < n4) {
            int n5;
            if (n > n3) {
                n5 = n;
                n = n3;
                n3 = n5;
                LogWriter.writeLog("x1 > x2, coordinates were swapped to validate");
            }
            if (n2 < n4) {
                n5 = n2;
                n2 = n4;
                n4 = n5;
                LogWriter.writeLog("y1 < y2, coordinates were swapped to validate");
            }
        }
        return new int[]{n, n2, n3, n4};
    }

    public final Vector extractTextAsWordlist(int n, int n2, int n3, int n4, int n5, boolean bl, String string) throws PdfException {
        int[] nArray = PdfGroupingAlgorithms.validateCoordinates(n, n2, n3, n4);
        n = nArray[0];
        n2 = nArray[1];
        n3 = nArray[2];
        n4 = nArray[3];
        if (bl) {
            this.copyToArrays(n, n4, n3, n2, true, true, false, string, true);
        } else {
            this.copyToArrays();
        }
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(true);
        int[] nArray2 = this.getsortedUnusedFragments(true, false);
        int n6 = nArray2.length;
        if (n6 == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int n7 = this.getWritingMode(nArray2, n6);
        this.createLines(n6, nArray2, n7, true, false, false);
        float[] fArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        float[] fArray4 = null;
        if (useUnrotatedCoords | oldTextExtraction | n7 == 0) {
            fArray = this.f_x1;
            fArray2 = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n7 == 1) {
            fArray2 = this.f_x1;
            fArray = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n7 == 3) {
            fArray = this.f_y2;
            fArray2 = this.f_y1;
            fArray3 = this.f_x2;
            fArray4 = this.f_x1;
        } else if (n7 == 2) {
            fArray = this.f_y1;
            fArray2 = this.f_y2;
            fArray4 = this.f_x1;
            fArray3 = this.f_x2;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == null) continue;
            if (this.colorExtracted && PdfDecoder.isXMLExtraction()) {
                if (!this.content[i].toString().toLowerCase().startsWith("<color ")) {
                    this.content[i].insert(0, this.f_colorTag[this.master]);
                }
                if (!this.content[i].toString().toLowerCase().endsWith("</color>")) {
                    this.content[i].append("</color>");
                }
            }
            if (PdfDecoder.isXMLExtraction()) {
                vector.add(this.content[i].toString());
            } else {
                vector.add(Strip.convertToText(this.content[i].toString()));
            }
            if (!useUnrotatedCoords && n7 == 2) {
                vector.add(String.valueOf(this.pdf_data.maxY - fArray[i]));
                vector.add(String.valueOf(fArray3[i]));
                vector.add(String.valueOf(this.pdf_data.maxY - fArray2[i]));
                vector.add(String.valueOf(fArray4[i]));
                continue;
            }
            if (!useUnrotatedCoords && n7 == 3) {
                vector.add(String.valueOf(fArray[i]));
                vector.add(String.valueOf(this.pdf_data.maxX - fArray4[i]));
                vector.add(String.valueOf(fArray2[i]));
                vector.add(String.valueOf(this.pdf_data.maxX - fArray3[i]));
                continue;
            }
            vector.add(String.valueOf(fArray[i]));
            vector.add(String.valueOf(fArray3[i]));
            vector.add(String.valueOf(fArray2[i]));
            vector.add(String.valueOf(fArray4[i]));
        }
        LogWriter.writeLog("Text extraction as wordlist completed");
        return vector;
    }

    private void reset() {
        this.isXHTML = true;
        this.nextSlot = 0;
        this.lineBreaks = new Vector_Int();
        this.max_rows = 0;
        this.master = 0;
        this.colorExtracted = false;
        this.tease = null;
        this.endX = 0.0f;
    }

    public final String extractTextInRectangle(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) throws PdfException {
        this.reset();
        if (bl2 && !this.pdf_data.IsEmbedded()) {
            throw new PdfException("[PDF] Request to breakfragments and width not added. Please add call to init(true) of PdfDecoder to your code.");
        }
        int[] nArray = PdfGroupingAlgorithms.validateCoordinates(n, n2, n3, n4);
        n = nArray[0];
        n2 = nArray[1];
        n3 = nArray[2];
        n4 = nArray[3];
        int n6 = 0;
        int n7 = 0;
        if (bl2) {
            this.copyToArrays(n, n4, n3, n2, PdfDecoder.isXMLExtraction(), false, false, null, false);
        } else {
            this.copyToArrays();
        }
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] nArray2 = this.getsortedUnusedFragments(true, false);
        n7 = nArray2.length;
        if (n7 == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int n8 = this.getWritingMode(nArray2, n7);
        this.createLines(n7, nArray2, n8, false, PdfDecoder.isXMLExtraction(), false);
        n6 = this.mergeLinesTogether(n8, bl, n, n3, n2, n4);
        if (PdfDecoder.isXMLExtraction()) {
            this.content[n6] = new StringBuffer(Fonts.cleanupTokens(this.content[n6].toString()));
            this.content[n6].insert(0, "<p>");
            this.content[n6].append("</p>");
        }
        LogWriter.writeLog("Text extraction completed");
        return this.cleanup(this.content[n6]).toString();
    }

    private StringBuffer cleanup(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return stringBuffer;
        }
        if (PdfDecoder.isXMLExtraction()) {
            String string = stringBuffer.toString();
            string = string.replaceAll("&#", "XX#");
            string = string.replaceAll("&lt", "XXlt");
            string = string.replaceAll("&gt", "XXgt");
            string = string.replaceAll("&", "&amp;");
            string = string.replaceAll("XX#", "&#");
            string = string.replaceAll("XXlt", "&lt");
            string = string.replaceAll("XXgt", "&gt");
            if (this.removeInvalidXMLValues) {
                int n;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (n = 1; n <= 8; ++n) {
                    hashMap.put("&#" + n + ';', "");
                }
                for (n = 11; n <= 12; ++n) {
                    hashMap.put("&#" + n + ';', "");
                }
                for (n = 14; n <= 31; ++n) {
                    hashMap.put("&#" + n + ';', "");
                }
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    String string3 = (String)hashMap.get(string2);
                    string = string.replace(string2, string3);
                }
            }
            stringBuffer = new StringBuffer(string);
        }
        return stringBuffer;
    }

    private int getWritingMode(int[] nArray, int n) {
        int n2 = this.writingMode[nArray[0]];
        if (n2 == 0 | n2 == 1) {
            return n2;
        }
        for (int i = 1; i < n; ++i) {
            int n3 = nArray[i];
            if (this.isUsed[n3] || !(this.writingMode[n3] == 0 | this.writingMode[n3] == 1)) continue;
            n2 = this.writingMode[n3];
            i = n;
            LogWriter.writeLog("Text of multiple orientations found. Only horizontal text used.");
        }
        return n2;
    }

    private int mergeLinesTogether(int n, boolean bl, int n2, int n3, int n4, int n5) throws PdfException {
        int n6;
        int[] nArray;
        float[] fArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        float[] fArray4 = null;
        if (oldTextExtraction | n == 0) {
            fArray = this.f_x1;
            fArray2 = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
            nArray = this.getsortedUnusedFragments(false, true);
            n6 = (n2 + n3) / 2;
        } else if (n == 1) {
            fArray2 = this.f_x1;
            fArray = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
            nArray = this.getsortedUnusedFragments(false, true);
            n6 = (n2 + n3) / 2;
        } else if (n == 3) {
            fArray = this.f_y1;
            fArray2 = this.f_y2;
            fArray3 = this.f_x2;
            fArray4 = this.f_x1;
            nArray = this.getsortedUnusedFragments(true, true);
            nArray = PdfGroupingAlgorithms.reverse(nArray);
            n6 = (n4 + n5) / 2;
        } else if (n == 2) {
            fArray = this.f_y2;
            fArray2 = this.f_y1;
            fArray4 = this.f_x2;
            fArray3 = this.f_x1;
            nArray = this.getsortedUnusedFragments(true, true);
            n6 = (n4 + n5) / 2;
        } else {
            throw new PdfException("Illegal value " + n + "for currentWritingMode");
        }
        int n7 = n6 / 2;
        int n8 = nArray.length;
        int n9 = nArray[n8 - 1];
        Object var17_16 = null;
        Object var18_17 = null;
        for (int i = n8 - 2; i > -1; --i) {
            int n10 = nArray[i];
            String string = "";
            int n11 = PdfGroupingAlgorithms.getLastChar(this.content[n10]);
            if (n11 == -1) continue;
            this.addAlignmentFormatting(bl, n6, fArray, fArray2, n7, n10);
            String string2 = "</p>" + SystemSeparator + "<p>";
            if (PdfDecoder.isXMLExtraction()) {
                string2 = SystemSeparator;
            }
            float f = fArray4[n9] - fArray3[n10];
            float f2 = fArray3[n10] - fArray4[n10];
            if (!oldTextExtraction && n == 3) {
                f = -f;
                f2 = -f2;
            }
            if (f > f2 & f2 > 0.0f) {
                while (f > f2) {
                    string = string + string2;
                    f -= f2;
                }
                string = PdfDecoder.isXMLExtraction() ? string + "</p>" + SystemSeparator + "<p>" : SystemSeparator;
            } else if (bl) {
                int n12 = PdfGroupingAlgorithms.getFirstChar(this.content[n10]);
                int n13 = PdfGroupingAlgorithms.getLastChar(this.content[n9]);
                if ((n13 == 46 || n13 == 34) && n12 >= 65 && n12 <= 90) {
                    string = PdfDecoder.isXMLExtraction() ? "</p>" + SystemSeparator + "<p>" : SystemSeparator;
                }
            } else if (this.IS_LEGACY) {
                if (PdfDecoder.isXMLExtraction()) {
                    this.content[n10].insert(0, "</p>" + SystemSeparator + "<p>");
                } else {
                    this.content[n9].append(SystemSeparator);
                }
            } else if (PdfDecoder.isXMLExtraction()) {
                this.content[n10].insert(0, "</p>" + SystemSeparator + "<p>");
            } else {
                this.content[n9].append(SystemSeparator);
            }
            this.merge(n9, n10, string, false);
        }
        return n9;
    }

    private static int getFirstChar(StringBuffer stringBuffer) {
        int n = -1;
        boolean bl = false;
        int n2 = stringBuffer.length();
        int n3 = 32;
        for (int i = 0; i < n2; ++i) {
            char c = stringBuffer.charAt(i);
            if (!bl && (c == '<' || PdfDecoder.isXMLExtraction() && c == '&')) {
                bl = true;
                n3 = c;
                if (n3 == 38) {
                    if (i + 1 == n2) {
                        n = 38;
                        i = n2;
                    } else {
                        char c2 = stringBuffer.charAt(i + 1);
                        if (c2 != '#' && c2 != 'g' && c2 != 'l') {
                            n = 38;
                            i = n2;
                        }
                    }
                }
            }
            if (!bl && c != ' ') {
                n = c;
                i = n2;
            }
            if (bl && n3 == 38 && c == ' ') {
                n = n3;
                i = n2;
                continue;
            }
            if (!bl || c != '>' && (!PdfDecoder.isXMLExtraction() || n3 != 38 || c != ';')) continue;
            if (c == ';' && n3 == 38 && i > 2 & stringBuffer.charAt(i - 1) == 't') {
                if (stringBuffer.charAt(i - 2) == 'l') {
                    n = 60;
                    i = n2;
                } else if (stringBuffer.charAt(i - 2) == 'g') {
                    n = 62;
                    i = n2;
                }
            }
            bl = false;
        }
        return n;
    }

    private static int getLastChar(StringBuffer stringBuffer) {
        int n = -1;
        boolean bl = false;
        int n2 = stringBuffer.length();
        int n3 = n2--;
        int n4 = 32;
        while (n2 > -1) {
            char c = stringBuffer.charAt(n2);
            if (bl && n4 == 59 && c == ';') {
                n = 59;
                n2 = -1;
            }
            if (!bl && (c == '>' || PdfDecoder.isXMLExtraction() && c == ';')) {
                bl = true;
                n4 = c;
            }
            if (!bl && c != ' ') {
                n = c;
                n2 = -1;
            }
            if (c == '<' || PdfDecoder.isXMLExtraction() && n4 == 59 && c == '&') {
                bl = false;
                if (c == '&' && n2 + 3 < n3 & stringBuffer.charAt(n2 + 2) == 't' && stringBuffer.charAt(n2 + 3) == ';') {
                    if (stringBuffer.charAt(n2 + 1) == 'l') {
                        n = 60;
                        n2 = -1;
                    } else if (stringBuffer.charAt(n2 + 1) == 'g') {
                        n = 62;
                        n2 = -1;
                    }
                }
            }
            if (bl && n4 == 59 && c == ' ') {
                n2 = -1;
                n = 59;
            }
            --n2;
        }
        return n;
    }

    private static int[] reverse(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[n - i - 1];
        }
        return nArray2;
    }

    private void addAlignmentFormatting(boolean bl, int n, float[] fArray, float[] fArray2, int n2, int n3) {
        float f = (float)n - fArray[n3];
        float f2 = fArray2[n3] - (float)n;
        if (!bl && PdfDecoder.isXMLExtraction() && f > 0.0f && f2 > 0.0f && fArray[n3] > (float)n2 && fArray[n3] < (float)(n + n2)) {
            float f3 = f / f2;
            if (f3 > 1.0f) {
                f3 = 1.0f / f3;
            }
            if ((double)f3 > 0.95) {
                this.content[n3] = new StringBuffer(Fonts.cleanupTokens(this.content[n3].toString()));
                this.content[n3].insert(0, "<center>");
                this.content[n3].append("</center>\n");
            } else if (f2 < 10.0f & f > 30.0f) {
                this.content[n3] = new StringBuffer(Fonts.cleanupTokens(this.content[n3].toString()));
                this.content[n3].insert(0, "<right>");
                this.content[n3].append("</right>\n");
            }
        }
    }

    private void createLines(int n, int[] nArray, int n2, boolean bl, boolean bl2, boolean bl3) throws PdfException {
        float[] fArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        float[] fArray4 = null;
        if (!(oldTextExtraction || n2 != 1 && n2 != 2)) {
            nArray = PdfGroupingAlgorithms.reverse(nArray);
        }
        if (oldTextExtraction || n2 == 0) {
            fArray = this.f_x1;
            fArray2 = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n2 == 1) {
            fArray2 = this.f_x1;
            fArray = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n2 == 3) {
            fArray = this.f_y1;
            fArray2 = this.f_y2;
            fArray3 = this.f_x2;
            fArray4 = this.f_x1;
        } else if (n2 == 2) {
            fArray = this.f_y2;
            fArray2 = this.f_y1;
            fArray4 = this.f_x1;
            fArray3 = this.f_x2;
        } else {
            throw new PdfException("Illegal value " + n2 + "for currentWritingMode");
        }
        block0: for (int i = 0; i < n; ++i) {
            int n3 = -1;
            int n4 = nArray[i];
            float f = -1.0f;
            float f2 = 0.0f;
            if (this.isUsed[n4] || this.writingMode[n4] != n2 && !oldTextExtraction) continue;
            while (true) {
                for (int j = 0; j < n; ++j) {
                    float f3;
                    int n5;
                    int n6 = nArray[j];
                    if (this.isUsed[n6]) continue;
                    int n7 = (int)(fArray4[n6] - fArray4[n4]);
                    if (n7 < 0) {
                        n7 = -n7;
                    }
                    if ((n5 = (int)(fArray3[n6] - fArray3[n4])) < 0) {
                        n5 = -n5;
                    }
                    int n8 = (int)(fArray[n6] - fArray2[n4]);
                    int n9 = this.fontSize[n4] - this.fontSize[n6];
                    if (n9 < 0) {
                        n9 = -n9;
                    }
                    if (bl3 && n8 > this.fontSize[n4] && n8 > 0 || bl3 && n7 > 1 && n8 > 2 * this.fontSize[n4] && this.fontSize[n4] == this.fontSize[n6] || bl3 && n7 > 3 || bl3 && n9 > 2 || n6 == n4 || (!(fArray[n6] > fArray[n4]) || n2 == 2 && !oldTextExtraction) && (!(fArray[n6] < fArray[n4]) || oldTextExtraction || n2 != 2 || this.writingMode[n4] != n2 && !oldTextExtraction || n9 > 2 && (n9 <= 2 || n5 >= 3))) continue;
                    f2 = fArray[n6] - fArray2[n4];
                    if (!(oldTextExtraction || n2 != 1 && n2 != 2)) {
                        f2 = -f2;
                    }
                    if (f2 < 0.0f && f2 > -2.0f) {
                        f2 = 0.0f;
                    }
                    if (!((f3 = (fArray3[n6] + fArray4[n6]) / 2.0f) < fArray3[n4]) || !(f3 > fArray4[n4]) || !(f < 0.0f) && !(f2 < f)) continue;
                    f = f2;
                    n3 = n6;
                }
                if (n3 == -1) continue block0;
                float f4 = fArray[n3] - fArray2[n4];
                if (!oldTextExtraction) {
                    if (n2 == 1 || n2 == 2) {
                        f4 = -f4;
                    } else if (n2 == 3) {
                        f4 = fArray2[n3] - fArray[n4];
                    }
                }
                String string = this.isGapASpace(n4, n3, f4, bl2, n2);
                if (bl && this.hadSpace != null && (this.hadSpace[n4] || string.startsWith(" "))) continue block0;
                this.merge(n4, n3, string, true);
                n3 = -1;
                f = 1000000.0f;
            }
        }
    }

    public SortedMap findMultipleTermsInRectangleWithMatchingTeasers(int n, int n2, int n3, int n4, int n5, int n6, String[] stringArray, int n7, SearchListener searchListener) throws PdfException {
        this.usingMultipleTerms = true;
        this.multipleTermTeasers.clear();
        List list = this.findMultipleTermsInRectangle(n, n2, n3, n4, n6, stringArray, n7, searchListener);
        TreeMap treeMap = new TreeMap(new ResultsComparator(n5));
        for (int i = 0; i < list.size(); ++i) {
            treeMap.put(list.get(i), this.multipleTermTeasers.get(i));
        }
        this.usingMultipleTerms = false;
        return treeMap;
    }

    public List findMultipleTermsInRectangle(int n, int n2, int n3, int n4, int n5, int n6, String[] stringArray, boolean bl, int n7, SearchListener searchListener) throws PdfException {
        this.usingMultipleTerms = true;
        this.multipleTermTeasers.clear();
        List list = this.findMultipleTermsInRectangle(n, n2, n3, n4, n6, stringArray, n7, searchListener);
        if (bl) {
            Collections.sort(list, new ResultsComparator(n5));
        }
        this.usingMultipleTerms = false;
        return list;
    }

    private List findMultipleTermsInRectangle(int n, int n2, int n3, int n4, int n5, String[] stringArray, int n6, SearchListener searchListener) throws PdfException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            Rectangle rectangle;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            String string = stringArray[i];
            if (searchListener != null && searchListener.isCanceled()) break;
            float[] fArray = null;
            if ((n6 & 8) == 8) {
                fArray = this.findTextInRectangleAcrossLines(n, n4, n3 + n, n2, n5, string, n6);
                if (fArray == null) continue;
                n12 = fArray.length;
                for (n11 = 0; n11 < n12; n11 += 5) {
                    n10 = (int)fArray[n11];
                    n9 = (int)fArray[n11 + 1];
                    n8 = (int)fArray[n11 + 2];
                    n7 = (int)fArray[n11 + 3];
                    rectangle = new Rectangle(n10, n7, n8 - n10, n9 - n7);
                    int n13 = (int)fArray[n11 + 4];
                    if (n13 == this.linkedSearchAreas) {
                        Vector_Rectangle vector_Rectangle = new Vector_Rectangle();
                        vector_Rectangle.addElement(rectangle);
                        while (n13 == this.linkedSearchAreas) {
                            n10 = (int)fArray[n11 += 5];
                            n9 = (int)fArray[n11 + 1];
                            n8 = (int)fArray[n11 + 2];
                            n7 = (int)fArray[n11 + 3];
                            n13 = (int)fArray[n11 + 4];
                            rectangle = new Rectangle(n10, n7, n8 - n10, n9 - n7);
                            vector_Rectangle.addElement(rectangle);
                        }
                        vector_Rectangle.trim();
                        arrayList.add(vector_Rectangle.get());
                        continue;
                    }
                    arrayList.add(rectangle);
                }
                continue;
            }
            fArray = this.findTextInRectangle(n, n4, n3 + n, n2, n5, string, n6);
            if (fArray == null) continue;
            n12 = fArray.length;
            for (n11 = 0; n11 != n12; ++n11) {
                n10 = (int)fArray[n11];
                n9 = (int)this.endPoints[n11];
                n8 = (int)this.endPoints[++n11];
                n7 = (int)fArray[n11];
                rectangle = new Rectangle(n10, n8, n9 - n10, n7 - n8);
                arrayList.add(rectangle);
            }
        }
        return arrayList;
    }

    public final float[] findTextInRectangle(int n, String string, int n2) throws PdfException {
        int n3 = this.pageData.getMediaBoxX(n);
        int n4 = this.pageData.getMediaBoxWidth(n);
        int n5 = this.pageData.getMediaBoxY(n);
        int n6 = this.pageData.getMediaBoxHeight(n);
        return this.findTextInRectangle(n3, n6 + n5, n4 + n3, n5, n, string, n2);
    }

    public final float[] findTextInRectangle(int n, int n2, int n3, int n4, int n5, String string, int n6) throws PdfException {
        if (string == null) {
            return null;
        }
        if ((n6 & 8) == 8) {
            return this.findTextInRectangleAcrossLines(n, n2, n3, n4, n5, string, n6);
        }
        boolean bl = (n6 & 2) == 2;
        boolean bl2 = (n6 & 4) != 4;
        boolean bl3 = (n6 & 1) == 1;
        string = PdfGroupingAlgorithms.removeDuplicateSpaces(string);
        StringBuffer[] stringBufferArray = null;
        if (string.length() == 0) {
            return null;
        }
        float[] fArray = null;
        float[] fArray2 = null;
        if (this.pageData != null && this.pageData.getRotation(n5) == 90 || this.pageData.getRotation(n5) == 270) {
            int n7 = n;
            n = n2;
            n2 = n7;
            n7 = n3;
            n3 = n4;
            n4 = n7;
        }
        int[] nArray = PdfGroupingAlgorithms.validateCoordinates(n, n2, n3, n4);
        n = nArray[0];
        n2 = nArray[1];
        n3 = nArray[2];
        n4 = nArray[3];
        this.copyToArrays();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] nArray2 = this.getsortedUnusedFragments(true, false);
        int n8 = nArray2.length;
        if (n8 == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        block6: for (int i = 0; i != nArray2.length; ++i) {
            switch (this.writingMode[nArray2[i]]) {
                case 0: {
                    ++n9;
                    continue block6;
                }
                case 1: {
                    ++n10;
                    continue block6;
                }
                case 2: {
                    ++n11;
                    continue block6;
                }
                case 3: {
                    ++n12;
                }
            }
        }
        int[] nArray3 = new int[]{n9, n10, n11, n12};
        int[] nArray4 = new int[]{n9, n10, n11, n12};
        int[] nArray5 = new int[]{-1, -1, -1, -1};
        Arrays.sort(nArray4);
        for (int i = 0; i != nArray3.length; ++i) {
            for (int j = 0; j < nArray4.length; ++j) {
                if (nArray3[i] != nArray4[j]) continue;
                int n13 = j - 3;
                if (n13 < 0) {
                    n13 = -n13;
                }
                if (nArray5[n13] != -1) continue;
                nArray5[n13] = i;
                j = nArray4.length;
            }
        }
        Vector_Int vector_Int = new Vector_Int(20);
        Vector_Int vector_Int2 = new Vector_Int(20);
        Vector_String vector_String = new Vector_String(20);
        int n14 = 0;
        for (int i = 0; i != nArray5.length; ++i) {
            Object object;
            int n15;
            int n16;
            int n17 = nArray5[i];
            if (this.includeTease) {
                int n18 = this.content.length;
                stringBufferArray = new StringBuffer[n18];
                for (int j = 0; j < n18; ++j) {
                    if (this.content[j] == null) continue;
                    stringBufferArray[j] = new StringBuffer(this.content[j].toString());
                    if (!(this.moveType[j] == 0 | (this.moveType[j] == 2 && j < n18 - 1 && this.f_x1[j] < this.f_x2[j + 1] && this.f_x2[j] > this.f_x1[j + 1]))) continue;
                    this.content[j].append("<link:");
                    this.content[j].append(j + 1);
                    this.content[j].append('>');
                }
            }
            this.createLines(n8, nArray2, n17, true, false, true);
            float[] fArray3 = null;
            float[] fArray4 = null;
            boolean bl4 = false;
            if (oldTextExtraction | n17 == 0) {
                fArray3 = this.f_y1;
                fArray4 = this.f_y2;
            } else if (n17 == 1) {
                fArray3 = this.f_y1;
                fArray4 = this.f_y2;
            } else if (n17 == 3) {
                fArray3 = this.f_x2;
                fArray4 = this.f_x1;
                bl4 = true;
            } else if (n17 == 2) {
                fArray4 = this.f_x1;
                fArray3 = this.f_x2;
                bl4 = true;
            } else {
                throw new PdfException("Illegal value " + n17 + "for currentWritingMode");
            }
            int[] nArray6 = this.getsortedUnusedFragments(false, true);
            n8 = nArray6.length;
            float f = -1.0f;
            block11: for (n16 = n8 - 1; n16 > -1; --n16) {
                n15 = nArray6[n16];
                if (this.writingMode[n15] != n17 || this.content[n15] == null) continue;
                int n19 = n;
                while (n19 < n3) {
                    object = this.scanLineForValue(stringBufferArray, PdfGroupingAlgorithms.removeDuplicateSpaces(this.content[n15]), string, n19, bl, bl3, this.endX, fArray4[n15]);
                    f = ((ScanLinePair)object).finalX;
                    if (f > (float)n && f < (float)n3 && (float)n2 > fArray3[n15] && (float)n4 < fArray4[n15] && f != -1.0f && (!bl3 || bl3 && ((ScanLinePair)object).isWholeWord)) {
                        if (bl4) {
                            if (n17 == 3) {
                                vector_Int.addElement((int)fArray4[n15]);
                                vector_Int.addElement((int)this.endX);
                                vector_Int2.addElement((int)fArray3[n15]);
                                vector_Int2.addElement((int)f);
                            } else {
                                vector_Int.addElement((int)fArray4[n15]);
                                vector_Int.addElement((int)f);
                                vector_Int2.addElement((int)fArray3[n15]);
                                vector_Int2.addElement((int)this.endX);
                            }
                        } else {
                            vector_Int.addElement((int)f);
                            vector_Int.addElement((int)fArray3[n15]);
                            vector_Int2.addElement((int)this.endX);
                            vector_Int2.addElement((int)fArray4[n15]);
                        }
                        if (this.includeTease) {
                            vector_String.addElement(this.tease.toString());
                        }
                        ++n14;
                        if (!bl2) {
                            n16 = n8;
                            n3 = n19;
                        }
                    }
                    if (n15 == n8 || f == -1.0f) continue block11;
                    n19 = (int)f + 1;
                }
            }
            stringBufferArray = null;
            if (n14 <= 0) continue;
            fArray = new float[n14 * 2];
            for (n16 = 0; n16 < n14 * 2; ++n16) {
                fArray[n16] = vector_Int.elementAt(n16);
            }
            fArray2 = new float[n14 * 2];
            for (n16 = 0; n16 < n14 * 2; ++n16) {
                fArray2[n16] = vector_Int2.elementAt(n16);
            }
            if (!this.includeTease) continue;
            this.teasers = new String[n14];
            for (n15 = 0; n15 < n14; ++n15) {
                String string2 = vector_String.elementAt(n15);
                if (this.includeHTMLtags) {
                    if (!bl) {
                        object = string.toLowerCase();
                        int n20 = ((String)object).length();
                        String string3 = string2.toLowerCase();
                        StringBuffer stringBuffer = new StringBuffer(string2);
                        int n21 = string3.indexOf((String)object);
                        while (n21 != -1) {
                            stringBuffer.insert(n21 + n20, "</b>");
                            stringBuffer.insert(n21, "<b>");
                            n21 = n21 + 7 + n20;
                            n21 = stringBuffer.indexOf((String)object, n21);
                        }
                        string2 = stringBuffer.toString();
                    } else {
                        string2 = string2.replaceAll(string, "<b>" + string + "</b>");
                    }
                }
                if (this.usingMultipleTerms) {
                    this.multipleTermTeasers.add(string2);
                    continue;
                }
                this.teasers[n15] = string2;
            }
        }
        LogWriter.writeLog("Text scan completed");
        this.endPoints = fArray2;
        return fArray;
    }

    public final float[] findTextInRectangleAcrossLines(int n, int n2, int n3, int n4, int n5, String string, int n6) throws PdfException {
        int n7;
        int n8;
        if (string == null) {
            return null;
        }
        boolean bl = (n6 & 2) == 2;
        boolean bl2 = (n6 & 4) != 4;
        boolean bl3 = (n6 & 1) == 1;
        string = PdfGroupingAlgorithms.removeDuplicateSpaces(string);
        StringBuffer[] stringBufferArray = null;
        if (string.length() == 0) {
            return null;
        }
        float[] fArray = null;
        if (this.pageData != null && this.pageData.getRotation(n5) == 90 || this.pageData.getRotation(n5) == 270) {
            int n9 = n;
            n = n2;
            n2 = n9;
            n9 = n3;
            n3 = n4;
            n4 = n9;
        }
        int[] nArray = PdfGroupingAlgorithms.validateCoordinates(n, n2, n3, n4);
        n = nArray[0];
        n2 = nArray[1];
        n3 = nArray[2];
        n4 = nArray[3];
        this.copyToArrays();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] nArray2 = this.getsortedUnusedFragments(true, false);
        int n10 = nArray2.length;
        if (n10 == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        block6: for (int i = 0; i != nArray2.length; ++i) {
            switch (this.writingMode[nArray2[i]]) {
                case 0: {
                    ++n11;
                    continue block6;
                }
                case 1: {
                    ++n12;
                    continue block6;
                }
                case 2: {
                    ++n13;
                    continue block6;
                }
                case 3: {
                    ++n14;
                }
            }
        }
        int[] nArray3 = new int[]{n11, n12, n13, n14};
        int[] nArray4 = new int[]{n11, n12, n13, n14};
        int[] nArray5 = new int[]{-1, -1, -1, -1};
        Arrays.sort(nArray4);
        for (int i = 0; i != nArray3.length; ++i) {
            for (n8 = 0; n8 < nArray4.length; ++n8) {
                if (nArray3[i] != nArray4[n8]) continue;
                n7 = n8 - 3;
                if (n7 < 0) {
                    n7 = -n7;
                }
                if (nArray5[n7] != -1) continue;
                nArray5[n7] = i;
                n8 = nArray4.length;
            }
        }
        Vector_Float vector_Float = new Vector_Float();
        for (n8 = 0; n8 != nArray5.length; ++n8) {
            int n15;
            n7 = nArray5[n8];
            if (nArray3[n7] == 0) continue;
            if (this.includeTease) {
                n15 = this.content.length;
                stringBufferArray = new StringBuffer[n15];
                for (int i = 0; i < n15; ++i) {
                    if (this.content[i] == null) continue;
                    stringBufferArray[i] = new StringBuffer(this.content[i].toString());
                    if (!(this.moveType[i] == 0 | (this.moveType[i] == 2 && i < n15 - 1 && this.f_x1[i] < this.f_x2[i + 1] && this.f_x2[i] > this.f_x1[i + 1]))) continue;
                    this.content[i].append("<link:");
                    this.content[i].append(i + 1);
                    this.content[i].append('>');
                }
            }
            this.createLines(n10, nArray2, n7, true, false, true);
            this.findAcrossLines = true;
            fArray = this.findValueCoords(n7, n, n3, n2, n4, stringBufferArray, string, bl, bl3, bl2);
            this.findAcrossLines = false;
            if (fArray == null) continue;
            for (n15 = 0; n15 != fArray.length; ++n15) {
                vector_Float.addElement(fArray[n15]);
            }
        }
        LogWriter.writeLog("Text scan completed");
        vector_Float.trim();
        fArray = vector_Float.get();
        if (fArray.length > 0) {
            return fArray;
        }
        return null;
    }

    private float[] findValueCoords(int n, int n2, int n3, int n4, int n5, StringBuffer[] stringBufferArray, String string, boolean bl, boolean bl2, boolean bl3) {
        int n6;
        String string2;
        int n7;
        Object object;
        int n8;
        int n9;
        float[] fArray = null;
        float[] fArray2 = null;
        Vector_Int vector_Int = new Vector_Int(20);
        Vector_Int vector_Int2 = new Vector_Int(20);
        Vector_String vector_String = new Vector_String(20);
        int n10 = 0;
        this.foundAcrossLine = false;
        this.remainderOfSearch = "";
        float[] fArray3 = this.f_x1;
        float[] fArray4 = this.f_x2;
        float[] fArray5 = this.f_y1;
        float[] fArray6 = this.f_y2;
        boolean bl4 = false;
        if (oldTextExtraction | n == 0) {
            fArray3 = this.f_x1;
            fArray4 = this.f_x2;
            fArray5 = this.f_y1;
            fArray6 = this.f_y2;
        } else if (n == 1) {
            fArray4 = this.f_x1;
            fArray3 = this.f_x2;
            fArray5 = this.f_y1;
            fArray6 = this.f_y2;
        } else if (n == 3) {
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
            fArray5 = this.f_x2;
            fArray6 = this.f_x1;
            bl4 = true;
        } else if (n == 2) {
            fArray3 = this.f_y2;
            fArray4 = this.f_y1;
            fArray6 = this.f_x1;
            fArray5 = this.f_x2;
            bl4 = true;
        }
        int[] nArray = this.getsortedUnusedFragments(false, true);
        int n11 = nArray.length;
        float f = -1.0f;
        block0: for (n9 = n11 - 1; n9 > -1; --n9) {
            n8 = nArray[n9];
            if (this.writingMode[n8] != n || this.content[n8] == null) continue;
            int n12 = n2;
            while (n12 < n3) {
                object = this.scanLineForValue(stringBufferArray, PdfGroupingAlgorithms.removeDuplicateSpaces(this.content[n8]), string, n12, bl, bl2, this.endX, fArray6[n8]);
                f = ((ScanLinePair)object).finalX;
                n7 = 0;
                if (bl4) {
                    if (fArray5[n8] > (float)n2 && fArray5[n8] < (float)n3 && fArray6[n8] > (float)n2 && fArray6[n8] < (float)n3 && (float)n4 > f && (float)n5 < f) {
                        n7 = 1;
                    }
                } else if (f > (float)n2 && f < (float)n3 && (float)n4 > fArray5[n8] && (float)n5 < fArray6[n8]) {
                    n7 = 1;
                }
                if (n7 != 0 && f != -1.0f && (!bl2 || bl2 && ((ScanLinePair)object).isWholeWord)) {
                    if (this.foundAcrossLine) {
                        int n13;
                        this.onlyCheckStart = true;
                        this.partialFindCoords = new float[]{f, fArray5[n8], this.endX, fArray6[n8]};
                        string2 = string.substring(0, string.length() - this.remainderOfSearch.length());
                        if (this.tease != null && (n13 = this.tease.toString().indexOf(string2)) != -1) {
                            this.tease.insert(n13, "<b>");
                            this.partialFindTeaser = this.tease.toString();
                        }
                    } else {
                        if (bl4) {
                            if (n == 3) {
                                vector_Int.addElement((int)fArray6[n8]);
                                vector_Int.addElement((int)this.endX);
                                vector_Int.addElement(0);
                                vector_Int2.addElement((int)fArray5[n8]);
                                vector_Int2.addElement((int)f);
                                vector_Int2.addElement(0);
                            } else {
                                vector_Int.addElement((int)fArray6[n8]);
                                vector_Int.addElement((int)f);
                                vector_Int.addElement(0);
                                vector_Int2.addElement((int)fArray5[n8]);
                                vector_Int2.addElement((int)this.endX);
                                vector_Int2.addElement(0);
                            }
                        } else {
                            vector_Int.addElement((int)f);
                            vector_Int.addElement((int)fArray5[n8]);
                            vector_Int.addElement(0);
                            vector_Int2.addElement((int)this.endX);
                            vector_Int2.addElement((int)fArray6[n8]);
                            vector_Int2.addElement(0);
                        }
                        if (this.includeTease) {
                            vector_String.addElement(this.tease.toString());
                        }
                        ++n10;
                        if (!bl3) {
                            n9 = n11;
                            n3 = n12;
                        }
                    }
                }
                if (this.onlyCheckStart) {
                    if (this.remainderOfSearch.startsWith(" ")) {
                        this.remainderOfSearch = this.remainderOfSearch.substring(1);
                    }
                    if (n9 > 0) {
                        int n14 = n8;
                        float f2 = fArray3[n14] + (fArray4[n14] - fArray3[n14]) / 2.0f;
                        n6 = n9 - 1;
                        int n15 = nArray[n6];
                        float f3 = fArray6[n14] - (fArray5[n14] - fArray6[n14]);
                        boolean bl5 = false;
                        while (!(fArray3[n14] < fArray4[n15] && fArray3[n14] >= fArray3[n15] && f3 < fArray5[n15] && f3 > fArray6[n15] || n6 == 0)) {
                            if (--n6 == n9) continue;
                            n15 = nArray[n6];
                        }
                        if (fArray3[n14] < fArray4[n15] && fArray3[n14] >= fArray3[n15] && f3 < fArray5[n15] && f3 > fArray6[n15]) {
                            bl5 = true;
                        }
                        if (!bl5) {
                            n6 = n9 - 1;
                            n15 = nArray[n6];
                            while (!(f2 < fArray4[n15] && f2 > fArray3[n15] && f3 < fArray5[n15] && f3 > fArray6[n15] || n6 == 0)) {
                                if (--n6 == n9) continue;
                                n15 = nArray[n6];
                            }
                            if (f2 < fArray4[n15] && f2 > fArray3[n15] && f3 < fArray5[n15] && f3 > fArray6[n15]) {
                                bl5 = true;
                            }
                            if (!bl5) {
                                n6 = n9 - 1;
                                n15 = nArray[n6];
                                while (!(fArray4[n14] <= fArray4[n15] && fArray4[n14] > fArray3[n15] && f3 < fArray5[n15] && f3 > fArray6[n15] || n6 == 0)) {
                                    if (--n6 == n9) continue;
                                    n15 = nArray[n6];
                                }
                                if (fArray4[n14] <= fArray4[n15] && fArray4[n14] > fArray3[n15] && f3 < fArray5[n15] && f3 > fArray6[n15]) {
                                    bl5 = true;
                                }
                            }
                            if (!bl5) {
                                n6 = n9 - 1;
                                n15 = nArray[n6];
                                while (!(fArray4[n14] > fArray4[n15] && fArray3[n14] < fArray3[n15] && f3 < fArray5[n15] && f3 > fArray6[n15] || n6 == 0)) {
                                    if (--n6 == n9) continue;
                                    n15 = nArray[n6];
                                }
                                if (fArray4[n14] > fArray4[n15] && fArray3[n14] < fArray3[n15] && f3 < fArray5[n15] && f3 > fArray6[n15]) {
                                    bl5 = true;
                                }
                            }
                        }
                        if (bl5 && this.content[n15] != null) {
                            object = this.scanLineForValue(stringBufferArray, PdfGroupingAlgorithms.removeDuplicateSpaces(this.content[n15]), this.remainderOfSearch, n12, bl, bl2, this.endX, fArray6[n15]);
                            f = ((ScanLinePair)object).finalX;
                            if (f > (float)n2 && f < (float)n3 && (float)n4 > fArray5[n15] && (float)n5 < fArray6[n15] && f != -1.0f && (!bl2 || bl2 && ((ScanLinePair)object).isWholeWord)) {
                                if (bl4) {
                                    if (n == 3) {
                                        vector_Int.addElement((int)this.partialFindCoords[3]);
                                        vector_Int.addElement((int)this.partialFindCoords[2]);
                                        vector_Int.addElement(this.linkedSearchAreas);
                                        vector_Int2.addElement((int)this.partialFindCoords[1]);
                                        vector_Int2.addElement((int)this.partialFindCoords[0]);
                                        vector_Int2.addElement(this.linkedSearchAreas);
                                        vector_Int.addElement((int)fArray6[n15]);
                                        vector_Int.addElement((int)this.endX);
                                        vector_Int.addElement(0);
                                        vector_Int2.addElement((int)fArray5[n15]);
                                        vector_Int2.addElement((int)f);
                                        vector_Int2.addElement(0);
                                    } else {
                                        vector_Int.addElement((int)this.partialFindCoords[3]);
                                        vector_Int.addElement((int)this.partialFindCoords[0]);
                                        vector_Int.addElement(this.linkedSearchAreas);
                                        vector_Int2.addElement((int)this.partialFindCoords[1]);
                                        vector_Int2.addElement((int)this.partialFindCoords[2]);
                                        vector_Int2.addElement(this.linkedSearchAreas);
                                        vector_Int.addElement((int)fArray6[n15]);
                                        vector_Int.addElement((int)f);
                                        vector_Int.addElement(0);
                                        vector_Int2.addElement((int)fArray5[n15]);
                                        vector_Int2.addElement((int)this.endX);
                                        vector_Int2.addElement(0);
                                    }
                                } else {
                                    vector_Int.addElement((int)this.partialFindCoords[0]);
                                    vector_Int.addElement((int)this.partialFindCoords[1]);
                                    vector_Int.addElement(this.linkedSearchAreas);
                                    vector_Int2.addElement((int)this.partialFindCoords[2]);
                                    vector_Int2.addElement((int)this.partialFindCoords[3]);
                                    vector_Int2.addElement(this.linkedSearchAreas);
                                    vector_Int.addElement((int)f);
                                    vector_Int.addElement((int)fArray5[n15]);
                                    vector_Int.addElement(0);
                                    vector_Int2.addElement((int)this.endX);
                                    vector_Int2.addElement((int)fArray6[n15]);
                                    vector_Int2.addElement(0);
                                }
                                if (this.includeTease) {
                                    vector_String.addElement(this.partialFindTeaser + this.tease);
                                }
                                ++n10;
                                ++n10;
                                if (!bl3) {
                                    n9 = n11;
                                    n3 = n12;
                                }
                            }
                            this.onlyCheckStart = false;
                        }
                    }
                }
                if (n8 == n11 || f == -1.0f) continue block0;
                n12 = (int)f + 1;
            }
        }
        stringBufferArray = null;
        if (n10 > 0) {
            vector_Int.trim();
            vector_Int2.trim();
            fArray = new float[vector_Int.size() - 1];
            for (n9 = 0; n9 < fArray.length; ++n9) {
                fArray[n9] = vector_Int.elementAt(n9);
            }
            fArray2 = new float[vector_Int2.size() - 1];
            for (n9 = 0; n9 < fArray2.length; ++n9) {
                fArray2[n9] = vector_Int2.elementAt(n9);
            }
            if (this.includeTease) {
                this.teasers = new String[n10];
                for (n8 = 0; n8 < n10; ++n8) {
                    String string3 = vector_String.elementAt(n8);
                    if (this.includeHTMLtags) {
                        if (!bl) {
                            object = string.toLowerCase();
                            n7 = ((String)object).length();
                            string2 = string3.toLowerCase();
                            StringBuffer stringBuffer = new StringBuffer(string3);
                            n6 = string2.indexOf((String)object);
                            while (n6 != -1) {
                                stringBuffer.insert(n6 + n7, "</b>");
                                stringBuffer.insert(n6, "<b>");
                                n6 = n6 + 7 + n7;
                                n6 = stringBuffer.indexOf((String)object, n6);
                            }
                            string3 = stringBuffer.toString();
                        } else {
                            string3 = string3.replaceAll(string, "<b>" + string + "</b>");
                        }
                    }
                    if (this.usingMultipleTerms) {
                        this.multipleTermTeasers.add(string3);
                        continue;
                    }
                    this.teasers[n8] = string3;
                }
            }
        }
        if (fArray != null && fArray2 != null) {
            Vector_Float vector_Float = new Vector_Float();
            for (n8 = 0; n8 != fArray.length; n8 += 3) {
                vector_Float.addElement(fArray[n8]);
                vector_Float.addElement(fArray[n8 + 1]);
                vector_Float.addElement(fArray2[n8]);
                vector_Float.addElement(fArray2[n8 + 1]);
                vector_Float.addElement(fArray2[n8 + 2]);
            }
            vector_Float.trim();
            fArray = vector_Float.get();
        }
        this.endPoints = fArray2;
        return fArray;
    }

    private static String removeDuplicateSpaces(String string) {
        if (string.indexOf("  ") != -1) {
            StringBuffer stringBuffer = PdfGroupingAlgorithms.removeDuplicateSpaces(new StringBuffer(string));
            string = stringBuffer.toString();
        }
        return string;
    }

    private static StringBuffer removeDuplicateSpaces(StringBuffer stringBuffer) {
        if (stringBuffer.indexOf("  ") != -1) {
            int n = stringBuffer.length() - 1;
            for (int i = 0; i < n; ++i) {
                if (stringBuffer.charAt(i) != ' ' || stringBuffer.charAt(i + 1) != ' ') continue;
                stringBuffer.deleteCharAt(i + 1);
                --n;
                --i;
            }
        }
        return stringBuffer;
    }

    public float[] getEndPoints() {
        return this.endPoints;
    }

    public String[] getTeasers() {
        return this.teasers;
    }

    public void generateTeasers() {
        this.includeTease = true;
    }

    public int getWordDetectionTechnique() {
        return this.wordDetectionTechnique;
    }

    public void setWordDetectionTechnique(int n) {
        this.wordDetectionTechnique = n;
    }

    static class ResultsComparator
    implements Comparator {
        private int rotation;

        public ResultsComparator(int n) {
            this.rotation = n;
        }

        public int compare(Object object, Object object2) {
            Rectangle[] rectangleArray = null;
            Rectangle[] rectangleArray2 = null;
            rectangleArray = object instanceof Rectangle[] ? (Rectangle[])object : new Rectangle[]{(Rectangle)object};
            rectangleArray2 = object2 instanceof Rectangle[] ? (Rectangle[])object2 : new Rectangle[]{(Rectangle)object2};
            for (int i = 0; i != rectangleArray.length; ++i) {
                int n = 0;
                if (n == rectangleArray2.length) continue;
                Rectangle rectangle = rectangleArray[i];
                Rectangle rectangle2 = rectangleArray2[n];
                if (this.rotation == 0 || this.rotation == 180) {
                    if (rectangle.y == rectangle2.y) {
                        if (rectangle.x > rectangle2.x) {
                            return 1;
                        }
                        return -1;
                    }
                    if (rectangle.y > rectangle2.y) {
                        return -1;
                    }
                    return 1;
                }
                if (rectangle.x == rectangle2.x) {
                    if (rectangle.y > rectangle2.y) {
                        return 1;
                    }
                    return -1;
                }
                if (rectangle.x > rectangle2.x) {
                    return 1;
                }
                return -1;
            }
            return -1;
        }
    }

    private static class ScanLinePair {
        private boolean isWholeWord;
        private float finalX;

        public ScanLinePair(float f, boolean bl) {
            this.finalX = f;
            this.isWholeWord = bl;
        }
    }
}

