/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.impl;

import java.io.File;
import java.util.Iterator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.SpatialIndexFactory;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.spi.spatialindex.AbstractSpatialIndex;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.visitor.Visitor;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.rtree.MVRTreeMap;
import org.h2.mvstore.rtree.SpatialKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialIndexMVRTree
extends AbstractSpatialIndex
implements SpatialIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpatialIndexMVRTree.class);
    private MVStore mvstore;
    private MVRTreeMap<Long> rtree;
    private int idcounter;

    public SpatialIndexMVRTree(GeometryManager geometryManager, SpatialIndexFactory factory, DynObject parameters) {
        super(geometryManager, factory, parameters);
        this.open();
    }

    public final synchronized void open() {
        File f = (File)this.getParameter("file");
        this.mvstore = f != null ? MVStore.open((String)f.getAbsolutePath()) : MVStore.open(null);
        this.rtree = (MVRTreeMap)this.mvstore.openMap("data", (MVMap.MapBuilder)new MVRTreeMap.Builder());
    }

    public void close() {
        this.mvstore.commit();
        this.mvstore.close();
        this.mvstore = null;
        this.rtree = null;
    }

    private SpatialKey createSpatialKey(Envelope envelope) {
        if (envelope == null || envelope.isEmpty()) {
            return null;
        }
        int id = this.idcounter++;
        SpatialKey key = new SpatialKey((long)id, new float[]{(float)envelope.getMinimum(0), (float)envelope.getMaximum(0), (float)envelope.getMinimum(1), (float)envelope.getMaximum(1)});
        if (this.idcounter > 0x7FFFFFF5) {
            this.idcounter = 0;
        }
        return key;
    }

    public synchronized long size() {
        return this.rtree.size();
    }

    public synchronized void query(Envelope envelope, Visitor visitor) {
        Iterator it = this.rtree.keyIterator((Object)this.createSpatialKey(envelope));
        while (it.hasNext()) {
            SpatialKey key = (SpatialKey)it.next();
            Long value = (Long)this.rtree.get((Object)key);
            try {
                visitor.visit((Object)value);
            }
            catch (BaseException ex) {
                LOGGER.debug("Can't visit, value=" + value, (Throwable)ex);
            }
        }
    }

    public synchronized Iterator query(Envelope envelope, long limit) {
        Iterator it = this.rtree.keyIterator((Object)this.createSpatialKey(envelope));
        return new SpatialKeyIteratorWrapper(it);
    }

    public Iterator queryNearest(Envelope envelope, long limit) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public synchronized Iterator queryAll() {
        Iterator it = this.rtree.keyIterator(this.rtree.firstKey());
        return new SpatialKeyIteratorWrapper(it);
    }

    public synchronized void insert(Envelope envelope, Object data) {
        SpatialKey key = this.createSpatialKey(envelope);
        if (key == null) {
            return;
        }
        this.rtree.add(key, (Object)((Long)data));
    }

    public synchronized boolean remove(Envelope envelope, Object data) {
        SpatialKey key = this.createSpatialKey(envelope);
        if (key == null) {
            return false;
        }
        return this.rtree.remove((Object)key) != null;
    }

    public synchronized void removeAll() {
        this.rtree.clear();
    }

    public synchronized void flush() {
        this.mvstore.commit();
    }

    private class SpatialKeyIteratorWrapper
    implements Iterator<Long> {
        private final Iterator<SpatialKey> it;

        public SpatialKeyIteratorWrapper(Iterator<SpatialKey> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Long next() {
            SpatialKey key = this.it.next();
            return (Long)SpatialIndexMVRTree.this.rtree.get((Object)key);
        }
    }
}

