/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.h2;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.store.h2.H2SpatialConnectionParameters;
import org.gvsig.fmap.dal.store.h2.H2SpatialConnectionParametersHelper;
import org.gvsig.fmap.dal.store.h2.H2SpatialUtils;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParametersBase;

public class H2SpatialStoreParameters
extends JDBCStoreParametersBase
implements H2SpatialConnectionParameters {
    private final H2SpatialConnectionParametersHelper helper = new H2SpatialConnectionParametersHelper(this);

    public H2SpatialStoreParameters() {
        super("H2SpatialStoreParameters", "H2Spatial");
    }

    public String getUrl() {
        return this.helper.getUrl();
    }

    public void validate() throws ValidateDataParametersException {
        this.helper.validate();
        super.validate();
    }

    @Override
    public Properties getProperties() {
        return this.helper.getProperties();
    }

    public File getFile() {
        return this.helper.getFile();
    }

    public void setFile(File database) {
        try {
            this.helper.setFile(database);
            String url = H2SpatialUtils.getConnectionURL(this);
            this.setDynValue("url", url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getMaxSecondsIdle() {
        return this.helper.getMaxSecondsIdle();
    }

    @Override
    public boolean getServerAllowOthers() {
        return this.helper.getServerAllowOthers();
    }

    @Override
    public int getServerPort() {
        return this.helper.getServerPort();
    }

    @Override
    public String getServerPortAsString() {
        return this.helper.getServerPortAsString();
    }

    @Override
    public int getSplitSize() {
        return this.helper.getSplitSize();
    }

    public boolean isTheSameExplorer(DataStoreParameters params) {
        block4: {
            if (!(params instanceof H2SpatialStoreParameters)) {
                return false;
            }
            File f1 = H2SpatialUtils.normalizeH2File(this.getFile());
            File f2 = H2SpatialUtils.normalizeH2File(((H2SpatialStoreParameters)params).getFile());
            try {
                if (!FilenameUtils.equalsOnSystem((String)f1.getCanonicalPath(), (String)f2.getCanonicalPath())) {
                    return false;
                }
            }
            catch (IOException ex) {
                if (FilenameUtils.equalsOnSystem((String)f1.getAbsolutePath(), (String)f2.getAbsolutePath())) break block4;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean getMaintainGlobalConnection() {
        return this.helper.getMaintainGlobalConnection();
    }

    public String getSourceId() {
        File f;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getTable());
        builder.append("(");
        boolean needComma = false;
        if (StringUtils.isNotBlank((CharSequence)this.getHost())) {
            builder.append("host=");
            builder.append(this.getHost());
            needComma = true;
        }
        if (this.getPort() > 0) {
            if (needComma) {
                builder.append(", ");
            }
            builder.append("port=");
            builder.append(this.getPort());
            needComma = true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getDBName())) {
            if (needComma) {
                builder.append(", ");
            }
            builder.append("db=");
            builder.append(this.getDBName());
            needComma = true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getSchema())) {
            if (needComma) {
                builder.append(", ");
            }
            builder.append("schema=");
            builder.append(this.getSchema());
            needComma = true;
        }
        if ((f = this.getFile()) != null) {
            if (needComma) {
                builder.append(", ");
            }
            builder.append("file=");
            builder.append(this.getFile().getAbsolutePath());
        }
        builder.append(")");
        return builder.toString();
    }
}

