/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.h2.operations;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.ListTablesOperation;

public class H2SpatialListTablesOperation
extends ListTablesOperation {
    public H2SpatialListTablesOperation(JDBCHelper helper, int mode, JDBCServerExplorerParameters serverParameters, boolean informationTables, int tablesOrViews) {
        super(helper, mode, serverParameters, informationTables, tablesOrViews);
    }

    public List<JDBCStoreParameters> listTables(JDBCConnection conn, int mode, JDBCServerExplorerParameters serverParameters, boolean informationTables, int tablesOrViews) {
        ArrayList<JDBCStoreParameters> arrayList;
        ResultSet rs = null;
        ArrayList<JDBCStoreParameters> tables = new ArrayList<JDBCStoreParameters>();
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME FROM INFORMATION_SCHEMA.TABLES where table_type in ");
            switch (tablesOrViews) {
                default: {
                    builder.append("('TABLE','VIEW','EXTERNAL')");
                    break;
                }
                case 1: {
                    builder.append("('TABLE')");
                    break;
                }
                case 2: {
                    builder.append("('VIEW','EXTERNAL')");
                }
            }
            if (!informationTables) {
                builder.append(" AND TABLE_SCHEMA<>'INFORMATION_SCHEMA'");
            }
            String sql = builder.toString();
            rs = conn.createStatement().executeQuery(sql);
            while (rs.next()) {
                JDBCStoreParameters params = this.helper.createOpenStoreParameters(serverParameters);
                params.setCatalog(rs.getString("TABLE_CATALOG"));
                params.setSchema(rs.getString("TABLE_SCHEMA"));
                params.setTable(rs.getString("TABLE_NAME"));
                tables.add(params);
            }
            arrayList = tables;
        }
        catch (SQLException ex) {
            try {
                throw new RuntimeException("Can't fetch tables information", ex);
            }
            catch (Throwable throwable) {
                JDBCUtils.closeQuietly(rs);
                throw throwable;
            }
        }
        JDBCUtils.closeQuietly((ResultSet)rs);
        return arrayList;
    }
}

