/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.TestAutoregister;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgis.PGbox2d;
import org.postgis.PGbox3d;
import org.postgis.PGboxbase;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;

public class TestBoxes {
    public static final String[] BOXEN3D = new String[]{"BOX3D(1 2 3,4 5 6)", "BOX3D(1 2,4 5)"};
    public static final String[] BOXEN2D = new String[]{"BOX(1 2,3 4)"};
    public static final int SRID = 4326;
    public static final String SRIDPREFIX = "SRID=4326;";
    public static int failcount = 0;

    public static void test(String orig, PGobject candidate, Connection[] conns, boolean newPostgisOnly) throws SQLException {
        PGobject recreated;
        System.out.println("Original:  " + orig);
        String redone = candidate.toString();
        System.out.println("Parsed:    " + redone);
        if (!orig.equals(redone)) {
            System.out.println("--- Recreated Text Rep not equal!");
            ++failcount;
        }
        try {
            recreated = (PGobject)candidate.getClass().newInstance();
        }
        catch (Exception e) {
            System.out.println("--- pgjdbc instantiation failed!");
            System.out.println("--- " + e.getMessage());
            ++failcount;
            return;
        }
        recreated.setValue(redone);
        String reparsed = recreated.toString();
        System.out.println("Re-Parsed: " + reparsed);
        if (!recreated.equals(candidate)) {
            System.out.println("--- Recreated boxen are not equal!");
            ++failcount;
        } else if (!reparsed.equals(orig)) {
            System.out.println("--- 2nd generation text reps are not equal!");
            ++failcount;
        } else {
            System.out.println("Equals:    yes");
        }
        for (int i = 0; i < conns.length; ++i) {
            System.out.println("Testing on connection " + i + ": " + conns[i].getCatalog());
            Statement statement = conns[i].createStatement();
            if (newPostgisOnly && TestAutoregister.getPostgisMajor(statement) < 1) {
                System.out.println("PostGIS version is too old, not testing box2d");
            } else {
                try {
                    PGobject sqlGeom = TestBoxes.viaSQL(candidate, statement);
                    System.out.println("SQLin    : " + sqlGeom.toString());
                    if (!candidate.equals(sqlGeom)) {
                        System.out.println("--- Geometries after SQL are not equal!");
                        ++failcount;
                    } else {
                        System.out.println("Eq SQL in: yes");
                    }
                }
                catch (SQLException e) {
                    System.out.println("--- Server side error: " + e.toString());
                    ++failcount;
                }
                try {
                    PGobject sqlreGeom = TestBoxes.viaSQL(recreated, statement);
                    System.out.println("SQLout  :  " + sqlreGeom.toString());
                    if (!candidate.equals(sqlreGeom)) {
                        System.out.println("--- reparsed Geometries after SQL are not equal!");
                        ++failcount;
                    } else {
                        System.out.println("Eq SQLout: yes");
                    }
                }
                catch (SQLException e) {
                    System.out.println("--- Server side error: " + e.toString());
                    ++failcount;
                }
            }
            statement.close();
        }
        System.out.println("***");
    }

    private static PGobject viaSQL(PGobject obj, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("SELECT '" + obj.toString() + "'::" + obj.getType());
        rs.next();
        return (PGobject)rs.getObject(1);
    }

    public static Connection connect(String url, String dbuser, String dbpass) throws SQLException, ClassNotFoundException {
        Class.forName("org.postgis.DriverWrapper");
        Connection conn = DriverManager.getConnection(url, dbuser, dbpass);
        return conn;
    }

    public static void main(String[] args) throws SQLException, ClassNotFoundException {
        PGboxbase candidate;
        int i;
        PGtokenizer dburls;
        String dbuser = null;
        String dbpass = null;
        if (args.length == 1 && args[0].equalsIgnoreCase("offline")) {
            System.out.println("Performing only offline tests");
            dburls = new PGtokenizer("", ';');
        } else if (args.length == 3) {
            System.out.println("Performing offline and online tests");
            dburls = new PGtokenizer(args[0], ';');
            dbuser = args[1];
            dbpass = args[2];
        } else {
            System.err.println("Usage: java examples/TestParser dburls user pass [tablename]");
            System.err.println("   or: java examples/TestParser offline");
            System.err.println();
            System.err.println("dburls has one or more jdbc urls separated by ; in the following format");
            System.err.println("jdbc:postgresql://HOST:PORT/DATABASENAME");
            System.err.println("tablename is 'jdbc_test' by default.");
            System.exit(1);
            return;
        }
        Connection[] conns = new Connection[dburls.getSize()];
        for (i = 0; i < dburls.getSize(); ++i) {
            System.out.println("Creating JDBC connection to " + dburls.getToken(i));
            conns[i] = TestBoxes.connect(dburls.getToken(i), dbuser, dbpass);
        }
        System.out.println("Performing tests...");
        System.out.println("***");
        for (i = 0; i < BOXEN3D.length; ++i) {
            try {
                candidate = new PGbox3d(BOXEN3D[i]);
                TestBoxes.test(BOXEN3D[i], candidate, conns, false);
                continue;
            }
            catch (SQLException e) {
                System.out.println("--- Instantiation of " + BOXEN3D[i] + "failed:");
                System.out.println("--- " + e.getMessage());
                ++failcount;
            }
        }
        for (i = 0; i < BOXEN2D.length; ++i) {
            try {
                candidate = new PGbox2d(BOXEN2D[i]);
                TestBoxes.test(BOXEN2D[i], candidate, conns, true);
                continue;
            }
            catch (SQLException e) {
                System.out.println("--- Instantiation of " + BOXEN2D[i] + "failed:");
                System.out.println("--- " + e.getMessage());
                ++failcount;
            }
        }
        System.out.print("cleaning up...");
        for (i = 0; i < conns.length; ++i) {
            conns[i].close();
        }
        System.out.println("Finished, " + failcount + " tests failed!");
        System.err.println("Finished, " + failcount + " tests failed!");
        System.exit(failcount);
    }
}

