/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featurequery;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.SymbolTableFactory;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureExtraColumns;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.featurequery.FeatureQueryGroupByPanel;
import org.gvsig.fmap.dal.swing.impl.featurequery.DefaultFeatureQueryGroupByPanel2View;
import org.gvsig.fmap.dal.swing.impl.featuretype.DefaultFeatureAttributesSelectionPanel;
import org.gvsig.tools.swing.api.FilteredListController;
import org.gvsig.tools.swing.api.FilteredListModel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.util.LabeledValue;

public class DefaultFeatureQueryGroupByPanel2
extends DefaultFeatureQueryGroupByPanel2View
implements FeatureQueryGroupByPanel {
    private FeatureStore store;
    private FeatureType featureType;
    private FilteredListController availableColumnsController;
    private DefaultFeatureAttributesSelectionPanel groupByPanel;
    private FeatureQuery query;

    public DefaultFeatureQueryGroupByPanel2() {
        this.initComponents();
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return ToolsSwingUtils.loadImage((Object)this, (String)imageName);
    }

    public void setStore(FeatureStore store) {
        try {
            this.featureType = store.getDefaultFeatureType();
            this.groupByPanel.setFeatureType(this.featureType);
            this.store = store;
            this.tblAggregates.setCellEditor(new DefaultCellEditor(new JComboBox<String>(this.createComboModelOfAvailableAggregates())));
            this.put(store.createFeatureQuery());
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't assign store", ex);
        }
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate((AbstractButton)this.btnAvailableColumns);
        toolsSwingManager.translate(this.tabGroup);
        this.groupByPanel = new DefaultFeatureAttributesSelectionPanel();
        this.groupByPanel.allowCalculatedAttributes(true);
        this.pnlGroupByAttributes.setLayout(new BorderLayout());
        this.pnlGroupByAttributes.add((Component)this.groupByPanel, "Center");
        this.availableColumnsController = toolsSwingManager.createFilteredListController(this.lstAvailableColumns, (JTextComponent)this.txtAvailableColumnsFilter, this.btnAvailableColumns);
        this.tblAggregates.setModel(new AggregatesModel());
        this.tblAggregates.setCellEditor(new DefaultCellEditor(new JComboBox(new DefaultComboBoxModel())));
        JScrollPane scrollPanel = this.getJScrollPane(this.tblAggregates);
        if (scrollPanel != null) {
            scrollPanel.getColumnHeader().setVisible(false);
            scrollPanel.getViewport().setBackground(this.tblAggregates.getBackground());
        }
        this.btnAggregateAdd.addActionListener(e -> this.doColumnAdd());
        this.btnAggregateRemove.addActionListener(e -> this.doColumnRemove());
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)15, (int)100, (int)25, (int)150);
    }

    private JScrollPane getJScrollPane(JComponent component) {
        try {
            JComponent p1 = (JComponent)component.getParent();
            if (p1 instanceof JViewport) {
                p1 = (JComponent)component.getParent();
            }
            if (p1 instanceof JScrollPane) {
                return (JScrollPane)p1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void doColumnRemove() {
        int row = this.tblAggregates.getSelectedRow();
        if (row < 0) {
            return;
        }
        AggregatesModel aggregatesModel = (AggregatesModel)this.tblAggregates.getModel();
        aggregatesModel.remove(row);
        this.updateControls();
    }

    private void doColumnAdd() {
        FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)this.lstAvailableColumns.getSelectedValue();
        if (attr == null) {
            return;
        }
        AggregatesModel aggregatesModel = (AggregatesModel)this.tblAggregates.getModel();
        if (aggregatesModel.contains(attr)) {
            return;
        }
        aggregatesModel.add(attr, "MIN");
        this.updateControls();
    }

    private ListModel createAvailableColumnsModel() {
        FeatureExtraColumns extraColumns;
        AggregatesModel aggregatesModel = (AggregatesModel)this.tblAggregates.getModel();
        FilteredListModel modelAvailables = ToolsSwingLocator.getToolsSwingManager().createFilteredListModel();
        if (this.featureType != null) {
            for (FeatureAttributeDescriptor attr : this.featureType.getAllAttributeDescriptors()) {
                if (aggregatesModel.contains(attr)) continue;
                modelAvailables.addElement((LabeledValue)attr);
            }
        }
        if ((extraColumns = this.query.getExtraColumns()) != null && !extraColumns.isEmpty()) {
            for (FeatureAttributeDescriptor extraCol : extraColumns) {
                if (aggregatesModel.contains(extraCol)) continue;
                modelAvailables.addElement((LabeledValue)extraCol);
            }
        }
        modelAvailables.setFilter(this.txtAvailableColumnsFilter.getText());
        modelAvailables.sort(true);
        return modelAvailables;
    }

    private void updateControls() {
        int indexAvailables = this.lstAvailableColumns.getSelectedIndex();
        int indexAggregates = this.tblAggregates.getSelectedRow();
        ListModel modelAvailables = this.createAvailableColumnsModel();
        this.lstAvailableColumns.setModel(modelAvailables);
        if (indexAvailables >= 0 && modelAvailables.getSize() > 0) {
            if (indexAvailables >= modelAvailables.getSize()) {
                indexAvailables = modelAvailables.getSize() - 1;
            }
            this.lstAvailableColumns.setSelectedIndex(indexAvailables);
            this.btnAggregateAdd.setEnabled(true);
        } else {
            this.btnAggregateAdd.setEnabled(false);
        }
        AggregatesModel aggregatesModel = (AggregatesModel)this.tblAggregates.getModel();
        if (indexAggregates >= 0 && aggregatesModel.getRowCount() > 0) {
            if (indexAggregates >= aggregatesModel.getRowCount()) {
                indexAggregates = aggregatesModel.getRowCount() - 1;
            }
            this.tblAggregates.getSelectionModel().setSelectionInterval(indexAggregates, indexAggregates);
            this.btnAggregateRemove.setEnabled(true);
        } else {
            this.btnAggregateRemove.setEnabled(false);
        }
    }

    public FeatureQuery fetch(FeatureQuery query) {
        FeatureQuery q = query;
        if (query == null) {
            q = this.query.getCopy();
        }
        q.getGroupByColumns().clear();
        q.getGroupByColumns().addAll(this.groupByPanel.getSelectedNames());
        q.getAggregateFunctions().clear();
        AggregatesModel aggregatesModel = (AggregatesModel)this.tblAggregates.getModel();
        for (int i = 0; i < aggregatesModel.getRowCount(); ++i) {
            q.addAggregate(aggregatesModel.getAggregateName(i), aggregatesModel.getAttribute(i).getName());
        }
        return q;
    }

    public FeatureQuery fetch() {
        return this.fetch(null);
    }

    public void put(FeatureQuery query) {
        this.query.copyFrom(query);
        this.groupByPanel.setSelectedNames(this.query.getGroupByColumns());
        this.groupByPanel.setExtraColumns(this.query.getExtraColumn().getColumns());
        AggregatesModel aggregatesModel = new AggregatesModel();
        for (Map.Entry entry : this.query.getAggregateFunctions().entrySet()) {
            String attrname = (String)entry.getKey();
            String aggregateName = (String)entry.getValue();
            FeatureAttributeDescriptor attr = null;
            if (this.featureType != null) {
                attr = this.featureType.getAttributeDescriptorFromAll(attrname);
            }
            if (attr == null) {
                attr = this.query.getExtraColumns().get(attrname);
            }
            if (attr == null) continue;
            aggregatesModel.add(attr, aggregateName);
        }
        this.tblAggregates.setModel(aggregatesModel);
        this.updateControls();
    }

    public ComboBoxModel<String> createComboModelOfAvailableAggregates() {
        if (this.store == null) {
            return new DefaultComboBoxModel<String>();
        }
        ArrayList<String> aggregateFunctions = new ArrayList<String>();
        java.util.function.Function isAllowed = ((FeatureStoreProviderFactory)this.store.getProviderFactory()).allowFunction();
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        for (SymbolTableFactory factory : manager.getSymbolTableFactories()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)"Aggregate", (CharSequence)factory.getName())) continue;
            SymbolTable symbolTable = factory.create(new Object[0]);
            for (Function function : symbolTable) {
                if ((Integer)isAllowed.apply(function.name()) == 2) continue;
                aggregateFunctions.add(function.name());
            }
        }
        Collections.sort(aggregateFunctions);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (String functionName : aggregateFunctions) {
            model.addElement(functionName);
        }
        return model;
    }

    public static void selfRegister() {
    }

    private class AggregatesModel
    extends AbstractTableModel
    implements TableModel {
        private final List<MutablePair<FeatureAttributeDescriptor, String>> aggregates = new ArrayList<MutablePair<FeatureAttributeDescriptor, String>>();

        @Override
        public int getRowCount() {
            return this.aggregates.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Pair row = (Pair)this.aggregates.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ((FeatureAttributeDescriptor)row.getLeft()).getName();
                }
                case 1: {
                    return row.getRight();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex != 1) {
                return;
            }
            this.aggregates.get(rowIndex).setRight((Object)((String)aValue));
        }

        public void add(FeatureAttributeDescriptor attr, String aggregateName) {
            this.aggregates.add((MutablePair<FeatureAttributeDescriptor, String>)new MutablePair((Object)attr, (Object)aggregateName));
            this.fireTableDataChanged();
        }

        public FeatureAttributeDescriptor getAttribute(int i) {
            return (FeatureAttributeDescriptor)this.aggregates.get(i).getLeft();
        }

        public String getAggregateName(int i) {
            return (String)this.aggregates.get(i).getRight();
        }

        private void remove(int n) {
            this.aggregates.remove(n);
            this.fireTableDataChanged();
        }

        public void remove(FeatureAttributeDescriptor attr) {
            this.remove(this.getIndexOf(attr));
        }

        public int getIndexOf(FeatureAttributeDescriptor attr) {
            return this.getIndexOf(attr.getName());
        }

        public int getIndexOf(String attrname) {
            int n = 0;
            for (MutablePair<FeatureAttributeDescriptor, String> aggregate : this.aggregates) {
                if (StringUtils.equalsIgnoreCase((CharSequence)attrname, (CharSequence)((FeatureAttributeDescriptor)aggregate.getLeft()).getName())) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public boolean contains(FeatureAttributeDescriptor attr) {
            return this.getIndexOf(attr) >= 0;
        }
    }
}

