/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretype.aggregatecontroller;

import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.apache.commons.lang3.ArrayUtils;
import org.gvsig.fmap.dal.swing.impl.featuretype.aggregatecontroller.AggregateController;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class DefaultAggregateController<T>
implements AggregateController<T> {
    private final JTable table;
    private final JButton btnModify;
    private final JButton btnDiscard;
    private final JButton btnAccept;
    private final JButton btnNew;
    private final JButton btnDelete;
    private final AggregateController.AggregateItemController<T> itemController;
    private AggregateController.AggregateModel<T> model;
    private boolean canCreate;
    private boolean canModify;
    private boolean canDelete;
    private ChangeListenerHelper changeListenerHelper;
    private int currentRow;
    private boolean editingItem;
    private T newItem;

    public DefaultAggregateController(JTable table, JButton btnFormFieldModify, JButton btnFormFieldDiscard, JButton btnFormFieldAccept, JButton btnNew, JButton btnDelete, AggregateController.AggregateItemController<T> itemController) {
        this.table = table;
        this.btnModify = btnFormFieldModify;
        this.btnDiscard = btnFormFieldDiscard;
        this.btnAccept = btnFormFieldAccept;
        this.btnNew = btnNew;
        this.btnDelete = btnDelete;
        this.canCreate = true;
        this.canDelete = true;
        this.canModify = true;
        this.itemController = itemController;
        this.model = EMPTY_MODEL;
        this.editingItem = false;
        this.newItem = null;
        this.currentRow = -1;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        this.changeListenerHelper = swingManager.createChangeListenerHelper();
        swingManager.translate((AbstractButton)this.btnAccept);
        swingManager.translate((AbstractButton)this.btnDiscard);
        swingManager.translate((AbstractButton)this.btnModify);
        swingManager.translate((AbstractButton)this.btnNew);
        swingManager.translate((AbstractButton)this.btnDelete);
        this.table.setModel(this.model);
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.doChangeItemSelection();
        });
        this.btnModify.addActionListener(e -> this.modifyCurrentItem());
        this.btnDiscard.addActionListener(e -> this.discardModificactions());
        this.btnAccept.addActionListener(e -> this.acceptModifications());
        this.btnNew.addActionListener(e -> this.newItem());
        this.btnDelete.addActionListener(e -> this.deleteCurrentItem());
    }

    @Override
    public void setModel(AggregateController.AggregateModel<T> model) {
        this.model = model;
        this.table.setModel(model);
        this.currentRow = -1;
        this.newItem = null;
        this.setEditing(false);
        this.itemController.setAggregateModel(model);
    }

    @Override
    public AggregateController.AggregateModel<T> getModel() {
        return this.model;
    }

    @Override
    public AggregateController.AggregateItemController<T> getItemController() {
        return this.itemController;
    }

    @Override
    public int getCurrentRow() {
        return this.currentRow;
    }

    private void doChangeItemSelection() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        if (this.editingItem) {
            if (row != this.currentRow) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                JOptionPane.showMessageDialog(this.table, i18n.getTranslation("_Before_changing_selected_item_accept_or_discard_the_changes"), i18n.getTranslation("_Warning"), 2);
                this.setCurrentRow(this.currentRow);
            }
            return;
        }
        this.setCurrentRow(row);
    }

    @Override
    public void newItem() {
        this.currentRow = -1;
        this.newItem = this.model.createItem();
        this.itemController.put(this.newItem);
        this.table.getSelectionModel().clearSelection();
        this.setEditing(true);
        this.changeListenerHelper.fireEvent();
    }

    @Override
    public void modifyCurrentItem() {
        int row = this.currentRow;
        if (row < 0) {
            return;
        }
        this.setCurrentRow(row);
        this.setEditing(true);
        this.newItem = null;
        this.changeListenerHelper.fireEvent();
    }

    @Override
    public void deleteCurrentItem() {
        int row = this.currentRow;
        int[] rows = this.table.getSelectedRows();
        int n = 0;
        Iterator it = this.model.iterator();
        while (it.hasNext()) {
            it.next();
            if (ArrayUtils.contains((int[])rows, (int)n)) {
                it.remove();
            }
            ++n;
        }
        this.setEditing(false);
        this.setCurrentRow(row);
        this.table.updateUI();
        this.changeListenerHelper.fireEvent();
    }

    @Override
    public void acceptModifications() {
        if (!this.editingItem) {
            return;
        }
        if (this.newItem != null) {
            if (this.itemController.fetch(this.newItem)) {
                int row = this.model.addItem(this.newItem);
                this.setEditing(false);
                this.setCurrentRow(row);
                this.newItem = null;
            }
        } else {
            int row = this.currentRow;
            if (row < 0) {
                return;
            }
            Object item = this.model.get(row);
            if (this.itemController.fetch(item)) {
                this.setEditing(false);
                this.setCurrentRow(row);
                this.model.itemUpdated(row);
            }
        }
        this.changeListenerHelper.fireEvent();
    }

    @Override
    public void discardModificactions() {
        if (!this.editingItem) {
            return;
        }
        if (this.newItem != null) {
            this.itemController.clean();
            this.itemController.setEnabled(false);
            this.newItem = null;
        }
        this.setEditing(false);
        this.setCurrentRow(this.currentRow);
        this.changeListenerHelper.fireEvent();
    }

    private void setEditing(boolean editing) {
        if (this.newItem == null && editing && this.currentRow < 0) {
            return;
        }
        this.editingItem = editing;
        this.itemController.setEnabled(this.editingItem);
        this.updateButtons();
    }

    private void updateButtons() {
        this.btnAccept.setEnabled(this.canModify() && this.editingItem);
        this.btnDiscard.setEnabled(this.editingItem);
        this.btnModify.setEnabled(this.canModify() && !this.editingItem && this.currentRow >= 0);
        this.btnNew.setEnabled(this.canCreate() && !this.editingItem);
        if (this.currentRow >= 0) {
            this.btnDelete.setEnabled(this.canDelete() && !this.editingItem);
        } else {
            this.btnDelete.setEnabled(false);
        }
    }

    @Override
    public boolean isEditing() {
        return this.editingItem;
    }

    @Override
    public void setCurrentRow(int row) {
        if (this.editingItem) {
            if (row != this.currentRow) {
                this.table.getSelectionModel().setSelectionInterval(this.currentRow, this.currentRow);
            }
            return;
        }
        int rowCount = this.table.getRowCount();
        if (rowCount < 1) {
            this.updateButtons();
            return;
        }
        if (row < 0) {
            if (!this.table.getSelectionModel().isSelectionEmpty()) {
                this.table.getSelectionModel().clearSelection();
            }
            this.itemController.clean();
            this.updateButtons();
            return;
        }
        if (row >= rowCount) {
            row = rowCount - 1;
        }
        Object item = this.model.get(row);
        this.itemController.put(item);
        this.currentRow = row;
        this.updateButtons();
        this.table.scrollRectToVisible(this.table.getCellRect(row, 0, true));
        if (this.table.getSelectedRow() != row) {
            this.table.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    @Override
    public void setCanCreate(boolean canCreate) {
        this.canCreate = canCreate;
    }

    @Override
    public void setCanModify(boolean canModify) {
        this.canModify = canModify;
    }

    @Override
    public void setCanDelete(boolean canDelete) {
        this.canDelete = canDelete;
    }

    @Override
    public boolean canCreate() {
        return this.canCreate;
    }

    @Override
    public boolean canModify() {
        return this.canModify;
    }

    @Override
    public boolean canDelete() {
        return this.canDelete;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            if (this.currentRow < 0) {
                this.itemController.setEnabled(false);
                this.btnAccept.setEnabled(false);
                this.btnDiscard.setEnabled(false);
                this.btnModify.setEnabled(false);
                this.btnDelete.setEnabled(false);
            } else {
                this.itemController.setEnabled(true);
                this.btnAccept.setEnabled(this.canModify() && this.editingItem);
                this.btnDiscard.setEnabled(this.editingItem);
                this.btnModify.setEnabled(this.canModify() && !this.editingItem);
                this.btnDelete.setEnabled(this.canDelete() && !this.editingItem);
            }
            this.btnNew.setEnabled(this.canCreate() && !this.editingItem);
        } else {
            this.itemController.setEnabled(false);
            this.btnAccept.setEnabled(false);
            this.btnDiscard.setEnabled(false);
            this.btnModify.setEnabled(false);
            this.btnDelete.setEnabled(false);
            this.btnNew.setEnabled(false);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.itemController.isEnabled();
    }

    @Override
    public void clean() {
        this.setModel(AggregateController.EMPTY_MODEL);
    }
}

