/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.searchpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.configurableactions.ConfigurableActionsMamager;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.complements.Search;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.paging.FacadeOfAFeaturePagingHelper;
import org.gvsig.fmap.dal.swing.AbstractDALActionFactory;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.featurequery.FeatureQueryOrderPanel;
import org.gvsig.fmap.dal.swing.featuretable.SimpleFeaturesTableModel;
import org.gvsig.fmap.dal.swing.featuretype.FeatureAttributesSelectionPanel;
import org.gvsig.fmap.dal.swing.impl.DefaultDALSwingLibrary;
import org.gvsig.fmap.dal.swing.impl.featurequery.DefaultFeatureQueryCalculatedColumnsPanel;
import org.gvsig.fmap.dal.swing.impl.featuretable.SimpleFeaturesTableModelImpl;
import org.gvsig.fmap.dal.swing.impl.searchpanel.DefaultSearchGroupByPanel;
import org.gvsig.fmap.dal.swing.impl.searchpanel.DefaultSearchPanelView2;
import org.gvsig.fmap.dal.swing.impl.searchpanel.DefaultSearchParameters;
import org.gvsig.fmap.dal.swing.impl.searchpanel.ExportTSV;
import org.gvsig.fmap.dal.swing.impl.searchpanel.SearchConditionPanelAdvanced;
import org.gvsig.fmap.dal.swing.impl.searchpanel.SearchConditionPanelSimplified;
import org.gvsig.fmap.dal.swing.searchPostProcess.SearchPostProcess;
import org.gvsig.fmap.dal.swing.searchPostProcess.SearchPostProcessFactory;
import org.gvsig.fmap.dal.swing.searchpanel.FeatureStoreSearchPanel;
import org.gvsig.fmap.dal.swing.searchpanel.SearchConditionPanel;
import org.gvsig.fmap.dal.swing.searchpanel.SearchParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmark;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.History;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynform.DynFormLocator;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.SupportIsEnable;
import org.gvsig.tools.swing.api.SupportIsVisible;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.bookmarkshistory.ActionEventWithCurrentValue;
import org.gvsig.tools.swing.api.bookmarkshistory.BookmarksController;
import org.gvsig.tools.swing.api.bookmarkshistory.HistoryController;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.util.ListBuilder;
import org.gvsig.tools.util.PropertiesSupportHelper;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSearchPanel
extends DefaultSearchPanelView2
implements FeatureStoreSearchPanel,
SupportIsEnable,
SupportIsVisible {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSearchPanel.class);
    private static final String EXPORT_TO_TSV_TITLE = "_Export_to_TSV";
    private static final String EXPORT_TO_TSV_LASTPATHID = "exporttotsv.lastpath";
    private static final String TSV_EXTENSION = "tsv";
    private BookmarksController bookmarksController;
    private HistoryController historyController;
    private FeatureQuery lastQuery;
    private Feature lastSelectedFeature;
    private final PropertiesSupportHelper propertiesHelper;
    private TaskStatusController taskStatusController;
    private boolean automaticallySearch;
    private String lastErrorMessage;
    private boolean initialized;
    private boolean postProcessEnabled;
    private boolean groupByEnabled;
    private Map<String, AdditionalResultsPanel> additionalResultsPanels;
    private FeatureStore store;
    private final ActionListenerSupport acctionListeners;
    private final Map<String, ActionButtons> actions;
    private boolean showActions = true;
    private DefaultSearchParameters parameters;
    private List<SearchConditionPanel> conditionPanels;
    public static final int PANEL_SIMPLIFIED = 0;
    public static final int PANEL_ADVANCED = 1;
    private static final String BOOKMARKSANDHISTORY_NAME = "SearchPanel";
    private final Bookmarks<Object> bookmarks;
    private final History<Object> history;
    private boolean filterOnlyMode;
    private String currentPostProcess;
    private DynObject postProcessParams;
    private FeatureStore postProcessStore;
    private FeatureQuery postProcessQuery;
    private SimpleFeaturesTableModel resultModel;
    private SimpleFeaturesTableModel resultPostProcessModel;
    private boolean processing;
    private JComponent configurableActions;

    public DefaultSearchPanel(FeatureStore store) {
        this.store = store;
        this.filterOnlyMode = false;
        DisposeUtils.bind((Disposable)store);
        this.acctionListeners = ToolsSwingLocator.getToolsSwingManager().createActionListenerSupport();
        this.actions = new HashMap<String, ActionButtons>();
        this.parameters = new DefaultSearchParameters();
        this.additionalResultsPanels = new HashMap<String, AdditionalResultsPanel>();
        FeatureQuery featureQuery = this.store.createFeatureQuery();
        featureQuery.retrievesAllAttributes();
        this.parameters.setQuery(featureQuery);
        this.currentPostProcess = null;
        this.postProcessParams = null;
        this.postProcessStore = null;
        this.postProcessQuery = null;
        this.processing = false;
        this.configurableActions = null;
        this.resultModel = null;
        this.resultPostProcessModel = null;
        this.propertiesHelper = new PropertiesSupportHelper();
        this.propertiesHelper.setProperty(BOOKMARKSANDHISTORY_NAME, (Object)this);
        this.automaticallySearch = true;
        this.postProcessEnabled = true;
        this.groupByEnabled = true;
        Search search = (Search)ToolsLocator.getComplementsManager().get("DAL.Search", (Object)this.getFeatureType());
        List attributos = search.getOrderedAttributes(Search.BASIC_TYPES_FILTER, Search.STR_INT_LONG_LABEL_ORDER, 12);
        for (Search.OrderedAttribute attrdesc : attributos) {
            this.parameters.getResultColumnNames().add(attrdesc.getDescriptor().getName());
        }
        this.bookmarks = ToolsLocator.getBookmarksAndHistoryManager().getBookmarksGroup(BOOKMARKSANDHISTORY_NAME);
        this.history = ToolsLocator.getBookmarksAndHistoryManager().getHistoryGroup(BOOKMARKSANDHISTORY_NAME);
        this.initComponents0();
        this.initialized = false;
    }

    public void dispose() {
        DisposeUtils.disposeQuietly((Disposable)this.store);
        TableModel m = this.tblResults.getModel();
        if (m instanceof Disposable) {
            DisposeUtils.disposeQuietly((Disposable)((Disposable)m));
        }
        this.store = null;
        this.tblResults.setModel(new DefaultTableModel());
        for (AdditionalResultsPanel additionalResultsPanel : this.additionalResultsPanels.values()) {
            additionalResultsPanel.doDispose();
        }
    }

    public JComponent asJComponent() {
        if (!this.initialized) {
            this.initComponents1();
        }
        return this;
    }

    private void addActions() {
        if (!this.showActions) {
            return;
        }
        this.pnlActions.removeAll();
        this.pnlActions.setLayout(new FlowLayout(4, 8, 4));
        SearchActionContext actionContext = new SearchActionContext(this);
        actionContext.set("searchpanel", this);
        Collection factories = DALSwingLocator.getSwingManager().getApplicableStoreActions((DALActionFactory.DALActionContext)actionContext);
        for (DALActionFactory factory : factories) {
            Action action = factory.createAction((DALActionFactory.DALActionContext)actionContext);
            JButton button = new JButton(action);
            this.actions.put(factory.getName(), new ActionButtons(factory, action, button));
            button.setBorder(BorderFactory.createEmptyBorder());
            button.setBorderPainted(false);
            button.setFocusPainted(false);
            button.setContentAreaFilled(false);
            button.setCursor(new Cursor(12));
            this.pnlActions.add(button);
        }
        this.pnlActions.revalidate();
        this.pnlActions.repaint();
    }

    public void addActionListener(ActionListener listener) {
        this.acctionListeners.addActionListener(listener);
    }

    public ActionListener[] getActionListeners() {
        return this.acctionListeners.getActionListeners();
    }

    public void removeActionListener(ActionListener listener) {
        this.acctionListeners.removeActionListener(listener);
    }

    public void removeAllActionListener() {
        this.acctionListeners.removeAllActionListener();
    }

    public void fireActionEvent(ActionEvent event) {
        this.acctionListeners.fireActionEvent(event);
    }

    public boolean hasActionListeners() {
        return this.acctionListeners.hasActionListeners();
    }

    private void initComponents0() {
        this.conditionPanels = new ArrayList<SearchConditionPanel>();
        this.taskStatusController = ToolsSwingLocator.getTaskStatusSwingManager().createTaskStatusController(this.lblStatusTitle, this.lblMsg, this.pgbStatus);
    }

    private void initComponents1() {
        String factoryName;
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate(this.tabSearchMode);
        swingManager.translate(this.tabResults);
        swingManager.translate((AbstractButton)this.btnSearch);
        swingManager.translate((AbstractButton)this.btnClear);
        swingManager.translate((AbstractButton)this.btnSearchPostProcess);
        swingManager.translate(this.lblExpressionDeBusqueda);
        swingManager.translate((AbstractButton)this.btnAddAccumulatedFilter);
        swingManager.translate((AbstractButton)this.btnRemoveAccumulatedFilter);
        swingManager.translate((AbstractButton)this.btnViewAccumulatedFilter);
        swingManager.translate((AbstractButton)this.chkUseSelection);
        ConfigurableActionsMamager cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
        this.configurableActions = cfgActionsManager.getConfigurableActionsComponent("FeatureStoreSearchPanel", (Object)this);
        this.pnlCfgActions.setLayout(new BorderLayout(0, 0));
        this.pnlCfgActions.add((Component)this.configurableActions, "Center");
        this.pgbStatus.setVisible(false);
        this.conditionPanels.add(new SearchConditionPanelSimplified(this.parameters, this.store, this.pnlConditionField, this.btnAddAccumulatedFilter, this.btnRemoveAccumulatedFilter, this.btnViewAccumulatedFilter));
        SearchConditionPanelAdvanced advancedPanel = new SearchConditionPanelAdvanced(this.store, this.txtAdvancedExpression, this.btnAdvancedExpression, this.btnAdvancedExpressionHistory, this.btnAdvancedExpressionBookmarks);
        this.conditionPanels.add(advancedPanel);
        for (SearchConditionPanel.SearchConditionPanelFactory factory : DALSwingLocator.getManager().getSearchConditionPanels()) {
            factoryName = "unknown";
            try {
                factoryName = factory.getName();
                if (!factory.isApplicable(this.store)) continue;
                SearchConditionPanel panel = factory.create(new Object[]{this});
                this.conditionPanels.add(panel);
                this.tabSearchMode.add(factory.getName(), panel.asJComponent());
            }
            catch (Throwable th) {
                LOGGER.warn("Can't create search panel '" + factoryName + "'.", th);
            }
        }
        this.btnSearch.addActionListener(e -> {
            this.tabResults.setEnabledAt(1, false);
            this.search();
        });
        this.tblResults.getSelectionModel().addListSelectionListener(e -> {
            try {
                this.lastSelectedFeature = this.resultModel.getFeatureAt(this.tblResults.getSelectedRow());
            }
            catch (Throwable th) {
                LOGGER.debug("Can't retrieve last selected feature.", th);
            }
            for (ActionButtons actionButton : this.actions.values()) {
                if (!(actionButton.action instanceof ListSelectionListener)) continue;
                ((ListSelectionListener)((Object)actionButton.action)).valueChanged(e);
            }
        });
        this.btnClear.addActionListener(e -> this.clear());
        this.addActions();
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)20, (int)100, (int)30, (int)120);
        this.bookmarksController = ToolsSwingLocator.getToolsSwingManager().createBookmarksController(this.bookmarks, this.btnBookmarks);
        this.historyController = ToolsSwingLocator.getToolsSwingManager().createHistoryController(this.history, this.btnHistory);
        this.historyController.setFilter(null);
        this.historyController.addActionListener(e -> {
            ActionEventWithCurrentValue b = (ActionEventWithCurrentValue)e;
            switch (b.getID()) {
                case 1002: {
                    DefaultSearchParameters actualParams = (DefaultSearchParameters)this.fetch(null);
                    b.setCurrentValue((Object)actualParams);
                    break;
                }
                case 1001: {
                    if (b.getCurrentValue() == null) {
                        return;
                    }
                    this.putParametersAndSearch((DefaultSearchParameters)b.getCurrentValue());
                }
            }
        });
        this.bookmarksController.addActionListener(e -> {
            BookmarksController.BookmarkEvent b = (BookmarksController.BookmarkEvent)e;
            switch (b.getID()) {
                case 1002: {
                    LOGGER.info("Save bookmark");
                    DefaultSearchParameters actualParams = (DefaultSearchParameters)this.fetch(null);
                    b.setCurrentValue((Object)actualParams);
                    break;
                }
                case 1001: {
                    LOGGER.info("Restore bookmark");
                    if (b.getCurrentValue() == null) {
                        return;
                    }
                    b.getBookmark().used();
                    ((DefaultSearchParameters)b.getCurrentValue()).setName(b.getBookmark().getName());
                    this.putParametersAndSearch((DefaultSearchParameters)b.getCurrentValue());
                    break;
                }
                case 1003: {
                    LOGGER.info("Rename bookmark");
                    if (b.getCurrentValue() == null) {
                        return;
                    }
                    ((DefaultSearchParameters)b.getCurrentValue()).setName(b.getBookmark().getName());
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                DefaultSearchPanel.this.dispose();
            }
        });
        this.btnSearchPostProcess.addActionListener(e -> {
            try {
                this.doSelectSearchPostprocess();
            }
            catch (DataException ex) {
                LOGGER.warn("Can't select a Search Post Process", (Throwable)ex);
            }
        });
        this.tabResults.setEnabledAt(1, false);
        this.tblResults.setSelectionMode(2);
        this.tblResults.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 115) {
                    DefaultSearchPanel.this.doShowCellInDialog();
                }
            }
        });
        this.tblResults.setComponentPopupMenu(new TablePopupMenu(this.tblResults));
        this.tabResults.addChangeListener(evt -> SwingUtilities.invokeLater(() -> {
            switch (this.tabResults.getSelectedIndex()) {
                case 1: {
                    this.updateNumberElementsMsg(this.resultPostProcessModel);
                    break;
                }
                default: {
                    this.updateNumberElementsMsg(this.resultModel);
                }
            }
        }));
        this.tblResults.getTableHeader().setReorderingAllowed(false);
        this.tblSearchPostProcessResults.setComponentPopupMenu(new TablePopupMenu(this.tblSearchPostProcessResults));
        this.tblSearchPostProcessResults.getTableHeader().setReorderingAllowed(false);
        if (this.filterOnlyMode || !this.postProcessEnabled) {
            this.btnSearchPostProcess.setVisible(false);
        }
        for (SearchConditionPanel.SearchConditionPanelFactory factory : DALSwingLocator.getManager().getSearchResultsPanels()) {
            factoryName = "unknown";
            try {
                factoryName = factory.getName();
                this.addResultPanel(factory.getName(), factory.getTitle(), factory.create(new Object[]{this}));
            }
            catch (Throwable th) {
                LOGGER.warn("Can't create results panel '" + factoryName + "'.", th);
            }
        }
        for (AdditionalResultsPanel panel : this.additionalResultsPanels.values()) {
            panel.setIndex(this.tabResults.getTabCount());
            this.tabResults.addTab(panel.getTitle(), panel.asJComponent());
        }
        this.initialized = true;
        if (this.automaticallySearch) {
            if (this.bookmarks.hasBookmark(this.store.getName())) {
                Bookmark initBookmark = this.bookmarks.get(this.store.getName());
                initBookmark.used();
                this.putParametersAndSearch((DefaultSearchParameters)initBookmark.getValue());
            } else {
                this.clear();
                this.search();
            }
        } else {
            this.clear();
        }
    }

    private void putParametersAndSearch(DefaultSearchParameters searchParams) {
        SearchParameters panelParams;
        DefaultSearchParameters params;
        try {
            params = searchParams.getCopy();
            FeatureType featType = this.getFeatureType();
            StringBuilder errMessage = new StringBuilder();
            boolean onlyEssentials = false;
            boolean isValid = params.isValid(featType, errMessage);
            if (!isValid) {
                I18nManager i18n;
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                int n = dialogs.confirmDialog((i18n = ToolsLocator.getI18nManager()).getTranslation("_The_validation_of_the_search_parameters_has_returned_the_following_errors") + ":\n\n" + errMessage.toString() + "\n" + i18n.getTranslation("_You_want_the_application_to_try_to_resolve_them_before_launching_the_query"), i18n.getTranslation("_Validation_of_search_parameters"), 0, 2, "_Fix_search_parameters");
                if (n != 0) {
                    onlyEssentials = true;
                } else {
                    LOGGER.info("It has been decided do not resolve errors in parameters of search");
                }
            }
            params.fix(featType, onlyEssentials);
        }
        catch (Exception ex) {
            LOGGER.warn("Not been able to clone export parameters", (Throwable)ex);
            return;
        }
        try {
            this.clear();
            this.put(params);
            panelParams = this.fetch(this.parameters.getCopy());
        }
        catch (Exception ex) {
            LOGGER.warn("Not able to create search parameters.", (Throwable)ex);
            this.taskStatusController.setTitle(ToolsLocator.getI18nManager().getTranslation("_Errors_fetching_new_query") + "...");
            this.resetTable();
            return;
        }
        Thread th = new Thread(() -> this.doSearch(panelParams));
        th.start();
    }

    private void doShowCellInDialog() {
        int row = this.tblResults.getSelectedRow();
        if (row < 0) {
            return;
        }
        int col = this.tblResults.getSelectedColumn();
        if (col < 0) {
            return;
        }
        String s = Objects.toString(this.tblResults.getValueAt(row, col), null);
        if (StringUtils.isBlank((CharSequence)s)) {
            return;
        }
        ToolsSwingLocator.getToolsSwingManager().showZoomDialog((Component)this, this.tblResults.getColumnName(col), s, false);
    }

    public FeatureType getFeatureType() {
        try {
            return this.store.getDefaultFeatureType();
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve the feature type.", ex);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.setEnabled(enabled));
            return;
        }
        if (!this.initialized) {
            this.initComponents1();
        }
        for (SearchConditionPanel conditionPanel : this.conditionPanels) {
            conditionPanel.setEnabled(enabled);
        }
        this.btnClear.setEnabled(enabled);
        this.btnSearch.setEnabled(enabled);
        for (ActionButtons actionButton : this.actions.values()) {
            actionButton.action.setEnabled(enabled);
        }
        this.btnSearchPostProcess.setEnabled(enabled);
    }

    public void clear() {
        this.taskStatusController.setTitle("");
        if (!this.initialized) {
            return;
        }
        for (SearchConditionPanel conditionPanel : this.conditionPanels) {
            conditionPanel.clear();
        }
        FeatureQuery emptyQuery = this.store.createFeatureQuery();
        emptyQuery.retrievesAllAttributes();
        this.parameters.setQuery(emptyQuery);
        List<String> resultColumnNames = this.parameters.getResultColumnNames();
        ArrayList<String> toDeleteAlreadyDontExist = new ArrayList<String>();
        for (String resultColumnName : resultColumnNames) {
            try {
                FeatureAttributeDescriptor attr = this.store.getDefaultFeatureType().getAttributeDescriptor(resultColumnName);
                if (attr != null) continue;
                toDeleteAlreadyDontExist.add(resultColumnName);
            }
            catch (DataException dataException) {}
        }
        resultColumnNames.removeAll(toDeleteAlreadyDontExist);
        this.resetTable();
    }

    public FeatureQuery getLastQuery() {
        return this.lastQuery;
    }

    public boolean isValid(StringBuilder message) {
        int searchMode = this.tabSearchMode.getSelectedIndex();
        SearchConditionPanel panel = this.conditionPanels.get(searchMode);
        boolean valid = panel.isValid(message);
        return valid;
    }

    public String getWarnings() {
        int searchMode = this.tabSearchMode.getSelectedIndex();
        SearchConditionPanel panel = this.conditionPanels.get(searchMode);
        String s = panel.getWarnings();
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s;
    }

    public int search() {
        ThreadSafeDialogsManager dialogManager;
        int n;
        StringBuilder message = new StringBuilder();
        if (!this.isValid(message)) {
            ThreadSafeDialogsManager dialogManager2 = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogManager2.messageDialog("_The_specified_search_condition_is_not_valid", "_Search", 2);
            return 1;
        }
        String warnings = this.getWarnings();
        if (StringUtils.isNotBlank((CharSequence)warnings) && (n = (dialogManager = ToolsSwingLocator.getThreadSafeDialogsManager()).confirmDialog("The indicated search can cause problems.\n" + warnings + "\n" + "Do you want to run it anyway?", "_Search", 0, 2)) == 1) {
            return 0;
        }
        this.lblMsg.setText(ToolsLocator.getI18nManager().getTranslation("_Searching") + "...");
        this.setEnabled(false);
        Thread th = new Thread(() -> {
            try {
                SearchParameters searchParams;
                try {
                    searchParams = this.fetch(this.parameters.getCopy());
                    Date date = Calendar.getInstance().getTime();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    String strDate = dateFormat.format(date);
                    searchParams.setName("Params: " + strDate);
                }
                catch (Exception ex) {
                    LOGGER.warn("Not able to create search parameters.", (Throwable)ex);
                    this.taskStatusController.setTitle(ToolsLocator.getI18nManager().getTranslation("_Errors_fetching_new_query") + "...");
                    this.resetTable();
                    SwingUtilities.invokeLater(() -> this.setEnabled(true));
                    return;
                }
                this.doSearch(searchParams);
            }
            catch (Exception ex) {
                LOGGER.warn("Search panel has errors during the search", (Throwable)ex);
                this.resetTable();
            }
            finally {
                SwingUtilities.invokeLater(() -> this.setEnabled(true));
            }
        });
        th.start();
        return 0;
    }

    public int search(SearchParameters searchParams) {
        ((DefaultSearchParameters)searchParams).fix(this.getFeatureType());
        return this.doSearch(searchParams);
    }

    private synchronized int doSearch(SearchParameters searchParams) {
        MutableObject model = new MutableObject(null);
        MutableLong rowCount = new MutableLong();
        Cursor savedCursor = this.getCursor();
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("");
        status.setAutoremove(true);
        status.add();
        this.taskStatusController.bind((TaskStatus)status);
        List features = null;
        try {
            LOGGER.info("Do search");
            status.setTitle(ToolsLocator.getI18nManager().getTranslation("_Processing_search"));
            SwingUtilities.invokeLater(() -> {
                if (this.initialized) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                }
            });
            List resultColumnNames = searchParams.getResultColumnNames();
            FeatureQuery myQuery = searchParams.getQueryToApply();
            if (this.useSelection()) {
                myQuery = this.addSelection(this.store, myQuery);
            }
            features = this.store.getFeatures(myQuery, 50);
            FacadeOfAFeaturePagingHelper facade = (FacadeOfAFeaturePagingHelper)features;
            FeatureType ftype = facade.getFeaturePagingHelper().getFeatureSet().getDefaultFeatureType();
            SimpleFeaturesTableModelImpl tableModel = new SimpleFeaturesTableModelImpl(ftype, resultColumnNames, features);
            model.setValue((Object)tableModel);
            rowCount.setValue((long)features.size());
            if (rowCount.longValue() > 0L) {
                Feature feature = (Feature)features.get(0);
            }
            this.resultModel = (SimpleFeaturesTableModel)model.getValue();
            SwingUtilities.invokeLater(() -> {
                if (this.initialized) {
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    try {
                        if (this.tabResults.getSelectedIndex() == 1) {
                            this.tabResults.setSelectedIndex(0);
                        }
                        TableModel oldmodel = this.tblResults.getModel();
                        this.tblResults.setModel((TableModel)this.resultModel);
                        this.resultModel.setCellRenderers(this.tblResults, this.getCustomRenderers(searchParams));
                        if (oldmodel instanceof SimpleFeaturesTableModelImpl) {
                            ((SimpleFeaturesTableModelImpl)oldmodel).dispose();
                        }
                        if (this.resultModel.hasErrors()) {
                            status.setTitle(i18n.getTranslation("_Errors_occurred_during_search"));
                        } else {
                            status.setTitle(String.format("%d " + i18n.getTranslation("_elements"), rowCount.getValue()));
                        }
                        if (this.parameters != null && this.parameters.getQuery() != null) {
                            this.history.add((Object)searchParams);
                        }
                        this.fireSearchEvent();
                    }
                    catch (Exception ex) {
                        LOGGER.warn(" Errors occurred during search getting old model", (Throwable)ex);
                        status.setTitle(i18n.getTranslation("_Errors_occurred_during_search"));
                    }
                    finally {
                        this.setEnabled(true);
                        status.terminate();
                        this.setCursor(savedCursor);
                    }
                }
            });
        }
        catch (Exception ex) {
            LOGGER.warn("Search not able to be executed. Can't get features or create table model", (Throwable)ex);
            status.setTitle(ToolsLocator.getI18nManager().getTranslation("_Errors_getting_new_feature_set") + "...");
            status.abort();
            DisposeUtils.disposeQuietly(features);
            this.lastErrorMessage = this.getLastErrorMessage(ex);
            if (StringUtils.isNotBlank((CharSequence)this.lastErrorMessage)) {
                status.setTitle(this.lastErrorMessage);
            }
            this.resetTable();
            return 2;
        }
        return 0;
    }

    public SimpleFeaturesTableModel getResultsTableModel() {
        return this.resultModel;
    }

    private Map<String, TableCellRenderer> getCustomRenderers(SearchParameters parameters) {
        FeatureType ft = this.store.getDefaultFeatureTypeQuietly();
        HashMap<String, TableCellRenderer> renderers = new HashMap<String, TableCellRenderer>();
        for (FeatureAttributeDescriptor attr : ft) {
            if (!attr.getDataType().isNumeric()) continue;
        }
        return renderers;
    }

    private void resetTable() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> {
                if (this.initialized) {
                    this.resetTable();
                }
            });
            return;
        }
        List<String> resultColumnNames = null;
        try {
            resultColumnNames = this.parameters.getResultColumnNames();
        }
        catch (Exception exception) {
            // empty catch block
        }
        FeatureType ftype = this.store.getDefaultFeatureTypeQuietly();
        SimpleFeaturesTableModelImpl emptyTableModel = new SimpleFeaturesTableModelImpl(ftype, resultColumnNames, null);
        this.tblResults.setModel(emptyTableModel);
    }

    public void setResultColumnNames(List<String> names) {
        this.parameters.getResultColumnNames().clear();
        this.parameters.getResultColumnNames().addAll(names);
    }

    public boolean setFilter(Expression filter) {
        try {
            if (!this.initialized) {
                this.initComponents1();
            }
            if (ExpressionUtils.isPhraseEmpty((Expression)filter)) {
                this.clear();
                return true;
            }
            int panel = 0;
            int selected = 1;
            for (SearchConditionPanel conditionPanel : this.conditionPanels) {
                if (panel != 1 && conditionPanel.set(filter)) {
                    selected = panel;
                }
                ++panel;
            }
            this.tabSearchMode.setSelectedIndex(selected);
            return true;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't set current search", (Throwable)ex);
            return false;
        }
    }

    public List<SearchConditionPanel> getConditionPanels() {
        return Collections.unmodifiableList(this.conditionPanels);
    }

    public SearchConditionPanel getConditionPanel(String name) {
        if (this.conditionPanels == null) {
            return null;
        }
        for (SearchConditionPanel panel : this.conditionPanels) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)panel.getFactory().getName())) continue;
            return panel;
        }
        return null;
    }

    public FeatureSelection getSelectedFeatures() {
        if (!this.initialized) {
            return null;
        }
        int[] selectedRows = this.tblResults.getSelectedRows();
        if (ArrayUtils.isEmpty((int[])selectedRows)) {
            return null;
        }
        if (this.tabResults.getSelectedIndex() == 1) {
            if (this.currentPostProcess == null) {
                return null;
            }
            try {
                FeatureSelection selection = this.store.createFeatureSelection();
                List<Feature> features = ((SimpleFeaturesTableModelImpl)this.tblSearchPostProcessResults.getModel()).getFeatures();
                for (int i = 0; i < selectedRows.length; ++i) {
                    Feature feature = features.get(selectedRows[i]);
                    selection.select(feature);
                }
                return selection == null ? null : selection;
            }
            catch (Exception ex) {
                LOGGER.warn("Can't build search for the selected feature.", (Throwable)ex);
                return null;
            }
        }
        try {
            FeatureSelection selection = this.store.createFeatureSelection();
            List<Feature> features = ((SimpleFeaturesTableModelImpl)this.tblResults.getModel()).getFeatures();
            for (int i = 0; i < selectedRows.length; ++i) {
                Feature feature = features.get(selectedRows[i]);
                selection.select(feature);
            }
            return selection == null ? null : selection;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't build search for the selected feature.", (Throwable)ex);
            return null;
        }
    }

    public Expression getFilterForSelectedFeatures() {
        int maxfeatures = 100;
        if (!this.initialized) {
            return null;
        }
        int[] selectedRows = this.tblResults.getSelectedRows();
        if (ArrayUtils.isEmpty((int[])selectedRows)) {
            return null;
        }
        if (selectedRows.length > maxfeatures) {
            this.taskStatusController.message("Too many items selecteds");
        }
        if (this.tabResults.getSelectedIndex() == 1) {
            if (this.currentPostProcess == null) {
                return null;
            }
            try {
                ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
                List<Feature> features = ((SimpleFeaturesTableModelImpl)this.tblSearchPostProcessResults.getModel()).getFeatures();
                for (int i = 0; i < selectedRows.length && i < maxfeatures; ++i) {
                    Feature feature = features.get(selectedRows[i]);
                    FeatureType ftype = this.postProcessStore.getDefaultFeatureType();
                    for (FeatureAttributeDescriptor attrdesc : ftype.getPrimaryKey()) {
                        builder.or((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(attrdesc.getName()), (ExpressionBuilder.Value)builder.constant(feature.get(attrdesc.getName()))));
                    }
                }
                Expression filter = ExpressionUtils.createExpression((String)builder.toString());
                return filter;
            }
            catch (Exception ex) {
                LOGGER.warn("Can't build search for the selected feature.", (Throwable)ex);
                return null;
            }
        }
        try {
            FeatureType ftype = this.store.getDefaultFeatureType();
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            List<Feature> features = ((SimpleFeaturesTableModelImpl)this.tblResults.getModel()).getFeatures();
            for (int i = 0; i < selectedRows.length && i < maxfeatures; ++i) {
                Feature feature = features.get(selectedRows[i]);
                for (FeatureAttributeDescriptor attrdesc : ftype.getPrimaryKey()) {
                    builder.or((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(attrdesc.getName()), (ExpressionBuilder.Value)builder.constant(feature.get(attrdesc.getName()))));
                }
            }
            Expression filter = ExpressionUtils.createExpression((String)builder.toString());
            return filter;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't build search for the selected feature.", (Throwable)ex);
            return null;
        }
    }

    public Expression getFilterForSelectedFeature() {
        if (!this.initialized) {
            return null;
        }
        if (this.tabResults.getSelectedIndex() == 1) {
            if (this.currentPostProcess == null) {
                return null;
            }
            int selectedRow = this.tblSearchPostProcessResults.getSelectedRow();
            if (selectedRow < 0) {
                return null;
            }
            try {
                List<Feature> features = ((SimpleFeaturesTableModelImpl)this.tblSearchPostProcessResults.getModel()).getFeatures();
                Feature feature = features.get(selectedRow);
                ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
                FeatureType ftype = this.postProcessStore.getDefaultFeatureType();
                for (FeatureAttributeDescriptor attrdesc : ftype.getPrimaryKey()) {
                    builder.and((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(attrdesc.getName()), (ExpressionBuilder.Value)builder.constant(feature.get(attrdesc.getName()))));
                }
                Expression filter = ExpressionUtils.createExpression((String)builder.toString());
                return filter;
            }
            catch (Exception ex) {
                LOGGER.warn("Can't build search for the selected feature.", (Throwable)ex);
                return null;
            }
        }
        int selectedRow = this.tblResults.getSelectedRow();
        if (selectedRow < 0) {
            return null;
        }
        try {
            List<Feature> features = ((SimpleFeaturesTableModelImpl)this.tblResults.getModel()).getFeatures();
            Feature feature = features.get(selectedRow);
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            FeatureType ftype = this.store.getDefaultFeatureType();
            for (FeatureAttributeDescriptor attrdesc : ftype.getPrimaryKey()) {
                builder.and((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(attrdesc.getName()), (ExpressionBuilder.Value)builder.constant(feature.get(attrdesc.getName()))));
            }
            Expression filter = ExpressionUtils.createExpression((String)builder.toString());
            return filter;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't build search for the selected feature.", (Throwable)ex);
            return null;
        }
    }

    public FeatureStore getStore() {
        return this.store;
    }

    private void doOrderBy() {
        try {
            LOGGER.info("Do show order by");
            I18nManager i18n = ToolsLocator.getI18nManager();
            WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            FeatureQueryOrderPanel orderPanel = DALSwingLocator.getDataSwingManager().createFeatureStoreOrderPanel();
            orderPanel.setStore(this.store);
            orderPanel.put(this.parameters.getQuery());
            Dialog dialog = windowManager.createDialog(orderPanel.asJComponent(), i18n.getTranslation("_Select_order"), null, 3);
            dialog.addActionListener(e -> {
                if (dialog.getAction() == 1) {
                    orderPanel.fetch(this.parameters.getQuery());
                    this.search();
                }
            });
            dialog.show(WindowManager.MODE.DIALOG);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show dialog", (Throwable)ex);
        }
    }

    private void doExportTSV(JTable table) {
        try {
            int res;
            LOGGER.info("Do export TSV");
            SimpleFeaturesTableModel model = table.getModel() instanceof SimpleFeaturesTableModel ? (SimpleFeaturesTableModel)table.getModel() : null;
            I18nManager i18n = ToolsLocator.getI18nManager();
            if (model == null) {
                ToolsSwingLocator.getThreadSafeDialogsManager().messageDialog(i18n.getTranslation("_Not_able_to_export_table_to_TSV"), i18n.getTranslation(EXPORT_TO_TSV_TITLE), 2);
                return;
            }
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String extension = FilenameUtils.getExtension((String)f.getAbsolutePath());
                    return StringUtils.equalsIgnoreCase((CharSequence)DefaultSearchPanel.TSV_EXTENSION, (CharSequence)extension);
                }

                @Override
                public String getDescription() {
                    return "TSV file";
                }
            };
            FoldersManager folderManager = ToolsLocator.getFoldersManager();
            File initialFolder = folderManager.getLastPath(EXPORT_TO_TSV_LASTPATHID);
            ThreadSafeDialogsManager safeDialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            ImmutablePair pair = safeDialogsManager.showChooserDialog(i18n.getTranslation(EXPORT_TO_TSV_TITLE), 1, 0, false, initialFolder, fileFilter, this.initialized, true);
            if (pair == null) {
                return;
            }
            File[] files = (File[])pair.getLeft();
            Charset charset = (Charset)pair.getRight();
            if (files.length < 1) {
                return;
            }
            File f = files[0];
            if (f == null) {
                return;
            }
            if (f.isDirectory()) {
                return;
            }
            if (FilenameUtils.getExtension((String)f.getName()).isEmpty()) {
                f = new File(f.getAbsolutePath() + '.' + TSV_EXTENSION);
            }
            if (f.exists() && (res = safeDialogsManager.confirmDialog(i18n.getTranslation("fichero_ya_existe_seguro_desea_guardarlo"), i18n.getTranslation(EXPORT_TO_TSV_TITLE), 1, 2)) != 0) {
                return;
            }
            File file = f;
            folderManager.setLastPath(EXPORT_TO_TSV_LASTPATHID, file.getParentFile());
            Cursor savedCursor = this.getCursor();
            SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("");
            status.setAutoremove(true);
            status.add();
            this.taskStatusController.bind((TaskStatus)status);
            SearchParameters searchParams = this.fetch(this.parameters.getCopy());
            FeatureQuery myQuery = this.useSelection() ? this.addSelection(this.store, searchParams.getQueryToApply()) : searchParams.getQueryToApply();
            Thread task = new Thread(() -> {
                try {
                    this.processing = true;
                    this.updateComponentState();
                    SwingUtilities.invokeLater(() -> this.setCursor(Cursor.getPredefinedCursor(3)));
                    status.setTitle(i18n.getTranslation(EXPORT_TO_TSV_TITLE));
                    Pair<Iterator<Feature>, Long> features = this.buildExportIterator(table, this.store, myQuery);
                    ExportTSV exportTSV = new ExportTSV();
                    exportTSV.process((Iterator<Feature>)((Iterator)features.getLeft()), (long)((Long)features.getRight()), model, file, charset, status);
                }
                catch (Exception ex) {
                    LOGGER.warn("Not able to export table to TSV", (Throwable)ex);
                }
                finally {
                    this.processing = false;
                    SwingUtilities.invokeLater(() -> this.setCursor(savedCursor));
                    this.updateComponentState();
                }
            }, "SearchPanelExportTSV");
            task.start();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't export TSV", (Throwable)ex);
        }
    }

    private void doCopyRows(JTable table) {
        LOGGER.info("Do copy rows");
        if (!(table.getModel() instanceof SimpleFeaturesTableModel)) {
            LOGGER.warn("Can't copy rows, wrong model.");
            return;
        }
        SimpleFeaturesTableModel model = (SimpleFeaturesTableModel)table.getModel();
        Cursor savedCursor = this.getCursor();
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("");
        status.setAutoremove(true);
        status.add();
        this.taskStatusController.bind((TaskStatus)status);
        Thread task = new Thread(() -> {
            try {
                this.processing = true;
                this.updateComponentState();
                SwingUtilities.invokeLater(() -> this.setCursor(Cursor.getPredefinedCursor(3)));
                String title = ToolsLocator.getI18nManager().getTranslation("_Copying_rows_to_clipboard");
                status.setTitle(title);
                status.message("");
                SearchParameters searchParams = this.fetch(this.parameters.getCopy());
                FeatureQuery myQuery = this.useSelection() ? this.addSelection(this.store, searchParams.getQueryToApply()) : searchParams.getQueryToApply();
                Pair<Iterator<Feature>, Long> features = this.buildExportIterator(table, this.store, myQuery);
                ExportTSV exportTSV = new ExportTSV();
                ByteArrayOutputStream fos = new ByteArrayOutputStream();
                exportTSV.process((Iterator<Feature>)((Iterator)features.getLeft()), (long)((Long)features.getRight()), model, fos, Charset.defaultCharset(), status);
                String toStr = new String(fos.toByteArray(), Charset.defaultCharset());
                SwingUtilities.invokeLater(() -> {
                    ToolsSwingLocator.getToolsSwingManager().putInClipboard(toStr);
                    status.setTitle(ToolsLocator.getI18nManager().getTranslation("_Copy_ended"));
                    status.terminate();
                });
            }
            catch (Exception ex) {
                LOGGER.warn("Not able to copy rows to the clipboard", (Throwable)ex);
                status.message("Not able to copy rows to the clipboard");
                status.abort();
            }
            finally {
                this.processing = false;
                SwingUtilities.invokeLater(() -> this.setCursor(savedCursor));
                this.updateComponentState();
            }
        }, "SearchPanelCopyRows");
        task.start();
    }

    private Pair<Iterator<Feature>, Long> buildExportIterator(final JTable table, FeatureStore store, FeatureQuery query) {
        if (!(table.getModel() instanceof SimpleFeaturesTableModel)) {
            return null;
        }
        final SimpleFeaturesTableModel model = (SimpleFeaturesTableModel)table.getModel();
        final int[] selection = table.getSelectedRows();
        if (ArrayUtils.isEmpty((int[])selection) || selection.length == model.size()) {
            FeatureSet features = null;
            try {
                features = store.getFeatureSet(query);
                ImmutablePair immutablePair = new ImmutablePair((Object)features.fastIterator(), (Object)features.size64());
                return immutablePair;
            }
            catch (Exception e) {
                throw new RuntimeException("Can't get features.", e);
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)features);
            }
        }
        Iterator<Feature> featIterator = new Iterator<Feature>(){
            int row = 0;

            @Override
            public boolean hasNext() {
                return this.row < selection.length;
            }

            @Override
            public Feature next() {
                int n = table.convertRowIndexToModel(selection[this.row++]);
                return model.getFeatureAt(n);
            }
        };
        return new ImmutablePair((Object)featIterator, (Object)selection.length);
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return ToolsSwingUtils.loadImage((Object)this, (String)imageName);
    }

    public int getSelectedFeatureCount() {
        if (!this.initialized) {
            return 0;
        }
        if (this.currentPostProcess != null && this.tabResults.getSelectedIndex() == 1) {
            return this.tblSearchPostProcessResults.getSelectedRowCount();
        }
        return this.tblResults.getSelectedRowCount();
    }

    public JComponent getActionButton(String name) {
        ActionButtons actionButton = this.actions.get(name);
        if (actionButton == null) {
            return null;
        }
        return actionButton.button;
    }

    public void setShowActions(boolean showActions) {
        this.showActions = showActions;
    }

    public boolean isShowActions() {
        return this.showActions;
    }

    private void doCalculatedColumns() {
        try {
            LOGGER.info("Do show calculate columns");
            WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            DefaultFeatureQueryCalculatedColumnsPanel panel = new DefaultFeatureQueryCalculatedColumnsPanel();
            panel.setStore(this.store);
            panel.put(this.parameters.getQuery());
            Dialog dialog = winmanager.createDialog(panel.asJComponent(), i18n.getTranslation("_Calculated_columns"), null, 3);
            dialog.addActionListener(e -> {
                if (dialog.getAction() == 1) {
                    panel.fetch(this.parameters.getQuery());
                    this.search();
                }
            });
            dialog.show(WindowManager.MODE.DIALOG);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show dialog", (Throwable)ex);
        }
    }

    private void doGroupBy() {
        try {
            LOGGER.info("Do show group by");
            DataStoreProviderFactory dataFactory = this.store.getProviderFactory();
            int allowGroupBy = ((FeatureStoreProviderFactory)dataFactory).allowGroupBy();
            if (allowGroupBy != 1) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                dialogs.messageDialog(i18n.getTranslation("_The_group_function_is_not_available_for_this_table"), i18n.getTranslation("_Information"), 1);
                return;
            }
            WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            DefaultSearchGroupByPanel panelGroupBy = new DefaultSearchGroupByPanel();
            panelGroupBy.setStore(this.store);
            panelGroupBy.put(this.parameters);
            Dialog dialog = winmanager.createDialog(panelGroupBy.asJComponent(), i18n.getTranslation("_Select_group_columns_and_aggregate_functions"), null, 3);
            dialog.addActionListener(e -> {
                if (dialog.getAction() == 1) {
                    panelGroupBy.fetch(this.parameters);
                    this.search();
                }
            });
            dialog.show(WindowManager.MODE.DIALOG);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show dialog", (Throwable)ex);
        }
    }

    private void doSelectResultColumnNames() {
        try {
            LOGGER.info("Do select result column names");
            WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            FeatureAttributesSelectionPanel panelSelectColumns = DALSwingLocator.getManager().createFeatureAttributeSelectionPanel();
            panelSelectColumns.allowCalculatedAttributes(false);
            FeatureType ftype = this.getFeatureType();
            panelSelectColumns.setFeatureType(ftype);
            if (this.parameters.getQuery() != null) {
                panelSelectColumns.setExtraColumns(this.parameters.getQuery().getExtraColumns().getColumns());
            }
            panelSelectColumns.setSelectedNames(this.parameters.getResultColumnNames());
            Dialog dialog = winmanager.createDialog(panelSelectColumns.asJComponent(), i18n.getTranslation("_Select_the_columns_to_display"), null, 3);
            dialog.addActionListener(e -> {
                if (dialog.getAction() == 1) {
                    this.setResultColumnNames(panelSelectColumns.getSelectedNames());
                    this.search();
                }
            });
            dialog.show(WindowManager.MODE.DIALOG);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show dialog", (Throwable)ex);
        }
    }

    public void put(SearchParameters inParams) {
        this.parameters = (DefaultSearchParameters)inParams;
        for (SearchConditionPanel conditionPanel : this.conditionPanels) {
            try {
                conditionPanel.put(inParams);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't open panel", (Throwable)ex);
            }
        }
        this.tabSearchMode.setSelectedIndex(inParams.getSearchMode());
    }

    private FeatureQuery getQuery() {
        try {
            int searchMode = this.tabSearchMode.getSelectedIndex();
            SearchConditionPanel panel = this.conditionPanels.get(searchMode);
            Expression filter = panel.get();
            if (searchMode != 1) {
                this.conditionPanels.get(1).set(filter);
            }
            FeatureQuery query = (FeatureQuery)this.parameters.getQuery().clone();
            query.retrievesAllAttributes();
            if (ExpressionUtils.isPhraseEmpty((Expression)filter)) {
                return query;
            }
            query.setFilter(Expression.cloneQuietly((Expression)filter));
            query.retrievesAllAttributes();
            return query;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't build query.", (Throwable)ex);
            return null;
        }
    }

    public SearchParameters fetch(SearchParameters outParams) {
        if (!this.initialized) {
            this.initComponents1();
        }
        for (SearchConditionPanel conditionPanel : this.conditionPanels) {
            try {
                conditionPanel.fetch((SearchParameters)this.parameters);
            }
            catch (Exception ex) {
                LOGGER.warn("Panel not able to fetch values", (Throwable)ex);
            }
        }
        int searchMode = this.tabSearchMode.getSelectedIndex();
        SearchConditionPanel panel = this.conditionPanels.get(searchMode);
        Expression filter = panel.get();
        if (searchMode != 1) {
            this.conditionPanels.get(1).set(filter);
        }
        this.parameters.setSearchMode(searchMode);
        FeatureQuery query = this.parameters.getQuery();
        this.lastQuery = query.getCopy();
        query.retrievesAllAttributes();
        query.clearFilter();
        if (!ExpressionUtils.isPhraseEmpty((Expression)filter)) {
            query.setFilter(filter);
            query.retrievesAllAttributes();
        }
        if (outParams == null) {
            return this.parameters.getCopy();
        }
        outParams.copyFrom((SearchParameters)this.parameters.getCopy());
        return outParams;
    }

    public static void selfRegister() {
        boolean n = ToolsSwingUtils.registerIcons(DefaultSearchPanel.class, (String)"", (String)"DataAccessSwingLibrary", (String[][])new String[][]{{"storeaction", "storeaction-select"}, {"storeaction", "storeaction-select-add"}, {"storeaction", "storeaction-select-filter"}, {"storesearch", "search-simplifiedcondition-edit-accumulate"}, {"storesearch", "search-simplifiedcondition-clear-accumulate"}, {"storesearch", "search-simplifiedcondition-add-accumulate"}, {"storesearch", "search-nullbehavior-null"}, {"storesearch", "search-nullbehavior-true"}, {"storesearch", "search-nullbehavior-false"}, {"storesearch", "search-geometry-select"}, {"storesearch", "search-select-column"}});
        ToolsSwingUtils.registerGroupIconScreenshot(DefaultDALSwingLibrary.class, (String)"storesearch", (String)"/org/gvsig/fmap/dal/screenshots/storesearch1.png");
        ConfigurableActionsMamager cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
        cfgActionsManager.addConfigurableAction("FeatureStoreSearchPanel", (Action)new UseLabelsYesAction());
        cfgActionsManager.addConfigurableAction("FeatureStoreSearchPanel", (Action)new UseLabelsNoAction());
        cfgActionsManager.addConfigurableAction("FeatureStoreSearchPanel", (Action)new UseLabelsBothAction());
        cfgActionsManager.addConfigurableAction("FeatureStoreSearchPanel", (Action)new SelectColumnsAction());
        cfgActionsManager.addConfigurableAction("FeatureStoreSearchPanel", (Action)new CalculatedColumnsAction());
        cfgActionsManager.addConfigurableAction("FeatureStoreSearchPanel", (Action)new GroupByAction());
        cfgActionsManager.addConfigurableAction("FeatureStoreSearchPanel", (Action)new OrderByAction());
        cfgActionsManager.addConfigurableAction("FeatureStoreSearchPanel", (Action)new PropertiesAction());
    }

    private void doSelectSearchPostprocess() throws DataException {
        DataSwingManager manager = DALSwingLocator.getDataSwingManager();
        Map searchPostProcessFactoryMap = manager.getSearchPostProcess();
        JPopupMenu menu = new JPopupMenu();
        for (String factory : searchPostProcessFactoryMap.keySet()) {
            JMenuItem item = new JMenuItem(factory);
            SearchParameters searchParams = this.fetch(this.parameters.getCopy());
            FeatureQuery myQuery = searchParams.getQueryToApply();
            item.addActionListener(e -> this.doSearchPostProcess(this.store, myQuery, manager.getSearchPostProcess(factory), searchParams));
            menu.add(item);
        }
        menu.show(this.btnSearchPostProcess, 0, this.btnSearchPostProcess.getHeight());
    }

    private void doExecuteSearchPostProcess(FeatureStore input, FeatureQuery query, SearchPostProcessFactory factory, DynObject parameters) {
        LOGGER.info("Do execute post process");
        Cursor savedCursor = this.getCursor();
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("");
        status.setAutoremove(true);
        status.add();
        this.taskStatusController.bind((TaskStatus)status);
        Thread task = new Thread(() -> {
            try {
                SearchPostProcess.SearchPostProcessResult output;
                SwingUtilities.invokeLater(() -> this.setCursor(Cursor.getPredefinedCursor(3)));
                this.processing = true;
                this.updateComponentState();
                SearchPostProcess process = factory.createProcess(factory, input, query, parameters);
                if (parameters != null) {
                    process.setParameters(parameters);
                }
                if ((output = process.execute(input, query, parameters, status)) != null) {
                    this.postProcessStore = output.getStore();
                    this.postProcessQuery = output.getQuery();
                    this.doLoadSearchPostProccessResults(this.postProcessStore);
                }
                this.currentPostProcess = factory.getName();
                status.terminate();
            }
            catch (Exception ex) {
                LOGGER.warn("SearchPostProcess not able to be executed.", (Throwable)ex);
                this.resetPostProcessTable();
                status.setTitle(ToolsLocator.getI18nManager().getTranslation("_Error_in_post_process_operation"));
                status.message("");
                status.abort();
            }
            finally {
                SwingUtilities.invokeLater(() -> this.setCursor(savedCursor));
                this.processing = false;
                this.updateComponentState();
            }
        }, "ExecuteSearchPostProcess");
        task.start();
    }

    private void doLoadSearchPostProccessResults(FeatureStore input) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.doLoadSearchPostProccessResults(input));
            return;
        }
        FeatureQuery finalQuery = null;
        try {
            this.tabResults.setEnabledAt(1, true);
            this.tabResults.setSelectedIndex(1);
            List featuresSearchPostProccessResults = input.getFeatures(finalQuery, 20);
            FacadeOfAFeaturePagingHelper facadeSearchPostProccessResults = (FacadeOfAFeaturePagingHelper)featuresSearchPostProccessResults;
            FeatureType ftypeSearchPostProccessResults = facadeSearchPostProccessResults.getFeaturePagingHelper().getFeatureSet().getDefaultFeatureType();
            this.resultPostProcessModel = new SimpleFeaturesTableModelImpl(ftypeSearchPostProccessResults, this.parameters.getResultColumnNames(), featuresSearchPostProccessResults);
            I18nManager i18n = ToolsLocator.getI18nManager();
            TableModel oldmodel = this.tblSearchPostProcessResults.getModel();
            this.tblSearchPostProcessResults.setModel((TableModel)this.resultPostProcessModel);
            this.resultPostProcessModel.setCellRenderers(this.tblSearchPostProcessResults);
            if (oldmodel instanceof SimpleFeaturesTableModel) {
                ((SimpleFeaturesTableModel)oldmodel).dispose();
            }
            this.updateNumberElementsMsg(this.resultPostProcessModel);
        }
        catch (Exception ex) {
            this.resetPostProcessTable();
            LOGGER.warn("SearchPostProcess not able to be executed. Can't get features or create table model", (Throwable)ex);
        }
    }

    private void updateComponentState() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::updateComponentState);
            return;
        }
        this.pgbStatus.setVisible(this.processing);
        this.setEnabled(!this.processing);
    }

    private void resetPostProcessTable() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::resetPostProcessTable);
            return;
        }
        this.tblSearchPostProcessResults.setModel(new DefaultTableModel());
    }

    private void doSearchPostProcess(FeatureStore store, FeatureQuery query, SearchPostProcessFactory factory, SearchParameters searchParams) {
        LOGGER.info("Do search post process");
        if (factory.hasProcessParameters()) {
            DynObject parametersPostProcess = factory.createProcessParameters(store, query, searchParams);
            JDynForm form = DynFormLocator.getDynFormManager().createJDynForm(parametersPostProcess);
            form.setLayoutMode(2);
            I18nManager i18n = ToolsLocator.getI18nManager();
            WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            Dialog dialog = windowManager.createDialog(form.asJComponent(), i18n.getTranslation("_Postprocess_parameters"), i18n.getTranslation("_Parameters_for_XpostprocessNameX_postprocess_on_XtableNameX", new String[]{factory.getName(), this.store.getName()}), 3);
            ToolsSwingUtils.ensureRowsCols((JComponent)dialog.asJComponent(), (int)20, (int)60, (int)30, (int)100);
            dialog.addActionListener(e2 -> {
                if (dialog.getAction() == 1) {
                    form.getValues(parametersPostProcess);
                    this.doExecuteSearchPostProcess(store, query, factory, parametersPostProcess);
                    this.postProcessParams = parametersPostProcess;
                }
            });
            dialog.show(WindowManager.MODE.DIALOG);
        } else {
            this.doExecuteSearchPostProcess(store, query, factory, null);
        }
    }

    private void updateNumberElementsMsg(SimpleFeaturesTableModel model) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (model.hasErrors()) {
            this.taskStatusController.setTitle(i18n.getTranslation("_Errors_occurred_load_search_post_process"));
        } else {
            this.taskStatusController.setTitle(String.format("%d " + i18n.getTranslation("_elements"), model.getRowCount()));
        }
    }

    public boolean isVisible(Object component) {
        return !this.filterOnlyMode && this.isGroupByEnabled() || !(component instanceof GroupByAction);
    }

    public boolean isEnabled(Object component) {
        DataStoreProviderFactory dataFactory;
        int allowGroupBy;
        return !(component instanceof GroupByAction) || (allowGroupBy = ((FeatureStoreProviderFactory)(dataFactory = this.store.getProviderFactory())).allowGroupBy()) == 1;
    }

    public void setFilterOnlyMode(boolean filterOnlyMode) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot change filter-only-mode after invoking asJComponent.");
        }
        this.filterOnlyMode = filterOnlyMode;
        this.groupByEnabled = false;
        this.postProcessEnabled = false;
        this.showActions = false;
    }

    public boolean isFilterOnlyMode() {
        return this.filterOnlyMode;
    }

    public Feature getLastSelectedFeature() {
        return this.lastSelectedFeature;
    }

    public Object getProperty(String name) {
        return this.propertiesHelper.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.propertiesHelper.setProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        return this.propertiesHelper.getProperties();
    }

    public void setAutomaticallySearch(boolean automaticallySearch) {
        this.automaticallySearch = automaticallySearch;
    }

    public boolean isAutomaticallySearch() {
        return this.automaticallySearch;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    private String getLastErrorMessage(Throwable ex) {
        StringBuilder builder = new StringBuilder();
        while (ex != null) {
            if (ex instanceof SQLException) {
                builder.append(ex.getLocalizedMessage());
                builder.append("\n");
            }
            ex = ex.getCause();
        }
        return builder.toString();
    }

    private void doCopyQueryToCLipboard(FeatureQuery query) {
        ToolsSwingLocator.getToolsSwingManager().putInClipboard(query.toJson().toString());
    }

    private void doShowProperties() {
        try {
            LOGGER.info("Do show properties");
            ToolsSwingManager toolSwingManager = ToolsSwingLocator.getToolsSwingManager();
            final SearchParameters params = this.fetch(null);
            StringBuilder msg = new StringBuilder();
            params.isValid(this.getFeatureType(), msg);
            I18nManager i18n = ToolsLocator.getI18nManager();
            toolSwingManager.showZoomDialog((Component)this, i18n.getTranslation("_Properties"), params.toString() + "\n" + msg.toString(), false, WindowManager.MODE.DIALOG, ListBuilder.create((Object[])new Object[]{new AbstractAction(i18n.getTranslation("_Copy_query")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultSearchPanel.this.doCopyQueryToCLipboard(params.getQuery());
                }
            }}));
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show dialog", (Throwable)ex);
        }
    }

    public void setPostProcessEnabled(boolean enabled) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot change postProcessEnabled after invoking asJComponent.");
        }
        this.postProcessEnabled = enabled;
    }

    public void setGroupByEnabled(boolean enabled) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot change groupByEnabled after invoking asJComponent.");
        }
        this.groupByEnabled = enabled;
    }

    public boolean isPostProcessEnabled() {
        return this.postProcessEnabled;
    }

    public boolean isGroupByEnabled() {
        return this.groupByEnabled;
    }

    private boolean useSelection() {
        boolean x = this.chkUseSelection.isSelected();
        return x;
    }

    private FeatureQuery addSelection(FeatureStore store, FeatureQuery query) {
        query = query.getCopy();
        if (store.isFeatureSelectionEmpty()) {
            return query;
        }
        if (store.getMode() != 0) {
            throw new RuntimeException("Use selection not allowed in editing mode");
        }
        FeatureAttributeDescriptor[] pks = store.getDefaultFeatureTypeQuietly().getPrimaryKey();
        if (pks == null) {
            throw new RuntimeException("Use selection not allowed without primarykey");
        }
        if (pks.length != 1) {
            throw new RuntimeException("Use selection not allowed with multifield primarykey");
        }
        ExpressionEvaluatorManager expManager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
        ExpressionBuilder expbuilder = expManager.createExpressionBuilder();
        Expression filter = query.getExpressionFilter();
        ExpressionBuilder.Value values = expManager.convertToValue((Object)store.getFeatureSelectionQuietly().referenceIterator());
        if (ExpressionBuilder.isFunction((ExpressionBuilder.Value)values, (String)"TUPLE")) {
            ((ExpressionBuilder.Function)values).name("");
        }
        String selectionfilter = expbuilder.binaryOperator("IN", (ExpressionBuilder.Value)expbuilder.variable(pks[0].getName()), values).toString();
        StringBuilder builder = new StringBuilder();
        builder.append(selectionfilter);
        if (filter == null) {
            query.addFilter(builder.toString());
        } else {
            builder.append(" AND (");
            builder.append(filter.getPhrase());
            builder.append(")");
            filter.setPhrase(builder.toString());
        }
        query.retrievesAllAttributes();
        return query;
    }

    public void addResultPanel(String name, String title, org.gvsig.tools.swing.api.Component component) {
        int index = -1;
        if (this.additionalResultsPanels.containsKey(name)) {
            index = this.additionalResultsPanels.get(name).getIndex();
        }
        AdditionalResultsPanel panel = new AdditionalResultsPanel(name, title, component, index);
        this.additionalResultsPanels.put(name, panel);
        if (this.initialized) {
            if (index < 0) {
                panel.setIndex(this.tabResults.getTabCount());
                this.tabResults.addTab(panel.getTitle(), panel.asJComponent());
            } else {
                this.tabResults.setComponentAt(index, panel.asJComponent());
                this.tabResults.setTitleAt(index, panel.getTitle());
            }
        }
    }

    public void removeResultPanel(String name) {
        int index = -1;
        if (this.additionalResultsPanels.containsKey(name)) {
            index = this.additionalResultsPanels.get(name).getIndex();
        }
        this.additionalResultsPanels.remove(name);
        if (this.initialized) {
            this.tabResults.removeTabAt(index);
        }
    }

    public DALActionFactory.DALActionContext getSearchActionContext() {
        return new SearchActionContext(this);
    }

    private void fireSearchEvent() {
        ActionEvent e = new ActionEvent(this, 1, "search");
        for (AdditionalResultsPanel additionalResultsPanel : this.additionalResultsPanels.values()) {
            additionalResultsPanel.fireActionEvent(e);
        }
    }

    public static class SearchActionContext
    extends AbstractDALActionFactory.AbstractDALActionContext {
        private final DefaultSearchPanel panel;

        public SearchActionContext(DefaultSearchPanel panel) {
            super("FeatureStoreSearchPanel");
            this.panel = panel;
        }

        public DataStore getStore() {
            if (this.panel.currentPostProcess != null && this.panel.tabResults.getSelectedIndex() == 1) {
                return this.panel.postProcessStore;
            }
            return this.panel.getStore();
        }

        public JComponent getActionButton(String actionName) {
            return this.panel.getActionButton(actionName);
        }

        public int getSelectedsCount() {
            return this.panel.getSelectedFeatureCount();
        }

        public Expression getFilterForSelecteds() {
            return this.panel.getFilterForSelectedFeatures();
        }

        public FeatureSelection getSelecteds() {
            return this.panel.getSelectedFeatures();
        }

        public FeatureQuery getQuery() {
            if (this.panel.currentPostProcess != null && this.panel.tabResults.getSelectedIndex() == 1) {
                return this.panel.postProcessQuery;
            }
            DefaultSearchParameters searchParams = this.panel.parameters;
            FeatureQuery query = searchParams.getQueryToApply();
            if (this.panel.useSelection()) {
                query = this.panel.addSelection(this.panel.store, query);
            }
            return query;
        }
    }

    private class ActionButtons {
        private final DALActionFactory factory;
        private final Action action;
        private final JButton button;

        public ActionButtons(DALActionFactory factory, Action action, JButton button) {
            this.factory = factory;
            this.action = action;
            this.button = button;
        }
    }

    private class TablePopupMenu
    extends JPopupMenu {
        public final JTable table;

        public TablePopupMenu(JTable inputTable) {
            this.table = inputTable;
            I18nManager i18n = ToolsLocator.getI18nManager();
            JMenuItem copyRowsActionMenu = new JMenuItem(i18n.getTranslation("_Copy_rows"));
            copyRowsActionMenu.addActionListener(e -> DefaultSearchPanel.this.doCopyRows(this.table));
            this.add(copyRowsActionMenu);
            JMenuItem exportTSVActionMenu = new JMenuItem(i18n.getTranslation(DefaultSearchPanel.EXPORT_TO_TSV_TITLE));
            exportTSVActionMenu.addActionListener(e -> DefaultSearchPanel.this.doExportTSV(this.table));
            this.add(exportTSVActionMenu);
        }
    }

    public static class PropertiesAction
    extends AbstractAction {
        public PropertiesAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Properties"));
            this.putValue("ActionCommandKey", "Properties");
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                return i18n.getTranslation("_Properties");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DefaultSearchPanel panel = (DefaultSearchPanel)ae.getSource();
            panel.doShowProperties();
        }
    }

    public static class OrderByAction
    extends AbstractAction {
        public OrderByAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Order_by"));
            this.putValue("ActionCommandKey", "SelectOrderBy");
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                return i18n.getTranslation("_Order_by");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DefaultSearchPanel panel = (DefaultSearchPanel)ae.getSource();
            panel.doOrderBy();
        }
    }

    public static class GroupByAction
    extends AbstractAction {
        public GroupByAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Group_by"));
            this.putValue("ActionCommandKey", "GroupBy");
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                return i18n.getTranslation("_Group_by");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DefaultSearchPanel panel = (DefaultSearchPanel)ae.getSource();
            panel.doGroupBy();
        }
    }

    public static class CalculatedColumnsAction
    extends AbstractAction {
        public CalculatedColumnsAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Calculated_columns"));
            this.putValue("ActionCommandKey", "CalculatedColumns");
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                return i18n.getTranslation("_Calculated_columns");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DefaultSearchPanel panel = (DefaultSearchPanel)ae.getSource();
            panel.doCalculatedColumns();
        }
    }

    public static class SelectColumnsAction
    extends AbstractAction {
        public SelectColumnsAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Select_columns_to_display"));
            this.putValue("ActionCommandKey", "SelectColumns");
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                return i18n.getTranslation("_Select_columns_to_display");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DefaultSearchPanel panel = (DefaultSearchPanel)ae.getSource();
            panel.doSelectResultColumnNames();
        }
    }

    public static class UseLabelsBothAction
    extends AbstractAction {
        public UseLabelsBothAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Use_labels_and_names"));
            this.putValue("ActionCommandKey", "UseLabelsBoth");
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                return i18n.getTranslation("_Use_labels_and_names");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DALSwingLocator.getDataSwingManager().setUseLabels(Integer.valueOf(2));
        }
    }

    public static class UseLabelsNoAction
    extends AbstractAction {
        public UseLabelsNoAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Use_names"));
            this.putValue("ActionCommandKey", "UseLabelsNo");
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                return i18n.getTranslation("_Use_names");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DALSwingLocator.getDataSwingManager().setUseLabels(Integer.valueOf(1));
        }
    }

    public static class UseLabelsYesAction
    extends AbstractAction {
        public UseLabelsYesAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Use_labels"));
            this.putValue("ActionCommandKey", "UseLabelsYes");
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                return i18n.getTranslation("_Use_labels");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DALSwingLocator.getDataSwingManager().setUseLabels(Integer.valueOf(0));
        }
    }

    private static class AdditionalResultsPanel
    implements org.gvsig.tools.swing.api.Component {
        private final String name;
        private final String title;
        private int index;
        private final org.gvsig.tools.swing.api.Component component;

        public AdditionalResultsPanel(String name, String title, org.gvsig.tools.swing.api.Component component, int index) {
            this.name = name;
            this.title = title;
            this.component = component;
            this.index = index;
        }

        public AdditionalResultsPanel(String name, String title, org.gvsig.tools.swing.api.Component component) {
            this(name, title, component, -1);
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public int getIndex() {
            return this.index;
        }

        public JComponent asJComponent() {
            return this.component.asJComponent();
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void fireActionEvent(ActionEvent e) {
            if (this.component instanceof ActionListenerSupport) {
                ((ActionListenerSupport)this.component).fireActionEvent(e);
            }
        }

        public void doDispose() {
            DisposeUtils.dispose((Object)this.component);
        }
    }
}

