/*
 * Decompiled with CFR 0.152.
 */
package org.medfoster.sqljep.function;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.medfoster.sqljep.ASTFunNode;
import org.medfoster.sqljep.JepRuntime;
import org.medfoster.sqljep.ParseException;
import org.medfoster.sqljep.function.PostfixCommand;

public final class Add
extends PostfixCommand {
    static final String DATE_ADDITION = "Wrong operation";
    static final BigDecimal DAY_MILIS = new BigDecimal(86400000);

    public final int getNumberOfParameters() {
        return 2;
    }

    public void evaluate(ASTFunNode aSTFunNode, JepRuntime jepRuntime) throws ParseException {
        aSTFunNode.childrenAccept(jepRuntime.ev, null);
        Comparable comparable = jepRuntime.stack.pop();
        Comparable comparable2 = jepRuntime.stack.pop();
        jepRuntime.stack.push(Add.add(comparable2, comparable));
    }

    public static Comparable add(Comparable comparable, Comparable comparable2) throws ParseException {
        if (comparable == null || comparable2 == null) {
            return null;
        }
        if (comparable instanceof String) {
            comparable = Add.parse((String)((Object)comparable));
        }
        if (comparable2 instanceof String) {
            comparable2 = Add.parse((String)((Object)comparable2));
        }
        if (comparable instanceof Number && comparable2 instanceof Number) {
            long l;
            long l2;
            Number number = (Number)((Object)comparable);
            Number number2 = (Number)((Object)comparable2);
            if (number instanceof BigDecimal || number2 instanceof BigDecimal) {
                BigDecimal bigDecimal = Add.getBigDecimal(number);
                BigDecimal bigDecimal2 = Add.getBigDecimal(number2);
                return bigDecimal.add(bigDecimal2);
            }
            if (number instanceof Double || number2 instanceof Double || number instanceof Float || number2 instanceof Float) {
                return Double.valueOf(number.doubleValue() + number2.doubleValue());
            }
            long l3 = number.longValue();
            if (l3 <= (l2 = l3 + (l = number2.longValue())) && l <= l2) {
                return Long.valueOf(l2);
            }
            BigDecimal bigDecimal = new BigDecimal(l3);
            BigDecimal bigDecimal3 = new BigDecimal(l);
            return bigDecimal.add(bigDecimal3);
        }
        if (comparable instanceof Timestamp || comparable2 instanceof Timestamp) {
            if (comparable instanceof Timestamp && comparable2 instanceof Timestamp) {
                throw new ParseException(DATE_ADDITION);
            }
            if (comparable instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)comparable;
                if (!(comparable2 instanceof Number)) {
                    throw new ParseException(DATE_ADDITION);
                }
                Number number = (Number)((Object)comparable2);
                return new Timestamp(timestamp.getTime() + Add.toDay(number));
            }
            if (comparable2 instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)comparable2;
                if (!(comparable instanceof Number)) {
                    throw new ParseException(DATE_ADDITION);
                }
                Number number = (Number)((Object)comparable);
                return new Timestamp(timestamp.getTime() + Add.toDay(number));
            }
            throw new ParseException("Internal error");
        }
        throw new ParseException("Wrong type  (" + comparable.getClass() + "+" + comparable2.getClass() + ")");
    }

    static long toDay(Number number) {
        if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)number;
            BigDecimal bigDecimal2 = bigDecimal.multiply(DAY_MILIS);
            bigDecimal2 = bigDecimal2.setScale(0, 4);
            return bigDecimal2.longValue();
        }
        return number.longValue() * 86400000L;
    }
}

