/*
 * Decompiled with CFR 0.152.
 */
package org.medfoster.sqljep.function;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.medfoster.sqljep.ASTFunNode;
import org.medfoster.sqljep.JepRuntime;
import org.medfoster.sqljep.ParseException;
import org.medfoster.sqljep.function.PostfixCommand;

public class Trunc
extends PostfixCommand {
    private static final String PARAM_EXCEPTION = "Scale in trunc shoud be integer";
    static final String TIME_EXCEPTION = "Can't use TIME here";
    static final String DATE_EXCEPTION = "Can't use DATE here";
    static final String FORMAT_EXCEPTION = "Unknown format";

    public final int getNumberOfParameters() {
        return -1;
    }

    public void evaluate(ASTFunNode aSTFunNode, JepRuntime jepRuntime) throws ParseException {
        aSTFunNode.childrenAccept(jepRuntime.ev, null);
        int n = aSTFunNode.jjtGetNumChildren();
        if (n == 1) {
            Comparable comparable = jepRuntime.stack.pop();
            jepRuntime.stack.push(Trunc.trunc(comparable, jepRuntime.calendar));
        } else if (n == 2) {
            Comparable comparable = jepRuntime.stack.pop();
            Comparable comparable2 = jepRuntime.stack.pop();
            jepRuntime.stack.push(Trunc.trunc(comparable2, comparable, jepRuntime.calendar));
        } else {
            this.removeParams(jepRuntime.stack, n);
            throw new ParseException("Wrong number of parameters for trunc");
        }
    }

    public static Comparable trunc(Comparable comparable, Calendar calendar) throws ParseException {
        if (comparable == null) {
            return null;
        }
        if (comparable instanceof String) {
            comparable = Trunc.parse((String)((Object)comparable));
        }
        if (comparable instanceof BigDecimal) {
            BigDecimal bigDecimal;
            try {
                bigDecimal = ((BigDecimal)comparable).setScale(0, 1);
                try {
                    return Long.valueOf(bigDecimal.longValueExact());
                }
                catch (Exception exception) {
                }
            }
            catch (Exception exception) {
                throw new ParseException(exception.getMessage());
            }
            return bigDecimal;
        }
        if (comparable instanceof Double || comparable instanceof Float) {
            return Long.valueOf(((Number)((Object)comparable)).longValue());
        }
        if (comparable instanceof Number) {
            return comparable;
        }
        if (comparable instanceof Timestamp || comparable instanceof java.sql.Date) {
            Timestamp timestamp = (Timestamp)comparable;
            calendar.setTimeInMillis(timestamp.getTime());
            int n = calendar.get(1);
            int n2 = calendar.get(2);
            int n3 = calendar.get(5);
            calendar.clear();
            calendar.set(n, n2, n3);
            return new Timestamp(calendar.getTimeInMillis());
        }
        throw new ParseException("Wrong type trunc(" + comparable.getClass() + ")");
    }

    public static Comparable trunc(Comparable comparable, Comparable comparable2, Calendar calendar) throws ParseException {
        if (comparable == null || comparable2 == null) {
            return null;
        }
        if (comparable instanceof String) {
            comparable = Trunc.parse((String)((Object)comparable));
        }
        if (comparable instanceof Number) {
            int n;
            try {
                n = Trunc.getInteger(comparable2);
            }
            catch (ParseException parseException) {
                throw new ParseException(PARAM_EXCEPTION);
            }
            if (n < 0) {
                return ZERO;
            }
            if (comparable instanceof BigDecimal) {
                return ((BigDecimal)comparable).setScale(n, 1);
            }
            if (comparable instanceof Double || comparable instanceof Float) {
                double d = ((Number)((Object)comparable)).doubleValue();
                long l = 1L;
                for (int i = 0; i < n; ++i) {
                    l *= 10L;
                }
                long l2 = (long)d * l;
                return Double.valueOf((double)l2 / (double)l);
            }
            return comparable;
        }
        if (comparable instanceof Date && comparable2 instanceof String) {
            String string = (String)((Object)comparable2);
            Date date = (Date)comparable;
            calendar.setTimeInMillis(date.getTime());
            if (string.equalsIgnoreCase("CC") || string.equalsIgnoreCase("SCC")) {
                if (date instanceof Time) {
                    throw new ParseException(TIME_EXCEPTION);
                }
                int n = calendar.get(1);
                calendar.clear();
                calendar.set(n / 100 * 100, 0, 1);
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (string.equalsIgnoreCase("SYYYY") || string.equalsIgnoreCase("YYYY") || string.equalsIgnoreCase("YYY") || string.equalsIgnoreCase("Y") || string.equalsIgnoreCase("YEAR") || string.equalsIgnoreCase("SYEAR")) {
                if (date instanceof Time) {
                    throw new ParseException(TIME_EXCEPTION);
                }
                int n = calendar.get(1);
                calendar.clear();
                calendar.set(n, 0, 1);
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (string.equalsIgnoreCase("IYYY") || string.equalsIgnoreCase("IY") || string.equalsIgnoreCase("I")) {
                throw new ParseException("Not implimented");
            }
            if (string.equalsIgnoreCase("Q")) {
                if (date instanceof Time) {
                    throw new ParseException(TIME_EXCEPTION);
                }
                int n = calendar.get(1);
                int n2 = calendar.get(2);
                calendar.clear();
                calendar.set(n, n2 / 3 * 3, 1);
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (string.equalsIgnoreCase("MONTH") || string.equalsIgnoreCase("MON") || string.equalsIgnoreCase("MM") || string.equalsIgnoreCase("RM")) {
                if (date instanceof Time) {
                    throw new ParseException(TIME_EXCEPTION);
                }
                int n = calendar.get(1);
                int n3 = calendar.get(2);
                calendar.clear();
                calendar.set(n, n3, 1);
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (string.equalsIgnoreCase("WW")) {
                if (date instanceof Time) {
                    throw new ParseException(TIME_EXCEPTION);
                }
                int n = calendar.get(1);
                int n4 = calendar.get(2);
                int n5 = calendar.get(5);
                int n6 = calendar.get(7);
                calendar.clear();
                calendar.set(n, 0, 1);
                int n7 = calendar.get(7);
                calendar.set(n, n4, n5 - (n6 < n7 ? 7 - (n7 - n6) : n6 - n7));
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (string.equalsIgnoreCase("W")) {
                if (date instanceof Time) {
                    throw new ParseException(TIME_EXCEPTION);
                }
                int n = calendar.get(1);
                int n8 = calendar.get(2);
                int n9 = calendar.get(5);
                int n10 = calendar.get(7);
                calendar.clear();
                calendar.set(n, n8, 1);
                int n11 = calendar.get(7);
                calendar.set(n, n8, n9 - (n10 < n11 ? 7 - (n11 - n10) : n10 - n11));
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (string.equalsIgnoreCase("IW")) {
                throw new ParseException("Not implimented");
            }
            if (string.equalsIgnoreCase("DAY") || string.equalsIgnoreCase("DY") || string.equalsIgnoreCase("D")) {
                if (date instanceof Time) {
                    throw new ParseException(TIME_EXCEPTION);
                }
                int n = calendar.get(1);
                int n12 = calendar.get(2);
                int n13 = calendar.get(5);
                int n14 = calendar.get(7);
                calendar.clear();
                calendar.set(n, n12, n13 - (n14 - calendar.getFirstDayOfWeek()));
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (string.equalsIgnoreCase("HH") || string.equalsIgnoreCase("HH12") || string.equalsIgnoreCase("HH24")) {
                if (date instanceof java.sql.Date) {
                    throw new ParseException(DATE_EXCEPTION);
                }
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (string.equalsIgnoreCase("MI")) {
                if (date instanceof java.sql.Date) {
                    throw new ParseException(DATE_EXCEPTION);
                }
                calendar.set(13, 0);
                calendar.set(14, 0);
                return new Timestamp(calendar.getTimeInMillis());
            }
            throw new ParseException(FORMAT_EXCEPTION);
        }
        throw new ParseException("Wrong type trunc(" + comparable.getClass() + "," + comparable2.getClass() + ")");
    }
}

