/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tasseledcap.algorithm;

import java.awt.geom.Rectangle2D;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.CloneException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.tasseledcap.algorithm.TasseledCapException;

public class TasseledCapProcess
extends DataProcess {
    public static int LANDSAT_MS = 0;
    public static int LANDSAT_TM = 1;
    public static int LANDSAT_ETM = 2;
    public static String RASTER_STORE = "RASTER_STORE";
    public static String PATH = "PATH";
    public static String FILENAME = "FILENAME";
    public static String LANDSAT_TYPE = "LANDSAT_TYPE";
    public static final String BUFFERS = "BUFFERS";
    public static final String GRAPHIC_DATA = "GRAPHIC_DATA";
    public static final String BANDS = "BANDS";
    private RasterDataStore store = null;
    private String filename = null;
    private List<ROI> rois = null;
    private Extent extentResult = null;
    private boolean[] bands = null;
    private NoData nodata = null;
    private double[][] matrixParams = null;
    private int type = LANDSAT_MS;
    double[][] LandSatMS = new double[][]{{0.433, 0.632, 0.586, 0.264}, {-0.29, -0.562, 0.6, 0.491}, {-0.829, 0.522, -0.039, 0.194}, {0.223, 0.012, -0.543, 0.81}};
    double[][] LandSatTM = new double[][]{{0.33183, 0.33121, 0.55177, 0.42514, 0.48087, 0.25252}, {-0.24717, -0.16263, -0.40639, 0.85468, 0.05493, -0.11749}, {0.13929, 0.2249, 0.40359, 0.25178, -0.70133, -0.45732}};
    double[][] LandSatETM = new double[][]{{0.3561, 0.3972, 0.3904, 0.6966, 0.2286, 0.1596}, {-0.3344, -0.3544, -0.4556, 0.6966, -0.0242, -0.263}, {0.2626, 0.2141, 0.0926, 0.0656, -0.7629, -0.5388}, {0.0805, -0.0498, 0.195, -0.1327, 0.5752, -0.7775}, {-0.7252, -0.0202, 0.6683, 0.0631, -0.1494, -0.0274}, {0.4, -0.8172, 0.3832, 0.0602, -0.1095, -0.0985}};

    public static void registerParameters() {
        TasseledCapProcess.registerInputParameter((String)RASTER_STORE, RasterDataStore.class, (String)"TasseledCapProcess");
        TasseledCapProcess.registerInputParameter((String)PATH, String.class, (String)"TasseledCapProcess");
        TasseledCapProcess.registerInputParameter((String)BANDS, Boolean[].class, (String)"TasseledCapProcess");
        TasseledCapProcess.registerInputParameter((String)LANDSAT_TYPE, Integer.class, (String)"TasseledCapProcess");
        TasseledCapProcess.registerOutputParameter((String)FILENAME, String.class, (String)"TasseledCapProcess");
        TasseledCapProcess.registerOutputParameter((String)GRAPHIC_DATA, Double[].class, (String)"TasseledCapProcess");
    }

    public void init() {
        this.store = this.getParam(RASTER_STORE) != null ? (RasterDataStore)this.getParam(RASTER_STORE) : null;
        this.filename = this.getStringParam(PATH);
        this.bands = (boolean[])this.getParam(BANDS);
        this.type = this.getIntParam(LANDSAT_TYPE);
    }

    private boolean loadCoefMatrix(int type) {
        switch (type) {
            case 0: {
                this.matrixParams = this.LandSatMS;
                if (this.getNumberOfOutputBands(this.bands) == 4) break;
                return false;
            }
            case 1: {
                this.matrixParams = this.LandSatTM;
                if (this.getNumberOfOutputBands(this.bands) == 6) break;
                return false;
            }
            case 2: {
                this.matrixParams = this.LandSatETM;
                if (this.getNumberOfOutputBands(this.bands) == 6) break;
                return false;
            }
        }
        return true;
    }

    public void process() throws ProcessInterruptedException, ProcessException {
        this.insertLineLog(Messages.getText((String)"processing_tc"));
        if (this.store == null) {
            throw new TasseledCapException(Messages.getText((String)"need_a_input"));
        }
        if (!this.loadCoefMatrix(this.type)) {
            throw new TasseledCapException(Messages.getText((String)"wrong_number_of_bands"));
        }
        if (this.getROIEPSG() != null) {
            try {
                this.rois = this.store.getRois(this.getROIEPSG());
            }
            catch (ROIException e2) {
                this.logger.error(Messages.getText((String)"error_getting_rois"), (Throwable)e2);
            }
        }
        try {
            this.store = this.store.cloneDataStore();
        }
        catch (CloneException e) {
            new TasseledCapException("Error cloning the input DataStore", e);
        }
        this.extentResult = this.getExtentResult(this.getOutputWindow(), this.rois, this.store);
        Rectangle2D sourcePxBBox = this.getSourcePxBox(this.extentResult, this.store);
        double cellSize = this.store.getCellSize();
        this.nodata = RasterLocator.getManager().getDataStructFactory().createDefaultNoData(1, 5);
        double nodataValue = this.nodata.getValue().doubleValue();
        Buffer outputBuffer = this.createOutputBuffer((int)sourcePxBBox.getWidth(), (int)sourcePxBBox.getHeight(), this.matrixParams.length, 4);
        Buffer sourceBuffer = this.createSourceBuffer(this.store, sourcePxBBox, this.bands);
        this.insertLineLog(Messages.getText((String)"writting_in_buffer"));
        float resultValue = 0.0f;
        for (int i = 0; i < sourceBuffer.getHeight(); ++i) {
            for (int j = 0; j < sourceBuffer.getWidth(); ++j) {
                if (this.isInsideOfROI(j, i, this.rois, this.extentResult)) {
                    for (int coef = 0; coef < this.matrixParams.length; ++coef) {
                        for (int band = 0; band < this.matrixParams[0].length; ++band) {
                            resultValue += this.getValue(sourceBuffer, i, j, band, coef);
                        }
                        outputBuffer.setElem(i, j, coef, resultValue);
                        resultValue = 0.0f;
                    }
                    continue;
                }
                for (int iBand = 0; iBand < outputBuffer.getBandCount(); ++iBand) {
                    outputBuffer.setElem(i, j, iBand, (float)nodataValue);
                }
            }
            this.updatePercent((int)((double)(i * 100) / sourcePxBBox.getHeight()), 100);
        }
        super.exportRaster(this.filename, outputBuffer, cellSize, this.extentResult.getULX(), this.extentResult.getULY(), this.nodata, this.store.getProjection());
        this.addOutputValue(FILENAME, this.filename);
        this.addOutputValue(GRAPHIC_DATA, this.filename);
    }

    private int getNumberOfOutputBands(boolean[] b) {
        int bandCount = 0;
        for (int i = 0; i < b.length; ++i) {
            if (!b[i]) continue;
            ++bandCount;
        }
        return bandCount;
    }

    private float getValue(Buffer sourceBuffer, int i, int j, int band, int coef) {
        if (sourceBuffer.getDataType() == 0) {
            return (float)((double)(sourceBuffer.getElemByte(i, j, band) & 0xFF) * this.matrixParams[coef][band]);
        }
        if (sourceBuffer.getDataType() == 2) {
            return (float)((double)sourceBuffer.getElemShort(i, j, band) * this.matrixParams[coef][band]);
        }
        if (sourceBuffer.getDataType() == 3) {
            return (float)((double)sourceBuffer.getElemInt(i, j, band) * this.matrixParams[coef][band]);
        }
        if (sourceBuffer.getDataType() == 4) {
            return (float)((double)sourceBuffer.getElemFloat(i, j, band) * this.matrixParams[coef][band]);
        }
        if (sourceBuffer.getDataType() == 5) {
            return (float)(sourceBuffer.getElemDouble(i, j, band) * this.matrixParams[coef][band]);
        }
        return this.nodata.getValue().floatValue();
    }

    public String getTitle() {
        return Messages.getText((String)"tasseled_cap");
    }
}

