/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dbf;

import java.io.File;
import java.io.IOException;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.CreateException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.FileNotFoundException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.RemoveException;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.resource.ResourceAction;
import org.gvsig.fmap.dal.resource.exception.ResourceExecuteException;
import org.gvsig.fmap.dal.resource.file.FileResource;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.AbsolutePathRequiredException;
import org.gvsig.fmap.dal.serverexplorer.filesystem.impl.AbstractFilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderServices;
import org.gvsig.fmap.dal.store.dbf.DBFFeatureWriter;
import org.gvsig.fmap.dal.store.dbf.DBFNewStoreParameters;
import org.gvsig.fmap.dal.store.dbf.DBFStoreParameters;

public class DBFFilesystemServerProvider
extends AbstractFilesystemServerExplorerProvider
implements FilesystemServerExplorerProvider,
ResourceConsumer {
    protected FilesystemServerExplorerProviderServices serverExplorer;

    public String getDataStoreProviderName() {
        return "DBF";
    }

    public int getMode() {
        return 1;
    }

    public boolean accept(File pathname) {
        return pathname.getName().toLowerCase().endsWith(".dbf");
    }

    public String getDescription() {
        return "DBF file";
    }

    public DataStoreParameters getParameters(File file) throws DataException {
        DataManager manager = DALLocator.getDataManager();
        DBFStoreParameters params = (DBFStoreParameters)manager.createStoreParameters(this.getDataStoreProviderName());
        params.setDBFFile(file.getPath());
        return params;
    }

    public boolean canCreate() {
        return true;
    }

    public boolean canCreate(NewDataStoreParameters parameters) {
        DBFNewStoreParameters params = (DBFNewStoreParameters)parameters;
        if (params.getDBFFile().getParentFile().canWrite()) {
            return false;
        }
        if (params.getDBFFile().exists() && !params.getDBFFile().canWrite()) {
            return false;
        }
        return params.getDefaultFeatureType() != null;
    }

    public void create(NewDataStoreParameters parameters, boolean overwrite) throws CreateException {
        FileResource resource;
        final DBFNewStoreParameters params = (DBFNewStoreParameters)parameters;
        File file = params.getDBFFile();
        if (!file.isAbsolute()) {
            throw new AbsolutePathRequiredException(file.getPath());
        }
        if (file.exists() && !overwrite) {
            throw new CreateException(this.getDataStoreProviderName(), (Throwable)new IOException("file already exist"));
        }
        try {
            resource = (FileResource)this.serverExplorer.getServerExplorerProviderServices().createResource("file", new Object[]{file.getAbsolutePath()});
        }
        catch (InitializeException e1) {
            throw new CreateException(params.getDBFFileName(), (Throwable)e1);
        }
        resource.addConsumer((ResourceConsumer)this);
        try {
            resource.execute(new ResourceAction(){

                public Object run() throws Exception {
                    DBFFeatureWriter writer = new DBFFeatureWriter(DBFFilesystemServerProvider.this.getDataStoreProviderName());
                    writer.begin(params, (FeatureType)params.getDefaultFeatureType(), 0L);
                    writer.end();
                    writer.dispose();
                    resource.notifyChanges();
                    return null;
                }
            });
        }
        catch (ResourceExecuteException e) {
            throw new CreateException(this.getDataStoreProviderName(), (Throwable)e);
        }
        finally {
            resource.removeConsumer((ResourceConsumer)this);
        }
    }

    protected NewDataStoreParameters createInstanceNewDataStoreParameters() {
        return new DBFNewStoreParameters();
    }

    public NewDataStoreParameters getCreateParameters() {
        NewFeatureStoreParameters params = (NewFeatureStoreParameters)this.createInstanceNewDataStoreParameters();
        EditableFeatureType featureType = this.serverExplorer.getServerExplorerProviderServices().createNewFeatureType();
        featureType.setHasOID(true);
        params.setDefaultFeatureType((FeatureType)featureType);
        return params;
    }

    public void initialize(FilesystemServerExplorerProviderServices serverExplorer) {
        this.serverExplorer = serverExplorer;
    }

    public void remove(DataStoreParameters parameters) throws RemoveException {
        DBFStoreParameters params = (DBFStoreParameters)parameters;
        File file = params.getDBFFile();
        if (!file.exists()) {
            throw new RemoveException(this.getDataStoreProviderName(), (Throwable)new FileNotFoundException(params.getDBFFile()));
        }
        if (!file.delete()) {
            throw new RemoveException(this.getDataStoreProviderName(), (Throwable)new IOException());
        }
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return !((Object)((Object)this)).equals(resource);
    }

    public void resourceChanged(ResourceProvider resource) {
    }
}

