/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dbf;

import java.nio.charset.Charset;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.SortedMap;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALFileLibrary;
import org.gvsig.fmap.dal.DALFileLocator;
import org.gvsig.fmap.dal.DALLibrary;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.store.dbf.DBFFilesystemServerProvider;
import org.gvsig.fmap.dal.store.dbf.DBFNewStoreParameters;
import org.gvsig.fmap.dal.store.dbf.DBFStoreParameters;
import org.gvsig.fmap.dal.store.dbf.DBFStoreProvider;
import org.gvsig.fmap.dal.store.dbf.DBFStoreProviderFactory;
import org.gvsig.fmap.dal.store.dbf.dbfcharset.JDynFormFieldDBFCharsetFactory;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.metadata.MetadataManager;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;

public class DBFLibrary
extends AbstractLibrary {
    public void doRegistration() {
        this.registerAsServiceOf(DALLibrary.class);
        this.require(DALFileLibrary.class);
    }

    protected void doInitialize() throws LibraryException {
    }

    protected void doPostInitialize() throws LibraryException {
        ArrayList<Throwable> exs = new ArrayList<Throwable>();
        FileHelper.registerParametersDefinition((String)"DBFStoreParameters", DBFStoreParameters.class, (String)"DBFParameters.xml");
        FileHelper.registerParametersDefinition((String)"DBFNewStoreParameters", DBFNewStoreParameters.class, (String)"DBFParameters.xml");
        try {
            FileHelper.registerMetadataDefinition((String)"DBF", DBFStoreProvider.class, (String)"DBFMetadata.xml");
        }
        catch (MetadataException e) {
            exs.add(e);
        }
        DBFLibrary.updateEncodingDefinition();
        DBFLibrary.updateLocaleDefinition();
        JDynFormFieldDBFCharsetFactory.selfRegister();
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        try {
            if (!dataman.getStoreProviders().contains("DBF")) {
                dataman.registerStoreProviderFactory((DataStoreProviderFactory)new DBFStoreProviderFactory("DBF", "DBF file"));
            }
        }
        catch (RuntimeException e) {
            exs.add(e);
        }
        try {
            DALFileLocator.getFilesystemServerExplorerManager().registerProvider("DBF", "DBF file", DBFFilesystemServerProvider.class);
        }
        catch (RuntimeException e) {
            exs.add(e);
        }
        DataManager dataManager = DALLocator.getDataManager();
        dataManager.setProperty("dbf_AutodetectEncoding", (Object)false);
        dataManager.setProperty("dbf_AutodetectEncodingMaxRecords", (Object)1000);
        if (!exs.isEmpty()) {
            throw new LibraryException(((Object)((Object)this)).getClass(), exs);
        }
    }

    private static void updateEncodingDefinition() {
        DynStruct parametersDefinition = ToolsLocator.getPersistenceManager().getDefinition("DBFStoreParameters");
        DynStruct newParametersDefinition = ToolsLocator.getPersistenceManager().getDefinition("DBFNewStoreParameters");
        DynObjectValueItem[] values = parametersDefinition.getDynField("Encoding").getAvailableValues();
        LinkedHashSet<DynObjectValueItem> charsetSet = new LinkedHashSet<DynObjectValueItem>(160);
        charsetSet.addAll(Arrays.asList(values));
        MetadataManager metadataManager = MetadataLocator.getMetadataManager();
        DynStruct dynStruct = metadataManager.getDefinition("DBF");
        DynObjectValueItem[] metadataValues = dynStruct.getDynField("Encoding").getAvailableValues();
        LinkedHashSet<DynObjectValueItem> metadataCharsetSets = new LinkedHashSet<DynObjectValueItem>(160);
        metadataCharsetSets.addAll(Arrays.asList(metadataValues));
        SortedMap<String, Charset> charsets = Charset.availableCharsets();
        Iterator iter = charsets.keySet().iterator();
        while (iter.hasNext()) {
            String value;
            String label = value = (String)iter.next();
            DynObjectValueItem item = new DynObjectValueItem((Object)value, label);
            charsetSet.add(item);
            metadataCharsetSets.add(item);
        }
        parametersDefinition.getDynField("Encoding").setAvailableValues(charsetSet.toArray(new DynObjectValueItem[charsetSet.size()]));
        newParametersDefinition.getDynField("Encoding").setAvailableValues(charsetSet.toArray(new DynObjectValueItem[charsetSet.size()]));
        dynStruct.getDynField("Encoding").setAvailableValues(metadataCharsetSets.toArray(new DynObjectValueItem[metadataCharsetSets.size()]));
    }

    private static void updateLocaleDefinition() {
        DynObjectValueItem[] values;
        HashSet<Locale> localeSet = new HashSet<Locale>(160);
        DynStruct parametersDefinition = ToolsLocator.getPersistenceManager().getDefinition("DBFStoreParameters");
        DynStruct newParametersDefinition = ToolsLocator.getPersistenceManager().getDefinition("DBFNewStoreParameters");
        for (DynObjectValueItem value : values = parametersDefinition.getDynField("Locale").getAvailableValues()) {
            Locale locale;
            String s = Objects.toString(value.getValue());
            if (StringUtils.isBlank((CharSequence)s) || (locale = Locale.forLanguageTag(s)) == null) continue;
            localeSet.add(locale);
        }
        Locale[] locales = Locale.getAvailableLocales();
        localeSet.addAll(Arrays.asList(locales));
        DynObjectValueItem[] items = new DynObjectValueItem[localeSet.size()];
        int i = 0;
        for (Locale locale : localeSet) {
            if (locale == null) continue;
            DynObjectValueItem item = new DynObjectValueItem((Object)locale.toLanguageTag(), locale.getDisplayName() + " [" + locale.toLanguageTag() + "]");
            items[i++] = item;
        }
        final Collator collator = Collator.getInstance();
        collator.setDecomposition(2);
        collator.setStrength(2);
        Arrays.sort(items, new Comparator<DynObjectValueItem>(){

            @Override
            public int compare(DynObjectValueItem o1, DynObjectValueItem o2) {
                return collator.compare(o1.getLabel(), o2.getLabel());
            }
        });
        parametersDefinition.getDynField("Locale").setAvailableValues(items);
        newParametersDefinition.getDynField("Locale").setAvailableValues(items);
    }
}

