/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dbf.utils;

import org.gvsig.fmap.dal.feature.exception.AttributeFeatureTypeNotSuportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbaseFieldDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbaseFieldDescriptor.class);
    public static final char DBFTYPE_STRING = 'C';
    public static final char DBFTYPE_NUMBER = 'N';
    public static final char DBFTYPE_FLOAT = 'F';
    public static final char DBFTYPE_DATE = 'D';
    public static final char DBFTYPE_BOOLEAN = 'L';
    public static final char DBFTYPE_LONG = 'l';
    public static final char DBFTYPE_DOUBLE = 'O';
    public static final char DBFTYPE_TIMESTAMP = '@';
    public static final char DBFTYPE_AUTOINCREMENT = '+';
    public static final int MAX_SIZE = 254;
    public static final int MAX_NUMBER_SIZE = 20;
    private String name;
    private String name_trim;
    private char type;
    private int offsetInRecord;
    private int size;
    private int scale;

    public String getName() {
        return this.name.trim();
    }

    public int getSize() {
        return this.size;
    }

    public int getScale() {
        return this.scale;
    }

    public int getPrecision() {
        switch (this.getType()) {
            case 'F': 
            case 'N': {
                if (this.scale < 1) {
                    return this.size;
                }
                return this.size - 2;
            }
        }
        return 0;
    }

    public char getType() {
        return this.type;
    }

    public int getOffsetInRecord() {
        return this.offsetInRecord;
    }

    public String getName_trim() {
        return this.name_trim;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setName_trim(String name_trim) {
        this.name_trim = name_trim;
    }

    public void setType(char type) throws AttributeFeatureTypeNotSuportedException {
        switch (type) {
            case 'C': 
            case 'D': 
            case 'F': 
            case 'L': 
            case 'N': {
                this.type = type;
                break;
            }
            case 'c': {
                this.type = (char)67;
                break;
            }
            case 'S': 
            case 's': {
                this.warn("Field type for " + this.name + " set to S which is flat out wrong people!, I am setting this to C, in the hopes you meant character.");
                this.type = (char)67;
                break;
            }
            case 'd': {
                this.type = (char)68;
                break;
            }
            case 'f': {
                this.type = (char)70;
                break;
            }
            case 'n': {
                this.type = (char)78;
                break;
            }
            case 'l': {
                this.type = (char)76;
                break;
            }
            default: {
                throw new AttributeFeatureTypeNotSuportedException(this.name, (int)type, "unknown", "DBF");
            }
        }
    }

    public void setOffsetInRecord(int offsetInRecord) {
        this.offsetInRecord = offsetInRecord;
    }

    public void setSize(int size) {
        switch (this.getType()) {
            case 'F': 
            case 'N': {
                this.size = size;
                break;
            }
            case 'C': {
                if (size > 254) {
                    this.warn("Field Length for " + this.name + " set to " + size + " Which is longer than " + 254 + " not consistent with dbase III");
                }
                this.size = size;
                break;
            }
            case 'D': {
                this.size = 8;
                break;
            }
            case 'L': {
                this.size = 1;
                break;
            }
            default: {
                this.size = size;
            }
        }
    }

    public void setScale(int scale) {
        if (scale == 0) {
            this.scale = 0;
            return;
        }
        switch (this.getType()) {
            case 'F': 
            case 'N': {
                int prec = this.size - 3;
                if (scale <= prec) {
                    this.scale = scale;
                    break;
                }
                this.scale = prec;
                break;
            }
            default: {
                this.scale = 0;
            }
        }
    }

    private void warn(String msg) {
        LOGGER.warn(msg);
    }
}

