/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import org.gvsig.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePanel
extends JPanel {
    private static final long serialVersionUID = -8877600252349334979L;
    private boolean enableValueChangedEvent = true;
    public static final int KEYLISTENER = 0;
    public static final int ACTIONLISTENER = 1;
    public static final int MOUSELISTENER = 2;
    private static final Logger logger = LoggerFactory.getLogger(BasePanel.class);

    public String getText(Object parent, String key) {
        if (key == null) {
            return null;
        }
        String translation = Messages.getText((String)key, (boolean)false);
        if (translation != null) {
            return translation;
        }
        logger.debug("Can't find translation for ''{1}''.", (Object)key);
        return key;
    }

    public String getText(String text) {
        return this.getText(this, text);
    }

    public void setEnableValueChangedEvent(boolean enableValueChangedEvent) {
        this.enableValueChangedEvent = enableValueChangedEvent;
    }

    public boolean isEnableValueChangedEvent() {
        return this.enableValueChangedEvent;
    }

    public ArrayList getComponentList() {
        ArrayList listComp = new ArrayList();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent(i) instanceof BasePanel) {
                ArrayList list = ((BasePanel)this.getComponent(i)).getComponentList();
                for (int j = 0; j < list.size(); ++j) {
                    listComp.add(list.get(j));
                }
                continue;
            }
            listComp.add(this.getComponent(i));
        }
        return listComp;
    }

    public void registerListener(int type, Object listener) {
        int i;
        ArrayList listComp = this.getComponentList();
        if (type == 0 && listener instanceof KeyListener) {
            for (i = 0; i < listComp.size(); ++i) {
                if (!(listComp.get(i) instanceof Component)) continue;
                ((Component)listComp.get(i)).addKeyListener((KeyListener)listener);
            }
        }
        if (type == 1 && listener instanceof ActionListener) {
            for (i = 0; i < listComp.size(); ++i) {
                if (!(listComp.get(i) instanceof AbstractButton)) continue;
                ((AbstractButton)listComp.get(i)).addActionListener((ActionListener)listener);
            }
        }
        if (type == 2 && listener instanceof MouseListener) {
            for (i = 0; i < listComp.size(); ++i) {
                if (!(listComp.get(i) instanceof Component)) continue;
                ((Component)listComp.get(i)).addMouseListener((MouseListener)listener);
            }
        }
    }

    protected abstract void translate();

    protected abstract void init();
}

