/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xml2db.lib.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.utils.CharsetUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.EditableForeingKey;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.xml2db.lib.api.xmlinfo.XMLAttributeInfo;
import org.gvsig.xml2db.lib.api.xmlinfo.XMLInfo;
import org.gvsig.xml2db.lib.api.xmlinfo.XMLTableInfo;
import org.gvsig.xml2db.lib.impl.Xml2dbCommons;
import org.gvsig.xml2db.lib.impl.xmlinfo.XMLAttributeInfoImpl;
import org.gvsig.xml2db.lib.impl.xmlinfo.XMLInfoImpl;
import org.gvsig.xml2db.lib.impl.xmlinfo.XMLTableInfoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StructureExtractorImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(StructureExtractorImpl.class);
    private String tablePrefix;

    private void extractTags(final XMLInfoImpl xmlinfo, Reader reader, final SimpleTaskStatus status) {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        try {
            final DataManager dataManager = DALLocator.getDataManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            status.message(i18n.getTranslation("_Reading_xml") + " 1/5");
            status.setRangeOfValues(0L, xmlinfo.getCountLines());
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            InputSource is = new InputSource(reader);
            final ArrayList path = new ArrayList();
            saxParser.parse(is, new DefaultHandler(){
                private Locator locator;
                int size;
                int refreshInterval = 1;
                StringBuilder chars = new StringBuilder();

                @Override
                public void setDocumentLocator(Locator locator) {
                    this.locator = locator;
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    int line = this.locator.getLineNumber();
                    int column = this.locator.getColumnNumber() - 2 - localName.length();
                    if (line % this.refreshInterval == 0) {
                        status.setCurValue((long)line);
                    }
                    if (line > 100000) {
                        this.refreshInterval = 10000;
                    } else if (line > 10000) {
                        this.refreshInterval = 1000;
                    } else if (line > 1000) {
                        this.refreshInterval = 100;
                    } else if (line > 100) {
                        this.refreshInterval = 10;
                    }
                    String idvalue = dataManager.createUniqueID();
                    path.add(localName);
                    String path_s = StringUtils.join((Iterable)path, (String)"/");
                    XMLAttributeInfoImpl info = xmlinfo.getTag(path_s);
                    if (info == null) {
                        info = new XMLAttributeInfoImpl(xmlinfo.getLocale(), path_s);
                        xmlinfo.addTag(info);
                    }
                    if (path.size() > 1) {
                        List parentpath = path.subList(0, path.size() - 1);
                        String parentpath_s = StringUtils.join(parentpath, (String)"/");
                        XMLAttributeInfoImpl parentinfo = xmlinfo.getTag(parentpath_s);
                        parentinfo.incrChildCount(localName);
                        parentinfo.setLastChildID(localName, idvalue);
                    }
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        IProjection proj;
                        String name = attributes.getLocalName(i);
                        String value = attributes.getValue(i);
                        String idvalueChild = dataManager.createUniqueID();
                        XMLAttributeInfoImpl infoChild = xmlinfo.getTag(path_s + "/" + name);
                        if (infoChild == null) {
                            infoChild = new XMLAttributeInfoImpl(xmlinfo.getLocale(), path_s + "/" + name);
                            xmlinfo.addTag(infoChild);
                        }
                        info.incrChildCount(infoChild.getName());
                        info.setLastChildID(infoChild.getName(), idvalueChild);
                        infoChild.addValue(value);
                        if (xmlinfo.getSrid() != null || !StringUtils.containsIgnoreCase((CharSequence)infoChild.getName(), (CharSequence)"srid") || (proj = StructureExtractorImpl.this.getProjection(value)) == null) continue;
                        xmlinfo.setSrid(proj);
                    }
                    this.chars.setLength(0);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    String value;
                    int line = this.locator.getLineNumber();
                    String path_s = StringUtils.join((Iterable)path, (String)"/");
                    XMLAttributeInfoImpl info = xmlinfo.getTag(path_s);
                    if (info == null) {
                        info = new XMLAttributeInfoImpl(xmlinfo.getLocale(), path_s);
                        xmlinfo.addTag(info);
                    }
                    XMLAttributeInfoImpl parentinfo = null;
                    if (path.size() > 1) {
                        List parentpath = path.subList(0, path.size() - 1);
                        String parentpath_s = StringUtils.join(parentpath, (String)"/");
                        parentinfo = xmlinfo.getTag(parentpath_s);
                    }
                    if (info.hasChilds() || parentinfo != null && parentinfo.getChildsCount(localName) > 1) {
                        value = this.chars.toString();
                        if (StringUtils.isNotBlank((CharSequence)value)) {
                            String name = info.getName() + "$v";
                            String idvalueChild = dataManager.createUniqueID();
                            XMLAttributeInfoImpl infoChild = xmlinfo.getTag(path_s + "/" + name);
                            if (infoChild == null) {
                                infoChild = new XMLAttributeInfoImpl(xmlinfo.getLocale(), path_s + "/" + name);
                                xmlinfo.addTag(infoChild);
                            }
                            info.incrChildCount(infoChild.getName());
                            info.setLastChildID(infoChild.getName(), idvalueChild);
                            infoChild.addValue(value);
                        }
                    } else {
                        IProjection proj;
                        value = this.chars.toString();
                        info.addValue(value);
                        if (StringUtils.containsIgnoreCase((CharSequence)info.getName(), (CharSequence)"srid") && (proj = StructureExtractorImpl.this.getProjection(value)) != null) {
                            xmlinfo.setSrid(proj);
                        }
                    }
                    info.consolidateChildCounters();
                    path.remove(path.size() - 1);
                    this.chars.setLength(0);
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    int line = this.locator.getLineNumber();
                    this.chars.append(ch, start, length);
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't extract tags.", ex);
        }
    }

    private IProjection getProjection(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        IProjection proj = null;
        try {
            proj = CRSFactory.getCRS((String)value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (proj != null) {
            return proj;
        }
        try {
            proj = CRSFactory.getCRS((String)("EPSG:" + value));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return proj;
    }

    public XMLInfo extractStructure(File xml, Charset charset, IProjection projection, Locale locale, SimpleTaskStatus status) throws FileNotFoundException, IOException {
        XMLInfoImpl xmlinfo = new XMLInfoImpl();
        xmlinfo.setTablePrefix(this.tablePrefix);
        xmlinfo.setLocale(locale);
        xmlinfo.setSrid(projection);
        xmlinfo.setTablePrefix(this.tablePrefix);
        long count = Xml2dbCommons.countLines(xml, charset, status);
        xmlinfo.setCountLines(count);
        InputSource is = Xml2dbCommons.openReader(xml, charset);
        return this.extractStructure(is, xmlinfo, status);
    }

    public XMLInfo extractStructure(InputStream xml, Charset charset, IProjection projection, Locale locale, SimpleTaskStatus status) throws IOException {
        XMLInfoImpl xmlinfo = new XMLInfoImpl();
        xmlinfo.setLocale(locale);
        xmlinfo.setSrid(projection);
        xmlinfo.setTablePrefix(this.tablePrefix);
        xmlinfo.setCountLines(-1L);
        InputSource is = Xml2dbCommons.openReader(xml, charset);
        return this.extractStructure(is, xmlinfo, status);
    }

    public XMLInfo extractStructure(Reader reader, IProjection projection, Locale locale, SimpleTaskStatus status) {
        XMLInfoImpl xmlinfo = new XMLInfoImpl();
        xmlinfo.setLocale(locale);
        xmlinfo.setSrid(projection);
        xmlinfo.setTablePrefix(this.tablePrefix);
        InputSource is = new InputSource(reader);
        return this.extractStructure(is, xmlinfo, status);
    }

    public XMLInfo extractStructure(InputSource is, XMLInfoImpl xmlinfo, SimpleTaskStatus status) {
        if (xmlinfo.getCharset() == null) {
            xmlinfo.setCharset(CharsetUtils.forName((String)is.getEncoding()));
        }
        this.extractTags(xmlinfo, is.getCharacterStream(), status);
        this.buildTablesFromTags(xmlinfo, status);
        this.removeDuplicateTableNames(xmlinfo, status);
        this.createPrimaryKeyAndForeignKeys(xmlinfo, status);
        this.createFeatureTypes(xmlinfo, status);
        return xmlinfo;
    }

    private String plural(String s) {
        int l = s.length();
        char ch = s.substring(l - 1, l).toLowerCase().charAt(0);
        if (ch == 'a' || ch == 'e' || ch == 'i' || ch == 'o' || ch == 'u') {
            return s + "s";
        }
        return s + "es";
    }

    private void buildTablesFromTags(XMLInfoImpl xmlinfo, SimpleTaskStatus status) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        status.message(i18n.getTranslation("_Identifying_tables") + " 2/5");
        status.setRangeOfValues(0L, (long)xmlinfo.getTagsPaths().size());
        for (String tagPath : xmlinfo.getTagsPaths()) {
            XMLAttributeInfoImpl tag1Info = xmlinfo.getTagInfo(tagPath);
            XMLTableInfoImpl tableInfo = new XMLTableInfoImpl(tagPath, tag1Info);
            for (String tagPath2 : xmlinfo.getTagsPaths()) {
                String fieldName;
                if (tagPath.equals(tagPath2) || !tagPath2.startsWith(tagPath + "/") || (fieldName = tagPath2.substring(tagPath.length() + 1)).contains("/")) continue;
                XMLAttributeInfoImpl info = xmlinfo.getTag(tagPath2);
                tableInfo.add(info);
            }
            if (!tableInfo.isEmpty()) {
                xmlinfo.addTable(tableInfo);
            }
            status.incrementCurrentValue();
        }
    }

    private void removeDuplicateTableNames(XMLInfoImpl xmlinfo, SimpleTaskStatus status) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        status.message(i18n.getTranslation("_Fixing_table_names") + " 3/5");
        status.setRangeOfValues(0L, (long)xmlinfo.size());
        Iterator<XMLTableInfo> iterator = xmlinfo.iterator();
        while (iterator.hasNext()) {
            XMLTableInfo tableInfo01 = iterator.next();
            XMLTableInfoImpl tableInfo1 = (XMLTableInfoImpl)tableInfo01;
            status.message(i18n.getTranslation("_Fixing_table_names") + " 3/5 (" + tableInfo1.getName() + ")");
            boolean renombrar = false;
            Iterator<XMLTableInfo> iterator2 = xmlinfo.iterator();
            while (iterator2.hasNext()) {
                XMLTableInfo tableInfo02 = iterator2.next();
                XMLTableInfoImpl tableInfo2 = (XMLTableInfoImpl)tableInfo02;
                if (tableInfo1 == tableInfo2 || !StringUtils.equalsIgnoreCase((CharSequence)tableInfo1.getName(), (CharSequence)tableInfo2.getName())) continue;
                String[] path_ss = tableInfo2.getPath().split("/");
                int l = path_ss.length;
                String name = path_ss[l - 1] + "_" + path_ss[l - 2];
                tableInfo2.rename(name);
                renombrar = true;
            }
            if (renombrar) {
                String[] path_ss = tableInfo1.getPath().split("/");
                int l = path_ss.length;
                String name = path_ss[l - 1] + "_" + path_ss[l - 2];
                tableInfo1.rename(name);
            }
            status.incrementCurrentValue();
        }
    }

    private void createPrimaryKeyAndForeignKeys(XMLInfoImpl xmlinfo, SimpleTaskStatus status) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        status.message(i18n.getTranslation("_Identifying_foreign_keys") + " 4/5");
        status.setRangeOfValues(0L, (long)xmlinfo.size());
        Iterator<XMLTableInfo> iterator = xmlinfo.iterator();
        while (iterator.hasNext()) {
            XMLTableInfo tableInfo0 = iterator.next();
            XMLTableInfoImpl tableInfo = (XMLTableInfoImpl)tableInfo0;
            status.message(i18n.getTranslation("_Identifying_foreign_keys") + " 4/5 (" + tableInfo.getName() + ")");
            Object[] fieldkeys = tableInfo.getPath().split("/");
            for (int i = 0; i < fieldkeys.length; ++i) {
                String fieldkey = fieldkeys[i];
                if (i == fieldkeys.length - 1) {
                    tableInfo.add(new XMLAttributeInfoImpl(xmlinfo.getLocale(), "$ID_" + tableInfo.getName(), 4).setPk(true));
                    continue;
                }
                XMLTableInfoImpl tableInfo2 = xmlinfo.getTableByPath(StringUtils.join((Object[])ArrayUtils.subarray((Object[])fieldkeys, (int)0, (int)(i + 1)), (String)"/"));
                tableInfo.add(new XMLAttributeInfoImpl(xmlinfo.getLocale(), "$ID_" + tableInfo2.getName(), 4).setFk(true).setFkCodeName("$ID_" + fieldkey).setFkTableName(fieldkey));
            }
            Iterator<XMLAttributeInfo> iterator2 = tableInfo.iterator();
            while (iterator2.hasNext()) {
                XMLAttributeInfo field0 = iterator2.next();
                XMLAttributeInfoImpl field = (XMLAttributeInfoImpl)field0;
                if (!xmlinfo.existsTableByPath(tableInfo.getPath() + "/" + field.getName())) continue;
                XMLTableInfoImpl fktableInfo = xmlinfo.getTableByPath(tableInfo.getPath() + "/" + field.getName());
                int count = tableInfo.getMaxCountChild(field.getName());
                if (count < 1) continue;
                if (count > 1) {
                    field.setAggregate(true);
                    field.setFkCodeName("$ID_" + fktableInfo.getName());
                    field.setFkTableName(fktableInfo.getName());
                    field.setSize(45);
                    field.setType(34);
                    continue;
                }
                field.setFk(true);
                field.setFkCodeName("$ID_" + fktableInfo.getName());
                field.setFkTableName(fktableInfo.getName());
                field.setSize(0);
                field.setType(4);
            }
            tableInfo.sort();
            status.incrementCurrentValue();
        }
    }

    private void createFeatureTypes(XMLInfoImpl xmlinfo, SimpleTaskStatus status) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        status.message(i18n.getTranslation("_Creating_table_definitions") + " 5/5");
        status.setRangeOfValues(0L, (long)xmlinfo.size());
        DataManager dataManager = DALLocator.getDataManager();
        Iterator<XMLTableInfo> iterator = xmlinfo.iterator();
        while (iterator.hasNext()) {
            XMLTableInfo tableInfo0 = iterator.next();
            XMLTableInfoImpl tableInfo = (XMLTableInfoImpl)tableInfo0;
            status.message(i18n.getTranslation("_Creating_table_definitions") + " 5/5 (" + tableInfo.getName() + ")");
            EditableFeatureType ft = dataManager.createFeatureType();
            ft.setLabel(tableInfo.getName());
            ft.getTags().set("xml2db.tablename", (Object)xmlinfo.getNameWithPrefix(tableInfo.getName()));
            ft.getTags().set("vcsgis.storename", (Object)xmlinfo.getNameWithPrefix(tableInfo.getName()));
            ft.getTags().set("xml2db.path", (Object)tableInfo.getPath());
            ft.getTags().set("xml2db.tableprefix", (Object)xmlinfo.getTablePrefix());
            Iterator<XMLAttributeInfo> iterator2 = tableInfo.iterator();
            while (iterator2.hasNext()) {
                EditableFeatureAttributeDescriptor attrdesc;
                XMLAttributeInfo attrinfo0 = iterator2.next();
                XMLAttributeInfoImpl attrinfo = (XMLAttributeInfoImpl)attrinfo0;
                if (ft.get(attrinfo.getName()) != null) {
                    LOGGER.warn("Duplicated attribute '" + attrinfo.getName() + "' in '" + xmlinfo.getNameWithPrefix(tableInfo.getName()) + "'.");
                }
                if (attrinfo.isAggregate()) continue;
                if (attrinfo.getName().startsWith("$ID")) {
                    attrdesc = ft.add(attrinfo.getName(), attrinfo.getType());
                    attrdesc.setLabel("Id. " + attrinfo.getName().substring(4));
                    attrdesc.setSize(attrinfo.getSize());
                } else if (attrinfo.getName().endsWith("$v")) {
                    attrdesc = ft.add(attrinfo.getName(), attrinfo.getType());
                    attrdesc.setLabel(StringUtils.left((String)attrinfo.getName(), (int)(attrinfo.getName().length() - 2)));
                    attrdesc.setSize(attrinfo.getSize());
                } else {
                    attrdesc = ft.add(attrinfo.getName(), attrinfo.getType());
                    attrdesc.setSize(attrinfo.getSize());
                    attrdesc.setPrecision(attrinfo.getPrecision());
                    attrdesc.setScale(attrinfo.getScale());
                    if (attrdesc.getType() == 66) {
                        attrdesc.setGeometryType(attrinfo.getGeometryType());
                        attrdesc.setSRS(xmlinfo.getSrid());
                        attrdesc.setIsIndexed(true);
                    }
                }
                attrdesc.setLocale(xmlinfo.getLocale());
                attrdesc.setIsPrimaryKey(attrinfo.isPk());
                if (!attrinfo.isFk()) continue;
                EditableForeingKey fk = attrdesc.getForeingKey();
                fk.setForeingKey(true);
                fk.setTableName(xmlinfo.getNameWithPrefix(attrinfo.getFkTableName()));
                fk.setCodeName(attrinfo.getFkCodeName());
                fk.setClosedList(false);
                fk.setLabelFormula("\"" + attrinfo.getFkCodeName() + "\"");
                attrdesc.setRelationType(1);
                attrdesc.setIsIndexed(true);
            }
            FeatureAttributeDescriptor pk = ft.getPrimaryKey()[0];
            Iterator<XMLAttributeInfo> iterator3 = tableInfo.iterator();
            while (iterator3.hasNext()) {
                XMLAttributeInfo attrinfo0 = iterator3.next();
                XMLAttributeInfoImpl attrinfo = (XMLAttributeInfoImpl)attrinfo0;
                if (!attrinfo.isAggregate()) continue;
                EditableFeatureAttributeDescriptor attrdesc = ft.add("$List_" + attrinfo.getName(), attrinfo.getType());
                attrdesc.setLabel(this.plural(attrinfo.getName()));
                attrdesc.getTags().set("dal.relatedfeatures.table", (Object)xmlinfo.getNameWithPrefix(attrinfo.getFkTableName()));
                attrdesc.getTags().set("dal.relatedfeatures.unique.field.name", (Object)attrinfo.getFkCodeName());
                attrdesc.getTags().set("dynform.label.empty", (Object)true);
                attrdesc.getTags().set("dynform.resizeWeight", (Object)100);
                attrdesc.setFeatureAttributeEmulator("SELECT * FROM \"" + xmlinfo.getNameWithPrefix(attrinfo.getFkTableName()) + "\" WHERE ( (:\"" + pk.getName() + "\") = (\"" + xmlinfo.getNameWithPrefix(attrinfo.getFkTableName()) + "\".\"" + pk.getName() + "\") )");
                attrdesc.setRelationType(4);
            }
            tableInfo.setFeatureType(ft);
            status.incrementCurrentValue();
        }
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }
}

