/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.plugins;

import java.io.Console;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.messages.Messages;
import org.gvsig.tools.future.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginClassLoader
extends URLClassLoader {
    private static Logger logger = LoggerFactory.getLogger((String)PluginClassLoader.class.getName());
    private Map<String, ZipFile> clasesJar = new HashMap<String, ZipFile>();
    private File baseDir;
    private List<PluginClassLoader> pluginLoaders;
    private static List<ClassLoader> otherLoaders = new ArrayList<ClassLoader>();
    private boolean isOtherLoader = false;

    public PluginClassLoader(URL[] jars, String baseDir, ClassLoader cl, PluginClassLoader[] pluginLoaders) throws IOException {
        this(jars, baseDir, cl, Arrays.asList(pluginLoaders));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginClassLoader(URL[] jars, String baseDir, ClassLoader cl, List<PluginClassLoader> pluginLoaders) throws IOException {
        super(jars, cl);
        this.baseDir = new File(new File(baseDir).getAbsolutePath());
        try {
            logger.debug("Creating PluginClassLoader for {}.", (Object)this.getPluginName());
            this.pluginLoaders = new ArrayList<PluginClassLoader>();
            this.pluginLoaders.addAll(pluginLoaders);
            if (jars == null || jars.length < 1) {
                this.debugDump();
                return;
            }
            ZipFile[] jarFiles = new ZipFile[jars.length];
            for (int i = 0; i < jars.length; ++i) {
                try {
                    logger.debug("Classloader {}, loading jar {}", (Object)this.getPluginName(), (Object)jars[i].getPath());
                    jarFiles[i] = new ZipFile(jars[i].getPath());
                    Enumeration<? extends ZipEntry> entradas = jarFiles[i].entries();
                    while (entradas.hasMoreElements()) {
                        ZipEntry file = entradas.nextElement();
                        String fileName = file.getName();
                        if (!fileName.toLowerCase().endsWith(".class")) continue;
                        if (this.clasesJar.get(fileName = fileName.substring(0, fileName.length() - 6).replace('/', '.')) != null) {
                            logger.warn("Classloader {}, duplicated class {} in {} and {}", new Object[]{this.getPluginName(), fileName, jarFiles[i].getName(), this.clasesJar.get(fileName).getName()});
                            continue;
                        }
                        this.clasesJar.put(fileName, jarFiles[i]);
                    }
                    continue;
                }
                catch (ZipException e) {
                    throw new IOException(e.getMessage() + " Jar: " + jars[i].getPath() + ": " + jarFiles[i]);
                }
                catch (IOException e) {
                    throw e;
                }
            }
        }
        finally {
            this.debugDump();
        }
    }

    private void debugDump() {
        URL[] urls;
        if (!logger.isDebugEnabled()) {
            return;
        }
        logger.debug(this.toString());
        logger.debug("  baseDir: " + this.baseDir);
        logger.debug("  parent: " + this.getParent());
        logger.debug("  depends:");
        for (PluginClassLoader pluginLoader : this.pluginLoaders) {
            logger.debug("    {}", (Object)pluginLoader.toString());
        }
        logger.debug("  urls:");
        for (URL url : urls = this.getURLs()) {
            logger.debug("    " + url.toString());
        }
    }

    protected Class singleLoadClass(String name) throws ClassNotFoundException {
        HashSet<String> pluginsVisiteds = new HashSet<String>();
        Class c = this.singleLoadClass(pluginsVisiteds, name);
        return c;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = null;
        if (StringUtils.equals((CharSequence)name, (CharSequence)"java.nio.file.SimpleFileVisitor")) {
            logger.info("Loading SimpleFileVisitor: isOtherLoader = " + this.isOtherLoader + " PluginName = " + this.getPluginName());
        }
        for (int retry = 0; c == null && retry < 3; ++retry) {
            block19: {
                try {
                    if (!this.isOtherLoader) {
                        c = super.loadClass(name, resolve);
                        logger.debug("Classloader {}, found class {}, loader {}.", new Object[]{this.getPluginName(), name, Objects.toString(c.getClassLoader())});
                    }
                }
                catch (ClassNotFoundException e1) {
                    if (!StringUtils.equals((CharSequence)name, (CharSequence)"java.nio.file.SimpleFileVisitor")) break block19;
                    logger.info("ClassNotFoundException SimpleFileVisitor in classLoader = " + super.getClass().getName(), (Throwable)e1);
                }
            }
            if (c == null) {
                try {
                    c = this.singleLoadClass(name);
                }
                catch (ClassNotFoundException e1) {
                    // empty catch block
                }
            }
            if (c == null) {
                try {
                    this.isOtherLoader = true;
                    c = this.loadOtherClass(name);
                }
                catch (ClassNotFoundException e3) {
                    if (StringUtils.equals((CharSequence)name, (CharSequence)"java.nio.file.SimpleFileVisitor")) {
                        logger.info("Crash loading SimpleFileVisitor: isOtherLoader = " + this.isOtherLoader + " PluginName = " + this.getPluginName());
                        if (FutureUtils.use((String)"ClassLoaderDebug")) {
                            logger.info("Pulse enter to continue");
                            Console console = System.console();
                            console.readLine();
                        }
                    }
                    throw new ClassNotFoundException("Class " + name + " not found through the plugin " + this.baseDir, e3);
                }
                finally {
                    this.isOtherLoader = false;
                }
            }
            if (c != null) continue;
            logger.info("class " + name + ", retry " + retry);
        }
        if (c == null) {
            if (StringUtils.startsWith((CharSequence)name, (CharSequence)"java.") || StringUtils.startsWith((CharSequence)name, (CharSequence)"javax.")) {
                logger.warn("Can't locate class '" + name + "'. It can be a serious problem. It is advisable that you close the application.");
            }
            throw new ClassNotFoundException(Messages.getString("PluginClassLoader.Error_reading_file") + name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private Class<?> loadOtherClass(String name) throws ClassNotFoundException {
        ClassLoader[] ocls;
        for (ClassLoader ocl : ocls = otherLoaders.toArray(new ClassLoader[0])) {
            Class<?> c = ocl.loadClass(name);
            if (c == null) continue;
            logger.debug("Classloader {}, found class {} in classloader {}", new Object[]{this, this.getPluginName(), name, Objects.toString(ocl)});
            return c;
        }
        throw new ClassNotFoundException(name);
    }

    private byte[] loadClassData(ZipEntry classFile, InputStream is) throws IOException {
        int size = (int)classFile.getSize();
        byte[] buff = new byte[size];
        DataInputStream dis = new DataInputStream(is);
        dis.readFully(buff);
        dis.close();
        return buff;
    }

    private byte[] loadClassData(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        ((InputStream)is).close();
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        return bytes;
    }

    @Override
    public URL getResource(String res) {
        HashSet<String> pluginsVisiteds = new HashSet<String>();
        URL ret = this.getResource(pluginsVisiteds, res);
        return ret;
    }

    private URL getResource(File base, List<String> res) {
        File[] files = base.listFiles();
        String parte = res.get(0);
        for (File file : files) {
            if (file.getName().compareTo(parte) != 0) continue;
            if (res.size() == 1) {
                try {
                    return new URL("file:" + file.toString());
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            return this.getResource(file, res.subList(1, res.size()));
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        HashSet<PluginClassLoader> visitedPlugins = new HashSet<PluginClassLoader>();
        return this.getResources(name, visitedPlugins);
    }

    protected Enumeration<URL> getResources(String name, HashSet<PluginClassLoader> visitedPlugins) throws IOException {
        ArrayList<URL> resources = new ArrayList<URL>();
        Enumeration<URL> aux = super.getResources(name);
        while (aux.hasMoreElements()) {
            URL url = aux.nextElement();
            resources.add(url);
        }
        visitedPlugins.add(this);
        for (PluginClassLoader loader : this.pluginLoaders) {
            if (visitedPlugins.contains(loader)) continue;
            aux = loader.getResources(name, visitedPlugins);
            while (aux.hasMoreElements()) {
                URL url = aux.nextElement();
                resources.add(url);
            }
        }
        return Collections.enumeration(resources);
    }

    public String getPluginName() {
        return this.baseDir.getName();
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection perms = super.getPermissions(codesource);
        perms.add(new AllPermission());
        return perms;
    }

    public String getBaseDir() {
        return this.baseDir.getAbsolutePath();
    }

    public static void addLoaders(ArrayList classLoaders) {
        otherLoaders.addAll(classLoaders);
    }

    public String toString() {
        return super.toString() + " (" + this.getPluginName() + ")";
    }

    public void addPluginClassLoader(PluginClassLoader pluginClassLoader) {
        if (!this.pluginLoaders.contains(pluginClassLoader)) {
            this.pluginLoaders.add(pluginClassLoader);
        }
    }

    private Class singleLoadClass(Set<String> pluginsVisiteds, String name) throws ClassNotFoundException {
        if (pluginsVisiteds.contains(this.getPluginName())) {
            return null;
        }
        pluginsVisiteds.add(this.getPluginName());
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        logger.debug("Classloader {}, searching class '{}'", new Object[]{this.getPluginName(), name});
        try {
            ZipFile jar = this.clasesJar.get(name);
            if (jar == null) {
                String classFileName = this.baseDir + "/classes/" + name.replace('.', '/') + ".class";
                File f = new File(classFileName);
                if (f.exists()) {
                    byte[] data = this.loadClassData(f);
                    c = this.defineClass(name, data, 0, data.length);
                    logger.debug("Classloader {}/classes-folder, found class {} in loader {}", new Object[]{this.getPluginName(), name, Objects.toString(c)});
                } else {
                    for (PluginClassLoader pluginLoader1 : this.pluginLoaders) {
                        c = null;
                        PluginClassLoader pluginLoader = pluginLoader1;
                        if (pluginLoader == null) continue;
                        try {
                            c = pluginLoader.singleLoadClass(pluginsVisiteds, name);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        if (c == null) continue;
                        logger.debug("Classloader {}, found class {} in plugin {}, loader {}", new Object[]{this.getPluginName(), name, pluginLoader.getPluginName(), Objects.toString(c.getClassLoader())});
                        return c;
                    }
                }
            } else {
                logger.debug("Classloader {}, found class {} in jar {}", new Object[]{this.getPluginName(), name, jar.getName()});
                String fileName = name.replace('.', '/') + ".class";
                ZipEntry classFile = jar.getEntry(fileName);
                byte[] data = this.loadClassData(classFile, jar.getInputStream(classFile));
                c = this.defineClass(name, data, 0, data.length);
                if (c == null) {
                    logger.debug("Classloader {}, can't load class {} from jar {}", new Object[]{this.getPluginName(), name, jar.getName()});
                }
            }
            if (c == null) {
                logger.debug("Classloader {}, class not found {}", new Object[]{this.getPluginName(), name});
                this.debugDump();
                throw new ClassNotFoundException(name);
            }
            return c;
        }
        catch (IOException e) {
            logger.debug("Classloader {}, error loading class {}", (Object)new Object[]{this.getPluginName(), name}, (Object)e);
            throw new ClassNotFoundException(Messages.getString("PluginClassLoader.Error_reading_file") + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getResource(Set<String> pluginsVisiteds, String res) {
        URL ret = null;
        if (pluginsVisiteds.contains(this.getPluginName())) {
            return null;
        }
        pluginsVisiteds.add(this.getPluginName());
        try {
            logger.debug("Classloader {}, searching resource '{}'", (Object)this.getPluginName(), (Object)res);
            ArrayList<String> resource = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(res, "\\/");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                resource.add(token);
            }
            ret = this.getResource(this.baseDir, resource);
            if (ret != null) {
                return ret;
            }
        }
        catch (Exception e) {
            logger.warn("Classloader {}, Error getting resource '{}'.", (Object)new Object[]{this.getPluginName(), res}, (Object)e);
        }
        logger.debug("Classloader {}, searching in depends pluginLoaders", (Object)this.getPluginName());
        for (PluginClassLoader pluginClassLoader : this.pluginLoaders) {
            if (pluginClassLoader == null) continue;
            try {
                ret = pluginClassLoader.getResource(pluginsVisiteds, res);
                if (ret == null) continue;
                logger.debug("Classloader {}, Found resource '{}' in plugin '{}'.", new Object[]{this.getPluginName(), res, pluginClassLoader.getPluginName()});
                URL uRL = ret;
                return uRL;
            }
            catch (Exception exception) {}
            continue;
            finally {
                pluginsVisiteds.add(pluginClassLoader.getPluginName());
            }
        }
        if (ret == null) {
            try {
                ret = super.getResource(res);
            }
            catch (Exception e) {
                logger.warn("Classloader {}, error getting resource '{}' in parent classloader'", (Object)new Object[]{this.getPluginName(), res}, (Object)e);
            }
            if (ret == null) {
                logger.debug("Classloader {}, Resource '{}' not found.", new Object[]{this.getPluginName(), res});
            }
        }
        return ret;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }
}

