/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geodb;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.CancelationException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.geodb.AbstractWizardDB;
import org.gvsig.geodb.vectorialdb.visibility.LayerScaleVisibilityUtils;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;

public class WizardDBVectorial
extends AbstractWizardDB {
    @Override
    protected boolean requireGeometry() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeWizard() {
        block31: {
            DataManager man = DALLocator.getDataManager();
            MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
            MapControl mapControl = this.getMapCtrl();
            MapContext mapContext = mapControl.getMapContext();
            String groupName = null;
            ArrayList<FLayer> all_layers = new ArrayList<FLayer>();
            try {
                FLayer layer = null;
                for (Object tableInfo : this.getTablesInformation()) {
                    FeatureStore store;
                    if (!tableInfo.isSelected()) continue;
                    JDBCStoreParameters params = tableInfo.getParameters();
                    this.fixCRS((DataStoreParameters)params);
                    if (groupName == null) {
                        String host;
                        String dbname = params.getDBName();
                        if (StringUtils.isEmpty((CharSequence)dbname)) {
                            dbname = "Group";
                        }
                        groupName = StringUtils.isEmpty((CharSequence)(host = params.getHost())) ? dbname : dbname + " (" + host + ")";
                    }
                    try {
                        store = (FeatureStore)man.openStore(params.getDataStoreName(), (DataStoreParameters)params);
                    }
                    catch (Exception e) {
                        LOGGER.warn("While opening DB store.", (Throwable)e);
                        Object var13_17 = null;
                        for (FLayer layer2 : all_layers) {
                            layer2.dispose();
                        }
                        return var13_17;
                    }
                    try {
                        layer = mapContextManager.createLayer(tableInfo.getDocumentName(), (DataStore)store);
                        if (this.arguments == null || !this.arguments.contains("ignoreVisibilityScaleCheck", (Object)true)) {
                            LayerScaleVisibilityUtils.checkForVisibilityScale(layer);
                        }
                        all_layers.add(layer);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Can't create layer '" + tableInfo.getDocumentName() + "'.", (Throwable)e);
                    }
                    finally {
                        DisposeUtils.disposeQuietly((Disposable)store);
                    }
                }
                if (all_layers.size() > 1) {
                    FLayers group = new FLayers();
                    group.setMapContext(mapContext);
                    group.setParentLayer(mapContext.getLayers());
                    group.setName(groupName);
                    for (FLayer aLayer : all_layers) {
                        group.addLayer(aLayer);
                    }
                    if (group.isOk()) {
                        group.setVisible(true);
                        mapContext.beginAtomicEvent();
                        try {
                            mapControl.addLayer((FLayer)group);
                            group.dispose();
                            break block31;
                        }
                        catch (CancelationException e) {
                            LOGGER.warn("Can't add group to mapcontext layers.", (Throwable)e);
                            break block31;
                        }
                        finally {
                            mapContext.endAtomicEvent();
                        }
                    }
                    this.fireLayerErrorEvent(layer, mapControl);
                    break block31;
                }
                if (all_layers.size() != 1) break block31;
                layer = (FLayer)all_layers.get(0);
                if (layer.isOk()) {
                    layer.setVisible(true);
                    mapContext.beginAtomicEvent();
                    try {
                        mapControl.addLayer(layer);
                        break block31;
                    }
                    catch (CancelationException e) {
                        LOGGER.warn("Can't add group to mapcontext layers.", (Throwable)e);
                        break block31;
                    }
                    finally {
                        mapContext.endAtomicEvent();
                    }
                }
                this.fireLayerErrorEvent(layer, mapControl);
            }
            finally {
                for (FLayer layer : all_layers) {
                    layer.dispose();
                }
            }
        }
        return null;
    }

    private void fireLayerErrorEvent(FLayer lyr, MapControl mapControl) {
        mapControl.getMapContext().callNewErrorEvent(null);
    }
}

