/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geodb.databaseworkspace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorer;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.operations.SingleLayer;
import org.gvsig.geodb.databaseworkspace.RepositoryAddTablePanelView;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryAddTablePanel
extends RepositoryAddTablePanelView
implements Component {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryAddTablePanel.class);
    private static final int TAB_LAYERS = 0;
    private static final int TAB_TABLES = 1;
    private static final int TAB_DATABASETABLES = 2;
    private PickerController<JDBCServerExplorerParameters> connectionPicker;

    public RepositoryAddTablePanel() {
        this.initComponents();
    }

    private void initComponents() {
        ApplicationManager application = ApplicationLocator.getManager();
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        TreeModel layersModel = application.createProjectLayersTreeModel();
        this.treeLayers.setModel(layersModel);
        this.treeLayers.getSelectionModel().addTreeSelectionListener(e -> this.doUpdateTableName());
        Project project = application.getCurrentProject();
        List docs = project.getDocuments(TableManager.TYPENAME);
        if (docs != null) {
            DefaultListModel<LabeledValueImpl> tablesModel = new DefaultListModel<LabeledValueImpl>();
            for (Document doc : docs) {
                TableDocument table = (TableDocument)doc;
                tablesModel.addElement(new LabeledValueImpl(table.getName(), (Object)table.getFeatureStore()));
            }
            this.lstTables.setModel(tablesModel);
            this.lstTables.addListSelectionListener(e -> {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                this.doUpdateTableName();
            });
            toolsSwingManager.addClearButton((JTextComponent)this.txtTableName);
            toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtTableName);
        }
        this.connectionPicker = DALSwingLocator.getSwingManager().createJDBCConnectionPickerController(this.cboConnections, this.btnAddConnection);
        this.connectionPicker.addChangeListener(e -> this.doUpdateDatabaseTables());
        this.lstDatabaseTables.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.doUpdateTableName();
        });
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)20, (int)60, (int)25, (int)100);
    }

    public JComponent asJComponent() {
        return this;
    }

    private void doUpdateDatabaseTables() {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorerParameters explorerParams = (JDBCServerExplorerParameters)this.connectionPicker.get();
            JDBCServerExplorer explorer = (JDBCServerExplorer)dataManager.openServerExplorer(explorerParams.getProviderName(), (DataServerExplorerParameters)explorerParams);
            ArrayList<LabeledValueImpl> tables = new ArrayList<LabeledValueImpl>();
            for (DataStoreParameters dataStoreParameters : explorer.list()) {
                JDBCStoreParameters jDBCStoreParameters = (JDBCStoreParameters)dataStoreParameters;
                tables.add(new LabeledValueImpl(jDBCStoreParameters.getTable(), (Object)jDBCStoreParameters));
            }
            Collections.sort(tables, new Comparator<LabeledValue<JDBCStoreParameters>>(){

                @Override
                public int compare(LabeledValue<JDBCStoreParameters> o1, LabeledValue<JDBCStoreParameters> o2) {
                    return StringUtils.compare((String)o1.getLabel(), (String)o2.getLabel());
                }
            });
            DefaultListModel<LabeledValue> tablesModel = new DefaultListModel<LabeledValue>();
            for (LabeledValue labeledValue : tables) {
                tablesModel.addElement(labeledValue);
            }
            this.lstDatabaseTables.setModel(tablesModel);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't update list of database tables.", (Throwable)ex);
        }
    }

    private void doUpdateTableName() {
        switch (this.tabStores.getSelectedIndex()) {
            case 0: {
                TreePath selected = this.treeLayers.getSelectionPath();
                FLayer layer = (FLayer)selected.getLastPathComponent();
                if (!(layer instanceof SingleLayer)) break;
                this.txtTableName.setText(layer.getName());
                break;
            }
            case 1: {
                int[] selecteds = this.lstTables.getSelectedIndices();
                if (selecteds.length > 1) {
                    this.txtTableName.setText("");
                    this.txtTableName.setEnabled(false);
                    break;
                }
                this.txtTableName.setEnabled(true);
                LabeledValue item = (LabeledValue)this.lstTables.getSelectedValue();
                if (item == null) break;
                this.txtTableName.setText(item.getLabel());
                break;
            }
            case 2: {
                int[] dbselecteds = this.lstTables.getSelectedIndices();
                if (dbselecteds.length > 1) {
                    this.txtTableName.setText("");
                    this.txtTableName.setEnabled(false);
                    break;
                }
                this.txtTableName.setEnabled(true);
                LabeledValue item = (LabeledValue)this.lstDatabaseTables.getSelectedValue();
                if (item == null) break;
                this.txtTableName.setText(item.getLabel());
                break;
            }
        }
    }

    public List<LabeledValue<DataStoreParameters>> getDataStoreParameters() {
        switch (this.tabStores.getSelectedIndex()) {
            case 0: {
                TreePath selectedPath = this.treeLayers.getSelectionPath();
                FLayer layer = (FLayer)selectedPath.getLastPathComponent();
                if (layer instanceof SingleLayer) {
                    DataStore store = ((SingleLayer)layer).getDataStore();
                    DataStoreParameters params = store.getParameters();
                    return Collections.singletonList(new LabeledValueImpl(store.getName(), (Object)params));
                }
                return Collections.EMPTY_LIST;
            }
            case 1: {
                int[] selectedsTables;
                ArrayList<LabeledValue<DataStoreParameters>> parameters = new ArrayList<LabeledValue<DataStoreParameters>>();
                ListModel tablesModel = this.lstTables.getModel();
                for (int selected : selectedsTables = this.lstTables.getSelectedIndices()) {
                    LabeledValue selectedTable = (LabeledValue)tablesModel.getElementAt(selected);
                    parameters.add((LabeledValue<DataStoreParameters>)new LabeledValueImpl(selectedTable.getLabel(), (Object)((FeatureStore)selectedTable.getValue()).getParameters()));
                }
                return parameters;
            }
            case 2: {
                int[] dbselectedsTables;
                ArrayList<LabeledValue<DataStoreParameters>> dbparameters = new ArrayList<LabeledValue<DataStoreParameters>>();
                ListModel dbtablesModel = this.lstDatabaseTables.getModel();
                for (int selected : dbselectedsTables = this.lstDatabaseTables.getSelectedIndices()) {
                    LabeledValue selectedTable = (LabeledValue)dbtablesModel.getElementAt(selected);
                    dbparameters.add((LabeledValue<DataStoreParameters>)new LabeledValueImpl(selectedTable.getLabel(), selectedTable.getValue()));
                }
                return dbparameters;
            }
        }
        return Collections.EMPTY_LIST;
    }
}

