/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.gui.styling.SymbolSelector;
import org.gvsig.app.project.documents.view.legend.gui.ISymbolSelector;
import org.gvsig.gui.beans.DefaultBean;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JButton;
import org.gvsig.gui.beans.swing.JNumberSpinner;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IArrowMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IArrowDecoratorStyle;

public class ArrowDecorator
extends DefaultBean
implements ActionListener {
    private JCheckBox chkFlipAll;
    private JCheckBox chkFlipFirst;
    private JRadioButton rdBtnFollowLine;
    private JRadioButton rdBtnFixedAngle;
    private JNumberSpinner incrPositionCount;
    private JNumberSpinner incrSharpness;
    private JCheckBox chkUseDecorator;
    private IMarkerSymbol marker;
    private JNumberSpinner incrSize;
    private JButton btnOpenSymbolSelector;

    public ArrowDecorator() {
        this.initialize();
    }

    private void initialize() {
        this.setName(Messages.getText((String)"arrow_decorator"));
        this.setLayout(new BorderLayout(10, 10));
        this.chkUseDecorator = new JCheckBox(Messages.getText((String)"use_decorator"));
        JPanel aux = new JPanel(new FlowLayout(0));
        GridBagLayoutPanel pnlTopOptions = new GridBagLayoutPanel();
        pnlTopOptions.addComponent((Component)this.chkUseDecorator);
        this.incrSize = new JNumberSpinner(0, 5, 0, Integer.MAX_VALUE, 1);
        pnlTopOptions.addComponent(Messages.getText((String)"size"), (Component)this.incrSize);
        this.incrSharpness = new JNumberSpinner(0, 5, 0, Integer.MAX_VALUE, 1);
        pnlTopOptions.addComponent(Messages.getText((String)"arrow_sharpness"), (Component)this.incrSharpness);
        JPanel aux2 = new JPanel(new FlowLayout(0, 0, 0));
        this.incrPositionCount = new JNumberSpinner(0, 5, 0, Integer.MAX_VALUE, 1);
        aux2.add((Component)this.incrPositionCount);
        JPanel aux3 = new JPanel(new FlowLayout(0, 5, 0));
        aux3.add((Component)this.getBtnOpenSymbolSelector());
        aux2.add(aux3);
        pnlTopOptions.addComponent(Messages.getText((String)"number_of_positions") + ":", (Component)aux2);
        aux.add((Component)pnlTopOptions);
        this.add(aux, "North");
        aux = new JPanel(new BorderLayout(5, 5));
        aux2 = new JPanel(new FlowLayout(0));
        GridBagLayoutPanel pnlFlip = new GridBagLayoutPanel();
        pnlFlip.setBorder((Border)BorderFactory.createTitledBorder(Messages.getText((String)"flip") + ":"));
        this.chkFlipAll = new JCheckBox(Messages.getText((String)"flip_all"));
        pnlFlip.addComponent((Component)this.chkFlipAll);
        this.chkFlipFirst = new JCheckBox(Messages.getText((String)"flip_first"));
        pnlFlip.addComponent((Component)this.chkFlipFirst);
        aux2.add((Component)pnlFlip);
        GridBagLayoutPanel pnlRotation = new GridBagLayoutPanel();
        pnlRotation.setBorder((Border)BorderFactory.createTitledBorder(Messages.getText((String)"rotation") + ":"));
        this.rdBtnFollowLine = new JRadioButton(Messages.getText((String)"rotate_symbol_to_follow_line_angle"));
        pnlRotation.addComponent((Component)this.rdBtnFollowLine);
        this.rdBtnFixedAngle = new JRadioButton(Messages.getText((String)"keep_symbol_at_fixed_angle_to_page"));
        pnlRotation.addComponent((Component)this.rdBtnFixedAngle);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rdBtnFixedAngle);
        group.add(this.rdBtnFollowLine);
        aux2.add((Component)pnlRotation);
        this.chkUseDecorator.addActionListener(this);
        this.incrPositionCount.addActionListener((ActionListener)this);
        this.incrSharpness.addActionListener((ActionListener)this);
        this.incrSize.addActionListener((ActionListener)this);
        this.chkFlipFirst.addActionListener(this);
        this.chkFlipAll.addActionListener(this);
        this.rdBtnFixedAngle.addActionListener(this);
        this.rdBtnFollowLine.addActionListener(this);
        aux.add((Component)aux2, "Center");
        this.add(aux, "Center");
    }

    public void setArrowDecoratorStyle(IArrowDecoratorStyle ads) {
        this.chkUseDecorator.setSelected(ads != null);
        if (ads == null) {
            ads = SymbologyLocator.getSymbologyManager().createArrowDecoratorStyle();
        }
        this.marker = ads.getMarker();
        if (this.marker instanceof IArrowMarkerSymbol) {
            IArrowMarkerSymbol arrow = (IArrowMarkerSymbol)this.marker;
            this.incrSharpness.setDouble(arrow.getSharpness());
        }
        this.incrSize.setDouble(this.marker.getSize());
        this.incrPositionCount.setInteger(ads.getArrowMarkerCount());
        this.chkFlipAll.setSelected(ads.isFlipAll());
        this.chkFlipFirst.setSelected(ads.isFlipFirst());
        this.rdBtnFollowLine.setSelected(ads.isFollowLineAngle());
    }

    public IArrowDecoratorStyle getArrowDecoratorStyle() {
        if (!this.chkUseDecorator.isSelected()) {
            return null;
        }
        IArrowDecoratorStyle ads = SymbologyLocator.getSymbologyManager().createArrowDecoratorStyle();
        if (this.marker == null) {
            this.marker = ads.getMarker();
        }
        if (this.marker instanceof IArrowMarkerSymbol) {
            IArrowMarkerSymbol arrow = (IArrowMarkerSymbol)this.marker;
            arrow.setSharpness(this.incrSharpness.getDouble());
        }
        this.marker.setSize(this.incrSize.getDouble());
        ads.setMarker(this.marker);
        ads.setArrowMarkerCount(this.incrPositionCount.getInteger());
        ads.setFlipAll(this.chkFlipAll.isSelected());
        ads.setFlipFirst(this.chkFlipFirst.isSelected());
        ads.setFollowLineAngle(this.rdBtnFollowLine.isSelected());
        return ads;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent c = (JComponent)e.getSource();
        if (c.equals(this.getBtnOpenSymbolSelector())) {
            ISymbolSelector se = SymbolSelector.createSymbolSelector(this.marker, 1);
            PluginServices.getMDIManager().addWindow((IWindow)se);
            this.marker = (IMarkerSymbol)se.getSelectedObject();
        }
        boolean isArrow = this.marker instanceof IArrowMarkerSymbol;
        this.incrSharpness.setEnabled(isArrow);
        this.callValueChanged(this.getArrowDecoratorStyle());
    }

    private JButton getBtnOpenSymbolSelector() {
        if (this.btnOpenSymbolSelector == null) {
            this.btnOpenSymbolSelector = new JButton();
            this.btnOpenSymbolSelector.setText(Messages.getText((String)"choose_symbol"));
            this.btnOpenSymbolSelector.addActionListener((ActionListener)this);
        }
        return this.btnOpenSymbolSelector;
    }
}

