/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.gvsig.gui.ColorTablePainter;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.swing.SymbologySwingLocator;

public class ColorSchemeSelector {
    private List<ColorTablePainter> colorTables = new ArrayList<ColorTablePainter>();
    private final JComboBox wrappedComboBox;

    public ColorSchemeSelector(final JComboBox wrappedComboBox, boolean interpolateValues) {
        this.wrappedComboBox = wrappedComboBox;
        this.wrappedComboBox.removeAllItems();
        this.wrappedComboBox.setPreferredSize(new Dimension(150, 20));
        for (ActionListener l : this.wrappedComboBox.getActionListeners()) {
            this.wrappedComboBox.removeActionListener(l);
        }
        this.colorTables = SymbologySwingLocator.getSwingManager().createColorTables();
        if (this.colorTables != null) {
            for (int i = 0; i < this.colorTables.size(); ++i) {
                ColorTablePainter colorTable = this.colorTables.get(i);
                wrappedComboBox.addItem(colorTable);
            }
            this.wrappedComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorSchemeSelector.this.doUpdateToolTip();
                }
            });
            this.wrappedComboBox.setRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    ColorTablePainter colorTable = (ColorTablePainter)value;
                    ColorSchemeItemPainter paintItem = new ColorSchemeItemPainter(colorTable.getTableName(), colorTable, isSelected);
                    paintItem.setPreferredSize(wrappedComboBox.getPreferredSize());
                    return paintItem;
                }
            });
        }
    }

    private void doUpdateToolTip() {
        ColorTablePainter colorTable = (ColorTablePainter)this.wrappedComboBox.getSelectedItem();
        if (colorTable != null) {
            this.wrappedComboBox.setToolTipText(colorTable.getTableName());
        } else {
            this.wrappedComboBox.setToolTipText(Messages.getText((String)"select_a_color_scheme"));
        }
    }

    public Color[] getSelectedColors() {
        ColorTablePainter colorTable = (ColorTablePainter)this.wrappedComboBox.getSelectedItem();
        if (colorTable == null) {
            return null;
        }
        return colorTable.getColors();
    }

    public void setSelectedColors(Color[] colors) {
        if (colors == null) {
            this.wrappedComboBox.setSelectedIndex(0);
            return;
        }
        this.colorTables.clear();
        for (int i = 0; i < this.wrappedComboBox.getItemCount(); ++i) {
            this.colorTables.add((ColorTablePainter)this.wrappedComboBox.getItemAt(i));
        }
        int n = 0;
        int colorsCode = this.getCode(colors);
        for (ColorTablePainter colorTable : this.colorTables) {
            Color[] curcolors = colorTable.getColors();
            if (this.getCode(curcolors) == colorsCode) {
                this.wrappedComboBox.setSelectedIndex(n);
                this.wrappedComboBox.repaint();
                return;
            }
            ++n;
        }
        if (this.wrappedComboBox.getItemCount() > 0) {
            this.wrappedComboBox.setSelectedItem(0);
        }
    }

    private int getCode(Color[] table) {
        StringBuilder builder = new StringBuilder();
        for (Color color : table) {
            builder.append(color.getRed());
            builder.append(color.getGreen());
            builder.append(color.getBlue());
            builder.append(color.getAlpha());
        }
        return builder.toString().hashCode();
    }

    private class ColorSchemeItemPainter
    extends JComponent {
        private static final long serialVersionUID = -6448740563809113949L;
        private boolean isSelected = false;
        private ColorTablePainter colorTablePaint = null;

        public ColorSchemeItemPainter(String name, ColorTablePainter colorTablePaint, boolean isSelected) {
            this.colorTablePaint = colorTablePaint;
            this.isSelected = isSelected;
            this.setToolTipText(name);
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.isSelected) {
                Color color1 = new Color(89, 153, 229);
                Color color2 = new Color(31, 92, 207);
                g2.setPaint(new GradientPaint(0.0f, 1.0f, color1, 0.0f, this.getHeight() - 1, color2, false));
                g2.fillRect(0, 1, this.getWidth(), this.getHeight() - 1);
                g2.setColor(new Color(61, 123, 218));
                g2.drawLine(0, 0, this.getWidth(), 0);
                g2.setColor(Color.white);
            } else {
                g2.setColor(Color.white);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2.setColor(Color.black);
            }
            this.colorTablePaint.paint(g2, this.isSelected);
        }
    }
}

