/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.gui.styling.AbstractTypeSymbolEditor;
import org.gvsig.app.gui.styling.SymbolSelector;
import org.gvsig.app.project.documents.view.legend.gui.ISymbolSelector;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JButton;
import org.gvsig.gui.beans.swing.JNumberSpinner;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IMask;

public class Mask
extends JPanel {
    private static final long serialVersionUID = 101766990165772454L;
    private JButton btnHaloSymbol;
    private JRadioButton rdBtnHalo;
    private JRadioButton rdBtnNone;
    private JNumberSpinner txtHaloSize;
    private IFillSymbol fill;
    private AbstractTypeSymbolEditor owner;
    private ActionListener action = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Mask.this.owner.fireSymbolChangedEvent();
        }
    };

    public Mask(AbstractTypeSymbolEditor owner) {
        this.setName(Messages.getText((String)"mask"));
        this.owner = owner;
        GridBagLayoutPanel aux = new GridBagLayoutPanel();
        aux.setBorder((Border)BorderFactory.createTitledBorder(Messages.getText((String)"style")));
        JPanel stylePanel = new JPanel(new GridLayout(2, 1));
        stylePanel.add(this.getRdNone());
        stylePanel.add(this.getRdHalo());
        aux.addComponent((Component)stylePanel);
        ButtonGroup group = new ButtonGroup();
        group.add(this.getRdNone());
        group.add(this.getRdHalo());
        JPanel aux2 = new JPanel(new FlowLayout(3, 5, 5));
        aux2.add(new JLabel(Messages.getText((String)"size") + ":"));
        aux2.add((Component)this.getTxtHaloSize());
        aux2.add((Component)this.getBtnHaloSymbol());
        this.getRdNone().addActionListener(this.action);
        this.getRdHalo().addActionListener(this.action);
        this.getTxtHaloSize().addActionListener(this.action);
        this.add((Component)aux);
        this.add(aux2);
    }

    private JNumberSpinner getTxtHaloSize() {
        if (this.txtHaloSize == null) {
            this.txtHaloSize = new JNumberSpinner(0.0, 5, 0.0, Double.MAX_VALUE, 1.0);
        }
        return this.txtHaloSize;
    }

    private JButton getBtnHaloSymbol() {
        if (this.btnHaloSymbol == null) {
            this.btnHaloSymbol = new JButton(Messages.getText((String)"symbol"));
            this.btnHaloSymbol.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ISymbolSelector symSel = SymbolSelector.createSymbolSelector(Mask.this.fill, 3);
                    PluginServices.getMDIManager().addCentredWindow((IWindow)symSel);
                    Mask.this.fill = (IFillSymbol)symSel.getSelectedObject();
                }
            });
        }
        return this.btnHaloSymbol;
    }

    private JRadioButton getRdHalo() {
        if (this.rdBtnHalo == null) {
            this.rdBtnHalo = new JRadioButton(Messages.getText((String)"halo"));
        }
        return this.rdBtnHalo;
    }

    private JRadioButton getRdNone() {
        if (this.rdBtnNone == null) {
            this.rdBtnNone = new JRadioButton(Messages.getText((String)"none"));
            this.rdBtnNone.setSelected(true);
        }
        return this.rdBtnNone;
    }

    public void setModel(IMask mask) {
        if (mask != null) {
            this.getTxtHaloSize().setDouble(mask.getSize());
            this.fill = mask.getFillSymbol();
        }
        this.getRdHalo().setSelected(mask != null);
    }

    public IMask getMask() {
        if (!this.getRdHalo().isSelected()) {
            return null;
        }
        IMask mask = SymbologyLocator.getSymbologyManager().createMask();
        if (this.fill == null) {
            this.fill = (IFillSymbol)MapContextLocator.getSymbolManager().createSymbol("fill");
        }
        mask.setFillSymbol(this.fill);
        mask.setSize(this.getTxtHaloSize().getDouble());
        return mask;
    }
}

