/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PatternEditor
extends JPanel {
    private static final long serialVersionUID = 4393880700290565871L;
    private static final int NULL_STATE = 0;
    private static final int EMPTY_STATE = 1;
    private static final int FILL_STATE = 2;
    private static final int END_MARK_STATE = 3;
    private int dividers = 9;
    private int subDividersPerDivider = 5;
    private int separations = this.dividers * this.subDividersPerDivider;
    private int vGap = 5;
    private int hGap = 5;
    private float[] dash;
    private int[] states = new int[this.separations];
    private MyMouseListener mouseBehavior = new MyMouseListener();
    private Rectangle bounds;
    private int width;
    private int height;
    private int halfHeight;
    private int separation;
    private ArrayList<ActionListener> listeners = new ArrayList();

    public PatternEditor() {
        this.addMouseListener(this.mouseBehavior);
        this.addMouseMotionListener(this.mouseBehavior);
        for (int i = 0; i < this.states.length; ++i) {
            this.states[i] = 0;
        }
        this.states[0] = 3;
    }

    public float[] getDash() {
        return this.dash;
    }

    public void setDash(float[] dash) {
        this.dash = dash;
        this.obtain_states(dash);
        this.repaint();
    }

    private void obtain_states(float[] dash) {
        int pos = 0;
        if (dash == null) {
            return;
        }
        for (int i = 0; i < dash.length; ++i) {
            int j;
            if (i % 2 == 0) {
                j = 0;
                while ((float)j < dash[i]) {
                    this.states[pos] = 2;
                    ++pos;
                    ++j;
                }
                continue;
            }
            j = 0;
            while ((float)j < dash[i]) {
                this.states[pos] = 1;
                ++pos;
                ++j;
            }
        }
        this.states[pos] = 3;
    }

    private void create_Dash() {
        if (this.states[0] == 0) {
            this.dash = null;
        } else {
            int i;
            int divisions = 1;
            boolean firstfilled = true;
            if (this.states[0] == 1) {
                ++divisions;
                firstfilled = false;
            }
            int k = 1;
            if (this.states[0] != 3) {
                while (this.states[k] != 3) {
                    if (this.states[k] != this.states[k - 1]) {
                        ++divisions;
                    }
                    ++k;
                }
            }
            int pos = 0;
            if (divisions == 1) {
                this.dash = null;
            } else {
                this.dash = new float[divisions];
                if (!firstfilled) {
                    this.dash[0] = 0.0f;
                    ++pos;
                    firstfilled = true;
                }
                this.dash[pos] = 1.0f;
                i = 1;
                while (this.states[i] != 3) {
                    if (this.states[i] == this.states[i - 1]) {
                        int n = pos;
                        this.dash[n] = this.dash[n] + 1.0f;
                    } else {
                        this.dash[++pos] = 1.0f;
                    }
                    ++i;
                }
            }
            for (i = 0; this.dash != null && i < this.dash.length; ++i) {
                System.out.print(this.dash[i] + " ");
            }
            System.out.print("\n");
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).actionPerformed(new ActionEvent(this, 1001, "Released"));
        }
    }

    public void clear_Dash() {
        this.dash = null;
        for (int i = 0; i < this.states.length; ++i) {
            this.states[i] = 0;
        }
        this.states[0] = 3;
        this.repaint();
        this.create_Dash();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void paintComponent(Graphics g) {
        int i;
        super.paintComponent(g);
        this.bounds = this.getBounds();
        this.width = this.bounds.width;
        this.height = this.bounds.height - 2 * this.vGap;
        this.halfHeight = this.height / 2;
        this.separation = this.width / this.separations;
        for (i = 0; i <= this.separations; ++i) {
            if (i % this.subDividersPerDivider == 0) {
                g.drawLine(this.hGap + this.separation * i, this.vGap, this.hGap + this.separation * i, this.vGap + this.halfHeight - 3);
                continue;
            }
            g.drawLine(this.hGap + this.separation * i, this.vGap + this.halfHeight / 2, this.hGap + this.separation * i, this.vGap + this.halfHeight - 3);
        }
        i = 0;
        while (true) {
            block10: {
                if (i >= this.states.length) {
                    this.bounds.setLocation(0, 0);
                    g.drawRect(this.hGap, this.vGap + this.height / 2, this.separation * this.separations, this.halfHeight);
                    return;
                }
                switch (this.states[i]) {
                    case 3: {
                        g.setColor(Color.GRAY);
                        break;
                    }
                    case 0: {
                        break block10;
                    }
                    case 2: {
                        g.setColor(Color.BLACK);
                        break;
                    }
                    case 1: {
                        g.setColor(Color.WHITE);
                    }
                }
                this.bounds.setLocation(0, 0);
                g.fillRect(this.hGap + this.separation * i, this.vGap + this.height / 2, this.separation, this.halfHeight);
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        final PatternEditor pe1 = new PatternEditor();
        final PatternEditor pe2 = new PatternEditor();
        JPanel content = new JPanel(new GridLayout(2, 1));
        pe1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pe2.setDash(pe1.getDash());
            }
        });
        content.add(pe1);
        content.add(pe2);
        f.setContentPane(content);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }

    public void addActionListener(ActionListener patternChange) {
        this.listeners.add(patternChange);
    }

    private class MyMouseListener
    implements MouseListener,
    MouseMotionListener {
        private Point initialPoint = null;
        private Point endPoint = null;

        private MyMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.initialPoint = this.getPoint(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.initialPoint = this.getPoint(e);
            if (this.isValidPoint(this.initialPoint)) {
                if (PatternEditor.this.states[this.getRect(this.initialPoint)] == 1) {
                    ((PatternEditor)PatternEditor.this).states[this.getRect((Point)this.initialPoint)] = 2;
                } else if (PatternEditor.this.states[this.getRect(this.initialPoint)] == 2) {
                    ((PatternEditor)PatternEditor.this).states[this.getRect((Point)this.initialPoint)] = 1;
                }
                PatternEditor.this.repaint();
                PatternEditor.this.create_Dash();
            }
        }

        private Point getPoint(MouseEvent e) {
            Point p = new Point();
            Point p2 = e.getPoint();
            return new Point(p2.x - p.x, p2.y - p.y);
        }

        private synchronized void doIt() {
            if (!this.isValidPoint(this.endPoint) || !this.isValidPoint(this.initialPoint)) {
                return;
            }
            if (this.isValidPoint(this.endPoint) && this.isValidPoint(this.initialPoint)) {
                int stateIndex = this.getRect(this.initialPoint);
                if (stateIndex >= PatternEditor.this.separations) {
                    return;
                }
                switch (PatternEditor.this.states[stateIndex]) {
                    case 0: 
                    case 3: {
                        this.enlarge();
                        break;
                    }
                    case 2: {
                        this.swap();
                    }
                }
                PatternEditor.this.repaint();
                PatternEditor.this.create_Dash();
            }
        }

        private void swap() {
            if (!this.isValidPoint(this.endPoint) || !this.isValidPoint(this.initialPoint)) {
                return;
            }
            if (PatternEditor.this.states[this.getRect(this.endPoint)] != 1) {
                return;
            }
            ((PatternEditor)PatternEditor.this).states[this.getRect((Point)this.endPoint)] = 2;
        }

        private synchronized void enlarge() {
            if (!this.isValidPoint(this.endPoint) || !this.isValidPoint(this.initialPoint)) {
                return;
            }
            int index = this.getRect(this.endPoint);
            if (index >= PatternEditor.this.separations) {
                return;
            }
            if (this.isValidPoint(this.endPoint) && this.isValidPoint(this.initialPoint)) {
                int i;
                for (i = index - 1; i >= 0; --i) {
                    if (PatternEditor.this.states[i] == 2) continue;
                    ((PatternEditor)PatternEditor.this).states[i] = 1;
                }
                for (i = index + 1; i < PatternEditor.this.states.length; ++i) {
                    ((PatternEditor)PatternEditor.this).states[i] = 0;
                }
                ((PatternEditor)PatternEditor.this).states[index] = 3;
            }
        }

        private boolean isValidPoint(Point p) {
            return this.getRect(p) != -1;
        }

        private int getRect(Point p) {
            if (PatternEditor.this.vGap + PatternEditor.this.halfHeight <= p.y && p.y <= PatternEditor.this.vGap + 2 * PatternEditor.this.halfHeight && PatternEditor.this.hGap <= p.x && p.x <= PatternEditor.this.hGap + PatternEditor.this.separation * PatternEditor.this.separations) {
                return (p.x - PatternEditor.this.hGap) / PatternEditor.this.separation;
            }
            return -1;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.endPoint = this.getPoint(e);
            if (this.isValidPoint(this.endPoint)) {
                this.doIt();
            }
        }
    }
}

