/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.app.gui.styling.SymbolPreviewer;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.IWarningSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.IStyle;
import org.gvsig.i18n.Messages;

public class StylePreviewer
extends SymbolPreviewer {
    private static final long serialVersionUID = -1690697926703748637L;
    private int hGap;
    private int vGap;
    private IStyle style;
    private boolean showOutline;

    public StylePreviewer(MutableObject<Feature> feature) {
        super(feature);
        this.initialize();
    }

    public StylePreviewer() {
        this.initialize();
    }

    private void initialize() {
        this.hGap = 5;
        this.vGap = 5;
        this.setBackground(Color.WHITE);
    }

    public IStyle getStyle() {
        return this.style;
    }

    public void setShowOutline(boolean so) {
        this.showOutline = so;
    }

    @Override
    public ISymbol getSymbol() {
        throw new Error(Messages.getText((String)"undefined_for_StylePreviewer_use") + " getStyle() " + Messages.getText((String)"instead"));
    }

    @Override
    public void setSymbol(ISymbol symbol) {
        throw new Error(Messages.getText((String)"undefined_for_StylePreviewer_use") + " setStyle(IStyle) " + Messages.getText((String)"instead"));
    }

    public void setStyle(IStyle style) {
        this.style = style;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle r = this.getBounds();
        g2.translate(this.hGap, this.vGap);
        r = new Rectangle(0, 0, (int)(r.getWidth() - (double)(this.hGap * 2)), (int)(r.getHeight() - (double)(this.vGap * 2)));
        if (this.style != null) {
            try {
                if (this.showOutline) {
                    this.style.drawOutline(g2, r);
                }
                this.style.drawInsideRectangle(g2, r);
            }
            catch (SymbolDrawingException e) {
                if (e.getType() == 0) {
                    try {
                        IWarningSymbol warning = MapContextLocator.getSymbolManager().getWarningSymbol(SymbolDrawingException.STR_UNSUPPORTED_SET_OF_SETTINGS, "", 0);
                        warning.drawInsideRectangle(g2, null, r);
                    }
                    catch (SymbolDrawingException warning) {}
                }
                throw new Error(Messages.getText((String)"symbol_shapetype_mismatch"));
            }
        } else {
            String noneSelected = "[" + Messages.getText((String)"preview_not_available") + "]";
            FontMetrics fm = g2.getFontMetrics();
            int lineWidth = fm.stringWidth(noneSelected);
            float scale = (float)r.getWidth() / (float)lineWidth;
            Font f = g2.getFont();
            float fontSize = (float)f.getSize() * scale;
            g2.setFont(f.deriveFont(fontSize));
            g2.drawString(noneSelected, (float)r.x * scale - (float)(this.hGap / 2), (float)(r.height / 2) + (float)this.vGap * scale);
        }
    }

    public int getHGap() {
        return this.hGap;
    }

    public int getVGap() {
        return this.vGap;
    }
}

