/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.swing.impl.panel.format;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.wmts.swing.impl.wizard.WMTSParametersListModel;

public class IFormatsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane jScrollImageFormats = null;
    private JList lstImageFormats = null;
    private JScrollPane jScrollInfoFormats = null;
    private JList lstInfoFormats = null;
    private JScrollPane jScrollLstSrs = null;
    private JList lstSRSs = null;
    private JPanel jPanelImageFormats = null;
    private JPanel jPanelInfoFormats = null;
    private JPanel jPanelLstSrs = null;
    private JCheckBox chkTransparency = null;
    private final Supplier<MapContext> mapContext;
    private JButton btnSrsToView;

    public IFormatsPanel(Supplier<MapContext> mapContext) {
        this.mapContext = mapContext;
        this.init();
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.anchor = 10;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getJPanelImageFormats(), gridBagConstraints1);
        gridBagConstraints1.gridy = 1;
        this.add((Component)this.getJPanelLstSrs(), gridBagConstraints1);
        gridBagConstraints1.gridy = 2;
        this.add((Component)this.getJPanelInfoFormats(), gridBagConstraints1);
    }

    private JPanel getJPanelInfoFormats() {
        if (this.jPanelInfoFormats == null) {
            this.jPanelInfoFormats = new JPanel();
            this.jPanelInfoFormats.setLayout(new GridBagLayout());
            this.jPanelInfoFormats.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"select_info_formats"), 0, 0, null, null));
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.anchor = 10;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
            this.jPanelInfoFormats.add((Component)this.getJScrollInfoFormats(), gridBagConstraints1);
        }
        return this.jPanelInfoFormats;
    }

    private JPanel getJPanelLstSrs() {
        if (this.jPanelLstSrs == null) {
            this.jPanelLstSrs = new JPanel();
            this.jPanelLstSrs.setLayout(new GridBagLayout());
            this.jPanelLstSrs.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"seleccionar_srs"), 0, 0, null, null));
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.anchor = 10;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            this.jPanelLstSrs.add((Component)this.getJScrollLstSrs(), gridBagConstraints1);
            gridBagConstraints1.fill = 0;
            gridBagConstraints1.anchor = 11;
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints1.weighty = 0.0;
            this.jPanelLstSrs.add((Component)this.getBtnSrsToView(), gridBagConstraints1);
        }
        return this.jPanelLstSrs;
    }

    private JButton getBtnSrsToView() {
        if (this.btnSrsToView == null) {
            MapContext mc;
            Image icon = IconThemeHelper.getImage((String)"addlayer-crstoview");
            this.btnSrsToView = new JButton();
            this.btnSrsToView.setIcon(new ImageIcon(icon));
            this.btnSrsToView.setEnabled(false);
            if (this.mapContext != null && (mc = this.mapContext.get()) != null) {
                this.btnSrsToView.setEnabled(!mc.hasLayers());
                this.btnSrsToView.addActionListener(e -> {
                    IProjection proj;
                    String srs;
                    if (!mc.hasLayers() && StringUtils.isNotBlank((CharSequence)(srs = (String)this.lstSRSs.getSelectedValue())) && (proj = CRSFactory.getCRS((String)srs)) != null) {
                        mc.setProjection(proj);
                    }
                });
            }
        }
        return this.btnSrsToView;
    }

    private JPanel getJPanelImageFormats() {
        if (this.jPanelImageFormats == null) {
            this.jPanelImageFormats = new JPanel();
            this.jPanelImageFormats.setLayout(new GridBagLayout());
            this.jPanelImageFormats.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"select_formats"), 0, 0, null, null));
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.anchor = 10;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
            this.jPanelImageFormats.add((Component)this.getJScrollImageFormats(), gridBagConstraints1);
        }
        return this.jPanelImageFormats;
    }

    private JScrollPane getJScrollInfoFormats() {
        if (this.jScrollInfoFormats == null) {
            this.jScrollInfoFormats = new JScrollPane();
            this.jScrollInfoFormats.setViewportView(this.getLstInfoFormats());
        }
        return this.jScrollInfoFormats;
    }

    private JScrollPane getJScrollImageFormats() {
        if (this.jScrollImageFormats == null) {
            this.jScrollImageFormats = new JScrollPane();
            this.jScrollImageFormats.setViewportView(this.getLstImageFormats());
        }
        return this.jScrollImageFormats;
    }

    public JList getLstImageFormats() {
        if (this.lstImageFormats == null) {
            this.lstImageFormats = new JList();
            this.lstImageFormats.setSelectionMode(0);
        }
        return this.lstImageFormats;
    }

    public JList getLstInfoFormats() {
        if (this.lstInfoFormats == null) {
            this.lstInfoFormats = new JList();
            this.lstInfoFormats.setSelectionMode(0);
        }
        return this.lstInfoFormats;
    }

    public JList getLstSRSs() {
        if (this.lstSRSs == null) {
            this.lstSRSs = new JList();
            this.lstSRSs.setModel(new WMTSParametersListModel());
            this.lstSRSs.setSelectionMode(0);
        }
        return this.lstSRSs;
    }

    private JScrollPane getJScrollLstSrs() {
        if (this.jScrollLstSrs == null) {
            this.jScrollLstSrs = new JScrollPane();
            this.jScrollLstSrs.setViewportView(this.getLstSRSs());
        }
        return this.jScrollLstSrs;
    }

    public JCheckBox getChkTransparency() {
        if (this.chkTransparency == null) {
            this.chkTransparency = new JCheckBox();
            this.chkTransparency.setText(Messages.getText((String)"wms_transparency"));
            this.chkTransparency.setSelected(true);
        }
        return this.chkTransparency;
    }
}

