/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.pdf.swing.impl;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.featureform.swing.JFeaturesForm;
import org.gvsig.fmap.dal.swing.AbstractDALActionFactory;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.pdf.lib.api.PDFDocument;
import org.gvsig.pdf.lib.api.PDFLocator;
import org.gvsig.pdf.lib.api.PDFManager;
import org.gvsig.pdf.swing.api.PDFSwingLocator;
import org.gvsig.pdf.swing.api.PDFSwingManager;
import org.gvsig.pdf.swing.api.PDFViewer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintFormAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrintFormAction.class);
    private final DALActionFactory.DALActionContext context;

    public PrintFormAction(DALActionFactory.DALActionContext context) {
        this.context = context;
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.putValue("ActionCommandKey", "PrintForm");
        this.putValue("ShortDescription", i18n.getTranslation("_Print_form"));
        this.putValue("SmallIcon", ToolsSwingLocator.getIconThemeManager().getCurrent().get("common-form-print"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            PDFManager pdfManager = PDFLocator.getPDFManager();
            PDFSwingManager pdfSwingManager = PDFSwingLocator.getPDFSwingManager();
            WindowManager windowManager = ToolsSwingLocator.getWindowManager();
            JFeaturesForm featuresForm = (JFeaturesForm)this.context.get("featuresform");
            if (featuresForm == null) {
                return;
            }
            this.setEnabled(false);
            JDynForm form = featuresForm.getFormset().getForm();
            String html = form.toHtml();
            PDFDocument pdfdoc = pdfManager.createPDFDocument(html);
            if (pdfdoc == null) {
                return;
            }
            PDFViewer viewer = pdfSwingManager.createPDFViewer();
            viewer.put(pdfdoc);
            viewer.setMode(0);
            JComponent comp = viewer.asJComponent();
            Dimension screensize = ToolsSwingLocator.getToolsSwingManager().getDesktopPanelSize();
            ToolsSwingUtils.ensureHeightWitdh((JComponent)comp, (int)Math.max(3 * (screensize.height / 4), ToolsSwingUtils.rows2px((int)80)), (int)Math.max(2 * (screensize.width / 4), ToolsSwingUtils.cols2px((int)20)), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
            String title = ToolsSwingUtils.makeTitle((String)"PDF", (String)form.getDefinition().getLabel(), null);
            windowManager.showWindow(comp, title, WindowManager.MODE.WINDOW);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show form", (Throwable)ex);
        }
        finally {
            this.setEnabled(true);
        }
    }

    public static class PrintFormActionFactory
    extends AbstractDALActionFactory {
        public static final String ACTION_NAME = "PrintForm";

        public PrintFormActionFactory() {
            super(ACTION_NAME);
        }

        public Action createAction(DALActionFactory.DALActionContext context) {
            return new PrintFormAction(context);
        }

        public boolean isApplicable(Object ... args) {
            if (!(args[0] instanceof DALActionFactory.DALActionContext)) {
                return false;
            }
            DALActionFactory.DALActionContext context = (DALActionFactory.DALActionContext)args[0];
            return StringUtils.equalsIgnoreCase((CharSequence)context.getName(), (CharSequence)"FormActionContext");
        }

        public static void selfRegister() {
            DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
            dalSwingManager.registerStoreAction((DALActionFactory)new PrintFormActionFactory());
        }
    }
}

