/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.pdf.swing.impl.report;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.gvsig.featureform.swing.JFeaturesForm;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.report.ReportActionFactory;
import org.gvsig.pdf.lib.api.PDFDocument;
import org.gvsig.pdf.lib.api.PDFLocator;
import org.gvsig.pdf.lib.api.PDFManager;
import org.gvsig.pdf.swing.api.PDFSwingLocator;
import org.gvsig.pdf.swing.api.PDFSwingManager;
import org.gvsig.pdf.swing.api.PDFViewer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFormReportCustomActionFactory
implements ReportActionFactory.ReportCustomActionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleFormReportCustomActionFactory.class);

    public String getName() {
        return "SimpleFormReport";
    }

    public Action createCustomAction(ActionEvent event, DALActionFactory.DALActionContext context) {
        final JFeaturesForm featuresForm = (JFeaturesForm)context.get("featuresform");
        if (featuresForm == null) {
            return null;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        AbstractAction action = new AbstractAction(i18n.getTranslation("_Simple_form")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleFormReportCustomActionFactory.this.doShowSimpleForm(featuresForm);
            }
        };
        return action;
    }

    private void doShowSimpleForm(JFeaturesForm featuresForm) {
        try {
            PDFManager pdfManager = PDFLocator.getPDFManager();
            PDFSwingManager pdfSwingManager = PDFSwingLocator.getPDFSwingManager();
            WindowManager windowManager = ToolsSwingLocator.getWindowManager();
            JDynForm form = featuresForm.getFormset().getForm();
            String html = form.toHtml();
            PDFDocument pdfdoc = pdfManager.createPDFDocument(html);
            if (pdfdoc == null) {
                return;
            }
            PDFViewer viewer = pdfSwingManager.createPDFViewer();
            viewer.put(pdfdoc);
            viewer.setMode(0);
            JComponent comp = viewer.asJComponent();
            Dimension screensize = ToolsSwingLocator.getToolsSwingManager().getDesktopPanelSize();
            ToolsSwingUtils.ensureHeightWitdh((JComponent)comp, (int)Math.max(3 * (screensize.height / 4), ToolsSwingUtils.rows2px((int)80)), (int)Math.max(2 * (screensize.width / 4), ToolsSwingUtils.cols2px((int)20)), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
            String title = ToolsSwingUtils.makeTitle((String)"Report", (String)form.getDefinition().getLabel(), null);
            windowManager.showWindow(comp, title, WindowManager.MODE.WINDOW);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show form", (Throwable)ex);
        }
    }

    public static void selfRegister() {
        DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
        dalSwingManager.registerReportsCustomAction((ReportActionFactory.ReportCustomActionFactory)new SimpleFormReportCustomActionFactory(), true);
    }
}

