/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.pdf.swing.impl.viewer;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.gvsig.pdf.lib.api.PDFDocument;
import org.gvsig.pdf.lib.api.PDFLocator;
import org.gvsig.pdf.lib.api.PDFManager;
import org.gvsig.pdf.swing.api.EmbeddedViewer;
import org.gvsig.pdf.swing.api.PDFSwingLocator;
import org.gvsig.pdf.swing.api.PDFViewer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.viewer.AbstractJViewer;
import org.gvsig.tools.swing.api.viewer.ViewerFactory;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.util.Invocable;

public class EmbeddedViewerPDF
extends AbstractJViewer
implements EmbeddedViewer<PDFDocument> {
    private PDFViewer pdfViewer;
    private JComponent pdfComponent;
    private PDFDocument currentDocument;
    private Invocable messageHandler;

    public EmbeddedViewerPDF() {
        super(null);
    }

    public EmbeddedViewerPDF(ViewerFactory factory) {
        super(factory);
    }

    public void setMessageHandler(Invocable messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void setReadOnly(boolean readonly) {
        this.pdfComponent.setEnabled(!readonly);
    }

    public boolean supportShowInWindow() {
        return true;
    }

    public Action createShowInWindowAction() {
        ShowInWindowAction action = new ShowInWindowAction();
        return action;
    }

    public void put(PDFDocument value) {
        block8: {
            if (this.pdfViewer == null) {
                return;
            }
            try {
                this.currentDocument = value;
                try {
                    this.pdfViewer.clean();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (value == null) {
                    this.pdfViewer.put(null);
                } else if (value instanceof PDFDocument) {
                    PDFDocument document = value;
                    this.pdfViewer.put(document);
                }
            }
            catch (Exception ex) {
                if (this.messageHandler == null) break block8;
                this.messageHandler.call(new Object[]{"Can't load PDF"});
            }
        }
    }

    public void clear() {
        if (this.pdfViewer == null) {
            return;
        }
        try {
            this.pdfViewer.clean();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JComponent asJComponent() {
        this.pdfViewer = PDFSwingLocator.getPDFSwingManager().createPDFViewer();
        this.pdfComponent = this.pdfViewer.asJComponent();
        return this.pdfComponent;
    }

    public void showInWindow() {
        PDFViewer viewer;
        WindowManager wmanager;
        block2: {
            wmanager = ToolsSwingLocator.getWindowManager();
            viewer = PDFSwingLocator.getPDFSwingManager().createPDFViewer();
            try {
                viewer.put(this.currentDocument);
            }
            catch (IOException ex) {
                if (this.messageHandler == null) break block2;
                this.messageHandler.call(new Object[]{"Not able to open pdf on new window."});
            }
        }
        viewer.setMode(1);
        JComponent panel = viewer.asJComponent();
        panel.setPreferredSize(new Dimension(650, 600));
        wmanager.showWindow(panel, "PDF Visor", WindowManager.MODE.WINDOW);
    }

    public void setContents(Object data) {
        if (data instanceof PDFDocument) {
            this.put((PDFDocument)data);
            return;
        }
        if (data instanceof byte[]) {
            PDFManager manager = PDFLocator.getPDFManager();
            PDFDocument doc = manager.createPDFDocument((byte[])data);
            this.put(doc);
            return;
        }
        if (data instanceof File) {
            PDFManager manager = PDFLocator.getPDFManager();
            PDFDocument doc = manager.createPDFDocument((File)data);
            this.put(doc);
            return;
        }
        if (data instanceof String) {
            PDFManager manager = PDFLocator.getPDFManager();
            PDFDocument doc = manager.createPDFDocument((String)data);
            this.put(doc);
            return;
        }
        super.setContents(data);
    }

    private class ShowInWindowAction
    extends AbstractAction {
        public ShowInWindowAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
            this.putValue("Name", "");
            this.putValue("SmallIcon", iconTheme.get("form-open-pdf"));
            this.putValue("ShortDescription", i18n.getTranslation("_Show_in_new_window"));
            this.putValue("ActionCommandKey", "ShowInWindow");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EmbeddedViewerPDF.this.showInWindow();
        }
    }
}

