/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class HiDPIUtils {
    public static void paintAtScale1x(Graphics2D g, JComponent c, Painter painter) {
        HiDPIUtils.paintAtScale1x(g, 0, 0, c.getWidth(), c.getHeight(), painter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintAtScale1x(Graphics2D g, int x, int y, int width, int height, Painter painter) {
        AffineTransform transform = g.getTransform();
        if (transform.getScaleX() == 1.0 && transform.getScaleY() == 1.0) {
            painter.paint(g, x, y, width, height, 1.0);
            return;
        }
        Rectangle2D.Double scaledRect = HiDPIUtils.scale(transform, x, y, width, height);
        try {
            g.setTransform(new AffineTransform(1.0, 0.0, 0.0, 1.0, Math.floor(scaledRect.x), Math.floor(scaledRect.y)));
            int swidth = (int)scaledRect.width;
            int sheight = (int)scaledRect.height;
            painter.paint(g, 0, 0, swidth, sheight, transform.getScaleX());
        }
        finally {
            g.setTransform(transform);
        }
    }

    private static Rectangle2D.Double scale(AffineTransform transform, int x, int y, int width, int height) {
        double dx1 = transform.getScaleX();
        double dy2 = transform.getScaleY();
        double px = (double)x * dx1 + transform.getTranslateX();
        double py = (double)y * dy2 + transform.getTranslateY();
        dx1 *= (double)width;
        dy2 *= (double)height;
        double newx = HiDPIUtils.normalize(px);
        double newy = HiDPIUtils.normalize(py);
        dx1 = HiDPIUtils.normalize(px + dx1) - newx;
        dy2 = HiDPIUtils.normalize(py + dy2) - newy;
        return new Rectangle2D.Double(newx, newy, dx1, dy2);
    }

    private static double normalize(double value) {
        return Math.floor(value + 0.25) + 0.25;
    }

    public static interface Painter {
        public void paint(Graphics2D var1, int var2, int var3, int var4, int var5, double var6);
    }
}

