/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.api.pickercontroller;

import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPickerController<T>
implements PickerController<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractPickerController.class);
    protected ChangeListenerHelper changeListenerHelper = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();
    private boolean editable = true;

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeListenerHelper.addChangeListener(listener);
    }

    @Override
    public ChangeListener[] getChangeListeners() {
        return this.changeListenerHelper.getChangeListeners();
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeListenerHelper.removeChangeListener(listener);
    }

    @Override
    public void removeAllChangeListener() {
        this.changeListenerHelper.removeAllChangeListener();
    }

    @Override
    public boolean hasChangeListeners() {
        return this.changeListenerHelper.hasChangeListeners();
    }

    protected void fireChangeEvent() {
        this.changeListenerHelper.fireEvent();
    }

    protected void fireChangeEvent(ChangeEvent event) {
        this.changeListenerHelper.fireEvent(event);
    }

    protected Object coerce(int type, Object value, Object defaultValue) {
        DataTypesManager manager = ToolsLocator.getDataTypesManager();
        DataType dataType = manager.get(type);
        try {
            Object v = dataType.coerce(value);
            return v;
        }
        catch (CoercionException ex) {
            String s = value == null ? "null" : StringUtils.abbreviate((String)value.toString(), (int)100);
            LOG.warn("Can't coerce value (" + s + ") to " + dataType.getName() + ".", (Throwable)ex);
            return defaultValue;
        }
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    protected boolean existsIcon(String name) {
        IconThemeManager iconThemeManager = ToolsSwingLocator.getIconThemeManager();
        IconTheme theme = iconThemeManager.getCurrent();
        return theme.exists(name);
    }

    protected ImageIcon getIcon(String name) {
        IconThemeManager iconThemeManager = ToolsSwingLocator.getIconThemeManager();
        IconTheme theme = iconThemeManager.getCurrent();
        ImageIcon icon = theme.get(name);
        return icon;
    }

    protected void initButton(JButton button, String iconName, ActionListener listener) {
        button.setIcon(this.getIcon(iconName));
        if (button.getText().equals("...")) {
            button.setText("");
        }
        button.addActionListener(listener);
    }

    protected void initText(JTextComponent text, ActionListener clearListener) {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.setDefaultPopupMenu(text);
        toolsSwingManager.addClearButton(text, clearListener);
        text.setEditable(false);
    }
}

