/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ChannelAgentForwarding;
import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelForwardedTCPIP;
import com.jcraft.jsch.ChannelSession;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.ChannelSubsystem;
import com.jcraft.jsch.ChannelX11;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.RequestSignal;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Vector;

public abstract class Channel
implements Runnable {
    static final int SSH_MSG_CHANNEL_OPEN_CONFIRMATION = 91;
    static final int SSH_MSG_CHANNEL_OPEN_FAILURE = 92;
    static final int SSH_MSG_CHANNEL_WINDOW_ADJUST = 93;
    static final int SSH_OPEN_ADMINISTRATIVELY_PROHIBITED = 1;
    static final int SSH_OPEN_CONNECT_FAILED = 2;
    static final int SSH_OPEN_UNKNOWN_CHANNEL_TYPE = 3;
    static final int SSH_OPEN_RESOURCE_SHORTAGE = 4;
    static int index = 0;
    private static Vector pool = new Vector();
    int id;
    volatile int recipient = -1;
    protected byte[] type = Util.str2byte("foo");
    volatile int lwsize_max;
    volatile int lwsize = this.lwsize_max = 0x100000;
    volatile int lmpsize = 16384;
    volatile long rwsize = 0L;
    volatile int rmpsize = 0;
    IO io = null;
    Thread thread = null;
    volatile boolean eof_local = false;
    volatile boolean eof_remote = false;
    volatile boolean close = false;
    volatile boolean connected = false;
    volatile boolean open_confirmation = false;
    volatile int exitstatus = -1;
    volatile int reply = 0;
    volatile int connectTimeout = 0;
    private Session session;
    int notifyme = 0;

    static Channel getChannel(String string) {
        if (string.equals("session")) {
            return new ChannelSession();
        }
        if (string.equals("shell")) {
            return new ChannelShell();
        }
        if (string.equals("exec")) {
            return new ChannelExec();
        }
        if (string.equals("x11")) {
            return new ChannelX11();
        }
        if (string.equals("auth-agent@openssh.com")) {
            return new ChannelAgentForwarding();
        }
        if (string.equals("direct-tcpip")) {
            return new ChannelDirectTCPIP();
        }
        if (string.equals("forwarded-tcpip")) {
            return new ChannelForwardedTCPIP();
        }
        if (string.equals("sftp")) {
            return new ChannelSftp();
        }
        if (string.equals("subsystem")) {
            return new ChannelSubsystem();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Channel getChannel(int n, Session session) {
        Vector vector = pool;
        synchronized (vector) {
            for (int i = 0; i < pool.size(); ++i) {
                Channel channel = (Channel)pool.elementAt(i);
                if (channel.id != n || channel.session != session) continue;
                return channel;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void del(Channel channel) {
        Vector vector = pool;
        synchronized (vector) {
            pool.removeElement(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Channel() {
        Vector vector = pool;
        synchronized (vector) {
            this.id = index++;
            pool.addElement(this);
        }
    }

    synchronized void setRecipient(int n) {
        this.recipient = n;
        if (this.notifyme > 0) {
            this.notifyAll();
        }
    }

    int getRecipient() {
        return this.recipient;
    }

    void init() throws JSchException {
    }

    public void connect() throws JSchException {
        this.connect(0);
    }

    public void connect(int n) throws JSchException {
        this.connectTimeout = n;
        try {
            this.sendChannelOpen();
            this.start();
        }
        catch (Exception exception) {
            this.connected = false;
            this.disconnect();
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            throw new JSchException(exception.toString(), exception);
        }
    }

    public void setXForwarding(boolean bl) {
    }

    public void start() throws JSchException {
    }

    public boolean isEOF() {
        return this.eof_remote;
    }

    void getData(Buffer buffer) {
        this.setRecipient(buffer.getInt());
        this.setRemoteWindowSize(buffer.getUInt());
        this.setRemotePacketSize(buffer.getInt());
    }

    public void setInputStream(InputStream inputStream) {
        this.io.setInputStream(inputStream, false);
    }

    public void setInputStream(InputStream inputStream, boolean bl) {
        this.io.setInputStream(inputStream, bl);
    }

    public void setOutputStream(OutputStream outputStream) {
        this.io.setOutputStream(outputStream, false);
    }

    public void setOutputStream(OutputStream outputStream, boolean bl) {
        this.io.setOutputStream(outputStream, bl);
    }

    public void setExtOutputStream(OutputStream outputStream) {
        this.io.setExtOutputStream(outputStream, false);
    }

    public void setExtOutputStream(OutputStream outputStream, boolean bl) {
        this.io.setExtOutputStream(outputStream, bl);
    }

    public InputStream getInputStream() throws IOException {
        int n = 32768;
        try {
            n = Integer.parseInt(this.getSession().getConfig("max_input_buffer_size"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        MyPipedInputStream myPipedInputStream = new MyPipedInputStream(32768, n);
        boolean bl = 32768 < n;
        this.io.setOutputStream(new PassiveOutputStream(myPipedInputStream, bl), false);
        return myPipedInputStream;
    }

    public InputStream getExtInputStream() throws IOException {
        int n = 32768;
        try {
            n = Integer.parseInt(this.getSession().getConfig("max_input_buffer_size"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        MyPipedInputStream myPipedInputStream = new MyPipedInputStream(32768, n);
        boolean bl = 32768 < n;
        this.io.setExtOutputStream(new PassiveOutputStream(myPipedInputStream, bl), false);
        return myPipedInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        final Channel channel = this;
        OutputStream outputStream = new OutputStream(){
            private int dataLen = 0;
            private Buffer buffer = null;
            private Packet packet = null;
            private boolean closed = false;
            byte[] b = new byte[1];

            private synchronized void init() throws IOException {
                this.buffer = new Buffer(Channel.this.rmpsize);
                this.packet = new Packet(this.buffer);
                byte[] byArray = this.buffer.buffer;
                if (byArray.length - 14 - 128 <= 0) {
                    this.buffer = null;
                    this.packet = null;
                    throw new IOException("failed to initialize the channel.");
                }
            }

            @Override
            public void write(int n) throws IOException {
                this.b[0] = (byte)n;
                this.write(this.b, 0, 1);
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                if (this.packet == null) {
                    this.init();
                }
                if (this.closed) {
                    throw new IOException("Already closed");
                }
                byte[] byArray2 = this.buffer.buffer;
                int n3 = byArray2.length;
                while (n2 > 0) {
                    int n4 = n2;
                    if (n2 > n3 - (14 + this.dataLen) - 128) {
                        n4 = n3 - (14 + this.dataLen) - 128;
                    }
                    if (n4 <= 0) {
                        this.flush();
                        continue;
                    }
                    System.arraycopy(byArray, n, byArray2, 14 + this.dataLen, n4);
                    this.dataLen += n4;
                    n += n4;
                    n2 -= n4;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void flush() throws IOException {
                if (this.closed) {
                    throw new IOException("Already closed");
                }
                if (this.dataLen == 0) {
                    return;
                }
                this.packet.reset();
                this.buffer.putByte((byte)94);
                this.buffer.putInt(Channel.this.recipient);
                this.buffer.putInt(this.dataLen);
                this.buffer.skip(this.dataLen);
                try {
                    int n = this.dataLen;
                    this.dataLen = 0;
                    Channel channel2 = channel;
                    synchronized (channel2) {
                        if (!channel.close) {
                            Channel.this.getSession().write(this.packet, channel, n);
                        }
                    }
                }
                catch (Exception exception) {
                    this.close();
                    throw new IOException(exception.toString());
                }
            }

            @Override
            public void close() throws IOException {
                if (this.packet == null) {
                    try {
                        this.init();
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
                if (this.closed) {
                    return;
                }
                if (this.dataLen > 0) {
                    this.flush();
                }
                channel.eof();
                this.closed = true;
            }
        };
        return outputStream;
    }

    void setLocalWindowSizeMax(int n) {
        this.lwsize_max = n;
    }

    void setLocalWindowSize(int n) {
        this.lwsize = n;
    }

    void setLocalPacketSize(int n) {
        this.lmpsize = n;
    }

    synchronized void setRemoteWindowSize(long l) {
        this.rwsize = l;
    }

    synchronized void addRemoteWindowSize(long l) {
        this.rwsize += l;
        if (this.notifyme > 0) {
            this.notifyAll();
        }
    }

    void setRemotePacketSize(int n) {
        this.rmpsize = n;
    }

    @Override
    public void run() {
    }

    void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.io.put(byArray, n, n2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void write_ext(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.io.put_ext(byArray, n, n2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void eof_remote() {
        this.eof_remote = true;
        try {
            this.io.out_close();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void eof() {
        if (this.eof_local) {
            return;
        }
        this.eof_local = true;
        int n = this.getRecipient();
        if (n == -1) {
            return;
        }
        try {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            packet.reset();
            buffer.putByte((byte)96);
            buffer.putInt(n);
            Channel channel = this;
            synchronized (channel) {
                if (!this.close) {
                    this.getSession().write(packet);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (this.close) {
            return;
        }
        this.close = true;
        this.eof_remote = true;
        this.eof_local = true;
        int n = this.getRecipient();
        if (n == -1) {
            return;
        }
        try {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            packet.reset();
            buffer.putByte((byte)97);
            buffer.putInt(n);
            Channel channel = this;
            synchronized (channel) {
                this.getSession().write(packet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        return this.close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disconnect(Session session) {
        Channel[] channelArray = null;
        int n = 0;
        Vector vector = pool;
        synchronized (vector) {
            channelArray = new Channel[pool.size()];
            for (int i = 0; i < pool.size(); ++i) {
                try {
                    Channel channel = (Channel)pool.elementAt(i);
                    if (channel.session != session) continue;
                    channelArray[n++] = channel;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        for (int i = 0; i < n; ++i) {
            channelArray[i].disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        try {
            Channel channel = this;
            synchronized (channel) {
                block11: {
                    if (this.connected) break block11;
                    return;
                }
                this.connected = false;
            }
            this.close();
            this.eof_local = true;
            this.eof_remote = true;
            this.thread = null;
            try {
                if (this.io != null) {
                    this.io.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            Channel.del(this);
        }
    }

    public boolean isConnected() {
        Session session = this.session;
        if (session != null) {
            return session.isConnected() && this.connected;
        }
        return false;
    }

    public void sendSignal(String string) throws Exception {
        RequestSignal requestSignal = new RequestSignal();
        requestSignal.setSignal(string);
        requestSignal.request(this.getSession(), this);
    }

    void setExitStatus(int n) {
        this.exitstatus = n;
    }

    public int getExitStatus() {
        return this.exitstatus;
    }

    void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() throws JSchException {
        Session session = this.session;
        if (session == null) {
            throw new JSchException("session is not available");
        }
        return session;
    }

    public int getId() {
        return this.id;
    }

    protected void sendOpenConfirmation() throws Exception {
        Buffer buffer = new Buffer(100);
        Packet packet = new Packet(buffer);
        packet.reset();
        buffer.putByte((byte)91);
        buffer.putInt(this.getRecipient());
        buffer.putInt(this.id);
        buffer.putInt(this.lwsize);
        buffer.putInt(this.lmpsize);
        this.getSession().write(packet);
    }

    protected void sendOpenFailure(int n) {
        try {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            packet.reset();
            buffer.putByte((byte)92);
            buffer.putInt(this.getRecipient());
            buffer.putInt(n);
            buffer.putString(Util.str2byte("open failed"));
            buffer.putString(Util.empty);
            this.getSession().write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Packet genChannelOpenPacket() {
        Buffer buffer = new Buffer(100);
        Packet packet = new Packet(buffer);
        packet.reset();
        buffer.putByte((byte)90);
        buffer.putString(this.type);
        buffer.putInt(this.id);
        buffer.putInt(this.lwsize);
        buffer.putInt(this.lmpsize);
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendChannelOpen() throws Exception {
        Session session = this.getSession();
        if (!session.isConnected()) {
            throw new JSchException("session is down");
        }
        Packet packet = this.genChannelOpenPacket();
        session.write(packet);
        int n = 2000;
        long l = System.currentTimeMillis();
        long l2 = this.connectTimeout;
        if (l2 != 0L) {
            n = 1;
        }
        Channel channel = this;
        synchronized (channel) {
            while (this.getRecipient() == -1 && session.isConnected() && n > 0) {
                if (l2 > 0L && System.currentTimeMillis() - l > l2) {
                    n = 0;
                    continue;
                }
                try {
                    long l3 = l2 == 0L ? 10L : l2;
                    this.notifyme = 1;
                    this.wait(l3);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.notifyme = 0;
                }
                --n;
            }
        }
        if (!session.isConnected()) {
            throw new JSchException("session is down");
        }
        if (this.getRecipient() == -1) {
            throw new JSchException("channel is not opened.");
        }
        if (!this.open_confirmation) {
            throw new JSchException("channel is not opened.");
        }
        this.connected = true;
    }

    class PassiveOutputStream
    extends PipedOutputStream {
        private MyPipedInputStream _sink;

        PassiveOutputStream(PipedInputStream pipedInputStream, boolean bl) throws IOException {
            super(pipedInputStream);
            this._sink = null;
            if (bl && pipedInputStream instanceof MyPipedInputStream) {
                this._sink = (MyPipedInputStream)pipedInputStream;
            }
        }

        @Override
        public void write(int n) throws IOException {
            if (this._sink != null) {
                this._sink.checkSpace(1);
            }
            super.write(n);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this._sink != null) {
                this._sink.checkSpace(n2);
            }
            super.write(byArray, n, n2);
        }
    }

    class PassiveInputStream
    extends MyPipedInputStream {
        PipedOutputStream out;

        PassiveInputStream(PipedOutputStream pipedOutputStream, int n) throws IOException {
            super(pipedOutputStream, n);
            this.out = pipedOutputStream;
        }

        PassiveInputStream(PipedOutputStream pipedOutputStream) throws IOException {
            super(pipedOutputStream);
            this.out = pipedOutputStream;
        }

        @Override
        public void close() throws IOException {
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
        }
    }

    class MyPipedInputStream
    extends PipedInputStream {
        private int BUFFER_SIZE;
        private int max_buffer_size;

        MyPipedInputStream() throws IOException {
            this.max_buffer_size = this.BUFFER_SIZE = 1024;
        }

        MyPipedInputStream(int n) throws IOException {
            this.max_buffer_size = this.BUFFER_SIZE = 1024;
            this.buffer = new byte[n];
            this.BUFFER_SIZE = n;
            this.max_buffer_size = n;
        }

        MyPipedInputStream(int n, int n2) throws IOException {
            this(n);
            this.max_buffer_size = n2;
        }

        MyPipedInputStream(PipedOutputStream pipedOutputStream) throws IOException {
            super(pipedOutputStream);
            this.max_buffer_size = this.BUFFER_SIZE = 1024;
        }

        MyPipedInputStream(PipedOutputStream pipedOutputStream, int n) throws IOException {
            super(pipedOutputStream);
            this.max_buffer_size = this.BUFFER_SIZE = 1024;
            this.buffer = new byte[n];
            this.BUFFER_SIZE = n;
        }

        public synchronized void updateReadSide() throws IOException {
            if (this.available() != 0) {
                return;
            }
            this.in = 0;
            this.out = 0;
            this.buffer[this.in++] = 0;
            this.read();
        }

        private int freeSpace() {
            int n = 0;
            if (this.out < this.in) {
                n = this.buffer.length - this.in;
            } else if (this.in < this.out) {
                n = this.in == -1 ? this.buffer.length : this.out - this.in;
            }
            return n;
        }

        synchronized void checkSpace(int n) throws IOException {
            int n2 = this.freeSpace();
            if (n2 < n) {
                int n3 = this.buffer.length - n2;
                int n4 = this.buffer.length;
                while (n4 - n3 < n) {
                    n4 *= 2;
                }
                if (n4 > this.max_buffer_size) {
                    n4 = this.max_buffer_size;
                }
                if (n4 - n3 < n) {
                    return;
                }
                byte[] byArray = new byte[n4];
                if (this.out < this.in) {
                    System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
                } else if (this.in < this.out) {
                    if (this.in != -1) {
                        System.arraycopy(this.buffer, 0, byArray, 0, this.in);
                        System.arraycopy(this.buffer, this.out, byArray, byArray.length - (this.buffer.length - this.out), this.buffer.length - this.out);
                        this.out = byArray.length - (this.buffer.length - this.out);
                    }
                } else if (this.in == this.out) {
                    System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
                    this.in = this.buffer.length;
                }
                this.buffer = byArray;
            } else if (this.buffer.length == n2 && n2 > this.BUFFER_SIZE) {
                int n5 = n2 / 2;
                if (n5 < this.BUFFER_SIZE) {
                    n5 = this.BUFFER_SIZE;
                }
                byte[] byArray = new byte[n5];
                this.buffer = byArray;
            }
        }
    }
}

