/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.nio.ByteBuffer;

public abstract class CharsetProber {
    public static final float SHORTCUT_THRESHOLD = 0.95f;
    public static final int ASCII_A = 97;
    public static final int ASCII_Z = 122;
    public static final int ASCII_A_CAPITAL = 65;
    public static final int ASCII_Z_CAPITAL = 90;
    public static final int ASCII_LT = 60;
    public static final int ASCII_GT = 62;
    public static final int ASCII_SP = 32;

    public abstract String getCharSetName();

    public abstract ProbingState handleData(byte[] var1, int var2, int var3);

    public abstract ProbingState getState();

    public abstract void reset();

    public abstract float getConfidence();

    public abstract void setOption();

    public ByteBuffer filterWithoutEnglishLetters(byte[] byArray, int n, int n2) {
        int n3;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        boolean bl = false;
        int n4 = n;
        int n5 = n + n2;
        for (n3 = n; n3 < n5; ++n3) {
            byte by = byArray[n3];
            if (!this.isAscii(by)) {
                bl = true;
                continue;
            }
            if (!this.isAsciiSymbol(by)) continue;
            if (bl && n3 > n4) {
                byteBuffer.put(byArray, n4, n3 - n4);
                byteBuffer.put((byte)32);
                n4 = n3 + 1;
                bl = false;
                continue;
            }
            n4 = n3 + 1;
        }
        if (bl && n3 > n4) {
            byteBuffer.put(byArray, n4, n3 - n4);
        }
        return byteBuffer;
    }

    public ByteBuffer filterWithEnglishLetters(byte[] byArray, int n, int n2) {
        int n3;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        boolean bl = false;
        int n4 = n;
        int n5 = n + n2;
        for (n3 = n; n3 < n5; ++n3) {
            byte by = byArray[n3];
            if (by == 62) {
                bl = false;
            } else if (by == 60) {
                bl = true;
            }
            if (!this.isAscii(by) || !this.isAsciiSymbol(by)) continue;
            if (n3 > n4 && !bl) {
                byteBuffer.put(byArray, n4, n3 - n4);
                byteBuffer.put((byte)32);
                n4 = n3 + 1;
                continue;
            }
            n4 = n3 + 1;
        }
        if (!bl && n3 > n4) {
            byteBuffer.put(byArray, n4, n3 - n4);
        }
        return byteBuffer;
    }

    private boolean isAscii(byte by) {
        return (by & 0x80) == 0;
    }

    private boolean isAsciiSymbol(byte by) {
        int n = by & 0xFF;
        return n < 65 || n > 90 && n < 97 || n > 122;
    }

    public static enum ProbingState {
        DETECTING,
        FOUND_IT,
        NOT_ME;

    }
}

