/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.awt.Color;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.db.ConnectionMgr;
import workbench.db.DbDriver;
import workbench.db.ObjectNameFilter;
import workbench.db.PasswordTrimType;
import workbench.db.postgres.PgPassReader;
import workbench.gui.profiles.ProfileKey;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.DelimiterDefinition;
import workbench.ssh.SshConfig;
import workbench.ssh.SshHostConfig;
import workbench.ssh.SshManager;
import workbench.util.CollectionUtil;
import workbench.util.FileDialogUtil;
import workbench.util.GlobalPasswordManager;
import workbench.util.StringUtil;
import workbench.util.WbCipher;
import workbench.util.WbDesCipher;
import workbench.util.WbFile;
import workbench.util.WbProperties;

public class ConnectionProfile
implements Serializable {
    public static final String PROPERTY_PROFILE_GROUP = "profileGroup";
    public static final String CRYPT_PREFIX = "@*@";
    public static final String MASTER_CRYPT_PREFIX = "$@wb@$";
    private String name;
    private String url;
    private String temporaryUrl;
    private String driverclass;
    private String username;
    private String temporaryUsername;
    private String password;
    private String driverName;
    private String group;
    private String icon;
    private boolean autocommit;
    private boolean storeCacheLocally;
    private boolean rollbackBeforeDisconnect;
    private boolean changed = true;
    private boolean groupChanged;
    private boolean isNew = true;
    private boolean usePgPass;
    private boolean storePassword = true;
    private boolean separateConnection;
    private Properties connectionProperties;
    private Properties variables;
    private String workspaceFile;
    private boolean ignoreDropErrors;
    private boolean trimCharData;
    private boolean temporaryProfile;
    private boolean oracleSysDBA;
    private boolean detectOpenTransaction;
    private boolean readOnly;
    private boolean preventNoWhere;
    private boolean confirmUpdates;
    private boolean promptForUsername;
    private Integer defaultFetchSize;
    private boolean emptyStringIsNull;
    private boolean includeNullInInsert = true;
    private boolean removeComments;
    private boolean rememberExplorerSchema;
    private boolean hideWarnings;
    private String postConnectScript;
    private String preDisconnectScript;
    private String idleScript;
    private long idleTime = 0L;
    private Color infoColor;
    private boolean copyPropsToSystem;
    private Integer connectionTimeout;
    private DelimiterDefinition alternateDelimiter;
    private ObjectNameFilter schemaFilter;
    private ObjectNameFilter catalogFilter;
    private String lastSettingsKey;
    private String macroFileName;
    private String defaultDirectory;
    private final Set<String> tags = CollectionUtil.caseInsensitiveSet();
    private SshConfig sshConfig;
    private static int nextId = 1;
    private int internalId = nextId++;

    public ConnectionProfile() {
    }

    public ConnectionProfile(String string, String string2, String string3, String string4, String string5) {
        this();
        this.setUrl(string3);
        this.setDriverclass(string2);
        this.setUsername(string4);
        this.setPassword(string5);
        this.setName(string);
        this.resetChangedFlags();
    }

    public static ConnectionProfile createEmptyProfile() {
        ConnectionProfile connectionProfile = new ConnectionProfile();
        connectionProfile.setUseSeparateConnectionPerTab(Settings.getInstance().getProfileDefaultSeparateConnection());
        connectionProfile.setStoreExplorerSchema(Settings.getInstance().getProfileDefaultStoreExplorerSchema());
        connectionProfile.setName(ResourceMgr.getString("TxtEmptyProfileName"));
        return connectionProfile;
    }

    public int internalId() {
        return this.internalId;
    }

    private void syncSettingsKey() {
        if (this.lastSettingsKey == null) {
            return;
        }
        String string = this.getSettingsKey();
        if (string == null) {
            return;
        }
        Settings.getInstance().replacePartialKey("." + this.lastSettingsKey + ".", "." + string + ".");
        this.lastSettingsKey = string;
    }

    public String getSettingsKey() {
        if (this.name == null || this.group == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("[^0-9A-Za-z]+");
        Matcher matcher = pattern.matcher(this.group);
        String string = matcher.replaceAll("").toLowerCase();
        Matcher matcher2 = pattern.matcher(this.name);
        String string2 = matcher2.replaceAll("").toLowerCase();
        String string3 = string + "." + string2;
        return string3;
    }

    public String getDefaultDirectory() {
        return this.defaultDirectory;
    }

    public void setDefaultDirectory(String string) {
        String string2 = StringUtil.trimToNull(string);
        if (this.defaultDirectory != null && string2 != null) {
            File file = new File(this.defaultDirectory);
            File file2 = new File(string2);
            if (!file.equals(file2)) {
                this.defaultDirectory = string2;
                this.changed = true;
            }
        } else {
            this.defaultDirectory = string2;
            this.changed = true;
        }
    }

    public boolean isConfigured() {
        return StringUtil.isNonBlank(this.driverclass) && StringUtil.isNonBlank(this.url) && this.url.startsWith("jdbc:");
    }

    public String getMacroFilename() {
        return this.macroFileName;
    }

    public WbFile getMacroFile() {
        if (StringUtil.isBlank(this.macroFileName)) {
            return null;
        }
        WbFile wbFile = new WbFile(FileDialogUtil.replaceConfigDir(this.macroFileName));
        if (wbFile.isAbsolute() && wbFile.exists()) {
            return wbFile;
        }
        WbFile wbFile2 = new WbFile(Settings.getInstance().getConfigDir(), this.macroFileName);
        if (wbFile2.exists() && wbFile2.isFile()) {
            return wbFile2;
        }
        return null;
    }

    public void setMacroFilename(String string) {
        if (StringUtil.stringsAreNotEqual(string, this.macroFileName)) {
            this.macroFileName = string;
            this.changed = true;
        }
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public String getTagList() {
        return StringUtil.listToString(this.tags, ',', false);
    }

    public void setTagList(String string) {
        Set<String> set = CollectionUtil.caseInsensitiveSet(StringUtil.stringToList(string, ",", true, true, false, false));
        this.changed = !this.tags.equals(set);
        this.tags.clear();
        this.tags.addAll(set);
    }

    public boolean getStoreCacheLocally() {
        return this.storeCacheLocally;
    }

    public void setStoreCacheLocally(boolean bl) {
        this.changed = bl != this.storeCacheLocally;
        this.storeCacheLocally = bl;
    }

    public boolean getPromptForUsername() {
        return this.promptForUsername;
    }

    public void setPromptForUsername(boolean bl) {
        this.changed = bl != this.promptForUsername;
        this.promptForUsername = bl;
    }

    public boolean getDetectOpenTransaction() {
        return this.detectOpenTransaction;
    }

    public void setDetectOpenTransaction(boolean bl) {
        this.changed = bl != this.detectOpenTransaction;
        this.detectOpenTransaction = bl;
    }

    public boolean isTemporaryProfile() {
        return this.temporaryProfile;
    }

    public void setTemporaryProfile(boolean bl) {
        this.temporaryProfile = bl;
    }

    public ObjectNameFilter getCatalogFilter() {
        return this.catalogFilter;
    }

    public void setCatalogFilter(ObjectNameFilter objectNameFilter) {
        if (this.catalogFilter == null && objectNameFilter == null) {
            return;
        }
        this.changed = objectNameFilter == null ? true : objectNameFilter.isModified();
        this.catalogFilter = objectNameFilter;
    }

    public ObjectNameFilter getSchemaFilter() {
        return this.schemaFilter;
    }

    public void setSchemaFilter(ObjectNameFilter objectNameFilter) {
        if (this.schemaFilter == null && objectNameFilter == null) {
            return;
        }
        this.changed = objectNameFilter == null ? true : objectNameFilter.isModified();
        this.schemaFilter = objectNameFilter;
    }

    public Color getInfoDisplayColor() {
        return this.infoColor;
    }

    public boolean isHideWarnings() {
        return this.hideWarnings;
    }

    public void setHideWarnings(boolean bl) {
        this.changed = this.hideWarnings != bl;
        this.hideWarnings = bl;
    }

    public boolean getOracleSysDBA() {
        return this.oracleSysDBA;
    }

    public void setOracleSysDBA(boolean bl) {
        this.changed = this.oracleSysDBA != bl;
        this.oracleSysDBA = bl;
    }

    public int getConnectionTimeoutValue() {
        if (this.connectionTimeout == null) {
            return 0;
        }
        return this.connectionTimeout;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer n) {
        int n2;
        int n3 = this.connectionTimeout == null ? Integer.MIN_VALUE : this.connectionTimeout;
        int n4 = n2 = n == null ? Integer.MIN_VALUE : n;
        if (n3 != n2) {
            this.connectionTimeout = n2 > 0 ? n : null;
            this.changed = true;
        }
    }

    public void setInfoDisplayColor(Color color) {
        if (this.infoColor == null && color == null) {
            return;
        }
        this.changed = this.infoColor != null && color != null ? !this.infoColor.equals(color) : true;
        this.infoColor = color;
    }

    public void setAlternateDelimiterString(String string) {
        DelimiterDefinition delimiterDefinition = new DelimiterDefinition(string);
        if (!delimiterDefinition.isStandard()) {
            this.setAlternateDelimiter(delimiterDefinition);
        }
    }

    public String getAlternateDelimiterString() {
        if (this.alternateDelimiter == null) {
            return null;
        }
        if (this.alternateDelimiter.isEmpty()) {
            return null;
        }
        return this.alternateDelimiter.getDelimiter();
    }

    public DelimiterDefinition getAlternateDelimiter() {
        if (this.alternateDelimiter == null) {
            return null;
        }
        if (this.alternateDelimiter.isEmpty()) {
            return null;
        }
        return this.alternateDelimiter;
    }

    public void setAlternateDelimiter(DelimiterDefinition delimiterDefinition) {
        if (delimiterDefinition == null && this.alternateDelimiter == null) {
            return;
        }
        if (delimiterDefinition != null && delimiterDefinition.isStandard()) {
            return;
        }
        if (!Objects.equals(delimiterDefinition, this.alternateDelimiter) || delimiterDefinition != null && delimiterDefinition.isChanged()) {
            this.alternateDelimiter = delimiterDefinition;
            this.changed = true;
        }
    }

    public boolean getCopyExtendedPropsToSystem() {
        return this.copyPropsToSystem;
    }

    public void setCopyExtendedPropsToSystem(boolean bl) {
        if (bl != this.copyPropsToSystem) {
            this.changed = true;
        }
        this.copyPropsToSystem = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        if (this.readOnly != bl) {
            this.changed = true;
        }
        this.readOnly = bl;
    }

    public void setPreventDMLWithoutWhere(boolean bl) {
        if (this.preventNoWhere != bl) {
            this.changed = true;
        }
        this.preventNoWhere = bl;
    }

    public boolean getPreventDMLWithoutWhere() {
        return this.preventNoWhere;
    }

    public boolean getTrimCharData() {
        return this.trimCharData;
    }

    public void setTrimCharData(boolean bl) {
        if (bl != this.trimCharData) {
            this.changed = true;
        }
        this.trimCharData = bl;
    }

    public boolean getStoreExplorerSchema() {
        return this.rememberExplorerSchema;
    }

    public void setStoreExplorerSchema(boolean bl) {
        if (bl != this.rememberExplorerSchema) {
            this.changed = true;
        }
        this.rememberExplorerSchema = bl;
    }

    public String getGroup() {
        if (this.group == null) {
            return ResourceMgr.getString("LblDefGroup");
        }
        return this.group;
    }

    public void setGroup(String string) {
        if (StringUtil.equalString(this.group, string)) {
            return;
        }
        this.group = string;
        this.changed = true;
        this.groupChanged = true;
        this.syncSettingsKey();
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String string) {
        if (this.icon != null && StringUtil.equalString(this.icon, string)) {
            return;
        }
        this.icon = string;
        this.changed = true;
    }

    public boolean isProfileForKey(ProfileKey profileKey) {
        ProfileKey profileKey2 = this.getKey();
        return profileKey2.equals(profileKey);
    }

    public ProfileKey getKey() {
        return new ProfileKey(this.getName(), this.getGroup());
    }

    public void setDisableUpdateTableCheck(boolean bl) {
    }

    public boolean getUseSeparateConnectionPerTab() {
        return this.separateConnection;
    }

    public void setUseSeparateConnectionPerTab(boolean bl) {
        if (this.separateConnection != bl) {
            this.changed = true;
        }
        this.separateConnection = bl;
    }

    public void setIncludeNullInInsert(boolean bl) {
        if (this.includeNullInInsert != bl) {
            this.changed = true;
        }
        this.includeNullInInsert = bl;
    }

    public boolean getIncludeNullInInsert() {
        return this.includeNullInInsert;
    }

    public void setEmptyStringIsNull(boolean bl) {
        if (this.emptyStringIsNull != bl) {
            this.changed = true;
        }
        this.emptyStringIsNull = bl;
    }

    public boolean getEmptyStringIsNull() {
        return this.emptyStringIsNull;
    }

    public void setRemoveComments(boolean bl) {
        if (this.removeComments != bl) {
            this.changed = true;
        }
        this.removeComments = bl;
    }

    public boolean getRemoveComments() {
        return this.removeComments;
    }

    public boolean getRollbackBeforeDisconnect() {
        return this.rollbackBeforeDisconnect;
    }

    public void setRollbackBeforeDisconnect(boolean bl) {
        if (bl != this.rollbackBeforeDisconnect) {
            this.changed = true;
        }
        this.rollbackBeforeDisconnect = bl;
    }

    public final void setPassword(String string) {
        if (string == null) {
            if (this.password != null) {
                this.password = null;
                if (this.storePassword) {
                    this.changed = true;
                }
            }
            return;
        }
        PasswordTrimType passwordTrimType = Settings.getInstance().getPassworTrimType();
        if (passwordTrimType == PasswordTrimType.always) {
            string = string.trim();
        } else if (passwordTrimType == PasswordTrimType.blankOnly && StringUtil.isBlank(string)) {
            string = "";
        }
        if (Settings.getInstance().getUseMasterPassword()) {
            if (!this.isEncrypted(string)) {
                string = MASTER_CRYPT_PREFIX + GlobalPasswordManager.getInstance().encrypt(string);
            }
        } else if (this.isEncrypted(string)) {
            string = this.decryptPassword(string);
        }
        if (!string.equals(this.password)) {
            this.password = string;
            if (this.storePassword) {
                this.changed = true;
            }
        }
    }

    public boolean isPasswordEncrypted() {
        return this.isEncrypted(this.password);
    }

    public String getPassword() {
        if (this.storePassword) {
            return this.password;
        }
        return null;
    }

    public boolean usePgPass() {
        return this.usePgPass;
    }

    public void setInputPassword(String string) {
        this.setPassword(string);
    }

    public String getDecryptedPassword() {
        return this.decryptPassword(this.getPassword());
    }

    public void setEncryptedPassword(String string) {
        if (this.getStorePassword()) {
            this.changed = !StringUtil.equalString(this.password, string);
            this.password = string;
        }
    }

    public String decryptPassword(String string) {
        if (StringUtil.isEmptyString(string)) {
            return "";
        }
        if (string.startsWith(CRYPT_PREFIX)) {
            WbCipher wbCipher = WbDesCipher.getInstance();
            return wbCipher.decryptString(string.substring(CRYPT_PREFIX.length()));
        }
        if (string.startsWith(MASTER_CRYPT_PREFIX)) {
            return GlobalPasswordManager.getInstance().decrypt(string.substring(MASTER_CRYPT_PREFIX.length()));
        }
        return string;
    }

    private boolean isEncrypted(String string) {
        return string.startsWith(CRYPT_PREFIX) || string.startsWith(MASTER_CRYPT_PREFIX);
    }

    public void setNew() {
        this.changed = true;
        this.isNew = true;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isChanged() {
        return this.changed || this.isNew;
    }

    public boolean isGroupChanged() {
        return this.groupChanged;
    }

    public final void resetChangedFlags() {
        this.changed = false;
        this.groupChanged = false;
        this.isNew = false;
        if (this.alternateDelimiter != null) {
            this.alternateDelimiter.resetChanged();
        }
        if (this.schemaFilter != null) {
            this.schemaFilter.resetModified();
        }
        if (this.catalogFilter != null) {
            this.catalogFilter.resetModified();
        }
        this.lastSettingsKey = this.getSettingsKey();
    }

    public String debugString() {
        return "\"" + this.getKey().toString() + "\": [user=" + DbDriver.getUsernameForLogging(this.username) + ", url=" + DbDriver.getURLForLogging(this) + ", driverClass=" + this.driverclass + ", driverName=" + this.driverName + "]";
    }

    public String toString() {
        return this.name;
    }

    public String getIdString() {
        return this.getKey().toString() + " using: " + this.driverclass;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object object) {
        try {
            ConnectionProfile connectionProfile = (ConnectionProfile)object;
            return this.getKey().equals(connectionProfile.getKey());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public void resetTemporaryUrl() {
        this.temporaryUrl = null;
    }

    public void switchToTemporaryUrl(String string) {
        this.temporaryUrl = string;
    }

    public String getActiveUrl() {
        if (StringUtil.isBlank(this.temporaryUrl)) {
            return this.url;
        }
        return this.temporaryUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public final void setUrl(String string) {
        if (string != null) {
            string = string.trim();
        }
        if (StringUtil.stringsAreNotEqual(string, this.url)) {
            this.changed = true;
        }
        this.url = string;
        this.usePgPass = (PgPassReader.isPgUrl(this.url) || PgPassReader.isGreenplumUrl(this.url)) && Settings.getInstance().usePgPassFile();
    }

    public String getDriverName() {
        return this.driverName;
    }

    public final void setDriverName(String string) {
        if (string != null && StringUtil.stringsAreNotEqual(string, this.driverName)) {
            this.driverName = string.trim();
            this.changed = true;
        }
    }

    public String getDriverclass() {
        return this.driverclass;
    }

    public final void setDriverclass(String string) {
        if (string != null && StringUtil.stringsAreNotEqual(string, this.driverclass)) {
            this.changed = true;
            this.driverclass = string.trim();
        }
    }

    public void setDriver(DbDriver dbDriver) {
        if (dbDriver != null) {
            this.setDriverName(dbDriver.getName());
            this.setDriverclass(dbDriver.getDriverClass());
        }
    }

    public String getUrlInfo() {
        if (StringUtil.isBlank(this.username)) {
            return this.url;
        }
        return this.username + "@" + this.url.replace("jdbc:", "");
    }

    public String getUsername() {
        if (this.temporaryUsername != null) {
            return this.temporaryUsername;
        }
        return this.username;
    }

    private String getPgPassPassword() {
        if (this.usePgPass()) {
            String string = System.getenv("PGPASSWORD");
            if (string != null) {
                LogMgr.logDebug(new CallerInfo(){}, "Using password from environment variable PGPASSWORD");
                return string;
            }
            PgPassReader pgPassReader = new PgPassReader(this.url, this.getLoginUser());
            LogMgr.logDebug(new CallerInfo(){}, "Using password from " + PgPassReader.getPgPassFile());
            return pgPassReader.getPasswordFromFile();
        }
        return null;
    }

    public String getLoginPassword() {
        if (StringUtil.isNonEmpty(this.password)) {
            return this.decryptPassword(this.password);
        }
        if (this.usePgPass() && !this.getStorePassword()) {
            return this.getPgPassPassword();
        }
        return null;
    }

    public String getLoginUser() {
        String string = this.getUsername();
        if (this.usePgPass() && StringUtil.isEmptyString(string) && (string = System.getenv("PGUSER")) == null) {
            string = System.getProperty("user.name");
        }
        if (Settings.getInstance().replaceEnvVarsInProfile()) {
            string = StringUtil.replaceProperties(string);
            string = StringUtil.replaceProperties(System.getenv(), string);
        }
        return string;
    }

    public boolean needsSSHPasswordPrompt() {
        SshHostConfig sshHostConfig = this.getSshHostConfig();
        if (sshHostConfig == null) {
            return false;
        }
        if (sshHostConfig.getTryAgent()) {
            return false;
        }
        if (sshHostConfig.getPrivateKeyFile() != null) {
            SshManager sshManager = ConnectionMgr.getInstance().getSshManager();
            if (!sshManager.needsPassphrase(sshHostConfig)) {
                return false;
            }
            String string = sshManager.getPassphrase(sshHostConfig);
            if (string != null) {
                sshHostConfig.setTemporaryPassword(string);
                return false;
            }
        }
        return StringUtil.isBlank(sshHostConfig.getPassword());
    }

    private boolean integratedSecurityEnabled() {
        if (this.url == null) {
            return false;
        }
        if (this.url.startsWith("jdbc:sqlserver:")) {
            Pattern pattern = Pattern.compile(";\\s*integratedSecurity\\s*=\\s*true", 2);
            Matcher matcher = pattern.matcher(this.url);
            return matcher.find();
        }
        return false;
    }

    public boolean needsPasswordPrompt() {
        if (this.integratedSecurityEnabled()) {
            return false;
        }
        return this.getLoginPassword() == null && !this.getStorePassword();
    }

    public void setTemporaryUsername(String string) {
        this.temporaryUsername = string;
    }

    public final void setUsername(String string) {
        if (string != null) {
            string = string.trim();
        }
        if (!(StringUtil.equalString(string, this.username) || this.changed || this.promptForUsername)) {
            this.changed = true;
        }
        this.temporaryUsername = null;
        this.username = string;
    }

    public boolean getAutocommit() {
        return this.autocommit;
    }

    public void setAutocommit(boolean bl) {
        if (bl != this.autocommit && !this.changed) {
            this.changed = true;
        }
        this.autocommit = bl;
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String string) {
        if (!this.changed && !StringUtil.equalString(this.name, string)) {
            this.changed = true;
        }
        this.name = string;
        this.syncSettingsKey();
    }

    public boolean getStorePassword() {
        return this.storePassword;
    }

    public void setStorePassword(boolean bl) {
        if (bl != this.storePassword && !this.changed) {
            this.changed = true;
        }
        this.storePassword = bl;
    }

    public ConnectionProfile createStatefulCopy() {
        ConnectionProfile connectionProfile = this.createCopy();
        connectionProfile.isNew = this.isNew;
        connectionProfile.changed = this.changed;
        connectionProfile.internalId = this.internalId;
        return connectionProfile;
    }

    public ConnectionProfile createCopy() {
        ConnectionProfile connectionProfile = new ConnectionProfile();
        connectionProfile.setUrl(this.url);
        connectionProfile.setAutocommit(this.autocommit);
        connectionProfile.setDriverclass(this.driverclass);
        connectionProfile.setConnectionTimeout(this.connectionTimeout);
        connectionProfile.setDriverName(this.driverName);
        connectionProfile.setName(this.name);
        connectionProfile.setGroup(this.group);
        connectionProfile.setIcon(this.icon);
        connectionProfile.setPassword(this.getPassword());
        connectionProfile.setOracleSysDBA(this.oracleSysDBA);
        connectionProfile.setUsername(this.username);
        connectionProfile.setWorkspaceFile(this.workspaceFile);
        connectionProfile.setIgnoreDropErrors(this.ignoreDropErrors);
        connectionProfile.setUseSeparateConnectionPerTab(this.separateConnection);
        connectionProfile.setTrimCharData(this.trimCharData);
        connectionProfile.setIncludeNullInInsert(this.includeNullInInsert);
        connectionProfile.setEmptyStringIsNull(this.emptyStringIsNull);
        connectionProfile.setRollbackBeforeDisconnect(this.rollbackBeforeDisconnect);
        connectionProfile.setConfirmUpdates(this.confirmUpdates);
        connectionProfile.setStorePassword(this.storePassword);
        connectionProfile.setDefaultFetchSize(this.defaultFetchSize);
        connectionProfile.setStoreExplorerSchema(this.rememberExplorerSchema);
        connectionProfile.setIdleScript(this.idleScript);
        connectionProfile.setIdleTime(this.idleTime);
        connectionProfile.setDefaultDirectory(this.defaultDirectory);
        connectionProfile.setPreDisconnectScript(this.preDisconnectScript);
        connectionProfile.setPostConnectScript(this.postConnectScript);
        connectionProfile.setInfoDisplayColor(this.infoColor);
        connectionProfile.setReadOnly(this.readOnly);
        connectionProfile.setAlternateDelimiter(this.alternateDelimiter == null ? null : this.alternateDelimiter.createCopy());
        connectionProfile.setHideWarnings(this.hideWarnings);
        connectionProfile.setCopyExtendedPropsToSystem(this.copyPropsToSystem);
        connectionProfile.setRemoveComments(this.removeComments);
        connectionProfile.setCatalogFilter(this.catalogFilter == null ? null : this.catalogFilter.createCopy());
        connectionProfile.setSchemaFilter(this.schemaFilter == null ? null : this.schemaFilter.createCopy());
        connectionProfile.setDetectOpenTransaction(this.detectOpenTransaction);
        connectionProfile.setPreventDMLWithoutWhere(this.preventNoWhere);
        connectionProfile.setPromptForUsername(this.promptForUsername);
        connectionProfile.setStoreCacheLocally(this.storeCacheLocally);
        connectionProfile.setMacroFilename(this.macroFileName);
        connectionProfile.setSshConfig(this.sshConfig == null ? null : this.sshConfig.createCopy());
        connectionProfile.tags.addAll(this.tags);
        connectionProfile.lastSettingsKey = this.lastSettingsKey;
        connectionProfile.temporaryUsername = null;
        connectionProfile.connectionProperties = WbProperties.createCopy(this.connectionProperties);
        connectionProfile.variables = WbProperties.createCopy(this.variables);
        return connectionProfile;
    }

    public static Comparator<ConnectionProfile> getNameComparator() {
        return (connectionProfile, connectionProfile2) -> {
            if (connectionProfile == null && connectionProfile2 == null) {
                return 0;
            }
            if (connectionProfile == null) {
                return -1;
            }
            if (connectionProfile2 == null) {
                return 1;
            }
            return StringUtil.compareStrings(connectionProfile.name, connectionProfile2.name, true);
        };
    }

    public boolean getIgnoreDropErrors() {
        return this.ignoreDropErrors;
    }

    public void setIgnoreDropErrors(boolean bl) {
        this.changed = bl != this.ignoreDropErrors;
        this.ignoreDropErrors = bl;
    }

    public String getWorkspaceFile() {
        return this.workspaceFile;
    }

    public void setWorkspaceFile(String string) {
        this.workspaceFile = string;
        this.changed = true;
    }

    public void addConnectionProperty(String string, String string2) {
        if (string == null) {
            return;
        }
        if (this.connectionProperties == null) {
            this.connectionProperties = new Properties();
        }
        this.connectionProperties.put(string, string2);
        this.changed = true;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(Properties properties) {
        if (CollectionUtil.isEmpty(properties)) {
            this.changed = CollectionUtil.isNonEmpty(this.connectionProperties);
            this.connectionProperties = null;
        } else if (!properties.equals(this.connectionProperties)) {
            this.changed = true;
            this.connectionProperties = WbProperties.createCopy(properties);
        }
    }

    public Properties getConnectionVariables() {
        return this.variables;
    }

    public void setConnectionVariables(Properties properties) {
        if (CollectionUtil.isEmpty(properties)) {
            this.changed = CollectionUtil.isNonEmpty(this.variables);
            this.variables = null;
        } else if (!properties.equals(this.variables)) {
            this.changed = true;
            this.variables = WbProperties.createCopy(properties);
        }
    }

    public boolean getConfirmUpdates() {
        return this.confirmUpdates;
    }

    public void setConfirmUpdates(boolean bl) {
        if (bl != this.confirmUpdates) {
            this.changed = true;
        }
        this.confirmUpdates = bl;
    }

    public int getFetchSize() {
        if (this.defaultFetchSize == null) {
            return -1;
        }
        return this.defaultFetchSize;
    }

    public Integer getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    public void setDefaultFetchSize(Integer n) {
        int n2;
        int n3 = this.defaultFetchSize == null ? Integer.MIN_VALUE : this.defaultFetchSize;
        int n4 = n2 = n == null ? Integer.MIN_VALUE : n;
        if (n3 != n2) {
            this.defaultFetchSize = n2 > 0 ? n : null;
            this.changed = true;
        }
    }

    public boolean hasConnectScript() {
        return StringUtil.isNonEmpty(this.postConnectScript) || StringUtil.isNonEmpty(this.preDisconnectScript) || StringUtil.isNonEmpty(this.idleScript) && this.idleTime > 0L;
    }

    public String getPostConnectScript() {
        return this.postConnectScript;
    }

    public void setPostConnectScript(String string) {
        if (!StringUtil.equalStringOrEmpty(string, this.postConnectScript)) {
            this.postConnectScript = StringUtil.trimToNull(string);
            this.changed = true;
        }
    }

    public String getPreDisconnectScript() {
        return this.preDisconnectScript;
    }

    public void setPreDisconnectScript(String string) {
        if (!StringUtil.equalStringOrEmpty(string, this.preDisconnectScript)) {
            this.preDisconnectScript = StringUtil.trimToNull(string);
            this.changed = true;
        }
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public void setIdleTime(long l) {
        if (l != this.idleTime && !this.changed) {
            this.changed = true;
        }
        this.idleTime = l;
    }

    public String getIdleScript() {
        return this.idleScript;
    }

    public void setIdleScript(String string) {
        if (!StringUtil.equalStringOrEmpty(string, this.idleScript)) {
            this.idleScript = StringUtil.trimToNull(string);
            this.changed = true;
        }
    }

    public static String makeFilename(String string, String string2) {
        Pattern pattern = Pattern.compile("[^a-zA-Z0-9$]+");
        int n = string.indexOf(63);
        if (n > 0) {
            string = string.substring(0, n);
        }
        Matcher matcher = pattern.matcher(string);
        String string3 = matcher.replaceAll("_");
        string3 = string3.substring(5);
        String string4 = "";
        if (StringUtil.isNonBlank(string2)) {
            Matcher matcher2 = pattern.matcher(string2);
            string4 = matcher2.replaceAll("_") + "@";
        }
        return string4.toLowerCase() + string3.toLowerCase();
    }

    public SshHostConfig getSshHostConfig() {
        if (this.sshConfig == null) {
            return null;
        }
        return this.sshConfig.getSshHostConfig();
    }

    public SshConfig getSshConfig() {
        return this.sshConfig;
    }

    public void setSshConfig(SshConfig sshConfig) {
        if (sshConfig == null) {
            this.changed = this.sshConfig != null;
            this.sshConfig = null;
        } else if (this.sshConfig != null) {
            this.sshConfig.copyFrom(sshConfig);
            this.changed = this.sshConfig.isChanged();
        } else {
            this.sshConfig = sshConfig.createCopy();
            this.changed = true;
        }
    }
}

