/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.util.Collections;
import java.util.List;
import workbench.db.DBID;
import workbench.db.WbConnection;
import workbench.db.ibm.Db2SearchPath;
import workbench.db.postgres.PostgresUtil;
import workbench.db.redshift.RedshiftSearchPathHandler;

public interface DbSearchPath {
    public static final DbSearchPath DEFAULT_HANDLER = new DbSearchPath(){

        @Override
        public List<String> getSearchPath(WbConnection wbConnection, String string) {
            if (string == null) {
                string = wbConnection.getCurrentSchema();
            }
            if (string == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(wbConnection.getMetadata().adjustSchemaNameCase(string));
        }

        @Override
        public boolean isRealSearchPath() {
            return false;
        }
    };
    public static final DbSearchPath PG_HANDLER = new DbSearchPath(){

        @Override
        public List<String> getSearchPath(WbConnection wbConnection, String string) {
            if (string != null && wbConnection != null) {
                return Collections.singletonList(wbConnection.getMetadata().adjustSchemaNameCase(string));
            }
            return PostgresUtil.getSearchPath(wbConnection);
        }

        @Override
        public boolean isRealSearchPath() {
            return true;
        }
    };

    public boolean isRealSearchPath();

    public List<String> getSearchPath(WbConnection var1, String var2);

    public static class Factory {
        public static DbSearchPath getSearchPathHandler(WbConnection wbConnection) {
            switch (DBID.fromConnection(wbConnection)) {
                case Postgres: 
                case Greenplum: {
                    return PG_HANDLER;
                }
                case Redshift: {
                    return new RedshiftSearchPathHandler();
                }
                case DB2_ISERIES: {
                    return new Db2SearchPath();
                }
            }
            return DEFAULT_HANDLER;
        }
    }
}

