/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObject;
import workbench.db.DummyDML;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.resource.Settings;
import workbench.sql.formatter.FormatterUtil;

public class DummyUpdate
extends DummyDML
implements DbObject {
    public DummyUpdate(TableIdentifier tableIdentifier) {
        super(tableIdentifier);
        this.doFormat = Settings.getInstance().getDoFormatUpdates();
    }

    public DummyUpdate(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        super(tableIdentifier, list);
        this.doFormat = Settings.getInstance().getDoFormatUpdates();
    }

    @Override
    public String getObjectType() {
        return "UPDATE";
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        ColumnIdentifier columnIdentifier;
        int n;
        List<ColumnIdentifier> list = this.getColumns(wbConnection);
        String string = Settings.getInstance().getInternalEditorLineEnding();
        StringBuilder stringBuilder = new StringBuilder(list.size() * 20 + 100);
        stringBuilder.append(FormatterUtil.getKeyword("UPDATE "));
        stringBuilder.append(FormatterUtil.getIdentifier(this.table.getTableExpression(wbConnection)));
        stringBuilder.append(string);
        stringBuilder.append(FormatterUtil.getKeyword("   SET "));
        int n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            columnIdentifier = list.get(n);
            if (columnIdentifier.isPkColumn() || columnIdentifier.isAutoGenerated()) continue;
            if (n2 > 0) {
                stringBuilder.append(',');
                stringBuilder.append(string);
                stringBuilder.append("       ");
            }
            this.appendColumnExpression(stringBuilder, columnIdentifier, wbConnection);
            ++n2;
        }
        stringBuilder.append(string);
        stringBuilder.append(FormatterUtil.getKeyword("WHERE "));
        n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            columnIdentifier = list.get(n);
            if (!columnIdentifier.isPkColumn()) continue;
            if (n2 > 0) {
                stringBuilder.append(string);
                stringBuilder.append("  AND ");
            }
            this.appendColumnExpression(stringBuilder, columnIdentifier, wbConnection);
            ++n2;
        }
        stringBuilder.append(";");
        return this.formatSql(stringBuilder.toString(), wbConnection);
    }

    private void appendColumnExpression(StringBuilder stringBuilder, ColumnIdentifier columnIdentifier, WbConnection wbConnection) {
        stringBuilder.append(this.getColumnName(columnIdentifier, wbConnection));
        stringBuilder.append(" = ");
        stringBuilder.append(this.getValueString(columnIdentifier));
    }
}

